/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.console.command;

import de.uniba.wiai.lspi.util.console.ConsoleException;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ListParameter {
    protected static final String SEPARATOR = "_";
    private String paramName;
    private String list;
    private boolean mayBeEmpty;

    ListParameter(String paramName1, String list1, boolean mayBeEmpty1) {
        this.paramName = paramName1;
        this.list = list1;
        this.mayBeEmpty = mayBeEmpty1;
    }

    List<String> getList() throws ConsoleException {
        if (!(this.mayBeEmpty || this.list != null && this.list.length() != 0)) {
            throw new ConsoleException("No value provided for " + this.paramName + " parameter.");
        }
        if (this.list == null || this.list.length() == 0) {
            return new LinkedList<String>();
        }
        LinkedList<String> stringList = new LinkedList<String>();
        int separatorIndex = this.list.indexOf(SEPARATOR);
        while (separatorIndex != -1) {
            String name = this.list.substring(0, separatorIndex);
            if (name != null && name.length() != 0) {
                stringList.add(name);
            }
            this.list = this.list.substring(separatorIndex + 1);
            separatorIndex = this.list.indexOf(SEPARATOR);
        }
        if (this.list != null && this.list.length() != 0) {
            stringList.add(this.list);
        }
        if (!this.mayBeEmpty && stringList.size() == 0) {
            throw new ConsoleException("No value provided for " + this.paramName + " parameter.");
        }
        return stringList;
    }

    String getStringList() {
        return this.list;
    }

    void add(String toAdd) {
        this.list = this.list == null || this.list.length() == 0 ? toAdd : this.list + SEPARATOR + toAdd;
    }
}

