/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.console.command;

import de.uniba.wiai.lspi.chord.com.local.Registry;
import de.uniba.wiai.lspi.chord.console.command.ListParameter;
import de.uniba.wiai.lspi.chord.data.URL;
import de.uniba.wiai.lspi.chord.service.ServiceException;
import de.uniba.wiai.lspi.chord.service.impl.ChordImpl;
import de.uniba.wiai.lspi.util.console.Command;
import de.uniba.wiai.lspi.util.console.ConsoleException;
import java.io.PrintStream;
import java.util.List;

public class CreateNodes
extends Command {
    public static final String COMMAND_NAME = "create";
    public static final String NAMES_PARAM = "names";
    public static final String BOOTSTRAP_PARAM = "bootstraps";

    public CreateNodes(Object[] toCommand1, PrintStream out1) {
        super(toCommand1, out1);
    }

    public void exec() throws ConsoleException {
        if (!this.parameters.containsKey(NAMES_PARAM)) {
            throw new ConsoleException("Not enough parameters. Provide at least one node name with help of 'names' parameter.");
        }
        String namesString = (String)this.parameters.get(NAMES_PARAM);
        ListParameter namesParam = new ListParameter(NAMES_PARAM, namesString, false);
        List<String> names = namesParam.getList();
        String bootstrapsString = (String)this.parameters.get(BOOTSTRAP_PARAM);
        ListParameter bootsNames = new ListParameter(BOOTSTRAP_PARAM, bootstrapsString, true);
        List<String> bootstraps = bootsNames.getList();
        if (names.size() > 1 && bootstraps.size() == 0) {
            throw new ConsoleException("Cannot start more than one node without at least one bootstrap node.");
        }
        if (names.size() == 1 && bootstraps.size() == 0) {
            this.out.println("Creating new chord network.");
            Registry reg = Registry.getRegistryInstance();
            if (reg.lookupAll().size() > 0) {
                throw new ConsoleException("There is already a chord network present in this JVM. Try to start node " + names.get(0) + " with one of the existing nodes as bootstrap node.");
            }
            ChordImpl node = null;
            node = new ChordImpl();
            try {
                URL url = new URL(URL.KNOWN_PROTOCOLS.get(1) + "://" + names.get(0) + "/");
                node.create(url);
            }
            catch (Throwable t) {
                t.printStackTrace(this.out);
                throw new ConsoleException("Exception during creation of node " + names.get(0) + ". Message : " + t.getMessage(), t);
            }
        }
        for (int i = 0; i < names.size(); ++i) {
            this.out.print("Starting node with name '" + names.get(i) + "'");
            String nodeToCreate = names.get(i);
            String bootstrap = "";
            if (i < bootstraps.size()) {
                bootstrap = bootstraps.get(i);
            } else if (bootstraps.size() >= 1) {
                bootstrap = bootstraps.get(bootstraps.size() - 1);
            }
            this.out.println(" with bootstrap node '" + bootstrap + "'");
            Registry reg = Registry.getRegistryInstance();
            URL url = null;
            try {
                url = new URL(URL.KNOWN_PROTOCOLS.get(1) + "://" + nodeToCreate + "/");
            }
            catch (Exception e) {
                throw new ConsoleException(e.getMessage());
            }
            if (reg.lookup(url) != null) {
                this.out.println("There is already a node in chord network present with name " + nodeToCreate);
                this.out.println("Ignoring node. Node " + nodeToCreate + " NOT started!");
                continue;
            }
            ChordImpl node = null;
            node = new ChordImpl();
            try {
                URL bootstrapURL = new URL(URL.KNOWN_PROTOCOLS.get(1) + "://" + bootstrap + "/");
                node.join(url, bootstrapURL);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
                try {
                    node.leave();
                }
                catch (ServiceException e) {
                    // empty catch block
                }
                throw new ConsoleException("Exception during join of node " + nodeToCreate + ". Message : " + t.getMessage(), t);
            }
        }
    }

    public String getCommandName() {
        return COMMAND_NAME;
    }

    public void printOutHelp() {
        this.out.println("The create command creates one or more \nnodes of a chord network. The first node created must be \nthe only node provides with help of parameter 'names'.");
        this.out.println("___________________");
        this.out.println("Parameters: ");
        this.out.println("'names' takes a list of names of nodes. The names \nmust be separated with help of '_' and without a space. ");
        this.out.println("'bootstraps' takes a list of names of nodes. The names \nmust be separated with help of '_' and without a space. ");
        this.out.println("There must always be a bootstrap node except in the case \nthat the first node of a chord network is created.");
    }
}

