/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.com.socket;

import de.uniba.wiai.lspi.chord.com.Endpoint;
import de.uniba.wiai.lspi.chord.com.Node;
import de.uniba.wiai.lspi.chord.com.socket.InvocationThread;
import de.uniba.wiai.lspi.chord.com.socket.RequestHandler;
import de.uniba.wiai.lspi.chord.com.socket.SocketProxy;
import de.uniba.wiai.lspi.chord.data.URL;
import de.uniba.wiai.lspi.util.logging.Logger;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;

public final class SocketEndpoint
extends Endpoint
implements Runnable {
    private static final Logger logger = Logger.getLogger(SocketEndpoint.class);
    private static final boolean debug = logger.isEnabledFor(Logger.LogLevel.DEBUG);
    private Set<RequestHandler> handlers = new HashSet<RequestHandler>();
    private ServerSocket mySocket = null;
    private final ThreadPoolExecutor invocationExecutor = InvocationThread.createInvocationThreadPool();

    public SocketEndpoint(Node node1, URL url1) {
        super(node1, url1);
        logger.info("Initialisation finished.");
    }

    protected void openConnections() {
        try {
            if (debug) {
                logger.debug("Trying to open server socket on port " + this.url.getPort());
            }
            this.mySocket = new ServerSocket(this.url.getPort());
            this.setState(1);
            if (debug) {
                logger.debug("Server socket opened on port " + this.url.getPort() + ". Starting listener thread.");
            }
            Thread listenerThread = new Thread((Runnable)this, "SocketEndpoint_" + this.url + "_Thread");
            listenerThread.start();
            if (debug) {
                logger.debug("Listener Thread " + listenerThread + "started. ");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("SocketEndpoint could not listen on port " + this.url.getPort() + " " + e.getMessage());
        }
    }

    protected void entriesAcceptable() {
        if (debug) {
            logger.debug("entriesAcceptable() called");
        }
        this.setState(2);
    }

    protected void closeConnections() {
        block2: {
            this.setState(0);
            try {
                this.mySocket.close();
            }
            catch (IOException e) {
                if (!debug) break block2;
                logger.debug("Could not close socket " + this.mySocket, e);
            }
        }
        this.invocationExecutor.shutdownNow();
        SocketProxy.shutDownAll();
    }

    public void run() {
        while (this.getState() > 0) {
            if (debug) {
                logger.debug("Waiting for incoming connection.");
            }
            Socket incomingConnection = null;
            try {
                incomingConnection = this.mySocket.accept();
                if (debug) {
                    logger.debug("Incoming connection " + incomingConnection);
                }
                if (debug) {
                    logger.debug("Creating request handler for incoming connection.");
                }
                RequestHandler handler = new RequestHandler(this.node, incomingConnection, this);
                this.handlers.add(handler);
                if (debug) {
                    logger.debug("Request handler created. Starting thread.");
                }
                handler.start();
                if (!debug) continue;
                logger.debug("Request handler thread started.");
            }
            catch (IOException e) {
                if (this.getState() <= 0) continue;
                if (debug) {
                    logger.debug("Could not accept connection from other node!", e);
                }
                if (incomingConnection == null) continue;
                try {
                    incomingConnection.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                incomingConnection = null;
            }
        }
        logger.info("Listener thread stopped.");
        for (RequestHandler handler : this.handlers) {
            handler.disconnect();
        }
        this.handlers.clear();
    }

    void scheduleInvocation(InvocationThread invocationThread) {
        if (debug) {
            logger.debug("Scheduling invocation: " + invocationThread);
        }
        this.invocationExecutor.execute(invocationThread);
        if (debug) {
            logger.debug("Current jobs: " + this.invocationExecutor.getQueue().size());
            logger.debug("Active jobs: " + this.invocationExecutor.getActiveCount());
            logger.debug("Completed jobs: " + this.invocationExecutor.getCompletedTaskCount());
        }
    }
}

