/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.com.socket;

import de.uniba.wiai.lspi.chord.com.CommunicationException;
import de.uniba.wiai.lspi.chord.com.Endpoint;
import de.uniba.wiai.lspi.chord.com.EndpointStateListener;
import de.uniba.wiai.lspi.chord.com.Entry;
import de.uniba.wiai.lspi.chord.com.Node;
import de.uniba.wiai.lspi.chord.com.RefsAndEntries;
import de.uniba.wiai.lspi.chord.com.socket.InvocationThread;
import de.uniba.wiai.lspi.chord.com.socket.MethodConstants;
import de.uniba.wiai.lspi.chord.com.socket.RemoteNodeInfo;
import de.uniba.wiai.lspi.chord.com.socket.RemoteRefsAndEntries;
import de.uniba.wiai.lspi.chord.com.socket.Request;
import de.uniba.wiai.lspi.chord.com.socket.Response;
import de.uniba.wiai.lspi.chord.com.socket.SocketEndpoint;
import de.uniba.wiai.lspi.chord.com.socket.SocketProxy;
import de.uniba.wiai.lspi.chord.data.ID;
import de.uniba.wiai.lspi.util.logging.Logger;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

final class RequestHandler
extends Thread
implements EndpointStateListener {
    private static Logger logger = Logger.getLogger(RequestHandler.class);
    private Node node;
    private Socket connection;
    private ObjectOutputStream out;
    private ObjectInputStream in;
    boolean connected = true;
    private int state;
    private SocketEndpoint endpoint;
    private Set<Thread> waitingThreads = new HashSet<Thread>();

    RequestHandler(Node node_, Socket connection_, SocketEndpoint ep) throws IOException {
        super("RequestHandler_" + ep.getURL());
        if (logger.isEnabledFor(Logger.LogLevel.INFO)) {
            logger.info("Initialising RequestHandler. Socket " + connection_ + ", " + ", Endpoint " + ep);
        }
        this.node = node_;
        this.connection = connection_;
        this.out = new ObjectOutputStream(this.connection.getOutputStream());
        try {
            this.in = new ObjectInputStream(this.connection.getInputStream());
        }
        catch (IOException e1) {
            this.out.close();
            throw e1;
        }
        try {
            Request r = (Request)this.in.readObject();
            if (r.getRequestType() != -1) {
                Response resp = new Response(0, r.getRequestType(), r.getReplyWith());
                try {
                    this.out.writeObject(resp);
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    this.out.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    this.in.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw new IOException("Unexpected Message received! " + r);
            }
            Response resp = new Response(1, r.getRequestType(), r.getReplyWith());
            this.out.writeObject(resp);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Unexpected class type received! " + e.getMessage());
        }
        this.endpoint = ep;
        this.state = this.endpoint.getState();
        this.endpoint.register(this);
        logger.info("RequestHandler initialised.");
    }

    SocketEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void run() {
        while (this.connected) {
            Request request = null;
            try {
                logger.debug("Waiting for request...");
                request = (Request)this.in.readObject();
                if (request.getRequestType() == 11) {
                    logger.debug("Received shutdown request");
                    this.disconnect();
                    continue;
                }
                logger.debug("Received request " + request);
                new InvocationThread(this, request, this.out);
            }
            catch (IOException e) {
                logger.debug("Exception occured while receiving a request. Maybe socket has been closed.");
                this.disconnect();
            }
            catch (ClassNotFoundException cnf) {
                logger.error("Exception occured while receiving a request ", cnf);
                this.disconnect();
            }
            catch (Throwable t) {
                logger.fatal("Unexpected throwable while receiving message!", t);
                this.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendFailureResponse(Throwable t, String failure, Request request) {
        block6: {
            if (!this.connected) {
                return;
            }
            logger.debug("Trying to send failure response. Failure reason " + failure);
            Response failureResponse = new Response(0, request.getRequestType(), request.getReplyWith());
            failureResponse.setFailureReason(failure);
            failureResponse.setThrowable(t);
            try {
                ObjectOutputStream objectOutputStream = this.out;
                synchronized (objectOutputStream) {
                    this.out.writeObject(failureResponse);
                    this.out.flush();
                    this.out.reset();
                }
                logger.debug("Response send.");
            }
            catch (IOException e) {
                if (!this.connected) break block6;
                logger.debug("Connection seems to be broken down. Could not send failure response. Connection is closed. ", e);
                this.disconnect();
            }
        }
    }

    Serializable invokeMethod(int methodType, Serializable[] parameters) throws Exception {
        String method = MethodConstants.getMethodName(methodType);
        this.waitForMethod(method);
        if (!this.connected) {
            throw new CommunicationException("Connection closed.");
        }
        Serializable result = null;
        logger.debug("Trying to invoke method " + methodType + " with parameters: ");
        for (Serializable parameter : parameters) {
            logger.debug(parameter);
        }
        switch (methodType) {
            case 0: {
                Node chordNode = this.node.findSuccessor((ID)parameters[0]);
                result = new RemoteNodeInfo(chordNode.getNodeURL(), chordNode.getNodeID());
                break;
            }
            case 1: {
                result = this.node.getNodeID();
                break;
            }
            case 2: {
                this.node.insertEntry((Entry)parameters[0]);
                break;
            }
            case 3: {
                this.node.insertReplicas((Set)((Object)parameters[0]));
                break;
            }
            case 4: {
                RemoteNodeInfo nodeInfo = (RemoteNodeInfo)parameters[0];
                this.node.leavesNetwork(SocketProxy.create(nodeInfo.getNodeURL(), this.node.getNodeURL(), nodeInfo.getNodeID()));
                break;
            }
            case 5: {
                RemoteNodeInfo nodeInfo = (RemoteNodeInfo)parameters[0];
                List<Node> l = this.node.notify(SocketProxy.create(nodeInfo.getNodeURL(), this.node.getNodeURL(), nodeInfo.getNodeID()));
                LinkedList<RemoteNodeInfo> nodeInfos = new LinkedList<RemoteNodeInfo>();
                for (Node current : l) {
                    nodeInfos.add(new RemoteNodeInfo(current.getNodeURL(), current.getNodeID()));
                }
                result = nodeInfos;
                break;
            }
            case 6: {
                RemoteNodeInfo nodeInfo = (RemoteNodeInfo)parameters[0];
                RefsAndEntries refs = this.node.notifyAndCopyEntries(SocketProxy.create(nodeInfo.getNodeURL(), this.node.getNodeURL(), nodeInfo.getNodeID()));
                List<Node> l = refs.getRefs();
                LinkedList<RemoteNodeInfo> nodeInfos = new LinkedList<RemoteNodeInfo>();
                for (Node current : l) {
                    nodeInfos.add(new RemoteNodeInfo(current.getNodeURL(), current.getNodeID()));
                }
                RemoteRefsAndEntries rRefs = new RemoteRefsAndEntries(refs.getEntries(), nodeInfos);
                result = rRefs;
                break;
            }
            case 7: {
                logger.debug("Invoking ping()");
                this.node.ping();
                logger.debug("ping() invoked.");
                break;
            }
            case 8: {
                this.node.removeEntry((Entry)parameters[0]);
                break;
            }
            case 9: {
                this.node.removeReplicas((ID)parameters[0], (Set)((Object)parameters[1]));
                break;
            }
            case 10: {
                result = (Serializable)((Object)this.node.retrieveEntries((ID)parameters[0]));
                break;
            }
            default: {
                logger.warn("Unknown method requested " + method);
                throw new Exception("Unknown method requested " + method);
            }
        }
        logger.debug("Returning result.");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForMethod(String method) {
        logger.debug(method + " allowed? " + (Collections.binarySearch(Endpoint.METHODS_ALLOWED_IN_ACCEPT_ENTRIES, method) < 0));
        Set<Thread> set = this.waitingThreads;
        synchronized (set) {
            while (this.state != 2 && this.connected && Collections.binarySearch(Endpoint.METHODS_ALLOWED_IN_ACCEPT_ENTRIES, method) >= 0) {
                Thread currentThread = Thread.currentThread();
                boolean debug = logger.isEnabledFor(Logger.LogLevel.DEBUG);
                if (debug) {
                    logger.debug("HERE!!!" + currentThread + " waiting for permission to " + "execute " + method);
                }
                this.waitingThreads.add(currentThread);
                try {
                    this.waitingThreads.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (debug) {
                    logger.debug("HERE!!!" + currentThread + " has been notified.");
                }
                this.waitingThreads.remove(currentThread);
            }
        }
        logger.debug("waitForMethod(" + method + ") returns!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        logger.info("Disconnecting.");
        if (this.connected) {
            Object object = this.waitingThreads;
            synchronized (object) {
                this.connected = false;
                this.waitingThreads.notifyAll();
            }
            this.node = null;
            try {
                object = this.out;
                synchronized (object) {
                    this.out.close();
                    this.out = null;
                }
            }
            catch (IOException e) {
                logger.debug("Exception while closing output stream " + this.out);
            }
            try {
                this.in.close();
                this.in = null;
            }
            catch (IOException e) {
                logger.debug("Exception while closing input stream" + this.in);
            }
            try {
                logger.info("Closing socket " + this.connection);
                this.connection.close();
                this.connection = null;
                logger.info("Socket closed.");
            }
            catch (IOException e) {
                logger.debug("Exception while closing socket " + this.connection);
            }
            this.endpoint.deregister(this);
        }
        logger.debug("Disconnected.");
    }

    public boolean isConnected() {
        return this.connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(int newState) {
        logger.debug("notify(" + newState + ") called.");
        this.state = newState;
        Set<Thread> set = this.waitingThreads;
        synchronized (set) {
            logger.debug("HERE!!! Notifying waiting threads. " + this.waitingThreads);
            this.waitingThreads.notifyAll();
        }
    }
}

