/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.com.rmi;

import de.uniba.wiai.lspi.chord.com.CommunicationException;
import de.uniba.wiai.lspi.chord.com.Endpoint;
import de.uniba.wiai.lspi.chord.com.Entry;
import de.uniba.wiai.lspi.chord.com.Node;
import de.uniba.wiai.lspi.chord.com.RefsAndEntries;
import de.uniba.wiai.lspi.chord.com.rmi.RMIProxy;
import de.uniba.wiai.lspi.chord.com.rmi.RemoteNode;
import de.uniba.wiai.lspi.chord.com.rmi.RemoteNodeInfo;
import de.uniba.wiai.lspi.chord.com.rmi.RemoteRefsAndEntries;
import de.uniba.wiai.lspi.chord.data.ID;
import de.uniba.wiai.lspi.chord.data.URL;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RMIEndpoint
extends Endpoint
implements RemoteNode {
    private Registry registry = null;
    private RemoteNode remoteNode = null;
    static final String NAME_IN_REGISTRY = "oc_endpoint_";

    public RMIEndpoint(Node node1, URL url1) {
        super(node1, url1);
    }

    RemoteNode getRemoteNode() {
        if (this.remoteNode == null) {
            throw new IllegalStateException();
        }
        return this.remoteNode;
    }

    @Override
    protected void closeConnections() {
        try {
            UnicastRemoteObject.unexportObject(this, true);
            this.registry.unbind(NAME_IN_REGISTRY + this.url.toString());
            this.setState(0);
        }
        catch (AccessException e) {
        }
        catch (RemoteException e) {
        }
        catch (NotBoundException notBoundException) {
            // empty catch block
        }
    }

    @Override
    protected void entriesAcceptable() {
        this.setState(2);
    }

    @Override
    protected void openConnections() {
        try {
            if (this.registry == null) {
                this.registry = LocateRegistry.createRegistry(this.url.getPort());
            }
            this.remoteNode = (RemoteNode)((Object)UnicastRemoteObject.exportObject(this));
            this.registry.bind(NAME_IN_REGISTRY + this.url.toString(), this.remoteNode);
            this.setState(1);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (AlreadyBoundException e) {
            throw new RuntimeException(e);
        }
    }

    private RemoteNodeInfo createInfo(Node node) {
        if (node.getNodeID().equals(this.node.getNodeID())) {
            return new RemoteNodeInfo(this.remoteNode, this.node.getNodeID(), this.node.getNodeURL());
        }
        return new RemoteNodeInfo(((RMIProxy)node).getRemoteNode(), node.getNodeID(), node.getNodeURL());
    }

    @Override
    public RemoteNodeInfo findSuccessor(ID key) throws CommunicationException, RemoteException {
        try {
            Node node = this.node.findSuccessor(key);
            return this.createInfo(node);
        }
        catch (ClassCastException e) {
            throw new RemoteException("Remote node uses unsuitable communication protocol!", e);
        }
    }

    @Override
    public ID getNodeID() throws RemoteException {
        return this.node.getNodeID();
    }

    @Override
    public void insertEntry(Entry entryToInsert) throws RemoteException, CommunicationException {
        this.node.insertEntry(entryToInsert);
    }

    @Override
    public void insertReplicas(Set<Entry> entries) throws RemoteException, CommunicationException {
        this.node.insertReplicas(entries);
    }

    @Override
    public void leavesNetwork(RemoteNodeInfo predecessor) throws RemoteException, CommunicationException {
        this.node.leavesNetwork(new RMIProxy(predecessor, this.getURL()));
    }

    @Override
    public List<RemoteNodeInfo> notify(RemoteNodeInfo potentialPredecessor) throws RemoteException, CommunicationException {
        List<Node> nodes = this.node.notify(new RMIProxy(potentialPredecessor, this.getURL()));
        LinkedList<RemoteNodeInfo> result = new LinkedList<RemoteNodeInfo>();
        for (Node node : nodes) {
            result.add(this.createInfo(node));
        }
        return result;
    }

    @Override
    public RemoteRefsAndEntries notifyAndCopyEntries(RemoteNodeInfo potentialPredecessor) throws RemoteException, CommunicationException {
        RefsAndEntries raes = this.node.notifyAndCopyEntries(new RMIProxy(potentialPredecessor, this.getURL()));
        LinkedList<RemoteNodeInfo> rNodes = new LinkedList<RemoteNodeInfo>();
        List<Node> nodes = raes.getRefs();
        for (Node node : nodes) {
            rNodes.add(this.createInfo(node));
        }
        return new RemoteRefsAndEntries(raes.getEntries(), rNodes);
    }

    @Override
    public void ping() throws RemoteException {
    }

    @Override
    public void removeEntry(Entry entryToRemove) throws RemoteException, CommunicationException {
        this.node.removeEntry(entryToRemove);
    }

    @Override
    public void removeReplicas(ID sendingNode, Set<Entry> replicasToRemove) throws RemoteException, CommunicationException {
        this.node.removeReplicas(sendingNode, replicasToRemove);
    }

    @Override
    public Set<Entry> retrieveEntries(ID id) throws RemoteException, CommunicationException {
        return this.node.retrieveEntries(id);
    }
}

