/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.com.rmi;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public class ListRMIRegistry {
    public static void main(String[] args) {
        String host = args[0];
        int port = 0;
        try {
            port = Integer.parseInt(args[1]);
        }
        catch (Exception e) {
            // empty catch block
        }
        Registry r = null;
        try {
            r = port != 0 ? LocateRegistry.getRegistry(host, port) : LocateRegistry.getRegistry(host);
            String[] names = r.list();
            System.out.println("Registered services in RMIRegistry at " + host + ":" + port);
            for (String name : names) {
                System.out.print("- " + name + ", Stub: ");
                try {
                    Remote stub = r.lookup(name);
                    System.out.println(stub.toString());
                }
                catch (Exception e) {
                    System.out.println("UNKNOWN");
                }
            }
        }
        catch (RemoteException e) {
            System.err.println("Could not connect to RMIRegistry at " + host + " on port " + port);
            System.err.println(e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

