/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.com;

import de.uniba.wiai.lspi.chord.com.CommunicationException;
import de.uniba.wiai.lspi.chord.com.Endpoint;
import de.uniba.wiai.lspi.chord.com.Entry;
import de.uniba.wiai.lspi.chord.com.Node;
import de.uniba.wiai.lspi.chord.com.Proxy;
import de.uniba.wiai.lspi.chord.com.RefsAndEntries;
import de.uniba.wiai.lspi.chord.data.ID;
import de.uniba.wiai.lspi.chord.data.URL;
import de.uniba.wiai.lspi.chord.service.PropertiesLoader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Test {
    static final String URL1 = "ocrmi://localhost:4245/";
    static final String URL2 = "ocrmi://localhost/";

    private Test() {
    }

    public static void main(String[] args) throws MalformedURLException, CommunicationException {
        PropertiesLoader.loadPropertyFile();
        try {
            if (args[0] != null) {
                NodeImpl node = new NodeImpl(URL2);
                Endpoint ep = Endpoint.createEndpoint(node, node.nodeURL);
                ep.listen();
                ep.acceptEntries();
            }
        }
        catch (Exception e) {
            NodeImpl node = new NodeImpl(URL1);
            Endpoint ep = Endpoint.createEndpoint(node, node.nodeURL);
            ep.listen();
            ep.acceptEntries();
            Node proxy = Proxy.createConnection(new URL(URL1), new URL(URL2));
            LinkedList<Long> millis = new LinkedList<Long>();
            long start = System.currentTimeMillis();
            proxy.findSuccessor(node.nodeID);
            long end = System.currentTimeMillis();
            System.out.println("findSuccessor took " + (end - start) + "ms");
            millis.add(end - start);
            start = System.currentTimeMillis();
            proxy.getNodeID();
            end = System.currentTimeMillis();
            System.out.println("getNodeID took " + (end - start) + "ms");
            millis.add(end - start);
            start = System.currentTimeMillis();
            proxy.insertEntry(new Entry(node.nodeID, (Serializable)((Object)"test")));
            end = System.currentTimeMillis();
            System.out.println("insertEntry took " + (end - start) + "ms");
            millis.add(end - start);
            start = System.currentTimeMillis();
            proxy.insertReplicas(new HashSet<Entry>());
            end = System.currentTimeMillis();
            System.out.println("insertReplicas took " + (end - start) + "ms");
            millis.add(end - start);
            start = System.currentTimeMillis();
            proxy.removeEntry(new Entry(node.nodeID, (Serializable)((Object)"test")));
            end = System.currentTimeMillis();
            System.out.println("removeEntry took " + (end - start) + "ms");
            millis.add(end - start);
            start = System.currentTimeMillis();
            proxy.leavesNetwork(node);
            end = System.currentTimeMillis();
            System.out.println("leavesNetwork took " + (end - start) + "ms");
            millis.add(end - start);
            start = System.currentTimeMillis();
            proxy.removeReplicas(node.nodeID, new HashSet<Entry>());
            end = System.currentTimeMillis();
            System.out.println("removeReplicas took " + (end - start) + "ms");
            millis.add(end - start);
            start = System.currentTimeMillis();
            proxy.notify(node);
            end = System.currentTimeMillis();
            System.out.println("notify took " + (end - start) + "ms");
            millis.add(end - start);
            proxy.notifyAndCopyEntries(node);
            end = System.currentTimeMillis();
            System.out.println("notifyAndCopyEntries took " + (end - start) + "ms");
            millis.add(end - start);
            start = System.currentTimeMillis();
            proxy.retrieveEntries(node.nodeID);
            end = System.currentTimeMillis();
            System.out.println("retrieveEntries took " + (end - start) + "ms");
            millis.add(end - start);
            start = System.currentTimeMillis();
            proxy.ping();
            end = System.currentTimeMillis();
            System.out.println("ping took " + (end - start) + "ms");
            millis.add(end - start);
            long calls = 0L;
            long total = 0L;
            for (Long time : millis) {
                total += time.longValue();
                ++calls;
            }
            System.out.println("Average duration of a call: " + total / calls);
            proxy.disconnect();
            ep.disconnect();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeImpl
    extends Node {
        NodeImpl(String url) {
            try {
                this.nodeURL = new URL(url);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                System.exit(-1);
            }
            this.nodeID = new ID(this.nodeURL.toString().getBytes());
        }

        @Override
        public void disconnect() {
        }

        @Override
        public Node findSuccessor(ID key) throws CommunicationException {
            return this;
        }

        @Override
        public void insertEntry(Entry entryToInsert) throws CommunicationException {
        }

        @Override
        public void insertReplicas(Set<Entry> entries) throws CommunicationException {
        }

        @Override
        public void leavesNetwork(Node predecessor) throws CommunicationException {
        }

        @Override
        public List<Node> notify(Node potentialPredecessor) throws CommunicationException {
            return new LinkedList<Node>();
        }

        @Override
        public RefsAndEntries notifyAndCopyEntries(Node potentialPredecessor) throws CommunicationException {
            return new RefsAndEntries(new LinkedList<Node>(), new HashSet<Entry>());
        }

        @Override
        public void ping() throws CommunicationException {
        }

        @Override
        public void removeEntry(Entry entryToRemove) throws CommunicationException {
        }

        @Override
        public void removeReplicas(ID sendingNode, Set<Entry> replicasToRemove) throws CommunicationException {
        }

        @Override
        public Set<Entry> retrieveEntries(ID id) throws CommunicationException {
            return new HashSet<Entry>();
        }
    }
}

