/*
 * Decompiled with CFR 0.152.
 */
package dareka.processor.impl;

import dareka.common.Logger;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NicoApiUtil {
    private NicoApiUtil() {
    }

    public static String getThumbURL(String type, String id) {
        return "http://ext.nicovideo.jp/api/getthumbinfo/" + type + id;
    }

    public static String getThumbURL(String cacheId) {
        return "http://ext.nicovideo.jp/api/getthumbinfo/" + cacheId;
    }

    public static String getThumbTitle(InputStream thumbResponse) {
        class ThumbTitleHandler
        extends DefaultHandler {
            public String status = "";
            private boolean inTitle;
            public String title = "";

            ThumbTitleHandler() {
            }

            @Override
            public void startElement(String uri, String localName, String name, Attributes attributes) {
                if (name.equals("nicovideo_thumb_response")) {
                    this.status = attributes.getValue("status");
                } else if (name.equals("title")) {
                    this.inTitle = true;
                }
            }

            @Override
            public void endElement(String uri, String localName, String name) {
                if (name.equals("title")) {
                    this.inTitle = false;
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) {
                if (this.inTitle) {
                    StringBuilder newTitle = new StringBuilder(this.title);
                    newTitle.append(ch, start, length);
                    this.title = newTitle.toString();
                }
            }
        }
        ThumbTitleHandler h;
        block5: {
            SAXParserFactory f = SAXParserFactory.newInstance();
            SAXParser p = f.newSAXParser();
            h = new ThumbTitleHandler();
            InputSource i = new InputSource(thumbResponse);
            p.parse(i, (DefaultHandler)h);
            if ("ok".equals(h.status)) break block5;
            return null;
        }
        try {
            return h.title;
        }
        catch (ParserConfigurationException e) {
            Logger.error(e);
        }
        catch (SAXException e) {
            Logger.error(e);
        }
        catch (IOException e) {
            Logger.error(e);
        }
        return null;
    }
}

