/*
 * Decompiled with CFR 0.152.
 */
package dareka.processor.impl;

import dareka.common.Config;
import dareka.common.Logger;
import dareka.dht.DHTManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Cache {
    private static final String NLTMP = "nltmp";
    private static final String NLTMP_ = "nltmp_";
    private static final String TMP = ".tmp";
    private static final Pattern CACHE_FILE_PATTERN = Pattern.compile("^([^_]+?)(?:_.*)?\\.(?!tmp$)[^.]+$");
    private static final Pattern NUMBER_CHARACTER_REFERENCE_PATTERN = Pattern.compile("&#(\\d+);");
    private static File cacheDir = new File("cache");
    private static ConcurrentHashMap<String, File> id2File = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, File> id2Tmp = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Integer> id2DL = new ConcurrentHashMap();
    private String cacheId;
    private String postfix;
    private File cacheFile;
    private File tmpFile;

    public static void init() {
        cacheDir.mkdir();
        id2File.clear();
        id2Tmp.clear();
        Cache.searchCachesOnADirectory(cacheDir, 1);
    }

    private static void searchCachesOnADirectory(File dir, int depth) {
        File[] cacheFiles = dir.listFiles();
        if (cacheFiles == null) {
            return;
        }
        File[] fileArray = cacheFiles;
        int n = cacheFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            File file = fileArray[n2];
            if (file.isDirectory()) {
                Cache.searchCachesOnADirectory(file, depth + 1);
            } else if (file.isFile() && !(id = Cache.getIdFromFilename(file.getName())).equals("")) {
                if (depth == 1 && id.equals(NLTMP)) {
                    id = Cache.getIdFromFilename(file.getName().substring(6));
                    id2Tmp.put(id, file);
                    Logger.debug("partial cache found: " + id + " => " + file.getPath());
                } else {
                    id2File.put(id, file);
                    DHTManager.getInstance().putNicoCache(id);
                    Logger.debug("cache found: " + id + " => " + file.getPath());
                }
            }
            ++n2;
        }
    }

    static String getIdFromFilename(String filename) {
        Matcher m = CACHE_FILE_PATTERN.matcher(filename);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }

    public static void cleanup() {
        File[] tmpFiles = cacheDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(Cache.TMP);
            }
        });
        if (tmpFiles == null) {
            return;
        }
        File[] fileArray = tmpFiles;
        int n = tmpFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
    }

    public static long size() {
        long sum = 0L;
        for (File file : id2File.values()) {
            sum += file.length();
        }
        return sum;
    }

    public static Map<String, File> getId2File() {
        return Collections.unmodifiableMap(id2File);
    }

    public static boolean getDLFlag(String id) {
        Integer size = id2DL.get(id);
        return size != null && size > 0;
    }

    public static void setDLFlag(String id, int size) {
        if (size > 0) {
            id2DL.put(id, size);
        } else {
            id2DL.remove(id);
        }
    }

    public Cache(String cacheId, String postfix) {
        this.cacheId = cacheId;
        this.postfix = postfix;
        this.cacheFile = id2File.get(cacheId);
        if (this.cacheFile == null) {
            this.cacheFile = new File(cacheDir, String.valueOf(cacheId) + postfix);
        }
    }

    public Cache(String cacheId, String postfix, String desc) {
        this.cacheId = cacheId;
        this.postfix = postfix;
        this.cacheFile = id2File.get(cacheId);
        if (this.cacheFile == null) {
            this.cacheFile = this.getDescribedCacheFile(desc);
        }
    }

    protected File getDescribedCacheFile(String desc) {
        StringBuffer decodedDesc = new StringBuffer(desc.length());
        Matcher m = NUMBER_CHARACTER_REFERENCE_PATTERN.matcher(desc);
        while (m.find()) {
            m.appendReplacement(decodedDesc, Character.toString((char)Integer.parseInt(m.group(1))));
        }
        m.appendTail(decodedDesc);
        String sanitizedDesc = Cache.getSanitizedDescription(decodedDesc.toString());
        return new File(cacheDir, String.valueOf(this.cacheId) + '_' + sanitizedDesc + this.postfix);
    }

    static String getSanitizedDescription(String decodedDesc) {
        String fileNameCharset = Config.getString("fileNameCharset", "");
        String narrowedDesc = Cache.narrowCharset(decodedDesc, fileNameCharset);
        StringBuilder sanitizedDesc = new StringBuilder(narrowedDesc.length());
        int i = 0;
        while (i < narrowedDesc.length()) {
            char c = narrowedDesc.charAt(i);
            if (c == '\\' || c == '/' || c == ':' || c == ',' || c == ';' || c == '*' || c == '?' || c == '\"' || c == '<' || c == '>' || c == '|') {
                sanitizedDesc.append('-');
            } else {
                sanitizedDesc.append(c);
            }
            ++i;
        }
        return sanitizedDesc.toString();
    }

    static String narrowCharset(String str, String charsetName) {
        String narrowedDesc = str;
        if (!charsetName.equals("")) {
            try {
                narrowedDesc = new String(str.getBytes(charsetName), charsetName);
            }
            catch (UnsupportedEncodingException e) {
                Logger.warning(e.toString());
            }
        }
        return narrowedDesc;
    }

    public String getId() {
        return this.cacheId;
    }

    public File getCacheFile() {
        return this.cacheFile;
    }

    public String getCacheFileName() {
        return this.cacheFile.getName();
    }

    public String getURLString() {
        return this.cacheFile.toURI().toString();
    }

    public void setDescribe(String desc) {
        this.cacheFile = this.getDescribedCacheFile(desc);
    }

    public void setTmpDescribe(String title) throws IOException {
        File newName = new File(cacheDir, NLTMP_ + this.getId() + "_" + Cache.getSanitizedDescription(title) + this.postfix);
        if (this.getCacheTmpFile().renameTo(newName)) {
            id2Tmp.put(this.getId(), newName);
        }
    }

    public long length() {
        return this.cacheFile.length();
    }

    public long tmpLength() throws IOException {
        return this.getCacheTmpFile().length();
    }

    public boolean exists() {
        return this.cacheFile.exists();
    }

    public void touch() {
        this.cacheFile.setLastModified(System.currentTimeMillis());
    }

    public InputStream getInputStream() throws IOException {
        this.cacheFile.setLastModified(System.currentTimeMillis());
        return new FileInputStream(this.cacheFile);
    }

    public InputStream getTmpInputStream() throws IOException {
        File cacheTmpFile = this.getCacheTmpFile();
        return new FileInputStream(cacheTmpFile);
    }

    public OutputStream getTmpOutputStream(boolean append) throws IOException {
        File cacheTmpFile = this.getCacheTmpFile();
        return new FileOutputStream(cacheTmpFile, append);
    }

    public void store() throws IOException {
        String lowId;
        File lowFile;
        File cacheTmpFile = this.getCacheTmpFile();
        File parentDir = cacheDir;
        if (!this.cacheId.endsWith("low") && (lowFile = id2File.get(lowId = String.valueOf(this.cacheId) + "low")) != null) {
            parentDir = lowFile.getParentFile();
        }
        this.cacheFile = new File(parentDir, this.cacheFile.getName());
        if (cacheTmpFile.renameTo(this.cacheFile)) {
            id2File.put(this.cacheId, this.cacheFile);
        } else {
            cacheTmpFile.delete();
        }
        id2Tmp.remove(this.cacheId);
    }

    public void deleteTmp() throws IOException {
        File cacheTmpFile = this.getCacheTmpFile();
        cacheTmpFile.delete();
    }

    protected synchronized File getCacheTmpFile() throws IOException {
        if (this.tmpFile == null) {
            File knownTmpFile = id2Tmp.get(this.getId());
            this.tmpFile = knownTmpFile == null ? new File(cacheDir, NLTMP_ + this.cacheFile.getName()) : knownTmpFile;
            if (!this.tmpFile.exists()) {
                this.tmpFile.createNewFile();
            }
        }
        id2Tmp.put(this.getId(), this.tmpFile);
        return this.tmpFile;
    }
}

