/*
 * Decompiled with CFR 0.152.
 */
package dareka.processor;

import dareka.common.Config;
import dareka.processor.HttpRequestHeader;
import dareka.processor.HttpResponseHeader;
import dareka.processor.Resource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.List;
import java.util.Map;

public class StringResource
extends Resource {
    private String statusline = "HTTP/1.1 200 OK";
    byte[] contentAsBytes;
    private boolean clientCanKeepAlive;

    public StringResource(String resource) {
        this.contentAsBytes = this.getBytesAsUtf8(resource);
    }

    public StringResource(byte[] resource) {
        this.contentAsBytes = resource;
    }

    public StringResource(int status, String resource) {
        switch (status) {
            case 302: {
                this.statusline = "HTTP/1.1 302 Found\r\nLocation:" + resource;
                this.contentAsBytes = new byte[0];
                return;
            }
            case 304: {
                this.statusline = "HTTP/1.1 304 Not Modified";
                break;
            }
            case 404: {
                this.statusline = "HTTP/1.1 404 Not Found";
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected status code: " + status);
            }
        }
        this.contentAsBytes = this.getBytesAsUtf8(resource);
    }

    private byte[] getBytesAsUtf8(String str) {
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("cannot use UTF-8");
        }
    }

    public void addNoCacheResponseHeaders() {
        this.setResponseHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        this.setResponseHeader("Cache-Control", "no-store");
        this.setResponseHeader("Pragma", "no-cache");
    }

    public void copyResponseHeaders(HttpResponseHeader responseHeader) {
        for (Map.Entry<String, List<String>> entry : responseHeader.getMessageHeaders().entrySet()) {
            String key = entry.getKey();
            List<String> values = entry.getValue();
            for (String value : values) {
                this.addResponseHeader(key, value);
            }
        }
    }

    @Override
    protected void doSetMandatoryResponseHeader(HttpResponseHeader responseHeader) {
        responseHeader.setContentLength(this.contentAsBytes.length);
        if (this.clientCanKeepAlive) {
            responseHeader.setMessageHeader("Connection", "keep-alive");
        } else {
            responseHeader.setMessageHeader("Connection", "close");
        }
    }

    @Override
    public boolean endEnsuredTransferTo(Socket receiver, HttpRequestHeader requestHeader, Config config) throws IOException {
        this.clientCanKeepAlive = this.isClientCanKeepAlive(requestHeader);
        HttpResponseHeader responseHeader = new HttpResponseHeader(String.valueOf(this.statusline) + "\r\n\r\n");
        this.execSendingHeaderSequence(receiver.getOutputStream(), responseHeader);
        this.execSendingBodySequence(receiver.getOutputStream(), new ByteArrayInputStream(this.contentAsBytes), responseHeader.getContentLength());
        return this.clientCanKeepAlive;
    }
}

