/*
 * Decompiled with CFR 0.152.
 */
package dareka.launcher.logview;

import dareka.common.DefaultLoggerHandler;
import dareka.launcher.logview.LogWindow;
import java.io.PrintWriter;
import java.io.StringWriter;

public class GUILoggerHandler
extends DefaultLoggerHandler {
    private static final boolean DEBUG = Boolean.getBoolean("dareka.debug");
    private LogWindow instance = LogWindow.getInstance();

    @Override
    public void debug(String message) {
        if (DEBUG) {
            System.out.println("DEBUG: " + message);
            this.instance.appendLog("DEBUG: " + message + "\n");
        }
    }

    @Override
    public void info(String message) {
        System.out.println(message);
        this.instance.appendLog(String.valueOf(message) + "\n");
    }

    @Override
    public void info(String format, Object ... arg) {
        System.out.printf(format, arg);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.printf(format, arg);
        this.instance.appendLog(sw.toString());
    }

    @Override
    public void warning(String message) {
        System.out.println(message);
        this.instance.appendLog(String.valueOf(message) + "\n");
    }

    @Override
    public void error(Throwable t) {
        System.out.println(this.getStackTraceString(t));
        this.instance.appendLog(String.valueOf(this.getStackTraceString(t)) + "\n");
    }
}

