/*
 * Decompiled with CFR 0.152.
 */
package dareka.launcher;

import dareka.Main;
import dareka.common.Logger;
import dareka.launcher.LauncherMain;
import dareka.launcher.common.IconImage;
import dareka.launcher.logview.LogWindow;
import java.awt.Desktop;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.Properties;

public class LauncherTray {
    private static final String URL_NICO_TOP = "http://www.nicovideo.jp/";
    private static final String URL_NICO_CACHE = "http://www.nicovideo.jp/cache/";
    private SystemTray f_tray;
    private TrayIcon f_trayIcon;

    public void start(String[] args) throws Exception {
        int intNameTail;
        if (!SystemTray.isSupported()) {
            System.out.println("\u30b7\u30b9\u30c6\u30e0\u30c8\u30ec\u30a4\u3092\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u305b\u3093\u3002");
            System.out.println("Java\u304c\u6700\u65b0\u7248(Version6.0\u4ee5\u964d)\u304b\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            return;
        }
        this.f_tray = SystemTray.getSystemTray();
        String strVerString = Main.getVersion();
        Image img = IconImage.getImage();
        PopupMenu popup = new PopupMenu();
        MenuItem menuhome = new MenuItem("\u30cb\u30b3\u30cb\u30b3\u52d5\u753b\u3092\u958b\u304f");
        menuhome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherTray.openBrowser(LauncherTray.URL_NICO_TOP);
            }
        });
        popup.add(menuhome);
        if (strVerString.startsWith("NicoCache_nl")) {
            MenuItem menucachepage = new MenuItem("\u30ad\u30e3\u30c3\u30b7\u30e5\u30da\u30fc\u30b8\u3092\u8868\u793a");
            menucachepage.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LauncherTray.openBrowser(LauncherTray.URL_NICO_CACHE);
                }
            });
            popup.add(menucachepage);
        }
        MenuItem menucachedir = new MenuItem("\u30ad\u30e3\u30c3\u30b7\u30e5\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u8868\u793a");
        menucachedir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherTray.openDirectory(new File("cache"));
            }
        });
        popup.add(menucachedir);
        popup.addSeparator();
        if (Boolean.getBoolean("dareka.debug")) {
            MenuItem menudebug = new MenuItem("\u30c7\u30d0\u30c3\u30b0\u30e2\u30fc\u30c9");
            menudebug.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Logger.info("\u672a\u5b9f\u88c5\u306a\u3046\u3048\u3001\u624b\u629c\u304d\u306aGUI\u3067\u3059\u3093\u307e\u305b\u3093\u3002");
                }
            });
            popup.add(menudebug);
        }
        MenuItem menushowlog = new MenuItem("\u30ed\u30b0\u30a6\u30a4\u30f3\u30c9\u30a6\u3092\u8868\u793a");
        menushowlog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogWindow.getInstance().show();
            }
        });
        popup.add(menushowlog);
        popup.addSeparator();
        String strProgName = strVerString.matches("^NicoCache v[0-9\\.]+p.*$") ? "NicoCache_p" : ((intNameTail = strVerString.indexOf(32)) == -1 ? strVerString : strVerString.substring(0, intNameTail));
        MenuItem menuexit = new MenuItem(String.valueOf(strProgName) + " \u306e\u7d42\u4e86");
        menuexit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LauncherTray.this.stop();
            }
        });
        popup.add(menuexit);
        this.f_trayIcon = new TrayIcon(img, strVerString, popup);
        this.f_trayIcon.setImageAutoSize(true);
        if (strVerString.startsWith("NicoCache_nl")) {
            this.f_trayIcon.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LauncherTray.openBrowser(LauncherTray.URL_NICO_CACHE);
                }
            });
        } else {
            this.f_trayIcon.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LauncherTray.openBrowser(LauncherTray.URL_NICO_TOP);
                }
            });
        }
        File file = new File("NicoCacheGUI.property");
        if (file.exists()) {
            FileInputStream in = new FileInputStream(file);
            Properties prop = new Properties();
            try {
                prop.load(in);
            }
            finally {
                in.close();
            }
            if (prop.size() != 0) {
                Rectangle rect = new Rectangle(Integer.parseInt(prop.getProperty("LogWindowX")), Integer.parseInt(prop.getProperty("LogWindowY")), Integer.parseInt(prop.getProperty("LogWindowW")), Integer.parseInt(prop.getProperty("LogWindowH")));
                LogWindow.getInstance().setBounds(rect);
            }
        }
        this.f_tray.add(this.f_trayIcon);
        if (Boolean.getBoolean("dareka.debug")) {
            LogWindow.getInstance().show();
        }
        try {
            Main.main(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        if (this.f_tray == null) {
            return;
        }
        Main.stop();
        try {
            FileOutputStream out = new FileOutputStream("NicoCacheGUI.property");
            Rectangle rect = LogWindow.getInstance().getBounds();
            Properties prop = new Properties();
            prop.setProperty("LogWindowX", Integer.toString(rect.x));
            prop.setProperty("LogWindowY", Integer.toString(rect.y));
            prop.setProperty("LogWindowW", Integer.toString(rect.width));
            prop.setProperty("LogWindowH", Integer.toString(rect.height));
            try {
                prop.store(out, LauncherMain.getVersion());
            }
            finally {
                out.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        LogWindow.getInstance().close();
        this.f_tray.remove(this.f_trayIcon);
        this.f_tray = null;
    }

    public static boolean openBrowser(String url) {
        Desktop desk = Desktop.getDesktop();
        try {
            desk.browse(new URL(url).toURI());
        }
        catch (Exception ex) {
            Logger.error(ex);
            return false;
        }
        return true;
    }

    private static boolean openDirectory(File file) {
        Desktop desk = Desktop.getDesktop();
        try {
            if (file.isDirectory()) {
                desk.open(file);
            }
        }
        catch (Exception ex) {
            Logger.error(ex);
            return false;
        }
        return true;
    }
}

