/*
 * Decompiled with CFR 0.152.
 */
package dareka.common;

import dareka.common.LoggerHandler;
import java.io.PrintWriter;
import java.io.StringWriter;

public class DefaultLoggerHandler
implements LoggerHandler {
    private static final boolean DEBUG = Boolean.getBoolean("dareka.debug");

    @Override
    public void debug(String message) {
        if (DEBUG) {
            System.out.println("DEBUG: " + message);
        }
    }

    @Override
    public void debug(Throwable t) {
        if (DEBUG) {
            this.debug(this.getStackTraceString(t));
        }
    }

    @Override
    public void debugWithThread(String message) {
        if (DEBUG) {
            this.debug(String.valueOf(Thread.currentThread().getName()) + ": " + message);
        }
    }

    @Override
    public void debugWithThread(Throwable t) {
        if (DEBUG) {
            this.debugWithThread(this.getStackTraceString(t));
        }
    }

    @Override
    public void info(String message) {
        System.out.println(message);
    }

    @Override
    public void info(String format, Object ... arg) {
        this.info(String.format(format, arg));
    }

    @Override
    public void warning(String message) {
        System.out.println(message);
    }

    @Override
    public void error(Throwable t) {
        System.out.println(this.getStackTraceString(t));
    }

    protected String getStackTraceString(Throwable t) {
        if (t == null) {
            return "null";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }
}

