package matrix;
import java.util.*;

import io.*;


public class ShortSim { 
    disrand dis;
    MatrixLoad m; // original mutation matrix
	Jacobi jacobi;
	
	public static void main(String[] args) throws Exception{
		String[] data = fileload.loadLine0(args[0]);
		MatrixLoad m0 = new MatrixLoad(data);
		ShortSim mut = new ShortSim(m0);
//		test(args);
		double scale = 6.25;
		double STEP  = 0.1;
		int seq_length = 30;
		int repeat = 1000;

//		for(double x=0.0;x<1.0;x+=0.05){
		for(double x=0.0;x<1.0;x+=STEP){
//			for(double y=x*0.25-0.1;y<x*0.25;y+=0.005){
			for(double y=0;y<1.0;y+=STEP){
			    int countDNA=0;
			    int countAA=0;

				for(int n=0;n<repeat;n++){//repeat
					String[] DNA = mut.felsensteinTree(seq_length,x*scale,y*scale);
//					String[] DNA = mut.longTree(10000,x*scale,y*scale);
					String[] aminoacid = new String[DNA.length]; // length is not length but size
					CodonTable t = new CodonTable();
					for(int i=0;i<DNA.length;i++) aminoacid[i] = t.translate(0,DNA[i]);
					if (numberOfConsistent(DNA)>numberOfLBA(DNA)) countDNA++;
					if (numberOfConsistent(aminoacid)>numberOfLBA(aminoacid)) countAA++;
				}
				System.out.print( x );
				System.out.print( "\t" );
				System.out.print( y );
				System.out.print( "\t" );
				System.out.print( countDNA );
				System.out.print( "\t" );
				System.out.print( countAA );
				System.out.print( "\t" );
/*
				System.out.print( numberOfConsistent(DNA) );
				System.out.print( "\t" );
				System.out.print( numberOfLBA(DNA) );
				System.out.print( "\t" );
				System.out.print( numberOfConsistent(aminoacid) );
				System.out.print( "\t" );
				System.out.print( numberOfLBA(aminoacid) );
*/
				System.out.println();
			}
		}
	}

	
	public String[] felsensteinTree(int seqLen, double x, double y){
        StringBuffer SB = new StringBuffer();
        for(int i=0;i<seqLen;i++) SB.append("AAA");
		// a------e---b
		//     x  | y
		// c------f---d
		String a = mutateThrough(100, SB.toString() ); // many mutations
		String e = mutateThrough(x,a);
		String b = mutateThrough(y,e);
		String f = mutateThrough(y,e);
		String c = mutateThrough(x,f);
		String d = mutateThrough(y,f);
		String[] result = new String[4];
		result[0]=a;result[1]=b;  // correct ((0,1),(2,3))
		result[2]=c;result[3]=d;  // LBA     ((0,2),(1,3))
		return result;
	}

	public String[] longTree(int seqLen, double x, double y){
        StringBuffer SB = new StringBuffer();
        for(int i=0;i<seqLen;i++) SB.append("AAA");
        //     x     x
		// a------e------b
		//        | y
		//    c---f---d
		//      y   y
		String a = mutateThrough(100, SB.toString() ); // many mutations
		String e = mutateThrough(x,a);
		String b = mutateThrough(x,e);
		String f = mutateThrough(y,e);
		String c = mutateThrough(y,f);
		String d = mutateThrough(y,f);
		String[] result = new String[4];
		result[0]=a;result[1]=b;  // correct ((0,1),(2,3))
		result[2]=c;result[3]=d;  // LBA     ((0,2),(1,3))
		return result;
	}


	public static int numberOfConsistent(String[] data){
		int count=0;
		for(int i=0;i<data[0].length();i++){
			char c0 = data[0].charAt(i);
			char c1 = data[1].charAt(i);
			char c2 = data[2].charAt(i);
			char c3 = data[3].charAt(i);
			if( (c0!=c2) && (c0==c1)&&(c2==c3) ) count++;
		}
		return count;
	}

	public static int numberOfLBA(String[] data){
		int count=0;
		for(int i=0;i<data[0].length();i++){
			char c0 = data[0].charAt(i);
			char c1 = data[1].charAt(i);
			char c2 = data[2].charAt(i);
			char c3 = data[3].charAt(i);
			if( (c0!=c1) && (c0==c2)&&(c1==c3) ) count++;
		}
		return count;
	}

	public static void test(String[] args) throws Exception{
		String[] data = fileload.loadLine0(args[0]);
		MatrixLoad m0 = new MatrixLoad(data);
		ShortSim mut = new ShortSim(m0);
        StringBuffer SB = new StringBuffer();
        for(int i=0;i<10000;i++) SB.append("AAA");
		String org = mut.mutateThrough(100, SB.toString() ); // many mutations

		CodonTable t = new CodonTable();
		String DNA0 = org;
		String aminoacid0 = t.translate(0,DNA0);
		for(double x=0.0;x<30;x+=0.5){
			String DNA1 = mut.mutateThrough(x,org);
			String aminoacid1 = t.translate(0,DNA1);

			double pDNA = p(DNA0,DNA1);
			double dDNA = -(3.0/4.0)*Math.log( 1.0-(4.0/3.0)*pDNA ); //Jukes-Cantor
			double pAmino = p(aminoacid0,aminoacid1);
			double dAmino = -Math.log( 1.0-pAmino ); // Poisson

			System.out.print( x );
			System.out.print( "\t" );
			System.out.print( pDNA );
			System.out.print( "\t" );
			System.out.print( dDNA );
			System.out.print( "\t" );
			System.out.print( pAmino );
			System.out.print( "\t" );
			System.out.print( dAmino );
			System.out.println();
		}
	}

	public static double p(String s1, String s2){
        double d=0;
		for(int i=0;i<s2.length();i++){
			if(s1.charAt(i)!=s2.charAt(i)) d++;
		}
		return d/s1.length();
	}
	
    public ShortSim(MatrixLoad m0) throws Exception{
    	m=m0;
		jacobi = new Jacobi(m.matrix);
        dis = new disrand();
    }

    public String mutateThrough(double T_v,String seq){ 
    	double[][] mutMatrix = jacobi.power(T_v);

    	StringBuffer SB = new StringBuffer();
        for(int i=0;i<seq.length()-2;i+=3){
		    String codon = seq.substring(i,i+3);
	    	double[] mutVector = mutMatrix[m.getPos(codon)]; 
			int c = dis.value(mutVector);
        	SB.append( m.list[c] );
        }
        return SB.toString();
    }
}
