package io;
import java.util.*;
import java.io.*;
import matrix.*;

/**
 * @author user
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class MatrixLoad {
    public String[] list;
    public double[][] matrix;
    Hashtable table;
    
    public static void main(String args[])  throws Exception {
		String[] data = fileload.loadLine0(args[0]);
    	MatrixLoad m = new MatrixLoad(data);
//    	for(int i=0;i<m.list.length;i++) System.out.println(m.list[i]);
//        System.out.println( m.value(args[1],args[2]) );
		Jacobi j = new Jacobi(m.matrix);
		Matrix.show( j.V() );
//		Matrix.show( Matrix.multiple(m.matrix,m.matrix) );
    }

	public MatrixLoad(String[] data)  throws FileNotFoundException,IOException {
        String[][] tmp = CSVtoStringMatrix(data);

        // double matrix
        matrix = StringToDoubleMatrix( tmp );

    	// list of name
        list = new String[tmp[0].length-1];

        for(int i=0;i<list.length;i++){
        	list[i] = tmp[0][i+1];
        }

    	// correspond name to number
    	table = new Hashtable();
		for(int i=0;i<list.length;i++){
			table.put(list[i],new Integer(i));
		}
	}

	public static double[][] StringToDoubleMatrix2(String[][] org){ 
        double[][] data = new double[org.length-1][];// first line is name

        for(int i=0;i<org.length-1;i++){
        	int size=org[i+1].length;
            data[i] = new double[size-1]; // first line is name
        	for(int j=0;j<size-1;j++){
                String a = org[i+1][j+1];
                double d = ( new Double(a) ).doubleValue();
        		data[i][j] = d;
        	}
        }
//        return data;
       	double[][] result = new double[data.length][];
      	for(int i=0;i<data.length;i++){
            double total = 0.0;
       		for(int j=0;j<data[i].length;j++) total+= data[i][j];
       		result[i] = new double[data[i].length];
       		for(int j=0;j<data[i].length;j++){
       			result[i][j] = data[i][j];//total;
       		}
       	}
        return result;
    }
	
	public static double[][] StringToDoubleMatrix(String[][] org){ 
        double[][] data = new double[org.length-1][];// first line is name

        for(int i=0;i<org.length-1;i++){
        	int size=org[i+1].length;
            data[i] = new double[size-1]; // first line is name
        	for(int j=0;j<size-1;j++){
                String a = org[i+1][j+1];
                double d = ( new Double(a) ).doubleValue();
        		data[i][j] = d;
        	}
        }
//        return data;
       	double[][] result = new double[data.length][];
      	for(int i=0;i<data.length;i++){
            double total = 0.0;
       		for(int j=0;j<data[i].length;j++) total+= data[i][j];
       		result[i] = new double[data[i].length];
       		for(int j=0;j<data[i].length;j++){
       			result[i][j] = data[i][j]/total;
       		}
       	}
        return result;
    }

	public static String[][] CSVtoStringMatrix(String[] lines){ 
        String[][] data = new String[lines.length][];// first line is name
        for(int i=0;i<lines.length;i++){
        	Vector v = new Vector();
        	StringTokenizer ST = new StringTokenizer(lines[i],",");
        	while (ST.hasMoreTokens()){
        		v.addElement(ST.nextToken());
        	}
        	int size=v.size();
            data[i] = new String[size]; // first line is name
        	for(int j=0;j<size;j++){
                String a = (String) v.elementAt(j);
        		data[i][j] = a;
        	}
        }
        return data;
    }
    
	public double value(String X, String Y){
		int x = ((Integer) table.get(X)).intValue();
		int y = ((Integer) table.get(Y)).intValue();
		return ( matrix[x][y] );
	}
	
	public int getPos(String X){
		int x = ((Integer) table.get(X)).intValue();
		return ( x );	}
	
	public double[] vector(String X){
		int x = ((Integer) table.get(X)).intValue();
		return ( matrix[x] );
	}
}
