/*
 * Decompiled with CFR 0.152.
 */
package matrix;

import io.MatrixLoad;
import io.fastaFormat;
import io.fileload;
import io.newMatrixLoad;
import matrix.Jacobi;
import matrix.disrand;

public class probCDS {
    disrand dis;
    MatrixLoad m;
    Jacobi jacobi;

    public static void main(String[] args) throws Exception {
        String[] data = fileload.loadLine0(args[0]);
        newMatrixLoad m0 = new newMatrixLoad(data);
        String[][] data2 = fastaFormat.input(args[1]);
        String[] DNA = data2[1];
        double kappa = new Double(args[2]);
        double lambda = new Double(args[3]);
        String[][] result = new String[][]{data2[0], probCDS.maxCDS(m0, DNA[0], DNA[1])};
        System.out.print(args[1]);
        System.out.print("\t");
        System.out.println(probCDS.E(kappa, lambda, DNA[0].length(), new Double(result[1][2])));
    }

    public static double E(double kappa, double lambda, int len, double score) {
        return kappa * (double)len * Math.exp(-score * lambda);
    }

    public static String[] maxCDS(newMatrixLoad mat, String seq1, String seq2) {
        int len = seq1.length() / 3;
        double[][] keisan = new double[3][len];
        int n = 0;
        while (n < 3) {
            int i = 0;
            while (i < len) {
                keisan[n][i] = mat.value(seq1.substring(i * 3, i * 3 + 3), seq2.substring(i * 3, i * 3 + 3));
                ++i;
            }
            ++n;
        }
        double max = -100.0;
        int maxX = 0;
        int maxY = 0;
        int n2 = 0;
        while (n2 < 3) {
            int start = 0;
            while (start < len - 1) {
                double total = keisan[n2][start];
                int end = start + 1;
                while (end < len) {
                    if (max < (total += keisan[n2][end])) {
                        max = total;
                        maxX = start * 3 + n2;
                        maxY = end * 3 + n2;
                    }
                    ++end;
                }
                ++start;
            }
            ++n2;
        }
        String[] result = new String[]{seq1.substring(maxX, maxY), seq2.substring(maxX, maxY), new Double(max).toString()};
        return result;
    }

    public static double max50(newMatrixLoad mat, String seq1, String seq2) {
        int len = seq1.length() / 3;
        double[] keisan = new double[len];
        int i = 0;
        while (i < len) {
            keisan[i] = mat.value(seq1.substring(i * 3, i * 3 + 3), seq2.substring(i * 3, i * 3 + 3));
            ++i;
        }
        double max = -100.0;
        int maxX = 0;
        int maxY = 0;
        int start = 0;
        while (start < len - 1) {
            double total = keisan[start];
            int end = start + 1;
            while (end < start + 50 && end < len) {
                if (max < (total += keisan[end])) {
                    max = total;
                    maxX = start;
                    maxY = end;
                }
                ++end;
            }
            ++start;
        }
        return max;
    }

    public static double max(newMatrixLoad mat, String seq1, String seq2) {
        int len = seq1.length() / 3;
        double[] keisan = new double[len];
        int i = 0;
        while (i < len) {
            keisan[i] = mat.value(seq1.substring(i * 3, i * 3 + 3), seq2.substring(i * 3, i * 3 + 3));
            ++i;
        }
        double max = -100.0;
        int maxX = 0;
        int maxY = 0;
        int start = 0;
        while (start < len - 1) {
            double total = keisan[start];
            int end = start + 1;
            while (end < len) {
                if (max < (total += keisan[end])) {
                    max = total;
                    maxX = start;
                    maxY = end;
                }
                ++end;
            }
            ++start;
        }
        System.out.println(seq1.substring(maxX, maxY));
        return max;
    }
}

