/*
 * Decompiled with CFR 0.152.
 */
package matrix;

import io.MatrixLoad;
import io.blastFormat;
import io.doBlast2;
import io.fastaFormat;
import io.fileload;
import io.newMatrixLoad;
import matrix.Jacobi;
import matrix.disrand;

public class findCDStest {
    disrand dis;
    MatrixLoad m;
    Jacobi jacobi;

    public static void main(String[] args) throws Exception {
        newMatrixLoad m0 = new newMatrixLoad();
        double kappa = newMatrixLoad.kappa;
        double lambda = newMatrixLoad.lambda;
        String[] tmpdata = args.length > 0 ? fileload.loadLine0(args[0]) : fileload.loadLine0();
        String[][] data = new String[0][0];
        data = tmpdata[0].charAt(0) == '>' ? fastaFormat.translate(tmpdata) : blastFormat.translate(tmpdata);
        int n = 0;
        while (n < data[0].length) {
            String[][] data2 = blastFormat.translate(doBlast2.search(data[1][n]));
            double[] score = new double[3];
            score[2] = 0.0;
            score[1] = 0.0;
            score[0] = 0.0;
            int size = data2[0].length / 2;
            int i = 0;
            while (i < size) {
                String[][] result = new String[2][];
                String[] tmp = findCDStest.maxCDS(m0, data2[1][i * 2], data2[1][i * 2 + 1], score);
                result[0] = new String[1];
                double E = findCDStest.E(kappa, lambda, data2[1][i * 2].length(), score[0]);
                if (E < 0.01) {
                    System.out.print(String.valueOf(data[0][n]) + "\t");
                    System.out.print(String.valueOf(score[1]) + "\t");
                    System.out.print(String.valueOf(score[2]) + "\t");
                    System.out.print(E);
                    System.out.println();
                }
                ++i;
            }
            ++n;
        }
    }

    public static double E(double kappa, double lambda, int len, double score) {
        return kappa * (double)len * Math.exp(-score * lambda);
    }

    public static String[] maxCDS(newMatrixLoad mat, String seq1, String seq2, double[] score) {
        int len = seq1.length() / 3;
        double[][] keisan = new double[3][len];
        int n = 0;
        while (n < 3) {
            int i = 0;
            while (i < len) {
                keisan[n][i] = mat.value(seq1.substring(i * 3, i * 3 + 3), seq2.substring(i * 3, i * 3 + 3));
                ++i;
            }
            ++n;
        }
        double max = -100.0;
        int maxX = 0;
        int maxY = 0;
        int n2 = 0;
        while (n2 < 3) {
            int start = 0;
            while (start < len - 1) {
                double total = keisan[n2][start];
                int end = start + 1;
                while (end < len) {
                    if (max < (total += keisan[n2][end])) {
                        max = total;
                        maxX = start * 3 + n2;
                        maxY = end * 3 + n2;
                    }
                    ++end;
                }
                ++start;
            }
            ++n2;
        }
        String[] result = new String[3];
        result[0] = seq1.substring(maxX, maxY);
        result[1] = seq2.substring(maxX, maxY);
        score[0] = max;
        score[1] = maxX;
        score[2] = maxY;
        return result;
    }

    public static double max50(newMatrixLoad mat, String seq1, String seq2) {
        int len = seq1.length() / 3;
        double[] keisan = new double[len];
        int i = 0;
        while (i < len) {
            keisan[i] = mat.value(seq1.substring(i * 3, i * 3 + 3), seq2.substring(i * 3, i * 3 + 3));
            ++i;
        }
        double max = -100.0;
        int maxX = 0;
        int maxY = 0;
        int start = 0;
        while (start < len - 1) {
            double total = keisan[start];
            int end = start + 1;
            while (end < start + 50 && end < len) {
                if (max < (total += keisan[end])) {
                    max = total;
                    maxX = start;
                    maxY = end;
                }
                ++end;
            }
            ++start;
        }
        return max;
    }

    public static double max(newMatrixLoad mat, String seq1, String seq2) {
        int len = seq1.length() / 3;
        double[] keisan = new double[len];
        int i = 0;
        while (i < len) {
            keisan[i] = mat.value(seq1.substring(i * 3, i * 3 + 3), seq2.substring(i * 3, i * 3 + 3));
            ++i;
        }
        double max = -100.0;
        int maxX = 0;
        int maxY = 0;
        int start = 0;
        while (start < len - 1) {
            double total = keisan[start];
            int end = start + 1;
            while (end < len) {
                if (max < (total += keisan[end])) {
                    max = total;
                    maxX = start;
                    maxY = end;
                }
                ++end;
            }
            ++start;
        }
        System.out.println(seq1.substring(maxX, maxY));
        return max;
    }
}

