/*
 * Decompiled with CFR 0.152.
 */
package matrix;

import io.AwkLike;
import io.MatrixLoad;
import io.blastFormat;
import io.doBlastHuman;
import io.fastaFormat;
import io.fileload;
import io.newMatrixLoad;
import java.util.Vector;
import matrix.Jacobi;
import matrix.disrand;
import matrix.findCDS;

public class findCDSblast3 {
    disrand dis;
    MatrixLoad m;
    Jacobi jacobi;

    public static void main(String[] args) throws Exception {
        newMatrixLoad m0 = new newMatrixLoad();
        double kappa = newMatrixLoad.kappa;
        double lambda = newMatrixLoad.lambda;
        String[] tmpdata = args.length > 0 ? fileload.loadLine0(args[0]) : fileload.loadLine0();
        String[][] data = new String[0][0];
        data = tmpdata[0].charAt(0) == '>' ? fastaFormat.translate(tmpdata) : blastFormat.translate(tmpdata);
        int n = 0;
        while (n < data[0].length) {
            String[][] data2 = blastFormat.translate(doBlastHuman.search(data[1][n]));
            int queryLen = blastFormat.queryLen(tmpdata);
            Vector<Integer> exonStart = new Vector<Integer>();
            Vector<Integer> exonEnd = new Vector<Integer>();
            Vector<String> muki = new Vector<String>();
            Vector<Double> Elist = new Vector<Double>();
            int size = data2[0].length / 2;
            int i = 0;
            while (i < size) {
                int end;
                int start;
                int tmp;
                AwkLike line;
                double E;
                int len = data2[1][i * 2].length();
                double[][] result = findCDS.areas(m0, data2[1][i * 2 + 1], data2[1][i * 2]);
                int j = 0;
                while (j < result.length) {
                    E = findCDS.E(kappa, lambda, data2[1][i * 2].length(), result[j][2]);
                    if (E < 0.01) {
                        line = new AwkLike(data2[0][i * 2]);
                        tmp = new Integer(line.doller(2));
                        start = (int)(result[j][0] + (double)tmp);
                        end = (int)(result[j][1] + (double)tmp);
                        exonStart.add(new Integer(start));
                        exonEnd.add(new Integer(end));
                        muki.add("+");
                        Elist.add(new Double(E));
                    }
                    ++j;
                }
                len = data2[1][i * 2].length();
                result = findCDS.areas(m0, blastFormat.complement(data2[1][i * 2 + 1]), blastFormat.complement(data2[1][i * 2]));
                j = 0;
                while (j < result.length) {
                    E = findCDS.E(kappa, lambda, data2[1][i * 2].length(), result[j][2]);
                    if (E < 0.01) {
                        line = new AwkLike(data2[0][i * 2]);
                        tmp = new Integer(line.doller(3));
                        start = (int)(-result[j][0] + (double)tmp);
                        end = (int)(-result[j][1] + (double)tmp);
                        exonStart.add(new Integer(start));
                        exonEnd.add(new Integer(end));
                        muki.add("-");
                        Elist.add(new Double(E));
                    }
                    ++j;
                }
                ++i;
            }
            size = exonStart.size();
            int j = 0;
            while (j < size) {
                System.out.print(args[0]);
                System.out.print("\t");
                System.out.print("new");
                System.out.print("\t");
                System.out.print("CDS");
                System.out.print("\t");
                System.out.print(exonStart.elementAt(j).toString());
                System.out.print("\t");
                System.out.print(exonEnd.elementAt(j).toString());
                System.out.print("\t");
                System.out.print(muki.elementAt(j).toString());
                System.out.print("\t");
                System.out.print(Elist.elementAt(j).toString());
                System.out.println();
                ++j;
            }
            ++n;
        }
    }
}

