/*
 * Decompiled with CFR 0.152.
 */
package matrix;

import io.AwkLike;
import io.MatrixLoad;
import io.blastFormat;
import io.doBlastHuman;
import io.fastaFormat;
import io.fileload;
import io.newMatrixLoad;
import matrix.Jacobi;
import matrix.disrand;
import matrix.findCDS;

public class findCDSblast2 {
    disrand dis;
    MatrixLoad m;
    Jacobi jacobi;

    public static void main(String[] args) throws Exception {
        newMatrixLoad m0 = new newMatrixLoad();
        double kappa = newMatrixLoad.kappa;
        double lambda = newMatrixLoad.lambda;
        String[] tmpdata = args.length > 0 ? fileload.loadLine0(args[0]) : fileload.loadLine0();
        String[][] data = new String[0][0];
        data = tmpdata[0].charAt(0) == '>' ? fastaFormat.translate(tmpdata) : blastFormat.translate(tmpdata);
        int n = 0;
        while (n < data[0].length) {
            String[][] data2 = blastFormat.translate(doBlastHuman.search(data[1][n]));
            int size = data2[0].length / 2;
            int orgLen = data[1][n].length();
            boolean[] CDS = new boolean[data[1][n].length()];
            int j = 0;
            while (j < data[1][n].length()) {
                CDS[j] = false;
                ++j;
            }
            int i = 0;
            while (i < size) {
                int len = data2[1][i * 2].length();
                double[][] result = findCDS.areas(m0, data2[1][i * 2 + 1], data2[1][i * 2]);
                int j2 = 0;
                while (j2 < result.length) {
                    double E = findCDS.E(kappa, lambda, orgLen, result[j2][2]);
                    if (E < 0.01) {
                        AwkLike line = new AwkLike(data2[0][i * 2]);
                        int tmp = new Integer(line.doller(2));
                        int start = (int)(result[j2][0] + (double)tmp);
                        int end = (int)(result[j2][1] + (double)tmp);
                        int k = start;
                        while (k <= end) {
                            CDS[k] = true;
                            ++k;
                        }
                    }
                    ++j2;
                }
                ++i;
            }
            System.out.print(String.valueOf(data[0][n]) + "\t");
            if (CDS[0]) {
                System.out.print("0\t");
            }
            j = 1;
            while (j < data[1][n].length() - 1) {
                if (!CDS[j - 1] && CDS[j]) {
                    System.out.print(String.valueOf(j) + "\t");
                }
                if (CDS[j] && !CDS[j + 1]) {
                    System.out.print(String.valueOf(j) + "\t");
                }
                ++j;
            }
            if (CDS[data[1][n].length() - 1]) {
                System.out.print("0\t");
            }
            System.out.println();
            ++n;
        }
    }
}

