/*
 * Decompiled with CFR 0.152.
 */
package matrix;

import io.MatrixLoad;
import io.blastFormat;
import io.fastaFormat;
import io.fileload;
import io.newMatrixLoad;
import matrix.Jacobi;
import matrix.disrand;

public class findCDSback {
    disrand dis;
    MatrixLoad m;
    Jacobi jacobi;

    public static void main(String[] args) throws Exception {
        newMatrixLoad m0 = new newMatrixLoad();
        double kappa = newMatrixLoad.kappa;
        double lambda = newMatrixLoad.lambda;
        String[] tmpdata = fileload.loadLine0(args[0]);
        String[][] data2 = new String[0][0];
        data2 = tmpdata[0].charAt(0) == '>' ? fastaFormat.translate(tmpdata) : blastFormat.translate(tmpdata);
        double[] score = new double[]{0.0};
        int size = data2[0].length / 2;
        int i = 0;
        while (i < size) {
            String[][] result = new String[2][];
            result[1] = findCDSback.maxCDS(m0, data2[1][i * 2], data2[1][i * 2 + 1], score);
            result[0] = new String[2];
            double E = findCDSback.E(kappa, lambda, data2[1][i * 2].length(), score[0]);
            result[0][0] = String.valueOf(data2[0][i * 2]) + " " + E;
            result[0][1] = String.valueOf(data2[0][i * 2 + 1]) + " " + E;
            fastaFormat.output(result);
            ++i;
        }
    }

    public static double E(double kappa, double lambda, int len, double score) {
        return kappa * (double)len * Math.exp(-score * lambda);
    }

    public static String[] maxCDS(newMatrixLoad mat, String seq1, String seq2, double[] score) {
        int len = seq1.length() / 3;
        double[][] keisan = new double[3][len];
        int n = 0;
        while (n < 3) {
            int i = 0;
            while (i < len) {
                keisan[n][i] = mat.value(seq1.substring(i * 3, i * 3 + 3), seq2.substring(i * 3, i * 3 + 3));
                ++i;
            }
            ++n;
        }
        double max = -100.0;
        int maxX = 0;
        int maxY = 0;
        int n2 = 0;
        while (n2 < 3) {
            int start = 0;
            while (start < len - 1) {
                double total = keisan[n2][start];
                int end = start + 1;
                while (end < len) {
                    if (max < (total += keisan[n2][end])) {
                        max = total;
                        maxX = start * 3 + n2;
                        maxY = end * 3 + n2;
                    }
                    ++end;
                }
                ++start;
            }
            ++n2;
        }
        String[] result = new String[3];
        result[0] = seq1.substring(maxX, maxY);
        result[1] = seq2.substring(maxX, maxY);
        score[0] = max;
        return result;
    }

    public static double[][] highScores(newMatrixLoad mat, String seq1, String seq2, double[] score) {
        int size = seq1.length() / 3;
        int len = size / 3;
        double[][] keisan = new double[3][len];
        double[][] result = new double[3][len];
        int n = 0;
        while (n < 3) {
            int i = 0;
            while (i < len) {
                keisan[n][i] = mat.value(seq1.substring(i * 3, i * 3 + 3), seq2.substring(i * 3, i * 3 + 3));
                ++i;
            }
            ++n;
        }
        double max = -100.0;
        boolean maxX = false;
        boolean maxY = false;
        int n2 = 0;
        while (n2 < 3) {
            int end;
            double total;
            double[][] tmp = new double[len][len];
            int start = 0;
            while (start < len - 1) {
                total = keisan[n2][start];
                end = start + 1;
                while (end < len) {
                    tmp[start][end] = total += keisan[n2][end];
                    ++end;
                }
                ++start;
            }
            start = 0;
            while (start < len - 1) {
                total = keisan[n2][start];
                end = start + 1;
                while (end < len) {
                    if (result[n2][end] < tmp[start][end]) {
                        result[n2][end] = tmp[start][end];
                    }
                    ++end;
                }
                ++start;
            }
            ++n2;
        }
        return result;
    }

    public static double[][] scores(newMatrixLoad mat, String seq1, String seq2, double[] score) {
        int size = seq1.length() / 3;
        int len = size / 3;
        double[][] keisan = new double[3][len];
        double[][] result = new double[3][len];
        int n = 0;
        while (n < 3) {
            int i = 0;
            while (i < len) {
                keisan[n][i] = mat.value(seq1.substring(i * 3, i * 3 + 3), seq2.substring(i * 3, i * 3 + 3));
                ++i;
            }
            ++n;
        }
        return keisan;
    }

    public static double[] window5(double[] org) {
        int len = org.length;
        double[] keisan = new double[len];
        keisan[0] = org[0];
        keisan[1] = org[0] + org[1];
        int i = 2;
        while (i < len - 2) {
            keisan[i] = org[i - 2] + org[i - 1] + org[i] + org[i + 1] + org[i + 2];
            ++i;
        }
        return keisan;
    }

    public static double max50(newMatrixLoad mat, String seq1, String seq2) {
        int len = seq1.length() / 3;
        double[] keisan = new double[len];
        int i = 0;
        while (i < len) {
            keisan[i] = mat.value(seq1.substring(i * 3, i * 3 + 3), seq2.substring(i * 3, i * 3 + 3));
            ++i;
        }
        double max = -100.0;
        int maxX = 0;
        int maxY = 0;
        int start = 0;
        while (start < len - 1) {
            double total = keisan[start];
            int end = start + 1;
            while (end < start + 50 && end < len) {
                if (max < (total += keisan[end])) {
                    max = total;
                    maxX = start;
                    maxY = end;
                }
                ++end;
            }
            ++start;
        }
        return max;
    }

    public static double max(newMatrixLoad mat, String seq1, String seq2) {
        int len = seq1.length() / 3;
        double[] keisan = new double[len];
        int i = 0;
        while (i < len) {
            keisan[i] = mat.value(seq1.substring(i * 3, i * 3 + 3), seq2.substring(i * 3, i * 3 + 3));
            ++i;
        }
        double max = -100.0;
        int maxX = 0;
        int maxY = 0;
        int start = 0;
        while (start < len - 1) {
            double total = keisan[start];
            int end = start + 1;
            while (end < len) {
                if (max < (total += keisan[end])) {
                    max = total;
                    maxX = start;
                    maxY = end;
                }
                ++end;
            }
            ++start;
        }
        System.out.println(seq1.substring(maxX, maxY));
        return max;
    }
}

