/*
 * Decompiled with CFR 0.152.
 */
package matrix;

import io.MatrixLoad;
import io.blastFormat;
import io.fastaFormat;
import io.fileload;
import io.newMatrixLoad;
import java.util.Vector;
import matrix.Jacobi;
import matrix.disrand;

public class findCDS {
    disrand dis;
    MatrixLoad m;
    Jacobi jacobi;

    public static void main(String[] args) throws Exception {
        newMatrixLoad m0 = new newMatrixLoad();
        double kappa = newMatrixLoad.kappa;
        double lambda = newMatrixLoad.lambda;
        String[] tmpdata = fileload.loadLine0(args[0]);
        String[][] data2 = new String[0][0];
        data2 = tmpdata[0].charAt(0) == '>' ? fastaFormat.translate(tmpdata) : blastFormat.translate(tmpdata);
        int i = 0;
        while (i < data2[0].length / 2) {
            double[][] result = findCDS.areas(m0, data2[1][i * 2], data2[1][i * 2 + 1]);
            int j = 0;
            while (j < result.length) {
                double E = findCDS.E(kappa, lambda, data2[1][i * 2].length(), result[j][2]);
                if (E < 0.01) {
                    System.out.println(String.valueOf((int)result[j][0]) + "\t" + (int)result[j][1] + "\t" + E);
                }
                ++j;
            }
            ++i;
        }
    }

    public static double E(double kappa, double lambda, int len, double score) {
        return kappa * (double)len * Math.exp(-score * lambda);
    }

    public static String[] maxCDS(newMatrixLoad mat, String seq1, String seq2, double[] score) {
        int len = seq1.length() / 3;
        double[][] keisan = findCDS.scores(mat, seq1, seq2);
        double max = -100.0;
        int maxX = 0;
        int maxY = 0;
        int n = 0;
        while (n < 3) {
            int start = 0;
            while (start < len - 1) {
                double total = keisan[n][start];
                int end = start + 1;
                while (end < len) {
                    if (max < (total += keisan[n][end])) {
                        max = total;
                        maxX = start * 3 + n;
                        maxY = end * 3 + n;
                    }
                    ++end;
                }
                ++start;
            }
            ++n;
        }
        String[] result = new String[3];
        result[0] = seq1.substring(maxX, maxY);
        result[1] = seq2.substring(maxX, maxY);
        score[0] = max;
        return result;
    }

    public static double[][] scores(newMatrixLoad mat, String seq1, String seq2) {
        int size = seq1.length() / 3;
        if (seq2.length() < seq1.length()) {
            size = seq2.length() / 3;
        }
        double[][] keisan = new double[3][size];
        double[][] result = new double[3][size];
        int n = 0;
        while (n < 3) {
            int i = 0;
            while (i < size - 2) {
                keisan[n][i] = mat.value(seq1.substring(i * 3 + n, i * 3 + 3 + n), seq2.substring(i * 3 + n, i * 3 + 3 + n));
                ++i;
            }
            ++n;
        }
        return keisan;
    }

    public static double[] window5(double[] org) {
        int len = org.length;
        double[] keisan = new double[len];
        keisan[0] = org[0];
        keisan[1] = org[0] + org[1];
        int i = 2;
        while (i < len - 2) {
            keisan[i] = org[i - 2] + org[i - 1] + org[i] + org[i + 1] + org[i + 2];
            ++i;
        }
        return keisan;
    }

    public static int maxPos(double[] data) {
        double max = 0.0;
        int result = 0;
        int i = 0;
        while (i < data.length) {
            if (max < data[i]) {
                max = data[i];
                result = i;
            }
            ++i;
        }
        return result;
    }

    public static double[] extend(int center, double[] data) {
        int start = center;
        int end = center;
        double max = 0.0;
        double total = 0.0;
        int i = center;
        while (i >= 0) {
            if (max < (total += data[i])) {
                max = total;
                start = i;
            }
            --i;
        }
        double max1 = max;
        max = 0.0;
        int i2 = center;
        while (i2 < data.length) {
            if (max < (total += data[i2])) {
                max = total;
                end = i2;
            }
            ++i2;
        }
        double[] result = new double[]{start, end, max1 + max - data[center]};
        return result;
    }

    public static double[][] areas(newMatrixLoad mat, String seq1, String seq2) {
        double[][] tmp = findCDS.scores(mat, seq1, seq2);
        Vector<Double> start = new Vector<Double>();
        Vector<Double> end = new Vector<Double>();
        Vector<Double> score = new Vector<Double>();
        int n = 0;
        while (n < 3) {
            double highScore = 1.0;
            do {
                highScore = 0.0;
                double[] tmp2 = findCDS.window5(tmp[n]);
                int pos = findCDS.maxPos(tmp2);
                double[] startend = findCDS.extend(pos, tmp[n]);
                int j = (int)startend[0];
                while ((double)j <= startend[1]) {
                    tmp[n][j] = 0.0;
                    ++j;
                }
                highScore = startend[2];
                if (!(highScore > 0.0)) continue;
                start.add(new Double(startend[0] * 3.0 + (double)n));
                end.add(new Double(startend[1] * 3.0 + (double)n));
                score.add(new Double(startend[2]));
            } while (highScore > 0.0);
            ++n;
        }
        int size = start.size();
        double[][] result = new double[size][3];
        int i = 0;
        while (i < size) {
            result[i][0] = (Double)start.elementAt(i);
            result[i][1] = (Double)end.elementAt(i);
            result[i][2] = (Double)score.elementAt(i);
            ++i;
        }
        return result;
    }
}

