/*
 * Decompiled with CFR 0.152.
 */
package matrix;

import io.MatrixLoad;
import io.fileload;
import matrix.CodonTable;
import matrix.Jacobi;
import matrix.disrand;

public class ShortSim {
    disrand dis;
    MatrixLoad m;
    Jacobi jacobi;

    public static void main(String[] args) throws Exception {
        String[] data = fileload.loadLine0(args[0]);
        MatrixLoad m0 = new MatrixLoad(data);
        ShortSim mut = new ShortSim(m0);
        double scale = 6.25;
        double STEP = 0.1;
        int seq_length = 30;
        int repeat = 1000;
        double x = 0.0;
        while (x < 1.0) {
            double y = 0.0;
            while (y < 1.0) {
                int countDNA = 0;
                int countAA = 0;
                int n = 0;
                while (n < repeat) {
                    String[] DNA = mut.felsensteinTree(seq_length, x * scale, y * scale);
                    String[] aminoacid = new String[DNA.length];
                    CodonTable t = new CodonTable();
                    int i = 0;
                    while (i < DNA.length) {
                        aminoacid[i] = t.translate(0, DNA[i]);
                        ++i;
                    }
                    if (ShortSim.numberOfConsistent(DNA) > ShortSim.numberOfLBA(DNA)) {
                        ++countDNA;
                    }
                    if (ShortSim.numberOfConsistent(aminoacid) > ShortSim.numberOfLBA(aminoacid)) {
                        ++countAA;
                    }
                    ++n;
                }
                System.out.print(x);
                System.out.print("\t");
                System.out.print(y);
                System.out.print("\t");
                System.out.print(countDNA);
                System.out.print("\t");
                System.out.print(countAA);
                System.out.print("\t");
                System.out.println();
                y += STEP;
            }
            x += STEP;
        }
    }

    public String[] felsensteinTree(int seqLen, double x, double y) {
        StringBuffer SB = new StringBuffer();
        int i = 0;
        while (i < seqLen) {
            SB.append("AAA");
            ++i;
        }
        String a = this.mutateThrough(100.0, SB.toString());
        String e = this.mutateThrough(x, a);
        String b = this.mutateThrough(y, e);
        String f = this.mutateThrough(y, e);
        String c = this.mutateThrough(x, f);
        String d = this.mutateThrough(y, f);
        String[] result = new String[]{a, b, c, d};
        return result;
    }

    public String[] longTree(int seqLen, double x, double y) {
        StringBuffer SB = new StringBuffer();
        int i = 0;
        while (i < seqLen) {
            SB.append("AAA");
            ++i;
        }
        String a = this.mutateThrough(100.0, SB.toString());
        String e = this.mutateThrough(x, a);
        String b = this.mutateThrough(x, e);
        String f = this.mutateThrough(y, e);
        String c = this.mutateThrough(y, f);
        String d = this.mutateThrough(y, f);
        String[] result = new String[]{a, b, c, d};
        return result;
    }

    public static int numberOfConsistent(String[] data) {
        int count = 0;
        int i = 0;
        while (i < data[0].length()) {
            char c0 = data[0].charAt(i);
            char c1 = data[1].charAt(i);
            char c2 = data[2].charAt(i);
            char c3 = data[3].charAt(i);
            if (c0 != c2 && c0 == c1 && c2 == c3) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int numberOfLBA(String[] data) {
        int count = 0;
        int i = 0;
        while (i < data[0].length()) {
            char c0 = data[0].charAt(i);
            char c1 = data[1].charAt(i);
            char c2 = data[2].charAt(i);
            char c3 = data[3].charAt(i);
            if (c0 != c1 && c0 == c2 && c1 == c3) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static void test(String[] args) throws Exception {
        String[] data = fileload.loadLine0(args[0]);
        MatrixLoad m0 = new MatrixLoad(data);
        ShortSim mut = new ShortSim(m0);
        StringBuffer SB = new StringBuffer();
        int i = 0;
        while (i < 10000) {
            SB.append("AAA");
            ++i;
        }
        String org = mut.mutateThrough(100.0, SB.toString());
        CodonTable t = new CodonTable();
        String DNA0 = org;
        String aminoacid0 = t.translate(0, DNA0);
        double x = 0.0;
        while (x < 30.0) {
            String DNA1 = mut.mutateThrough(x, org);
            String aminoacid1 = t.translate(0, DNA1);
            double pDNA = ShortSim.p(DNA0, DNA1);
            double dDNA = -0.75 * Math.log(1.0 - 1.3333333333333333 * pDNA);
            double pAmino = ShortSim.p(aminoacid0, aminoacid1);
            double dAmino = -Math.log(1.0 - pAmino);
            System.out.print(x);
            System.out.print("\t");
            System.out.print(pDNA);
            System.out.print("\t");
            System.out.print(dDNA);
            System.out.print("\t");
            System.out.print(pAmino);
            System.out.print("\t");
            System.out.print(dAmino);
            System.out.println();
            x += 0.5;
        }
    }

    public static double p(String s1, String s2) {
        double d = 0.0;
        int i = 0;
        while (i < s2.length()) {
            if (s1.charAt(i) != s2.charAt(i)) {
                d += 1.0;
            }
            ++i;
        }
        return d / (double)s1.length();
    }

    public ShortSim(MatrixLoad m0) throws Exception {
        this.m = m0;
        this.jacobi = new Jacobi(this.m.matrix);
        this.dis = new disrand();
    }

    public String mutateThrough(double T_v, String seq) {
        double[][] mutMatrix = this.jacobi.power(T_v);
        StringBuffer SB = new StringBuffer();
        int i = 0;
        while (i < seq.length() - 2) {
            String codon = seq.substring(i, i + 3);
            double[] mutVector = mutMatrix[this.m.getPos(codon)];
            int c = disrand.value(mutVector);
            SB.append(this.m.list[c]);
            i += 3;
        }
        return SB.toString();
    }
}

