/*
 * Decompiled with CFR 0.152.
 */
package matrix;

import io.MatrixLoad;
import io.fileload;
import io.newMatrixLoad;
import matrix.Jacobi;
import matrix.disrand;

public class ScoreRandSim {
    disrand dis;
    MatrixLoad m;
    Jacobi jacobi;

    public static void main(String[] args) throws Exception {
        String[] data = fileload.loadLine0(args[0]);
        newMatrixLoad m0 = new newMatrixLoad(data);
        String[] data2 = fileload.loadLine0(args[1]);
        newMatrixLoad freq = new newMatrixLoad(data2);
        int repeat = new Integer(args[2]);
        int len = new Integer(args[3]);
        int i = 0;
        while (i < repeat) {
            String[] DNA = ScoreRandSim.simtree(freq, len);
            int keta = 3;
            String[] shuffled = ScoreRandSim.bootstrap(DNA);
            System.out.println(ScoreRandSim.max50(m0, shuffled[0], shuffled[1]));
            ++i;
        }
    }

    public static String[] bootstrap(String[] org) {
        int len = org[0].length();
        StringBuffer SB1 = new StringBuffer();
        StringBuffer SB2 = new StringBuffer();
        int l = 0;
        while (l < len) {
            int x = 0;
            while ((x = new Double(Math.random() * (double)len).intValue()) >= len) {
            }
            SB1.append(org[0].charAt(x));
            SB2.append(org[1].charAt(x));
            ++l;
        }
        String[] result = new String[]{SB1.toString(), SB2.toString()};
        return result;
    }

    public static String[] simtree(newMatrixLoad freq, int len) {
        int aminolen = len;
        double[][] mat = freq.matrix;
        double[] org = new double[mat.length];
        int i = 0;
        while (i < mat.length) {
            org[i] = 0.0;
            int j = 0;
            while (j < mat[i].length) {
                int n = i;
                org[n] = org[n] + mat[i][j];
                ++j;
            }
            ++i;
        }
        StringBuffer SB1 = new StringBuffer();
        StringBuffer SB2 = new StringBuffer();
        int l = 0;
        while (l < aminolen) {
            int x = disrand.value(org);
            int y = disrand.value(mat[x]);
            SB1.append(freq.getCharAt(x));
            SB2.append(freq.getCharAt(y));
            ++l;
        }
        String[] result = new String[]{SB1.toString(), SB2.toString()};
        return result;
    }

    public static double max50(newMatrixLoad mat, String seq1, String seq2) {
        int len = seq1.length() / 3;
        double[] keisan = new double[len];
        int i = 0;
        while (i < len) {
            keisan[i] = mat.value(seq1.substring(i * 3, i * 3 + 3), seq2.substring(i * 3, i * 3 + 3));
            ++i;
        }
        double max = -100.0;
        int maxX = 0;
        int maxY = 0;
        int start = 0;
        while (start < len - 1) {
            double total = keisan[start];
            int end = start + 1;
            while (end < start + 50 && end < len) {
                if (max < (total += keisan[end])) {
                    max = total;
                    maxX = start;
                    maxY = end;
                }
                ++end;
            }
            ++start;
        }
        return max;
    }
}

