/*
 * Decompiled with CFR 0.152.
 */
package matrix;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class MatrixCalculator {
    private boolean DEBUG = false;
    private boolean INFO = true;
    private static int max = 100;
    private static int decimals = 3;
    private JLabel statusBar;
    private JTextArea taA;
    private JTextArea taB;
    private JTextArea taC;
    private int iDF = 0;
    private int n = 4;
    private static NumberFormat nf;

    public Component createComponents() {
        this.taA = new JTextArea();
        this.taB = new JTextArea();
        this.taC = new JTextArea();
        JPanel paneMs = new JPanel();
        paneMs.setLayout(new BoxLayout(paneMs, 0));
        paneMs.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        paneMs.add(this.MatrixPane("Matrix A", this.taA));
        paneMs.add(Box.createRigidArea(new Dimension(10, 0)));
        paneMs.add(this.MatrixPane("Matrix B", this.taB));
        paneMs.add(Box.createRigidArea(new Dimension(10, 0)));
        paneMs.add(this.MatrixPane("Matrix C", this.taC));
        JPanel paneBtn = new JPanel();
        paneBtn.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        paneBtn.setLayout(new GridLayout(3, 3));
        JButton btnApB = new JButton("A + B = C");
        JButton btnAmB = new JButton("A * B = C");
        JButton btnBmA = new JButton("B * A = C");
        JButton btnAdjA = new JButton("adjoint(A) = C");
        JButton btnInvA = new JButton("inverse(A) = C");
        JButton btnInvB = new JButton("inverse(B) = C");
        JButton btnTrnsA = new JButton("transpose(A) = C");
        JButton btnDetA = new JButton("determ(A) = C");
        JButton btnDetB = new JButton("determ(B) = C");
        paneBtn.add(btnApB);
        paneBtn.add(btnAmB);
        paneBtn.add(btnBmA);
        paneBtn.add(btnAdjA);
        paneBtn.add(btnInvA);
        paneBtn.add(btnInvB);
        paneBtn.add(btnTrnsA);
        paneBtn.add(btnDetA);
        paneBtn.add(btnDetB);
        btnApB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    MatrixCalculator.this.DisplayMatrix(MatrixCalculator.this.AddMatrix(MatrixCalculator.this.ReadInMatrix(MatrixCalculator.this.taA), MatrixCalculator.this.ReadInMatrix(MatrixCalculator.this.taB)), MatrixCalculator.this.taC);
                }
                catch (Exception e) {
                    System.err.println("Error: " + e);
                }
            }
        });
        btnAmB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    MatrixCalculator.this.DisplayMatrix(MatrixCalculator.this.MultiplyMatrix(MatrixCalculator.this.ReadInMatrix(MatrixCalculator.this.taA), MatrixCalculator.this.ReadInMatrix(MatrixCalculator.this.taB)), MatrixCalculator.this.taC);
                }
                catch (Exception e) {
                    System.err.println("Error: " + e);
                }
            }
        });
        btnBmA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    MatrixCalculator.this.DisplayMatrix(MatrixCalculator.this.MultiplyMatrix(MatrixCalculator.this.ReadInMatrix(MatrixCalculator.this.taB), MatrixCalculator.this.ReadInMatrix(MatrixCalculator.this.taA)), MatrixCalculator.this.taC);
                }
                catch (Exception e) {
                    System.err.println("Error: " + e);
                }
            }
        });
        btnInvA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    MatrixCalculator.this.DisplayMatrix(MatrixCalculator.this.Inverse(MatrixCalculator.this.ReadInMatrix(MatrixCalculator.this.taA)), MatrixCalculator.this.taC);
                }
                catch (Exception e) {
                    System.err.println("Error: " + e);
                }
            }
        });
        btnInvB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    MatrixCalculator.this.DisplayMatrix(MatrixCalculator.this.Inverse(MatrixCalculator.this.ReadInMatrix(MatrixCalculator.this.taB)), MatrixCalculator.this.taC);
                }
                catch (Exception e) {
                    System.err.println("Error: " + e);
                }
            }
        });
        btnAdjA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    MatrixCalculator.this.DisplayMatrix(MatrixCalculator.this.Adjoint(MatrixCalculator.this.ReadInMatrix(MatrixCalculator.this.taA)), MatrixCalculator.this.taC);
                }
                catch (Exception e) {
                    System.err.println("Error: " + e);
                }
            }
        });
        btnTrnsA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    MatrixCalculator.this.DisplayMatrix(MatrixCalculator.this.Transpose(MatrixCalculator.this.ReadInMatrix(MatrixCalculator.this.taA)), MatrixCalculator.this.taC);
                }
                catch (Exception e) {
                    System.err.println("Error: " + e);
                }
            }
        });
        btnDetA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    MatrixCalculator.this.taC.setText("Determinant A: " + nf.format(MatrixCalculator.this.Determinant(MatrixCalculator.this.ReadInMatrix(MatrixCalculator.this.taA))));
                }
                catch (Exception e) {
                    System.err.println("Error: " + e);
                }
            }
        });
        btnDetB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    MatrixCalculator.this.taC.setText("Determinant B: " + nf.format(MatrixCalculator.this.Determinant(MatrixCalculator.this.ReadInMatrix(MatrixCalculator.this.taB))));
                }
                catch (Exception e) {
                    System.err.println("Error: " + e);
                }
            }
        });
        JPanel pane = new JPanel();
        pane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pane.setLayout(new BoxLayout(pane, 1));
        pane.add(paneMs);
        pane.add(paneBtn);
        JPanel fpane = new JPanel();
        fpane.setLayout(new BorderLayout());
        fpane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        fpane.add("Center", pane);
        this.statusBar = new JLabel("Ready");
        fpane.add("South", this.statusBar);
        return fpane;
    }

    private JPanel MatrixPane(String str, JTextArea ta) {
        JScrollPane scrollPane = new JScrollPane(ta);
        int size = 200;
        scrollPane.setPreferredSize(new Dimension(size, size));
        JLabel label = new JLabel(str);
        label.setLabelFor(scrollPane);
        JPanel pane = new JPanel();
        pane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pane.setLayout(new BoxLayout(pane, 1));
        pane.add(label);
        pane.add(scrollPane);
        return pane;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Matrix Calculator");
        frame.setSize(new Dimension(725, 200));
        MatrixCalculator app = new MatrixCalculator();
        Component contents = app.createComponents();
        frame.getContentPane().add(contents, "Center");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.pack();
        frame.setVisible(true);
        nf = NumberFormat.getInstance();
        nf.setMinimumFractionDigits(1);
        nf.setMaximumFractionDigits(decimals);
    }

    public float[][] ReadInMatrix(JTextArea ta) throws Exception {
        if (this.DEBUG) {
            System.out.println("Reading In Matrix");
        }
        String rawtext = ta.getText();
        String val = "";
        int i = 0;
        int j = 0;
        int[] rsize = new int[max];
        StringTokenizer ts = new StringTokenizer(rawtext, "\n");
        while (ts.hasMoreTokens()) {
            StringTokenizer ts2 = new StringTokenizer(ts.nextToken());
            while (ts2.hasMoreTokens()) {
                ts2.nextToken();
                ++j;
            }
            rsize[i] = j;
            ++i;
            j = 0;
        }
        this.statusBar.setText("Matrix Size: " + i);
        if (this.DEBUG || this.INFO) {
            System.out.println("Matrix Size: " + i);
        }
        int c = 0;
        while (c < i) {
            if (this.DEBUG) {
                System.out.println("i=" + i + "  j=" + rsize[c] + "   Column: " + c);
            }
            if (rsize[c] != i) {
                this.statusBar.setText("Invalid Matrix Entered. Size Mismatch.");
                throw new Exception("Invalid Matrix Entered. Size Mismatch.");
            }
            ++c;
        }
        this.n = i;
        float[][] matrix = new float[this.n][this.n];
        j = 0;
        i = 0;
        val = "";
        StringTokenizer st = new StringTokenizer(rawtext, "\n");
        while (st.hasMoreTokens()) {
            StringTokenizer st2 = new StringTokenizer(st.nextToken());
            while (st2.hasMoreTokens()) {
                val = st2.nextToken();
                try {
                    matrix[i][j] = Float.valueOf(val).floatValue();
                }
                catch (Exception exception) {
                    this.statusBar.setText("Invalid Number Format");
                }
                ++j;
            }
            ++i;
            j = 0;
        }
        if (this.DEBUG) {
            System.out.println("Matrix Read::");
            i = 0;
            while (i < this.n) {
                j = 0;
                while (j < this.n) {
                    System.out.print("m[" + i + "][" + j + "] = " + matrix[i][j] + "   ");
                    ++j;
                }
                System.out.println();
                ++i;
            }
        }
        return matrix;
    }

    public void DisplayMatrix(float[][] matrix, JTextArea ta) {
        if (this.DEBUG) {
            System.out.println("Displaying Matrix");
        }
        int tms = matrix.length;
        String rstr = "";
        String dv = "";
        int i = 0;
        while (i < tms) {
            int j = 0;
            while (j < tms) {
                dv = nf.format(matrix[i][j]);
                rstr = rstr.concat(String.valueOf(dv) + "  ");
                ++j;
            }
            rstr = rstr.concat("\n");
            ++i;
        }
        ta.setText(rstr);
    }

    public float[][] AddMatrix(float[][] a, float[][] b) throws Exception {
        int tms = a.length;
        int tmsB = b.length;
        if (tms != tmsB) {
            this.statusBar.setText("Matrix Size Mismatch");
        }
        float[][] matrix = new float[tms][tms];
        int i = 0;
        while (i < tms) {
            int j = 0;
            while (j < tms) {
                matrix[i][j] = a[i][j] + b[i][j];
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public float[][] MultiplyMatrix(float[][] a, float[][] b) throws Exception {
        int j;
        int tms = a.length;
        int tmsB = b.length;
        if (tms != tmsB) {
            this.statusBar.setText("Matrix Size Mismatch");
        }
        float[][] matrix = new float[tms][tms];
        int i = 0;
        while (i < tms) {
            j = 0;
            while (j < tms) {
                matrix[i][j] = 0.0f;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < tms) {
            j = 0;
            while (j < tms) {
                int p = 0;
                while (p < tms) {
                    float[] fArray = matrix[i];
                    int n = j;
                    fArray[n] = fArray[n] + a[i][p] * b[p][j];
                    ++p;
                }
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public float[][] Transpose(float[][] a) {
        if (this.INFO) {
            System.out.println("Performing Transpose...");
        }
        int tms = a.length;
        float[][] m = new float[tms][tms];
        int i = 0;
        while (i < tms) {
            int j = 0;
            while (j < tms) {
                m[i][j] = a[j][i];
                ++j;
            }
            ++i;
        }
        return m;
    }

    public float[][] Inverse(float[][] a) throws Exception {
        if (this.INFO) {
            System.out.println("Performing Inverse...");
        }
        int tms = a.length;
        float[][] m = new float[tms][tms];
        float[][] mm = this.Adjoint(a);
        float det = this.Determinant(a);
        float dd = 0.0f;
        if (det == 0.0f) {
            this.statusBar.setText("Determinant Equals 0, Not Invertible.");
            if (this.INFO) {
                System.out.println("Determinant Equals 0, Not Invertible.");
            }
        } else {
            dd = 1.0f / det;
        }
        int i = 0;
        while (i < tms) {
            int j = 0;
            while (j < tms) {
                m[i][j] = dd * mm[i][j];
                ++j;
            }
            ++i;
        }
        return m;
    }

    public float[][] Adjoint(float[][] a) throws Exception {
        if (this.INFO) {
            System.out.println("Performing Adjoint...");
        }
        int tms = a.length;
        float[][] m = new float[tms][tms];
        int i = 0;
        while (i < tms) {
            int j = 0;
            while (j < tms) {
                int ja = 0;
                int ia = 0;
                float[][] ap = new float[tms - 1][tms - 1];
                int ii = 0;
                while (ii < tms) {
                    int jj = 0;
                    while (jj < tms) {
                        if (ii != i && jj != j) {
                            ap[ia][ja] = a[ii][jj];
                            ++ja;
                        }
                        ++jj;
                    }
                    if (ii != i && jj != j) {
                        ++ia;
                    }
                    ja = 0;
                    ++ii;
                }
                float det = this.Determinant(ap);
                m[i][j] = (float)Math.pow(-1.0, i + j) * det;
                ++j;
            }
            ++i;
        }
        m = this.Transpose(m);
        return m;
    }

    public float[][] UpperTriangle(float[][] m) {
        if (this.INFO) {
            System.out.println("Converting to Upper Triangle...");
        }
        float f1 = 0.0f;
        float temp = 0.0f;
        int tms = m.length;
        int v = 1;
        this.iDF = 1;
        int col = 0;
        while (col < tms - 1) {
            int row = col + 1;
            while (row < tms) {
                v = 1;
                while (m[col][col] == 0.0f) {
                    if (col + v >= tms) {
                        this.iDF = 0;
                        break;
                    }
                    int c = 0;
                    while (c < tms) {
                        temp = m[col][c];
                        m[col][c] = m[col + v][c];
                        m[col + v][c] = temp;
                        ++c;
                    }
                    ++v;
                    this.iDF *= -1;
                }
                if (m[col][col] != 0.0f) {
                    if (this.DEBUG) {
                        System.out.println("tms = " + tms + "   col = " + col + "   row = " + row);
                    }
                    try {
                        f1 = -1.0f * m[row][col] / m[col][col];
                        int i = col;
                        while (i < tms) {
                            m[row][i] = f1 * m[col][i] + m[row][i];
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Still Here!!!");
                    }
                }
                ++row;
            }
            ++col;
        }
        return m;
    }

    public float Determinant(float[][] matrix) {
        if (this.INFO) {
            System.out.println("Getting Determinant...");
        }
        int tms = matrix.length;
        float det = 1.0f;
        matrix = this.UpperTriangle(matrix);
        int i = 0;
        while (i < tms) {
            det *= matrix[i][i];
            ++i;
        }
        det *= (float)this.iDF;
        if (this.INFO) {
            System.out.println("Determinant: " + det);
        }
        return det;
    }
}

