/*
 * Decompiled with CFR 0.152.
 */
package matrix;

import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;

public class Matrix {
    public static double[][] copy(double[][] org) {
        int n = org.length;
        double[][] result = new double[n][];
        int i = 0;
        while (i < n) {
            result[i] = new double[org[i].length];
            int j = 0;
            while (j < org[i].length) {
                result[i][j] = org[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[][] multiple(double[][] A, double[][] B) {
        double[][] result = new double[0][0];
        try {
            int m = A.length;
            int n = B[0].length;
            result = new double[m][n];
            int i = 0;
            while (i < m) {
                int j = 0;
                while (j < n) {
                    result[i][j] = 0.0;
                    int l = A[i].length;
                    int k = 0;
                    while (k < l) {
                        double[] dArray = result[i];
                        int n2 = j;
                        dArray[n2] = dArray[n2] + A[i][k] * B[k][j];
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return result;
    }

    public static double[][] sum(double[][] A, double[][] B) {
        Object result = new double[0][0];
        try {
            int m = A.length;
            result = new double[m][];
            int i = 0;
            while (i < m) {
                int n = A[i].length;
                result[i] = new double[n];
                int j = 0;
                while (j < n) {
                    result[i][j] = A[i][j] + B[i][j];
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return result;
    }

    public static double[][] scalar(double c, double[][] A) {
        Object result = new double[0][0];
        try {
            int m = A.length;
            result = new double[m][];
            int i = 0;
            while (i < m) {
                int n = A[i].length;
                result[i] = new double[n];
                int j = 0;
                while (j < n) {
                    result[i][j] = c * A[i][j];
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return result;
    }

    public static double[][] makeItOne(double[][] org) {
        int n = org.length;
        double[][] result = new double[n][];
        int i = 0;
        while (i < n) {
            double total = 0.0;
            result[i] = new double[org[i].length];
            int j = 0;
            while (j < org[i].length) {
                total += org[i][j];
                ++j;
            }
            j = 0;
            while (j <= i) {
                result[i][j] = org[i][j] / total;
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[][] log(double[][] org) {
        int n = org.length;
        double[][] result = new double[n][];
        int i = 0;
        while (i < n) {
            double total = 0.0;
            result[i] = new double[org[i].length];
            int j = 0;
            while (j <= i) {
                result[i][j] = Math.log(org[i][j]);
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[][] E(int n) {
        double[][] result = new double[n][n];
        int i = 0;
        while (i < n) {
            result[i] = new double[n];
            Arrays.fill(result[i], 0.0);
            result[i][i] = 1.0;
            ++i;
        }
        return result;
    }

    public static void show(double[][] mat) {
        int n = mat.length;
        int s = 0;
        while (s < n) {
            int m = mat[s].length;
            int t = 0;
            while (t < m) {
                long tmp = Math.round(mat[s][t] * 1000.0);
                Double SB = new Double((double)tmp / 1000.0);
                System.out.print(SB);
                System.out.print(',');
                ++t;
            }
            System.out.println();
            ++s;
        }
    }

    public static void show2(double[][] mat) {
        int n = mat.length;
        int s = 0;
        while (s < n) {
            int m = mat[s].length;
            int t = 0;
            while (t < m) {
                long tmp = Math.round(mat[s][t] * 1000.0);
                Double SB = new Double((double)tmp / 1000.0);
                System.out.print(mat[s][t]);
                System.out.print(',');
                ++t;
            }
            System.out.println();
            ++s;
        }
    }

    public static double[][] CSVtoMatrix(String[] lines) {
        double[][] result = new double[lines.length][];
        int i = 0;
        while (i < lines.length) {
            Vector<String> v = new Vector<String>();
            StringTokenizer ST = new StringTokenizer(lines[i], ",");
            while (ST.hasMoreTokens()) {
                v.addElement(ST.nextToken());
            }
            int size = v.size();
            result[i] = new double[size];
            int j = 0;
            while (j < size) {
                result[i][j] = new Double((String)v.elementAt(j));
                ++j;
            }
            ++i;
        }
        return result;
    }
}

