/*
 * Decompiled with CFR 0.152.
 */
package matrix;

import io.fileload;
import java.util.Arrays;
import matrix.Matrix;
import matrix.inverse;

public class Jacobi {
    double[][] original;
    double[][] diagonal;
    double[][] U;
    double[][] invU;
    double[][] diagonalLog;
    static double EPS = 1.0E-9;

    public Jacobi(double[][] org) throws Exception {
        double max;
        double[][] a = Jacobi.sym(org);
        this.original = Matrix.copy(a);
        int dim = a.length;
        double[][] u = new double[dim][dim];
        int i = 0;
        while (i < dim) {
            Arrays.fill(u[i], 0.0);
            u[i][i] = 1.0;
            ++i;
        }
        while (!((max = Jacobi.transform(a, u)) < EPS)) {
        }
        this.diagonal = a;
        this.U = u;
        inverse I = new inverse();
        this.invU = I.Inverse(u);
        this.diagonalLog = Jacobi.diagonalLog(this.diagonal);
    }

    public double[][] power(double x) {
        int n = this.diagonalLog.length;
        double[][] tmp = new double[n][n];
        int i = 0;
        while (i < n) {
            Arrays.fill(tmp[i], 0.0);
            ++i;
        }
        i = 0;
        while (i < n) {
            tmp[i][i] = Math.exp(x * this.diagonalLog[i][i]);
            ++i;
        }
        double[][] tmp2 = Matrix.multiple(this.U, tmp);
        double[][] result = Matrix.multiple(tmp2, this.invU);
        return result;
    }

    public double[][] V() {
        int n = this.diagonalLog.length;
        double[][] tmp = new double[n][n];
        int i = 0;
        while (i < n) {
            Arrays.fill(tmp[i], 0.0);
            ++i;
        }
        i = 0;
        while (i < n) {
            tmp[i][i] = this.diagonalLog[i][i];
            ++i;
        }
        double[][] tmp2 = Matrix.multiple(this.U, tmp);
        double[][] result = Matrix.multiple(tmp2, this.invU);
        return result;
    }

    public void test() {
        double[][] tmp2 = Matrix.multiple(this.original, this.U);
        tmp2 = Matrix.multiple(this.invU, tmp2);
        Matrix.show(tmp2);
    }

    public static void main(String[] args) throws Exception {
        double max;
        String[] lines = fileload.loadLine0(args[0]);
        double[][] org = Matrix.scalar(1.0E-4, Matrix.CSVtoMatrix(lines));
        double[][] a = Jacobi.sym(org);
        double[][] copya = Matrix.copy(a);
        int dim = a.length;
        double[][] u = new double[dim][dim];
        int i = 0;
        while (i < dim) {
            Arrays.fill(u[i], 0.0);
            u[i][i] = 1.0;
            ++i;
        }
        while (!((max = Jacobi.transform(a, u)) < EPS)) {
        }
        inverse I = new inverse();
        double[][] invU = I.Inverse(u);
        double[][] logA = Jacobi.diagonalLog(a);
        double[][] tmp3 = Matrix.multiple(u, logA);
        double[][] tmp4 = Matrix.multiple(tmp3, invU);
        System.out.println("delta");
        Matrix.show(tmp4);
    }

    static double transform(double[][] a, double[][] u) {
        double w;
        int[] maxPos = Jacobi.getMaxPos(a);
        int p = maxPos[0];
        int q = maxPos[1];
        double max = Math.abs(a[p][q]);
        double wa = a[p][p];
        double wb = a[p][q];
        double wc = a[q][q];
        double alpha = -wb;
        double beta = (wa - wc) / 2.0;
        double gamma = Math.abs(beta) / Math.sqrt(alpha * alpha + beta * beta);
        double sine = Math.sqrt((1.0 - gamma) / 2.0);
        if (alpha * beta < 0.0) {
            sine = -sine;
        }
        double cosine = Math.sqrt(1.0 - sine * sine);
        int dim = a.length;
        int j = 0;
        while (j < dim) {
            w = a[p][j] * cosine - a[q][j] * sine;
            a[q][j] = a[p][j] * sine + a[q][j] * cosine;
            a[p][j] = w;
            ++j;
        }
        j = 0;
        while (j < dim) {
            a[j][p] = a[p][j];
            a[j][q] = a[q][j];
            ++j;
        }
        w = 2.0 * wb * sine * cosine;
        a[p][p] = wa * cosine * cosine + wc * sine * sine - w;
        a[q][q] = wa * sine * sine + wc * cosine * cosine + w;
        a[q][p] = 0.0;
        a[p][q] = 0.0;
        int i = 0;
        while (i < dim) {
            w = u[i][p] * cosine - u[i][q] * sine;
            u[i][q] = u[i][p] * sine + u[i][q] * cosine;
            u[i][p] = w;
            ++i;
        }
        return max;
    }

    static int[] getMaxPos(double[][] a) {
        double max = 0.0;
        int p = 0;
        int q = 0;
        int dim = a.length;
        int i = 0;
        while (i < dim - 1) {
            int j = i + 1;
            while (j < dim) {
                double tmp = Math.abs(a[i][j]);
                if (tmp > max) {
                    p = i;
                    q = j;
                    max = tmp;
                }
                ++j;
            }
            ++i;
        }
        int[] result = new int[]{p, q};
        return result;
    }

    public static double[][] getData() {
        double sum;
        int j;
        double[][] org = new double[][]{{0.0, 0.3, 1.1, 20.0}, {0.4, 0.0, 25.8, 1.1}, {1.1, 33.8, 0.0, 1.6}, {14.1, 0.3, 0.5, 0.0}};
        int n = org.length;
        double[][] a = new double[n][n];
        double[][] abs = new double[n][n];
        int i = 0;
        while (i < n) {
            j = 0;
            while (j < i) {
                double d = (org[i][j] + org[j][i]) * 0.5 * 0.001;
                a[j][i] = d;
                a[i][j] = d;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < n) {
            a[i][i] = 0.0;
            sum = 0.0;
            j = 0;
            while (j < n) {
                sum += a[i][j];
                ++j;
            }
            a[i][i] = 1.0 - sum;
            ++i;
        }
        i = 0;
        while (i < n) {
            sum = 0.0;
            j = 0;
            while (j <= i) {
                abs[i][j] = Math.abs(a[i][j]);
                ++j;
            }
            ++i;
        }
        return a;
    }

    public static double[][] sym(double[][] org) {
        double sum;
        int j;
        int n = org.length;
        double[][] a = new double[n][n];
        double[][] abs = new double[n][n];
        int i = 0;
        while (i < n) {
            j = 0;
            while (j < i) {
                double d = (org[i][j] + org[j][i]) * 0.5;
                a[j][i] = d;
                a[i][j] = d;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < n) {
            a[i][i] = 0.0;
            sum = 0.0;
            j = 0;
            while (j < n) {
                sum += a[i][j];
                ++j;
            }
            a[i][i] = 1.0 - sum;
            ++i;
        }
        i = 0;
        while (i < n) {
            sum = 0.0;
            j = 0;
            while (j <= i) {
                abs[i][j] = Math.abs(a[i][j]);
                ++j;
            }
            ++i;
        }
        return a;
    }

    public static double[][] diagonalLog(double[][] org) {
        int n = org.length;
        double[][] result = new double[n][n];
        int i = 0;
        while (i < n) {
            Arrays.fill(result[i], 0.0);
            ++i;
        }
        i = 0;
        while (i < n) {
            result[i][i] = Math.log(org[i][i]);
            ++i;
        }
        return result;
    }
}

