/*
 * Decompiled with CFR 0.152.
 */
package io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class newMatrixLoad {
    public String[] list;
    public double[][] matrix;
    Hashtable table;
    double minimumValue;
    public static double kappa = 0.2819;
    public static double lambda = 1.21975;

    public newMatrixLoad(String[] data) throws FileNotFoundException, IOException {
        String[][] tmp = newMatrixLoad.CSVtoStringMatrix(data);
        this.matrix = newMatrixLoad.StringToDoubleMatrix2(tmp);
        this.list = new String[tmp[0].length - 1];
        int i = 0;
        while (i < this.list.length) {
            this.list[i] = tmp[0][i + 1];
            ++i;
        }
        this.minimumValue = this.min();
        this.table = new Hashtable();
        i = 0;
        while (i < this.list.length) {
            this.table.put(this.list[i].toUpperCase(), new Integer(i));
            this.table.put(this.list[i].toLowerCase(), new Integer(i));
            ++i;
        }
    }

    public static double[][] StringToDoubleMatrix2(String[][] org) {
        double[][] data = new double[org.length - 1][];
        int i = 0;
        while (i < org.length - 1) {
            int size = org[i + 1].length;
            data[i] = new double[size - 1];
            int j = 0;
            while (j < size - 1) {
                double d;
                String a = org[i + 1][j + 1];
                data[i][j] = d = new Double(a).doubleValue();
                ++j;
            }
            ++i;
        }
        double[][] result = new double[data.length][];
        int i2 = 0;
        while (i2 < data.length) {
            double total = 0.0;
            int j = 0;
            while (j < data[i2].length) {
                total += data[i2][j];
                ++j;
            }
            result[i2] = new double[data[i2].length];
            j = 0;
            while (j < data[i2].length) {
                result[i2][j] = data[i2][j];
                ++j;
            }
            ++i2;
        }
        return result;
    }

    public static double[][] StringToDoubleMatrix(String[][] org) {
        double[][] data = new double[org.length - 1][];
        int i = 0;
        while (i < org.length - 1) {
            int size = org[i + 1].length;
            data[i] = new double[size - 1];
            int j = 0;
            while (j < size - 1) {
                double d;
                String a = org[i + 1][j + 1];
                data[i][j] = d = new Double(a).doubleValue();
                ++j;
            }
            ++i;
        }
        double[][] result = new double[data.length][];
        int i2 = 0;
        while (i2 < data.length) {
            double total = 0.0;
            int j = 0;
            while (j < data[i2].length) {
                total += data[i2][j];
                ++j;
            }
            result[i2] = new double[data[i2].length];
            j = 0;
            while (j < data[i2].length) {
                result[i2][j] = data[i2][j] / total;
                ++j;
            }
            ++i2;
        }
        return result;
    }

    public static String[][] CSVtoStringMatrix(String[] lines) {
        String[][] data = new String[lines.length][];
        int i = 0;
        while (i < lines.length) {
            Vector<String> v = new Vector<String>();
            StringTokenizer ST = new StringTokenizer(lines[i], ",");
            while (ST.hasMoreTokens()) {
                v.addElement(ST.nextToken());
            }
            int size = v.size();
            data[i] = new String[size];
            int j = 0;
            while (j < size) {
                String a;
                data[i][j] = a = (String)v.elementAt(j);
                ++j;
            }
            ++i;
        }
        return data;
    }

    public double min() {
        double tmp = this.matrix[0][0];
        int i = 0;
        while (i < this.matrix.length) {
            int j = 0;
            while (j < this.matrix[i].length) {
                if (tmp > this.matrix[i][j]) {
                    tmp = this.matrix[i][j];
                }
                ++j;
            }
            ++i;
        }
        return tmp;
    }

    public double value(String X, String Y) {
        try {
            int x = (Integer)this.table.get(X);
            int y = (Integer)this.table.get(Y);
            return this.matrix[x][y];
        }
        catch (NullPointerException e) {
            return this.minimumValue;
        }
    }

    public int getPos(String X) {
        int x = (Integer)this.table.get(X);
        return x;
    }

    public String getCharAt(int x) {
        if (x >= 0 && x < this.list.length) {
            return this.list[x];
        }
        return "---";
    }

    public double[] vector(String X) {
        int x = (Integer)this.table.get(X);
        return this.matrix[x];
    }

    public newMatrixLoad() {
        String[][] tmp = newMatrixLoad.score2();
        this.matrix = newMatrixLoad.StringToDoubleMatrix2(tmp);
        this.list = new String[tmp[0].length - 1];
        int i = 0;
        while (i < this.list.length) {
            this.list[i] = tmp[0][i + 1];
            ++i;
        }
        this.minimumValue = this.min();
        this.table = new Hashtable();
        i = 0;
        while (i < this.list.length) {
            this.table.put(this.list[i].toUpperCase(), new Integer(i));
            this.table.put(this.list[i].toLowerCase(), new Integer(i));
            ++i;
        }
    }

    /*
     * Opcode count of 17231 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public static String[][] score2() {
        String[][] result = new String[][]{{"score", "TTT", "TTC", "TTA", "TTG", "TCT", "TCC", "TCA", "TCG", "TAT", "TAC", "TAA", "TAG", "TGT", "TGC", "TGA", "TGG", "CTT", "CTC", "CTA", "CTG", "CCT", "CCC", "CCA", "CCG", "CAT", "CAC", "CAA", "CAG", "CGT", "CGC", "CGA", "CGG", "ATT", "ATC", "ATA", "ATG", "ACT", "ACC", "ACA", "ACG", "AAT", "AAC", "AAA", "AAG", "AGT", "AGC", "AGA", "AGG", "GTT", "GTC", "GTA", "GTG", "GCT", "GCC", "GCA", "GCG", "GAT", "GAC", "GAA", "GAG", "GGT", "GGC", "GGA", "GGG"}, {"TTT", "0.357031", "0.956855", "0.073595", "0.348473", "-2.243697", "-0.957390", "-0.298294", "-0.489329", "-0.039379", "0.747028", "0.654466", "-1.255077", "-1.545635", "-0.553346", "0.929245", "-0.114792", "-1.627381", "0.403152", "0.244546", "0.720814", "-2.355451", "-0.250775", "0.115469", "-0.444146", "-0.855803", "0.126898", "-0.289996", "0.334159", "-1.439380", "-0.695461", "-0.002314", "-0.513139", "-0.993173", "0.585473", "0.710636", "0.378459", "-1.182189", "0.097770", "0.536683", "-0.002314", "-0.775503", "0.403152", "0.690834", "-0.513139", "-1.122905", "-0.127477", "1.096299", "0.403152", "-1.094878", "0.434900", "-0.093285", "0.773525", "-1.114304", "0.158029", "0.403152", "-0.289996", "-1.301597", "-0.695461", "0.808617", "-0.002314", "-0.513139", "-0.107674", "0.585473", "-0.849611"}, {"TTC", "0.974961", "0.434122", "-0.118539", "0.149567", "-0.501443", "-2.405076", "-1.172385", "-0.498750", "0.792616", "0.000515", "0.603822", "-1.994744", "-0.471091", "-2.149790", "-2.439818", "-1.423699", "0.442940", "-1.303431", "0.585473", "0.547401", "-0.184635", "-1.191898", "-1.031933", "-0.002314", "-0.002314", "-0.983143", "-0.513139", "-0.420049", "-0.289996", "-1.812422", "-0.608449", "-0.513139", "0.385452", "-0.716080", "0.477260", "0.549755", "-0.120097", "-0.110110", "-0.082356", "0.285368", "0.285368", "-0.918604", "-0.608449", "0.249001", "0.285368", "-0.933872", "-0.107674", "-0.513139", "0.385452", "-1.176433", "0.403152", "0.366784", "0.467690", "-0.100985", "0.180008", "-0.002314", "-0.289996", "-1.812422", "-0.289996", "0.115469", "-0.695461", "-0.849611", "-0.513139", "-0.983143"}, {"TTA", "-0.077037", "-0.053701", "-0.112796", "0.860334", "-0.054682", "-0.715582", "-2.112567", "-0.883059", "-0.577678", "-0.561929", "-4.118637", "-2.235906", "-0.638302", "-1.611751", "-4.644298", "-1.487699", "0.669890", "0.973582", "-0.013278", "1.016794", "0.202481", "0.115469", "-0.745132", "0.195512", "0.115469", "-0.289996", "-0.646671", "-0.002314", "0.585473", "-0.513139", "-1.468651", "0.536683", "0.126898", "0.724735", "-0.291628", "0.837725", "-0.002314", "0.140787", "-0.236507", "0.403152", "1.096299", "0.403152", "-0.338786", "-0.289996", "0.403152", "-0.002314", "-1.023965", "-0.002314", "0.307841", "0.974938", "-0.604706", "0.744455", "0.585473", "0.603822", "0.115469", "0.690834", "1.096299", "1.096299", "0.115469", "-0.156464", "0.403152", "0.403152", "-0.191556", "0.626295"}, {"TTG", "0.268232", "0.160590", "0.816032", "-0.250922", "-0.093881", "-0.051104", "-0.694462", "-2.825957", "-0.202984", "0.161989", "-1.948224", "-4.297329", "-1.301597", "-0.143392", "-3.557662", "-2.288841", "0.979304", "0.980655", "0.988804", "0.630833", "0.103047", "0.285368", "0.187176", "-0.584795", "0.307841", "-0.513139", "0.463776", "-0.420049", "0.808617", "-0.202984", "-0.513139", "-0.626468", "0.851176", "0.610791", "0.752203", "0.199486", "0.721605", "0.713306", "0.354361", "-0.058667", "-0.002314", "0.690834", "0.873155", "0.313539", "0.403152", "0.403152", "-0.370038", "-0.716080", "0.773525", "0.263390", "0.725925", "0.052636", "0.316140", "0.403152", "0.621841", "0.249001", "1.096299", "1.096299", "-0.444146", "0.349084", "0.403152", "0.585473", "-0.289996", "0.330831"}, {"TCT", "-2.014101", "-0.597021", "-0.069005", "-0.159058", "-0.149020", "0.829518", "0.896645", "0.949771", "-1.529009", "-0.025042", "-0.638302", "0.728574", "-1.364310", "-0.150576", "-1.566289", "-1.055463", "-1.790521", "-0.608449", "0.520935", "0.307841", "-1.308189", "0.610452", "0.514377", "0.634953", "-0.804979", "0.050330", "-1.301597", "0.358700", "-0.775503", "0.054845", "-0.156464", "0.536683", "-1.150936", "0.460310", "-0.695461", "0.654466", "-0.294411", "0.839869", "0.853068", "0.895628", "0.046477", "0.833934", "-0.107674", "0.728574", "0.403152", "0.585473", "0.084698", "-0.107674", "-0.446245", "0.285368", "0.895628", "0.895628", "-0.161831", "0.903565", "0.765266", "0.993114", "-0.249722", "0.249001", "0.520935", "0.323109", "0.359979", "0.131218", "0.115469", "0.808617"}, {"TCC", "-0.544230", "-2.174428", "-0.670143", "-0.154120", "0.832669", "-0.063492", "0.653510", "0.937382", "0.024715", "-1.507340", "-1.821472", "0.759826", "-0.156464", "-1.502857", "-3.022738", "-0.667290", "0.017489", "-0.763599", "0.180008", "-0.035103", "0.550185", "-1.240489", "0.316974", "0.382532", "0.205326", "-0.289996", "0.231301", "0.293952", "0.307841", "-0.695461", "-0.695461", "-0.002314", "0.115469", "-0.496332", "0.626295", "0.759826", "0.913977", "-0.218423", "0.620453", "0.861459", "0.585473", "0.576423", "0.610791", "0.490163", "0.644314", "0.567039", "0.084698", "-0.289996", "0.249001", "0.011673", "0.285368", "0.570206", "0.877163", "0.155781", "0.743858", "0.927676", "0.180008", "0.334159", "0.403152", "0.180008", "0.536683", "0.249001", "0.557302", "0.644314"}, {"TCA", "-0.800821", "-0.891576", "-2.105894", "-0.639745", "0.878804", "0.754137", "-0.637234", "0.710703", "-0.661559", "-1.165464", "-3.561119", "-2.558679", "-0.664689", "-0.792088", "-3.873923", "-1.122905", "-0.002314", "-0.362316", "-0.572858", "0.280091", "0.453924", "0.219229", "-1.346489", "-0.143653", "-0.002314", "-0.184635", "-1.008851", "-0.100754", "0.403152", "0.873155", "-1.676290", "-0.590100", "-0.289996", "0.084698", "-0.276750", "0.660981", "0.831606", "0.629465", "-0.272261", "0.523296", "0.536683", "0.403152", "-0.397626", "-0.577678", "0.585473", "0.690834", "-0.877782", "-0.289996", "0.403152", "0.403152", "0.081068", "0.779961", "0.791638", "0.844019", "-0.330479", "0.668855", "0.610791", "0.557302", "-0.027631", "0.568231", "0.536683", "-0.002314", "-0.427197", "0.403152"}, {"TCG", "-0.695461", "-0.566249", "-0.695461", "-2.747268", "0.943378", "0.933932", "0.714667", "-0.702425", "-0.695461", "-1.542759", "-0.027631", "-5.687026", "-0.219378", "-1.180969", "0.900990", "-2.777280", "0.403152", "-0.695461", "0.046477", "-0.379608", "0.453162", "0.551072", "-0.106537", "-2.701377", "0.403152", "1.096299", "-1.429430", "-1.518661", "0.690834", "0.403152", "-0.289996", "-1.000842", "-0.002314", "1.096299", "-0.289996", "-0.127477", "0.818667", "0.913977", "0.601602", "-1.068665", "0.403152", "1.096299", "-0.289996", "-1.037210", "0.249001", "0.508512", "0.115469", "-0.983143", "1.096299", "0.808617", "0.585473", "0.368060", "0.821862", "0.899588", "0.664367", "-0.688772", "1.096299", "0.180008", "-0.107674", "-0.716080", "1.096299", "1.096299", "0.249001", "-0.176667"}, {"TAT", "0.037899", "0.669780", "0.066679", "-0.056381", "-1.520420", "-0.316664", "-0.652901", "-0.350620", "0.476760", "1.017881", "-2.929053", "-2.842042", "-1.713150", "-0.754301", "-2.235906", "-0.684287", "-0.686158", "0.180008", "1.096299", "0.557302", "-1.450166", "0.180008", "-0.002314", "0.403152", "-2.120915", "0.344981", "-0.247436", "0.106886", "-2.006043", "-0.027631", "-0.156464", "-0.225457", "0.097770", "-0.002314", "-5.687026", "1.096299", "-0.116724", "-0.002314", "0.180008", "1.096299", "-1.160645", "0.702394", "0.334159", "0.557302", "-0.577678", "-0.002314", "0.285368", "0.403152", "-0.608449", "0.180008", "0.403152", "0.403152", "-0.429758", "0.140787", "-0.002314", "-0.002314", "-1.452030", "-0.036800", "-0.082356", "0.334159", "-1.057251", "-0.626468", "-0.513139", "0.249001"}, {"TAC", "0.752527", "-0.136222", "-1.023965", "-0.749528", "-0.297778", "-1.684302", "-0.577678", "-0.238702", "1.033103", "0.669433", "-3.436301", "-3.567140", "-0.903100", "-1.988588", "-4.113187", "-1.110143", "-0.407779", "-0.840042", "0.536683", "0.728574", "-0.423527", "-1.081123", "-1.542759", "0.180008", "0.078290", "-1.453425", "-0.397626", "-0.730552", "-0.225457", "-1.259396", "-0.749528", "-0.444146", "0.585473", "0.334159", "-5.687026", "0.403152", "0.654466", "-0.461846", "-0.513139", "-0.002314", "0.568231", "-1.039496", "-0.608449", "-0.423527", "-0.135845", "-0.898802", "-0.849611", "0.084698", "0.115469", "-0.107674", "0.403152", "0.403152", "0.626295", "0.054845", "-0.289996", "0.403152", "0.403152", "-1.357257", "-0.048834", "-0.590100", "0.084698", "-0.857980", "-0.289996", "0.249001"}, {"TAA", "0.477260", "0.565670", "-3.492742", "-3.078089", "-2.102374", "0.814659", "-4.615546", "-3.381038", "-2.641371", "-3.295678", "-2.336484", "-0.755279", "-2.430062", "-2.952583", "-1.999932", "-3.200987", "-0.983143", "-1.468651", "0.836788", "-1.676290", "-0.513139", "-0.156464", "-3.483554", "-0.420049", "-1.577850", "-3.548092", "-4.596848", "-3.276309", "-0.983143", "-0.513139", "0.135404", "-0.156464", "-0.513139", "1.096299", "-0.156464", "1.096299", "0.585473", "-0.002314", "-2.430062", "0.403152", "1.096299", "-0.107674", "-3.867711", "-1.932223", "-0.849611", "1.096299", "-3.446996", "-0.002314", "-5.687026", "-0.513139", "0.115469", "-0.002314", "-0.289996", "-0.695461", "-2.514619", "1.096299", "-1.100926", "-2.161798", "-3.465643", "-2.132527", "-0.002314", "-0.184635", "-2.528042", "-0.608449"}, {"TAG", "-1.301597", "0.486533", "-1.388608", "-5.280428", "-2.199538", "0.719004", "-3.778899", "-5.357326", "0.685003", "-3.562412", "-0.819004", "-2.107426", "-2.981239", "-3.595049", "-1.335642", "-4.388875", "0.808617", "-0.775503", "-0.289996", "-3.715886", "0.536683", "0.690834", "-2.122577", "-0.866779", "-2.617273", "-2.743154", "-2.637395", "-4.146990", "-0.849611", "0.403152", "-1.255077", "-3.985106", "1.096299", "-5.687026", "1.096299", "0.962767", "1.096299", "0.403152", "-0.983143", "-0.577678", "-0.695461", "-1.100926", "-2.142380", "-3.283225", "1.096299", "-0.289996", "0.323109", "-2.353689", "-5.687026", "1.096299", "0.690834", "-1.542759", "0.585473", "-0.002314", "-0.289996", "-0.107674", "-0.156464", "-0.082356", "-1.337315", "-3.732015", "-0.002314", "-0.107674", "-1.388608", "-2.009782"}, {"TGT", "-1.529957", "-0.558750", "-0.127477", "-0.951394", "-1.489943", "-0.144284", "0.140787", "0.046477", "-1.814917", "-0.708008", "-3.014575", "-3.014575", "-0.389559", "0.663650", "-3.845344", "-1.204618", "-1.215765", "-0.790771", "-0.370038", "0.151837", "-1.511317", "-1.186084", "-0.289996", "-1.301597", "-1.836967", "-0.812382", "-0.267006", "-0.137655", "-3.065435", "-0.925477", "-0.884703", "-0.261825", "-0.391778", "-0.289996", "1.096299", "-0.289996", "-0.391778", "-0.107674", "1.096299", "1.096299", "-0.953290", "0.050330", "0.084698", "0.249001", "-1.502680", "-0.223746", "-1.100926", "-0.849611", "-0.652901", "-0.156464", "1.096299", "-0.002314", "-0.479238", "0.180008", "0.690834", "0.690834", "-1.445303", "-0.813244", "0.403152", "-0.577678", "-2.307673", "-0.159943", "-0.435178", "-0.179995"}, {"TGC", "-0.436178", "-2.221005", "-1.078453", "-0.558260", "-0.342442", "-1.745621", "-1.522139", "-0.407779", "-0.849611", "-2.224933", "-3.420040", "-2.262339", "0.680050", "-0.440412", "-4.346840", "-1.677386", "-0.334447", "-1.525144", "0.844984", "-0.813244", "-0.407779", "-1.649622", "-1.122905", "-0.513139", "-0.741981", "-1.569192", "-1.172385", "-0.667290", "-0.732275", "-2.487561", "-1.023965", "-0.320767", "-0.289996", "-1.075925", "-0.002314", "-0.002314", "-0.002314", "-0.303789", "-0.002314", "-0.002314", "-0.043136", "-0.617810", "-0.127477", "-1.848140", "-0.043136", "-1.310840", "-1.100926", "-0.983143", "0.307841", "-1.043767", "-5.687026", "0.626295", "0.131218", "-0.112012", "-1.206286", "-0.002314", "-1.043767", "-1.161550", "-0.577678", "-0.238702", "-0.127477", "-1.692176", "-0.800821", "-1.226089"}, {"TGA", "-2.039196", "0.758086", "-3.826598", "0.949695", "-1.518661", "-3.567140", "-4.121170", "-2.964144", "-2.400209", "-3.397940", "-2.091193", "-1.021676", "-3.173399", "-3.755732", "-2.784176", "-3.516569", "-1.206286", "-1.360437", "-1.736915", "0.654466", "-1.736915", "-1.736915", "-2.883383", "0.644314", "0.265950", "-2.259436", "-3.006345", "-2.843339", "-1.542759", "-3.046836", "-4.692363", "-2.946753", "-0.002314", "-0.002314", "0.770876", "-0.695461", "0.690834", "0.626295", "-2.369437", "-0.695461", "-0.849611", "-1.301597", "-1.938654", "-2.122577", "-1.899434", "-1.655237", "-3.852461", "-3.414561", "-0.289996", "-0.289996", "-1.542759", "-0.002314", "-1.100926", "-0.289996", "-2.353689", "-0.289996", "-0.002314", "-0.289996", "-2.321428", "-0.813244", "0.054845", "-2.753849", "-4.187413", "-2.199538"}, {"TGG", "0.015386", "-0.501966", "-1.038406", "-2.080053", "-1.082234", "-1.301597", "-1.146468", "-3.019778", "-1.133716", "-2.081755", "-3.342423", "-4.396129", "-1.321768", "-1.596727", "-3.429662", "-0.520887", "-0.461846", "-1.301597", "-0.884703", "-1.008755", "-1.172385", "-1.100926", "-1.516441", "-2.290510", "-0.476098", "-0.923039", "-0.896131", "-1.504379", "-0.598297", "-0.718991", "-0.649998", "-2.821008", "0.690834", "-1.206286", "0.403152", "-0.309044", "0.115469", "-0.289996", "-0.877782", "0.833934", "-0.407779", "-0.066852", "-1.100926", "-0.709254", "-0.661559", "-1.374622", "-1.174538", "-2.113601", "1.096299", "-0.202984", "-0.695461", "-0.221003", "0.759826", "-1.301597", "-0.652901", "-1.206286", "-0.695461", "-0.775503", "-0.722860", "-1.296235", "-0.957825", "-0.527324", "-0.945685", "-2.204094"}, {"CTT", "-1.635787", "0.443524", "0.578093", "1.016512", "-1.462806", "-0.043136", "-0.407779", "0.307841", "-1.100926", "-0.156464", "0.585473", "-0.002314", "-1.317283", "-0.759999", "-1.542759", "-0.202984", "-0.278934", "0.861656", "0.585791", "0.968822", "-2.327822", "-0.679783", "-0.649998", "-0.323518", "-1.984156", "-0.618500", "-0.306525", "-0.169368", "-2.246645", "-1.261011", "-0.423527", "-0.314688", "-0.493153", "0.751093", "0.424205", "0.779961", "-1.149534", "0.293952", "0.066679", "0.403152", "-0.556624", "0.249001", "-0.156464", "0.285368", "-0.969157", "-0.370038", "-0.107674", "-0.002314", "-0.815460", "0.633168", "-0.093285", "0.833934", "-1.347450", "0.277988", "0.342527", "-0.002314", "-1.611751", "0.285368", "-0.156464", "0.403152", "-0.532942", "-0.918604", "0.323109", "-0.002314"}, {"CTC", "0.522389", "-1.009500", "0.849703", "0.987333", "-0.020663", "-0.819758", "-0.320767", "-0.066852", "-0.849611", "-0.784014", "-1.542759", "0.103047", "-0.946775", "-2.009782", "-1.794073", "-0.472317", "0.883308", "0.119033", "0.794065", "0.950298", "-0.436489", "-2.143809", "-1.063186", "-0.289996", "-0.513139", "-2.071579", "-0.954972", "-0.534530", "-0.928083", "-2.174537", "-0.903100", "-0.289996", "0.847837", "-0.052766", "0.690834", "0.831018", "0.434900", "-0.442265", "0.297791", "0.115469", "0.585473", "-0.501305", "-0.513139", "-0.225457", "-0.695461", "-0.793653", "-0.849611", "0.208996", "0.595523", "-0.635331", "0.227261", "0.770876", "0.285368", "-0.214772", "-0.043136", "-0.002314", "0.403152", "-1.189479", "-0.513139", "-0.513139", "-0.638302", "-1.128325", "-0.444146", "-0.289996"}, {"CTA", "-0.122942", "0.345993", "-0.196449", "0.990938", "-0.350620", "-0.156464", "-0.496790", "0.342527", "0.403152", "-0.156464", "-2.039196", "-0.002314", "-0.775503", "-0.983143", "-2.580002", "-0.877782", "0.615278", "0.835538", "-0.757661", "0.862461", "-0.503570", "-1.031933", "-2.601912", "-0.845137", "-0.918604", "-1.524740", "-1.921600", "-0.377857", "-0.127477", "-0.608449", "-2.542748", "-0.879764", "0.307841", "0.849439", "-1.089639", "0.755128", "0.285368", "0.690834", "-0.695461", "0.873155", "1.096299", "-0.289996", "0.115469", "-0.127477", "0.585473", "0.180008", "-0.320767", "-0.461846", "0.134888", "0.560780", "-1.548989", "0.553092", "0.342527", "-0.002314", "-0.861446", "-0.156464", "0.403152", "-5.687026", "0.084698", "0.180008", "0.403152", "1.096299", "-0.695461", "-0.407779"}, {"CTG", "0.599862", "0.619959", "1.001337", "0.667593", "0.035427", "0.249001", "0.284031", "-0.481534", "0.403152", "0.180008", "-0.749528", "-2.487220", "-0.513139", "-0.813244", "-2.710364", "-1.054969", "0.938464", "0.952805", "0.894244", "0.314127", "-0.240827", "-0.340526", "-0.573906", "-2.118123", "-0.420049", "-0.229371", "-0.177200", "-1.535641", "-0.813244", "-0.539457", "-0.225457", "-2.142380", "0.865187", "0.826008", "0.801182", "0.314669", "0.525754", "0.380679", "0.311717", "0.072910", "0.084698", "0.403152", "0.467690", "0.006989", "0.536683", "-0.461846", "0.249001", "-0.417829", "0.741754", "0.859169", "0.687835", "-0.072616", "0.770876", "0.714931", "0.134262", "-0.150494", "0.536683", "0.285368", "-0.048834", "-0.127477", "-0.695461", "0.342527", "-0.107674", "-0.422167"}, {"CCT", "-1.903272", "-0.391778", "0.362330", "0.285368", "-1.283247", "0.474688", "0.454445", "0.630935", "-1.429430", "0.180008", "-0.289996", "-1.388608", "-1.419091", "-0.836539", "-0.407779", "-0.444146", "-2.465302", "-0.704104", "-0.403655", "-0.198747", "-0.299410", "0.838916", "0.878243", "0.941601", "-2.040349", "-0.563570", "-0.012676", "0.282788", "-1.950322", "-0.784692", "-0.379608", "-0.425170", "-0.909035", "0.263390", "0.285368", "0.626295", "-1.207385", "0.550476", "0.650988", "0.338613", "-0.781403", "0.536683", "-0.849611", "0.342527", "-0.407779", "0.126898", "0.220830", "-1.388608", "-1.094368", "-0.002314", "0.249001", "0.536683", "-0.999672", "0.567601", "0.372380", "0.734509", "-0.619749", "-0.749528", "-0.513139", "0.269620", "-0.825514", "0.147218", "-0.695461", "0.285368"}, {"CCC", "-0.035103", "-1.087503", "-0.202984", "0.260051", "0.585473", "-1.087021", "0.344178", "0.508512", "-1.794073", "-0.886516", "-1.206286", "0.285368", "-1.191898", "-1.611751", "-2.541287", "-1.644541", "-0.952929", "-2.069213", "-0.947516", "-0.381626", "0.843546", "-0.082622", "0.688024", "0.906458", "-0.430578", "-1.922173", "-0.586261", "0.173712", "-0.679460", "-2.367847", "-1.239076", "-0.289996", "-0.638302", "-0.506667", "-0.002314", "-0.043136", "0.658044", "-0.811421", "0.339973", "0.585473", "0.334159", "-0.035103", "-0.513139", "0.549755", "-0.184635", "-0.328315", "-0.238702", "-0.513139", "0.115469", "-0.367131", "-0.225457", "0.365411", "0.597576", "-0.539716", "0.353390", "0.518221", "0.739624", "0.088658", "-0.749528", "0.151837", "0.477260", "-0.401914", "-0.202984", "-0.066852"}, {"CCA", "-1.172385", "-0.618500", "-0.322084", "0.205326", "0.446118", "0.286776", "-1.335655", "-0.155020", "0.467690", "-0.577678", "-2.039196", "-2.687891", "-0.813244", "-1.994744", "-3.017304", "-1.016666", "-0.780300", "-1.159993", "-2.354399", "-0.742632", "0.871685", "0.738615", "-0.492908", "0.678529", "-0.362316", "-0.898106", "-1.540328", "-0.243172", "-0.728251", "-0.929654", "-2.561006", "-1.158277", "0.180008", "-0.289996", "-0.513139", "-0.044873", "0.403152", "0.041650", "-1.085178", "-0.114105", "0.403152", "-1.206286", "-0.326810", "0.070446", "-0.002314", "-0.135845", "-1.294579", "-0.370038", "0.180008", "-0.176667", "-0.403940", "0.379621", "0.421170", "0.368060", "-1.014271", "0.098662", "-0.002314", "0.520935", "-0.205913", "0.161989", "-0.513139", "-0.775503", "-0.787576", "-0.107674"}, {"CCG", "-0.107674", "0.180008", "0.066679", "-0.425170", "0.403152", "0.504934", "0.008586", "-2.315743", "-0.289996", "-1.100926", "-0.983143", "-2.710364", "-0.608449", "-1.346048", "0.457219", "-1.971754", "-0.366957", "-0.668432", "-0.785317", "-2.351219", "0.890463", "0.903644", "0.646374", "-0.945578", "-0.756085", "-0.572858", "-0.520386", "-1.766467", "-0.191556", "-0.135845", "-1.437398", "-2.595078", "-0.289996", "0.403152", "0.759826", "-0.407779", "0.544230", "0.193431", "0.115469", "-1.900821", "-0.002314", "0.690834", "-0.444146", "-0.947803", "0.808617", "0.644314", "-0.202984", "-1.400442", "0.536683", "0.508512", "-0.002314", "-0.340427", "0.447603", "0.505430", "0.148622", "-1.867685", "1.096299", "0.403152", "0.297791", "-1.555662", "-0.983143", "0.690834", "-0.156464", "-0.664689"}, {"CAT", "-0.666047", "0.100871", "-0.002314", "-0.156464", "-0.813244", "0.124438", "-0.289996", "0.307841", "-2.068154", "0.343728", "-1.899434", "-2.641371", "-1.889791", "-0.853931", "-1.874116", "-1.594944", "-1.678714", "-0.618074", "-0.120097", "0.193431", "-1.920954", "-0.495121", "-0.396605", "-0.179995", "-0.545447", "0.855686", "0.304061", "0.453266", "-1.416893", "-0.116042", "0.569473", "0.455111", "-0.541310", "0.759826", "-5.687026", "0.690834", "-0.907431", "0.654466", "-0.289996", "0.690834", "-0.911848", "0.651848", "0.508512", "0.515269", "-0.757981", "0.036907", "0.437053", "0.147218", "-0.407779", "0.220830", "0.690834", "-0.513139", "-1.057251", "0.202481", "-0.849611", "-0.513139", "-1.563076", "0.303068", "0.439519", "0.318594", "-1.077784", "-0.101404", "-0.225457", "-0.444146"}, {"CAC", "0.071794", "-0.922518", "-0.513139", "0.220830", "0.366784", "-0.664278", "0.316140", "-0.407779", "0.204301", "-1.411200", "-2.567263", "-2.753849", "-1.167617", "-1.940636", "-3.346353", "-1.218709", "-0.363327", "-2.030270", "-0.600151", "-0.403324", "-0.689269", "-1.841694", "-0.901797", "-0.163955", "0.859401", "-0.039940", "-0.097127", "0.097685", "0.063748", "-0.972418", "0.062826", "0.230539", "0.249001", "-0.528407", "-0.289996", "0.249001", "0.180008", "-0.142076", "-0.695461", "1.096299", "0.749428", "-0.443895", "0.180008", "0.225470", "0.088070", "-0.444146", "0.054845", "0.297791", "0.249001", "-1.911856", "1.096299", "0.180008", "0.054845", "-0.525562", "-0.775503", "0.249001", "0.345993", "-1.148935", "0.017489", "0.213910", "-0.306525", "-0.991727", "-0.258247", "-0.749528"}, {"CAA", "-0.082356", "-1.154993", "-0.264678", "0.297791", "0.180008", "0.050330", "-1.110976", "-0.983143", "-0.052324", "-0.787576", "-4.340609", "-2.551107", "-1.072755", "-0.619749", "-2.964144", "-1.285424", "-0.289996", "-1.065208", "-1.639786", "-0.429056", "-0.240399", "-0.440569", "-1.704498", "-0.754884", "0.368960", "-0.099888", "-0.693127", "0.696478", "0.390729", "0.010590", "-1.133824", "0.118700", "1.096299", "-0.002314", "0.275318", "0.342527", "-0.156464", "-0.289996", "-0.279067", "-1.301597", "0.857888", "0.508512", "-0.828859", "0.403152", "0.349084", "0.220830", "-0.368984", "0.305513", "-0.289996", "-0.002314", "-0.002314", "0.403152", "0.557302", "0.403152", "-0.687093", "0.131218", "0.794018", "0.043149", "-0.788987", "0.443698", "0.084698", "-0.289996", "-0.983143", "-0.289996"}, {"CAG", "-0.002314", "-0.484152", "0.354361", "-0.176667", "-0.043136", "0.040246", "-0.068453", "-1.291444", "0.340631", "-0.554688", "-2.825675", "-3.608983", "-0.486111", "-0.893736", "-1.852517", "-1.420800", "-0.166617", "-0.818521", "-0.542698", "-1.630037", "0.233592", "0.043432", "-0.079101", "-1.707175", "0.466401", "0.158097", "0.692914", "0.296861", "0.433305", "0.389484", "0.341134", "-0.857300", "-0.002314", "0.403152", "0.403152", "0.112349", "0.636766", "0.467690", "0.417967", "-0.233756", "0.756431", "0.466065", "0.380679", "0.033231", "0.597308", "0.304061", "0.384342", "0.031753", "0.690834", "0.249001", "0.307841", "-0.019705", "0.690834", "0.297791", "0.267606", "-0.908022", "0.800834", "0.460310", "0.460310", "0.088559", "0.066679", "-0.082356", "-0.002314", "-0.376705"}, {"CGT", "-1.812422", "-0.289996", "-0.002314", "-0.002314", "-0.824078", "-0.127477", "-0.513139", "0.403152", "-1.676290", "-0.187717", "-0.289996", "0.403152", "-3.183967", "-0.926903", "-2.337688", "-0.965124", "-2.000238", "-0.322785", "-0.608449", "0.077729", "-2.268840", "-1.078453", "-0.513139", "-0.652901", "-1.398571", "-0.040780", "0.343963", "0.459032", "0.064665", "0.982767", "1.046208", "1.039140", "-1.043767", "1.096299", "-5.687026", "-5.687026", "-0.568709", "-0.289996", "0.690834", "0.403152", "-0.421572", "0.759826", "0.828035", "0.990938", "-1.865824", "0.020159", "0.973696", "0.966841", "0.115469", "-0.002314", "1.096299", "-5.687026", "-1.524740", "-0.513139", "1.096299", "-5.687026", "-1.114719", "-0.444146", "0.403152", "1.096299", "-2.422682", "-0.867311", "0.180008", "-0.849611"}, {"CGC", "-0.127477", "-1.605672", "0.403152", "0.285368", "-0.002314", "-0.833611", "-1.301597", "-0.002314", "-0.156464", "-0.987041", "-0.775503", "0.307841", "-0.752156", "-2.408685", "-3.108394", "-1.948224", "-0.650610", "-2.005021", "-1.043767", "0.149703", "-0.838973", "-2.283562", "-0.741981", "-0.132367", "0.141698", "-1.072344", "-0.083381", "0.278226", "0.965110", "0.552374", "0.994237", "1.003947", "-0.002314", "-0.561929", "-5.687026", "0.115469", "0.536683", "-0.212034", "0.403152", "0.690834", "0.449672", "-0.028982", "0.690834", "0.786144", "0.132861", "-1.210410", "0.910196", "0.977851", "-0.002314", "-1.449233", "0.585473", "0.490163", "0.307841", "-0.998647", "0.403152", "-0.002314", "-0.350620", "-0.728251", "0.490163", "0.231301", "-0.487821", "-1.513973", "-0.420049", "-0.358989"}, {"CGA", "-0.513139", "-0.407779", "-0.056381", "0.285368", "-0.289996", "0.180008", "-1.086940", "-0.002314", "-0.002314", "-1.542759", "-2.459049", "-1.994744", "-0.435178", "-0.912525", "-4.387114", "-1.037210", "0.342527", "-1.331450", "-1.466166", "-0.323897", "-0.487821", "-0.957825", "-2.145909", "-1.058366", "0.505806", "0.042138", "-0.821141", "0.366231", "1.055283", "1.018879", "0.139320", "1.031587", "0.690834", "0.690834", "0.307841", "1.096299", "-5.687026", "-0.156464", "-0.552360", "0.403152", "0.808617", "-0.289996", "0.547401", "0.621841", "-0.082356", "-0.120097", "0.102574", "0.975285", "1.096299", "0.403152", "-1.154993", "0.585473", "0.180008", "-0.849611", "-0.918604", "-0.002314", "0.508512", "-0.983143", "-0.002314", "-0.127477", "0.249001", "-0.626468", "-2.479528", "-0.025844"}, {"CGG", "-0.289996", "-0.289996", "-1.206286", "-0.395356", "-0.225457", "0.208996", "-0.120097", "-0.695461", "-0.350620", "-0.608449", "-2.161798", "-4.027665", "-0.381803", "-0.672471", "-3.816356", "-2.594617", "-0.156464", "-0.638302", "-0.545929", "-1.962744", "-0.577678", "-0.472317", "-0.836832", "-2.380536", "0.243521", "0.059678", "0.211351", "-0.852263", "1.037895", "1.002922", "1.007718", "0.452517", "1.096299", "0.180008", "0.115469", "0.249001", "0.180008", "0.585473", "0.490163", "0.249001", "0.759826", "0.084698", "0.808617", "0.730292", "0.658044", "-0.325087", "1.020274", "0.672934", "-0.289996", "-0.849611", "0.180008", "-0.273189", "0.962767", "0.536683", "0.323109", "-1.388608", "-1.301597", "-0.444146", "0.508512", "-0.113539", "-0.472317", "0.319770", "0.107687", "-1.202004"}, {"ATT", "-0.720265", "0.351858", "0.260051", "0.659085", "-1.137294", "-0.215888", "0.115469", "0.249001", "0.202481", "-0.156464", "-5.687026", "0.403152", "-0.537832", "-1.100926", "0.403152", "0.249001", "-0.615726", "0.856819", "0.585473", "0.735684", "-1.708378", "0.074647", "-0.695461", "-1.206286", "-0.716080", "-1.301597", "1.096299", "0.508512", "-0.661559", "0.403152", "-5.687026", "0.115469", "0.397223", "0.995708", "0.908687", "0.538289", "-1.814388", "-0.375762", "-0.073083", "0.005291", "-0.449890", "-0.138446", "-0.093285", "0.180008", "-0.588977", "0.006497", "-0.608449", "-0.951394", "-0.361796", "0.894490", "0.644314", "0.909260", "-1.136760", "0.644314", "0.338613", "0.599862", "-0.144488", "-0.156464", "0.690834", "0.180008", "-0.385306", "0.031588", "0.690834", "-0.370038"}, {"ATC", "0.403152", "-0.631913", "0.557302", "0.725925", "0.285368", "-0.520519", "0.180008", "-0.002314", "-5.687026", "-0.391778", "0.403152", "-0.289996", "-0.370038", "-0.711990", "-0.983143", "-0.695461", "0.802386", "-0.146074", "0.735285", "0.762526", "-0.215888", "-0.782472", "-0.429758", "0.557302", "0.285368", "-1.239076", "-0.407779", "-0.107674", "-0.513139", "-0.884703", "-0.513139", "0.690834", "1.012396", "0.588345", "0.898094", "0.451561", "-0.305500", "-1.726653", "-0.555103", "0.112349", "0.066679", "-0.756615", "-0.461846", "-0.648941", "-0.099952", "-1.070056", "-0.407779", "-0.535118", "0.905466", "0.019234", "0.782641", "0.889643", "0.199553", "-0.261217", "0.134888", "0.616726", "-0.002314", "-0.453035", "-0.107674", "-0.461846", "-0.407779", "-0.815710", "-0.202984", "-0.513139"}, {"ATA", "0.358700", "0.808617", "-0.543855", "0.659085", "0.777845", "0.654466", "-0.269793", "0.403152", "-5.687026", "1.096299", "0.690834", "-5.687026", "-0.289996", "1.096299", "0.728574", "-0.849611", "0.442372", "0.781218", "-0.928083", "0.633168", "0.084698", "0.403152", "-0.521797", "-0.056381", "-0.002314", "1.096299", "-0.073773", "0.307841", "0.403152", "0.403152", "-0.472317", "-0.513139", "0.899069", "0.962389", "0.004371", "0.073748", "-0.093285", "-0.699158", "-2.115774", "-0.550369", "-0.775503", "-0.695461", "-0.625144", "-0.144488", "-0.107674", "-0.461846", "-1.144820", "-0.215888", "0.524512", "0.856277", "-0.553021", "0.808617", "0.549755", "0.424205", "-0.317147", "-0.135845", "1.096299", "0.249001", "-0.164833", "0.368060", "0.180008", "0.490163", "-0.054273", "-0.082356"}, {"ATG", "0.690834", "0.403152", "0.869986", "0.226661", "0.365411", "0.483194", "0.536683", "-0.022314", "0.690834", "-5.687026", "0.403152", "-1.676290", "-0.002314", "-5.687026", "0.962767", "-0.407779", "0.741754", "0.893070", "0.690834", "0.207974", "0.362330", "-0.156464", "-0.016702", "-0.833611", "0.403152", "1.096299", "0.403152", "0.098940", "1.096299", "0.403152", "-0.608449", "-0.531158", "0.355002", "0.460994", "0.040160", "0.320298", "0.066679", "0.007839", "-0.159860", "-2.315860", "0.285368", "0.279538", "0.200627", "-0.508897", "0.031588", "0.275318", "-0.184635", "-1.221486", "0.699417", "0.732506", "0.621724", "-0.260132", "0.852677", "0.604704", "0.399253", "-0.389944", "0.626295", "0.690834", "0.191842", "0.044206", "0.585473", "0.665516", "0.403152", "-0.077821"}, {"ACT", "-0.570709", "0.231301", "-0.513139", "0.610791", "-0.286435", "0.825424", "0.734797", "0.802059", "-1.100926", "0.115469", "1.096299", "0.403152", "-0.338786", "0.403152", "1.096299", "-0.695461", "-1.075201", "0.213910", "0.220830", "0.654466", "-1.026368", "0.475125", "0.505806", "0.705432", "-0.559124", "0.454445", "0.323109", "0.626295", "-0.258247", "-0.513139", "0.403152", "1.096299", "-1.723779", "-0.046116", "0.079364", "0.163922", "-0.218695", "0.832151", "0.915206", "0.981584", "0.010175", "0.731895", "0.383349", "0.580082", "0.108065", "0.746697", "-0.048834", "0.253620", "-0.553685", "0.548659", "0.690834", "0.598896", "-0.909412", "0.687853", "0.740844", "0.857888", "-0.616680", "0.454445", "0.285368", "0.744901", "0.142425", "0.520935", "0.610791", "0.808617"}, {"ACC", "-0.289996", "-0.635357", "0.508512", "0.403152", "0.821410", "-0.186455", "0.717645", "0.833934", "0.873155", "-0.002314", "0.690834", "-0.002314", "-0.002314", "-0.303789", "-0.849611", "-0.775503", "0.329044", "-0.576114", "-0.513139", "0.115469", "0.511954", "-0.913851", "0.347889", "0.426141", "0.520935", "0.084698", "0.490163", "0.403152", "-0.002314", "-0.327736", "-0.289996", "0.844984", "-0.205821", "-1.595729", "-0.402208", "-0.098146", "0.830581", "0.034436", "0.715916", "0.941234", "0.759826", "0.277271", "0.301369", "0.275318", "0.678915", "0.305498", "-0.212034", "0.154255", "0.603822", "0.146046", "0.180008", "0.598052", "0.726552", "-0.484065", "0.333084", "0.755694", "0.773525", "0.154872", "0.733393", "0.708533", "-0.002314", "0.140787", "-0.407779", "0.334159"}, {"ACA", "0.690834", "0.180008", "-0.150734", "0.554701", "0.851176", "0.702668", "-0.321513", "0.531533", "1.096299", "0.180008", "-1.794073", "-0.289996", "0.403152", "-0.695461", "0.205326", "-0.407779", "0.054845", "-0.038681", "-0.505417", "0.285368", "0.569278", "0.151837", "-0.955445", "0.164741", "-0.156464", "-0.849611", "-0.116724", "0.254732", "-0.513139", "0.403152", "-1.007835", "0.636766", "0.079364", "-0.382992", "-1.898794", "-0.301572", "0.898672", "0.755187", "-0.317070", "0.834964", "0.592394", "0.334159", "-0.339947", "0.338393", "0.590363", "0.495089", "-0.996447", "-0.268942", "0.240633", "0.474610", "0.073036", "0.530060", "0.675499", "0.482349", "-0.912603", "0.163479", "0.323109", "0.449672", "-0.312137", "0.146432", "0.660981", "0.442372", "-0.236507", "0.272123"}, {"ACG", "1.096299", "0.690834", "0.249001", "-0.597021", "0.823005", "1.013607", "0.577810", "-1.150338", "1.096299", "0.808617", "1.096299", "-2.430062", "-5.687026", "0.403152", "0.913977", "-0.931850", "0.403152", "0.490163", "-0.156464", "-0.410948", "0.375753", "0.501592", "-0.073773", "-2.105887", "0.690834", "1.096299", "-0.107674", "-0.736283", "1.096299", "1.096299", "-0.695461", "-0.289996", "-0.455981", "0.031588", "-0.459738", "-2.246533", "0.945339", "0.948983", "0.831336", "-0.426008", "0.403152", "0.546252", "-0.002314", "-1.051785", "0.759826", "0.664165", "-1.000842", "-1.216649", "0.733393", "0.933780", "0.640823", "-0.047097", "0.747114", "0.773525", "0.411337", "-1.523993", "0.585473", "0.536683", "-0.179995", "-1.298457", "1.096299", "0.477260", "0.066679", "-0.202984"}, {"AAT", "-0.454299", "0.403152", "0.403152", "0.759826", "0.372380", "0.828035", "0.585473", "1.096299", "-1.403314", "0.420543", "-0.983143", "-0.002314", "-0.648059", "-0.082356", "-0.002314", "0.285368", "-0.232837", "0.460310", "0.585473", "0.739624", "-0.559659", "0.573051", "-0.156464", "0.180008", "-0.877694", "0.712975", "0.591743", "0.704257", "-0.459072", "0.140787", "-0.002314", "0.403152", "-0.354336", "0.296179", "0.115469", "0.549755", "0.030342", "0.729152", "0.555168", "0.808617", "0.362680", "0.967028", "0.378122", "0.440960", "-0.633767", "0.394988", "-0.207409", "-0.201048", "-0.289996", "-0.289996", "1.096299", "0.490163", "-0.298435", "0.756431", "0.403152", "0.403152", "-1.007835", "0.663084", "0.615326", "0.599862", "-0.124203", "0.444310", "0.151837", "0.575002"}, {"AAC", "-0.002314", "-0.370038", "1.096299", "0.873155", "0.895628", "0.389729", "0.477260", "0.690834", "0.313539", "-1.042657", "-0.444146", "-0.370038", "-0.184635", "-1.006310", "0.403152", "-0.289996", "0.066679", "-1.063186", "-0.002314", "0.403152", "0.358700", "0.101676", "-0.002314", "-0.107674", "0.600320", "-0.637725", "0.237637", "0.289823", "0.403152", "-0.991442", "-0.289996", "0.403152", "0.155315", "-0.996936", "1.096299", "0.155315", "0.578160", "0.168629", "0.296542", "0.477260", "0.980595", "0.490795", "-0.366279", "0.026146", "0.358083", "-0.730220", "-0.866953", "-0.518837", "-0.225457", "-0.666047", "-0.156464", "0.690834", "0.440892", "0.155650", "0.403152", "0.626295", "0.669916", "-0.685623", "0.161316", "0.016735", "0.435587", "-0.084835", "-0.379608", "-0.140464"}, {"AAA", "1.096299", "-0.002314", "0.349084", "-0.002314", "0.610791", "0.307841", "0.011673", "0.140787", "0.208996", "-1.063186", "-3.107149", "-2.854945", "0.269620", "-0.695461", "-2.459049", "-0.820624", "0.403152", "-0.983143", "-0.202984", "0.260051", "-0.289996", "-0.156464", "-0.524835", "-0.172213", "0.440892", "0.027539", "-0.984677", "0.218938", "0.520935", "0.942148", "0.598460", "0.817127", "-0.032167", "-0.600151", "-0.660121", "0.026674", "0.345993", "0.082244", "-0.491424", "0.045696", "0.283861", "-0.296685", "0.215240", "0.895575", "0.064549", "-0.637567", "-0.857689", "0.361215", "0.644314", "0.140787", "-0.066852", "-0.035103", "0.198357", "0.031588", "-0.241749", "-0.817351", "0.445711", "-0.143854", "-1.683501", "-0.296075", "0.439519", "0.051754", "-0.758159", "-0.407779"}, {"AAG", "0.585473", "-0.289996", "0.180008", "-0.289996", "0.808617", "0.403152", "0.345993", "-1.249771", "0.403152", "0.231301", "-2.641371", "-2.895767", "0.115469", "-1.043767", "-0.896131", "-1.039838", "0.403152", "0.403152", "0.557302", "-0.152596", "0.644314", "0.808617", "0.137448", "-0.931850", "0.532363", "0.403152", "0.204150", "-0.138250", "0.710636", "0.890447", "0.759826", "0.606931", "0.501592", "-0.268942", "-0.454299", "-0.668473", "0.461648", "0.488511", "0.143443", "-1.082954", "0.389668", "0.051596", "0.890692", "0.449150", "0.049511", "-0.236775", "0.325936", "-0.945861", "0.140787", "0.220830", "0.349084", "0.015386", "0.403152", "0.439519", "0.174617", "-1.378137", "0.403152", "-0.097624", "-0.300148", "-0.943966", "0.445711", "0.070446", "-0.051585", "-0.621994"}, {"AGT", "-0.905181", "0.180008", "-0.002314", "-0.002314", "0.312180", "0.767795", "0.833934", "0.585473", "-0.820624", "0.449672", "-0.695461", "1.096299", "-1.868589", "-0.276009", "-1.948224", "-0.695461", "-1.222816", "-0.215888", "0.690834", "0.180008", "-0.142543", "0.040246", "-0.225457", "-0.513139", "-0.955686", "0.030476", "0.365411", "0.514377", "-2.032652", "0.173135", "0.460310", "0.370362", "-0.613944", "0.037692", "-0.513139", "0.215940", "0.152118", "0.633958", "0.492099", "0.913977", "-0.654880", "0.419291", "0.183789", "0.073970", "-0.177790", "0.758928", "-0.425262", "-0.520921", "-0.068689", "0.213910", "0.808617", "0.460310", "0.050054", "0.403152", "0.054845", "0.808617", "-0.267929", "0.251921", "0.338613", "0.426141", "-1.078178", "0.357595", "0.530307", "0.652963"}, {"AGC", "-0.107674", "-1.688713", "-0.002314", "0.690834", "0.786144", "0.440193", "0.403152", "1.096299", "0.403152", "-0.488847", "0.508512", "-0.289996", "-0.034574", "-1.468651", "-2.946753", "-1.577850", "-0.289996", "-1.263445", "0.403152", "-0.695461", "0.124438", "-0.441395", "-0.238702", "-0.849611", "0.196357", "-0.553549", "-0.002314", "0.352721", "-0.002314", "-1.316252", "-0.040780", "0.323109", "0.245523", "-0.991582", "-0.661559", "-0.101404", "0.720866", "0.186220", "0.188040", "0.682323", "0.422733", "-0.676357", "-0.713415", "-0.033404", "0.769409", "-0.087382", "-1.051024", "-0.774994", "-0.344063", "-0.565586", "0.644314", "0.585473", "0.481932", "0.267810", "0.140787", "0.660981", "0.382532", "-0.327613", "0.220830", "0.084698", "0.441938", "-0.668421", "0.199553", "0.263390"}, {"AGA", "-0.513139", "-0.775503", "-0.983143", "-0.695461", "-0.407779", "-0.577678", "-0.849611", "-0.608449", "-0.156464", "-0.202984", "-3.207766", "0.307841", "-0.338786", "-1.100926", "-4.310275", "-1.150936", "-0.107674", "-0.983143", "-0.513139", "-0.184635", "0.403152", "-1.301597", "-1.100926", "0.046477", "0.066679", "-0.397626", "-0.254728", "0.253033", "0.937234", "0.947616", "0.124226", "0.988778", "-0.184635", "-1.756333", "-1.225029", "-0.299212", "-0.002314", "-0.334447", "-1.152219", "-0.328710", "-0.180796", "-0.942869", "-0.810100", "0.398985", "-0.432170", "-1.223586", "-0.900459", "0.607865", "-0.407779", "0.158029", "-0.072272", "-0.066852", "-0.289996", "-1.063186", "-0.896131", "-0.253628", "-0.002314", "-0.407779", "-0.842996", "-0.468687", "-0.130931", "-0.614922", "-2.629946", "-0.202984"}, {"AGG", "0.403152", "-0.513139", "-0.002314", "0.046477", "-1.301597", "0.231301", "0.403152", "-0.385306", "0.585473", "-0.156464", "-0.002314", "-2.567263", "-0.479238", "-1.560458", "-2.102374", "-2.274010", "-0.513139", "-1.154993", "-0.002314", "-0.420049", "-1.206286", "-0.695461", "-0.225457", "-0.970564", "0.227261", "0.107687", "0.205983", "-0.116724", "0.940428", "0.936577", "0.950637", "0.485802", "-0.728251", "-1.301597", "-0.338786", "-1.104126", "0.195512", "-0.335805", "-0.237810", "-1.582151", "0.036526", "-0.507719", "0.245851", "-1.000518", "-0.591257", "-0.743437", "0.525358", "-0.692949", "-0.156464", "-0.202984", "0.460310", "-0.659093", "-0.695461", "-0.043136", "-0.127477", "-0.963725", "0.040246", "-0.358989", "-0.350620", "-0.755887", "-0.189912", "-0.059472", "-0.150955", "-1.837235"}, {"GTT", "-0.857181", "0.690834", "0.202481", "0.735285", "-0.353417", "0.777845", "0.151837", "0.873155", "0.180008", "0.403152", "-0.289996", "1.096299", "-0.385306", "0.115469", "-0.002314", "-0.289996", "-0.850217", "0.641826", "0.403152", "0.849898", "-1.282609", "0.220830", "-1.100926", "-0.002314", "-0.849611", "-1.611751", "0.808617", "-0.695461", "-1.301597", "0.403152", "0.403152", "-0.002314", "-0.170016", "0.942492", "0.668259", "0.766995", "-0.587434", "0.712340", "0.595523", "0.585473", "-0.163955", "0.483194", "-0.289996", "0.285368", "-0.031301", "0.316140", "-1.301597", "0.536683", "0.050543", "0.953669", "0.799385", "1.018843", "-1.243585", "0.230539", "0.285368", "0.341020", "-1.079186", "0.210780", "0.213910", "0.443974", "-1.080246", "0.082244", "-0.061154", "0.345993"}, {"GTC", "0.749428", "-0.631254", "0.895628", "0.667303", "0.501592", "-0.057883", "0.603822", "0.913977", "0.403152", "-0.289996", "0.403152", "-0.289996", "-0.370038", "-0.828992", "-0.289996", "-0.849611", "0.639540", "-0.486027", "0.301369", "0.675566", "0.285368", "-0.890770", "-0.056381", "0.403152", "-0.289996", "-1.180969", "-0.156464", "0.342527", "0.403152", "-1.013914", "-0.513139", "0.403152", "0.930383", "0.159404", "0.953878", "0.702394", "0.571774", "0.160960", "0.447603", "0.713306", "-0.289996", "-0.612769", "-0.775503", "-0.002314", "0.610791", "-0.485847", "-0.289996", "-0.350620", "0.949040", "0.308165", "0.845534", "1.010972", "0.284200", "-0.822411", "-0.135162", "0.414580", "-0.019705", "-1.350116", "-0.695461", "-0.695461", "-0.156464", "-1.097918", "-0.616680", "0.160205"}, {"GTA", "-0.202984", "0.690834", "-0.567206", "0.735285", "0.323109", "0.403152", "0.387647", "0.585473", "-5.687026", "1.096299", "0.285368", "-5.687026", "0.403152", "-0.289996", "-1.611751", "0.808617", "0.220830", "0.651613", "-1.353748", "0.589605", "-0.107674", "0.739624", "-0.449626", "0.557302", "1.096299", "-0.289996", "-0.232837", "0.115469", "1.096299", "1.096299", "-0.002314", "0.536683", "0.527794", "0.923586", "-0.348590", "0.632337", "0.636766", "0.690834", "-0.055423", "0.746096", "1.096299", "0.759826", "-0.267006", "0.403152", "0.873155", "-0.002314", "-0.499716", "-0.056381", "0.806665", "0.936557", "-0.203806", "0.953896", "0.495525", "0.294418", "-1.458610", "0.083576", "0.115469", "0.362330", "-0.668062", "0.135837", "0.285368", "-0.027631", "-0.955876", "-0.149638"}, {"GTG", "0.962767", "0.788814", "0.707928", "0.107899", "0.483194", "0.942148", "0.589481", "0.344311", "0.403152", "1.096299", "1.096299", "0.654466", "-0.849611", "-0.513139", "-0.849611", "-0.370038", "0.674304", "0.780782", "0.740748", "-0.019056", "0.490163", "0.786144", "0.437053", "-0.643404", "1.096299", "0.403152", "0.151837", "0.065128", "0.180008", "0.403152", "-0.002314", "-0.800821", "0.942148", "0.934713", "0.896215", "-0.090400", "0.823432", "0.762293", "0.584331", "-0.033085", "0.249001", "-0.202984", "0.105900", "-0.177518", "0.097770", "0.490163", "-0.243476", "-0.732404", "0.995508", "1.005400", "0.961620", "0.469752", "0.543437", "0.453667", "0.238033", "-1.356238", "-0.736283", "0.265950", "0.086142", "-0.997874", "0.124438", "-0.124203", "0.166763", "-0.933628"}, {"GCT", "-0.864802", "0.115469", "1.096299", "0.962767", "-0.362272", "0.925888", "0.789145", "0.857888", "-0.191556", "0.585473", "1.096299", "-0.289996", "-0.863796", "-0.695461", "0.403152", "-0.513139", "-1.324639", "0.066679", "-0.289996", "0.601602", "-1.082945", "0.671785", "0.631993", "0.620875", "-1.228265", "-0.918604", "0.403152", "0.342527", "-0.794552", "-0.289996", "0.403152", "0.403152", "-0.761916", "0.451161", "0.570206", "0.663435", "-0.973630", "0.658676", "0.595716", "0.784360", "-0.263609", "0.750022", "0.603822", "0.323109", "-0.189254", "0.573051", "-0.127477", "-0.093285", "-1.409774", "0.226221", "0.321658", "0.549244", "-0.168771", "0.927994", "0.926802", "0.965361", "-1.233138", "0.139567", "0.380162", "0.479785", "-0.766363", "0.344468", "0.571288", "0.465027"}, {"GCC", "-0.056381", "-0.231155", "-0.002314", "0.833934", "0.842233", "0.109215", "0.794018", "0.983503", "-1.100926", "-0.029713", "0.873155", "0.808617", "0.115469", "-0.402474", "0.654466", "-1.206286", "0.403152", "-0.543702", "-0.289996", "0.568231", "0.624694", "-0.588196", "0.234529", "0.456261", "-0.056381", "-0.300358", "0.066679", "0.403152", "0.249001", "-0.889617", "-0.983143", "-0.513139", "0.336012", "-0.027631", "0.403152", "0.728574", "0.771244", "-0.348442", "0.481676", "0.808617", "0.799047", "0.359561", "0.316140", "0.639540", "0.533205", "0.307360", "-0.289996", "-0.135845", "0.307436", "-0.804749", "0.003257", "0.496678", "0.928332", "0.236587", "0.771017", "0.968889", "0.295521", "-0.575233", "-0.010612", "0.542264", "0.408164", "-0.414395", "-0.028982", "0.616726"}, {"GCA", "0.403152", "0.115469", "-0.531158", "0.465027", "0.921095", "0.767795", "-0.319616", "0.536683", "1.096299", "0.403152", "-2.304899", "0.403152", "0.115469", "-0.289996", "-2.288092", "-0.056381", "-0.093285", "0.354361", "-0.600845", "0.225945", "0.332534", "0.245966", "-1.110633", "0.206778", "-0.002314", "0.115469", "-0.552360", "0.317629", "0.403152", "-0.695461", "-1.128325", "-0.918604", "0.236097", "0.403152", "-0.332555", "0.403152", "0.561943", "0.556871", "-0.932288", "0.347172", "0.220830", "0.454445", "-0.231288", "0.156751", "0.508512", "0.495525", "-0.936226", "0.018740", "0.168644", "0.054845", "-1.308853", "0.072189", "0.917182", "0.826716", "-0.341139", "0.755837", "0.269620", "0.147218", "-0.997038", "0.147573", "0.487235", "0.339973", "-0.886329", "0.243957"}, {"GCG", "0.403152", "-0.002314", "0.690834", "0.076467", "0.753354", "0.873155", "0.538019", "-1.173316", "-5.687026", "-0.002314", "1.096299", "-1.278607", "-0.513139", "-0.002314", "-0.849611", "-1.468651", "0.180008", "0.307841", "-0.082356", "-0.394775", "0.312180", "0.665516", "0.195512", "-1.814964", "0.808617", "-0.849611", "-1.388608", "-0.652901", "1.096299", "-0.002314", "-0.289996", "-0.849611", "0.739624", "0.747992", "0.368060", "-0.234115", "0.755694", "0.873155", "0.269969", "-1.730681", "0.690834", "0.066679", "-0.243476", "-1.180969", "0.844984", "0.334159", "0.031588", "-1.206286", "0.285368", "0.460310", "-0.050675", "-1.491544", "0.926926", "0.934067", "0.731820", "-0.652659", "0.334159", "0.166763", "-0.473918", "-1.655360", "0.817585", "0.551572", "0.385452", "-1.012662"}, {"GAT", "-0.048834", "-0.289996", "1.096299", "-0.513139", "-0.093285", "0.249001", "0.913977", "0.808617", "-1.255077", "0.158029", "-0.156464", "0.180008", "-0.990925", "0.307841", "-0.407779", "-0.289996", "-0.420049", "-0.225457", "1.096299", "0.759826", "-0.407779", "0.759826", "0.626295", "0.403152", "-1.513891", "0.268232", "0.786144", "0.709526", "-1.197918", "0.342527", "-0.002314", "-0.407779", "-0.598297", "0.151837", "0.403152", "0.249001", "-0.225457", "0.716809", "0.536683", "0.962767", "-0.701593", "0.710636", "0.555168", "0.708533", "-0.113214", "0.376718", "-0.002314", "-0.093285", "-1.225611", "-0.320767", "-0.695461", "0.460310", "-1.036764", "0.238277", "0.597308", "0.751458", "0.418254", "1.011033", "0.885164", "0.952397", "-1.066186", "0.023004", "0.375753", "0.541988"}, {"GAC", "0.285368", "-0.385306", "-5.687026", "0.403152", "0.460310", "0.136523", "-0.513139", "0.690834", "0.378459", "-1.337315", "-1.100926", "-1.542759", "-0.820624", "-0.943922", "-0.002314", "-0.849611", "0.403152", "-0.863796", "0.403152", "0.585473", "0.557302", "-0.208650", "0.585473", "0.585473", "0.316974", "-1.169382", "0.263390", "0.575002", "-0.082356", "-0.172213", "0.084698", "-0.002314", "-0.156464", "-1.055463", "-0.002314", "0.220830", "0.622514", "0.238848", "-0.225457", "0.115469", "0.664447", "-0.389725", "-0.162162", "0.139462", "0.396231", "-0.169506", "-0.027631", "-0.484152", "-0.188900", "-1.155695", "0.084698", "-0.071306", "0.327754", "-0.698035", "0.123567", "0.508512", "1.007799", "0.557712", "0.617229", "0.734302", "-0.067356", "-1.056115", "-0.405509", "-0.191556"}, {"GAA", "0.249001", "0.115469", "-0.107674", "0.610791", "0.467690", "0.929245", "0.211261", "0.198357", "0.180008", "-0.247436", "-2.863782", "-1.003762", "0.140787", "0.054845", "-1.542759", "-0.379608", "0.873155", "-0.202984", "0.180008", "0.626295", "0.403152", "0.403152", "-0.152795", "-0.202984", "0.530985", "0.057406", "-0.919896", "0.426936", "-0.002314", "0.249001", "-0.289996", "-0.238702", "0.962767", "0.269620", "0.529903", "0.562216", "0.557302", "0.437053", "-0.123547", "-0.040780", "0.647348", "0.102494", "-1.382044", "0.039143", "0.676445", "0.249001", "-0.720779", "-0.103666", "0.126898", "-0.048834", "-0.478159", "0.445711", "0.335710", "0.231301", "-0.814746", "-0.202984", "0.907318", "0.676953", "0.198430", "0.928074", "0.174310", "0.028817", "-1.181012", "-0.011659"}, {"GAG", "0.115469", "0.403152", "0.403152", "-0.052324", "1.096299", "0.759826", "0.701645", "-0.677761", "0.721605", "-0.325087", "-1.756333", "-2.608085", "0.180008", "0.307841", "-1.206286", "-0.849611", "0.403152", "-0.127477", "0.180008", "0.148917", "0.654466", "0.483194", "0.133488", "-0.597480", "0.473769", "0.257970", "0.420914", "0.074356", "0.508512", "0.460310", "0.334159", "-0.532942", "0.808617", "-0.056381", "0.236097", "0.283606", "0.552683", "0.585473", "0.436304", "-0.877782", "0.694957", "0.449061", "0.112841", "-0.648417", "0.447603", "0.591204", "0.100341", "-0.782803", "0.626295", "0.237637", "0.164741", "-0.991262", "0.592772", "0.677930", "0.265530", "-1.595458", "0.946646", "0.787419", "0.931471", "0.602371", "0.249001", "-0.026528", "0.153621", "-1.181473"}, {"GGT", "-0.429758", "0.490163", "0.403152", "1.096299", "-0.370038", "0.220830", "0.962767", "0.403152", "-0.924647", "-1.468651", "-0.513139", "1.096299", "-2.050878", "-0.084835", "-0.370038", "-0.461846", "-0.513139", "-1.794073", "0.403152", "0.690834", "-0.500560", "0.269620", "0.690834", "0.403152", "-1.283959", "-0.476098", "0.323109", "0.536683", "-2.723800", "-0.593182", "0.180008", "-0.127477", "-0.528407", "-0.048834", "0.403152", "0.403152", "0.108549", "0.660981", "0.054845", "0.508512", "-0.228120", "0.249001", "0.151837", "0.403152", "-1.124552", "0.418596", "0.052949", "0.099469", "-0.746516", "-0.199024", "0.403152", "0.528315", "-0.636037", "0.338613", "0.416757", "0.690834", "-0.983959", "-0.192832", "0.296542", "0.324163", "-0.261102", "0.812662", "0.924258", "0.925613"}, {"GGC", "0.403152", "-0.720779", "1.096299", "0.942148", "0.403152", "0.097770", "-0.608449", "0.403152", "-0.407779", "-0.686158", "-1.206286", "-1.542759", "-0.170649", "-1.498403", "-0.194685", "-1.611751", "0.115469", "-1.451409", "-0.002314", "0.220830", "-0.140464", "-0.859764", "-0.002314", "-0.156464", "-0.289996", "-1.016368", "-0.002314", "0.160205", "0.023662", "-1.588049", "-0.264678", "0.427249", "-0.056381", "-0.704677", "0.585473", "0.460310", "0.432139", "0.178068", "0.301369", "0.403152", "0.520935", "0.029792", "0.020159", "0.180008", "0.378459", "-0.717541", "-0.580798", "-0.502270", "-0.301830", "-1.283109", "-0.002314", "0.337194", "0.311584", "-0.528081", "0.004512", "0.225470", "-0.185517", "-1.159178", "-0.489329", "-0.184635", "0.827839", "0.089331", "0.729283", "0.849792"}, {"GGA", "0.585473", "-0.289996", "-0.066852", "0.307841", "0.115469", "0.626295", "-0.782472", "0.777845", "0.690834", "-1.301597", "-2.288092", "0.084698", "-0.289996", "-1.068665", "-3.582122", "-1.023965", "0.180008", "-0.695461", "-0.590100", "0.565670", "-0.513139", "-1.301597", "-0.597480", "-1.206286", "-0.652901", "-0.370038", "-0.630922", "-0.182575", "-0.093285", "-0.140464", "-2.176710", "-0.130147", "0.180008", "-0.775503", "-0.289996", "0.220830", "0.565670", "0.115469", "-0.302844", "0.358700", "0.035427", "-0.099952", "-0.297468", "-0.037405", "0.513500", "0.001915", "-2.598442", "-0.340427", "0.097770", "-0.539457", "-0.847057", "-0.040780", "0.285368", "0.117831", "-0.996118", "0.324371", "0.148259", "-0.069284", "-1.196073", "0.007147", "0.900572", "0.824441", "-0.457405", "0.859566"}, {"GGG", "0.403152", "-0.289996", "-0.002314", "-0.202984", "0.467690", "0.467690", "0.713306", "0.354361", "0.403152", "-0.002314", "-0.082356", "-3.425490", "-0.718991", "-0.433096", "-1.971754", "-2.178694", "0.180008", "0.140787", "0.151837", "-0.127477", "-1.100926", "0.054845", "0.403152", "-0.476098", "-0.370038", "-0.577678", "-0.002314", "-0.410485", "0.269620", "0.043149", "-0.118145", "-1.561381", "0.585473", "-0.513139", "0.403152", "-0.218537", "0.477260", "0.490163", "0.134888", "0.129456", "0.546252", "0.097770", "-0.279524", "-0.602129", "0.479525", "0.334159", "-0.276390", "-1.945003", "0.046477", "0.103047", "0.186480", "-1.019171", "0.572444", "0.624459", "0.330989", "-1.030980", "0.174617", "0.033680", "-0.018612", "-1.227575", "0.906199", "0.885670", "0.841562", "-0.133893"}};
        return result;
    }
}

