/*
 * Decompiled with CFR 0.152.
 */
package io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;

public class locus2pir2 {
    public static void main(String[] args) throws Exception {
        int n = 0;
        while (n < args.length) {
            String gi = locus2pir2.GI(args[n]);
            System.out.println(gi);
            String SwissProt = locus2pir2.GI2swissprot(gi);
            System.out.println(SwissProt);
            locus2pir2.swissprot2GO(SwissProt);
            ++n;
        }
    }

    public static String swissprot2GO(String query) {
        StringBuffer v = new StringBuffer();
        String result = "";
        try {
            String line;
            URL helloURL = new URL("http://www.ebi.ac.uk/ego/QuickGO?mode=search&querytype=protein&query=" + query);
            URLConnection con = helloURL.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            int flag = 0;
            while ((line = in.readLine()) != null) {
                if (flag > 0 && line.indexOf(">") < 0 && line.indexOf("<") < 0 && line.length() >= 8) {
                    System.out.println(line.substring(8));
                }
                if (line.indexOf("With") < 0) continue;
                ++flag;
            }
            in.close();
        }
        catch (IOException e) {
            return null;
        }
        return result;
    }

    public static String GI(String query) {
        String result = locus2pir2.definition(query);
        int pos1 = result.indexOf("|") + 1;
        String tmp = result.substring(pos1);
        int pos2 = tmp.indexOf("|");
        return tmp.substring(0, pos2);
    }

    public static String GI2swissprot(String query) {
        StringBuffer v = new StringBuffer();
        String result = "";
        try {
            String line;
            URL helloURL = new URL("http://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?db=nucleotide&val=" + query);
            URLConnection con = helloURL.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            int flag = 3;
            while ((line = in.readLine()) != null) {
                int n;
                int m = line.indexOf("translation");
                if (m >= 0) {
                    System.out.println(line.substring(m + 11));
                }
                if ((n = line.indexOf("Swiss-Prot:")) >= 0) {
                    result = line.substring(n + 11, line.length() - 1);
                }
                if (n >= 0) break;
            }
            in.close();
        }
        catch (IOException e) {
            return null;
        }
        return result;
    }

    public static String GI2protein(String query) {
        StringBuffer v = new StringBuffer();
        String result = "";
        try {
            String line;
            URL helloURL = new URL("http://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?db=nucleotide&val=" + query);
            URLConnection con = helloURL.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            int flag = 3;
            while ((line = in.readLine()) != null) {
                int n = line.indexOf("Swiss-Prot:");
                if (n >= 0) {
                    result = line.substring(n + 11, line.length() - 1);
                }
                if (n >= 0) break;
            }
            in.close();
        }
        catch (IOException e) {
            return null;
        }
        return result;
    }

    public static String definition(String query) {
        StringBuffer v = new StringBuffer(query);
        try {
            String line;
            URL helloURL = new URL("http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=Nucleotide&cmd=search&term=" + query + "+");
            URLConnection con = helloURL.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            int flag = 3;
            while ((line = in.readLine()) != null) {
                ++flag;
                if (line.equals("<dd>")) {
                    flag = 0;
                }
                if (flag != 1 && flag != 2) continue;
                v.append("\t" + line);
            }
            in.close();
        }
        catch (IOException e) {
            return null;
        }
        return v.toString();
    }

    public static String[] search(String query) {
        Vector<String> v = new Vector<String>();
        try {
            String line;
            URL helloURL = new URL("http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=Nucleotide&cmd=search&term=" + query + "+");
            URLConnection con = helloURL.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            boolean flag = false;
            while ((line = in.readLine()) != null) {
                if (line.equals("<dd>")) {
                    flag = true;
                }
                if (flag) {
                    v.add(line);
                }
                if (!line.equals("</dd>")) continue;
                flag = false;
            }
            in.close();
        }
        catch (IOException e) {
            return null;
        }
        int size = v.size();
        String[] result = new String[size];
        int i = 0;
        while (i < size) {
            result[i] = (String)v.get(i);
            ++i;
        }
        return result;
    }
}

