/*
 * Decompiled with CFR 0.152.
 */
package io;

import io.fileload;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import matrix.Jacobi;
import matrix.Matrix;

public class MatrixLoad {
    public String[] list;
    public double[][] matrix;
    Hashtable table;

    public static void main(String[] args) throws Exception {
        String[] data = fileload.loadLine0(args[0]);
        MatrixLoad m = new MatrixLoad(data);
        Jacobi j = new Jacobi(m.matrix);
        Matrix.show(j.V());
    }

    public MatrixLoad(String[] data) throws FileNotFoundException, IOException {
        String[][] tmp = MatrixLoad.CSVtoStringMatrix(data);
        this.matrix = MatrixLoad.StringToDoubleMatrix(tmp);
        this.list = new String[tmp[0].length - 1];
        int i = 0;
        while (i < this.list.length) {
            this.list[i] = tmp[0][i + 1];
            ++i;
        }
        this.table = new Hashtable();
        i = 0;
        while (i < this.list.length) {
            this.table.put(this.list[i], new Integer(i));
            ++i;
        }
    }

    public static double[][] StringToDoubleMatrix2(String[][] org) {
        double[][] data = new double[org.length - 1][];
        int i = 0;
        while (i < org.length - 1) {
            int size = org[i + 1].length;
            data[i] = new double[size - 1];
            int j = 0;
            while (j < size - 1) {
                double d;
                String a = org[i + 1][j + 1];
                data[i][j] = d = new Double(a).doubleValue();
                ++j;
            }
            ++i;
        }
        double[][] result = new double[data.length][];
        int i2 = 0;
        while (i2 < data.length) {
            double total = 0.0;
            int j = 0;
            while (j < data[i2].length) {
                total += data[i2][j];
                ++j;
            }
            result[i2] = new double[data[i2].length];
            j = 0;
            while (j < data[i2].length) {
                result[i2][j] = data[i2][j];
                ++j;
            }
            ++i2;
        }
        return result;
    }

    public static double[][] StringToDoubleMatrix(String[][] org) {
        double[][] data = new double[org.length - 1][];
        int i = 0;
        while (i < org.length - 1) {
            int size = org[i + 1].length;
            data[i] = new double[size - 1];
            int j = 0;
            while (j < size - 1) {
                double d;
                String a = org[i + 1][j + 1];
                data[i][j] = d = new Double(a).doubleValue();
                ++j;
            }
            ++i;
        }
        double[][] result = new double[data.length][];
        int i2 = 0;
        while (i2 < data.length) {
            double total = 0.0;
            int j = 0;
            while (j < data[i2].length) {
                total += data[i2][j];
                ++j;
            }
            result[i2] = new double[data[i2].length];
            j = 0;
            while (j < data[i2].length) {
                result[i2][j] = data[i2][j] / total;
                ++j;
            }
            ++i2;
        }
        return result;
    }

    public static String[][] CSVtoStringMatrix(String[] lines) {
        String[][] data = new String[lines.length][];
        int i = 0;
        while (i < lines.length) {
            Vector<String> v = new Vector<String>();
            StringTokenizer ST = new StringTokenizer(lines[i], ",");
            while (ST.hasMoreTokens()) {
                v.addElement(ST.nextToken());
            }
            int size = v.size();
            data[i] = new String[size];
            int j = 0;
            while (j < size) {
                String a;
                data[i][j] = a = (String)v.elementAt(j);
                ++j;
            }
            ++i;
        }
        return data;
    }

    public double value(String X, String Y) {
        int x = (Integer)this.table.get(X);
        int y = (Integer)this.table.get(Y);
        return this.matrix[x][y];
    }

    public int getPos(String X) {
        int x = (Integer)this.table.get(X);
        return x;
    }

    public double[] vector(String X) {
        int x = (Integer)this.table.get(X);
        return this.matrix[x];
    }
}

