/*
 * Decompiled with CFR 0.152.
 */
package geneWaltz;

import java.util.StringTokenizer;
import java.util.Vector;

public class SmithWaterman {
    public double[][] mat;

    public static void main(String[] args) {
        String data1 = "AAUGCCAUUGACGG";
        String data2 = "CAGCCUCGCUUAG";
        double[][] s = SmithWaterman.score(data1, data2);
        SmithWaterman.show(s);
        System.out.println();
        double[][] H = SmithWaterman.Hij(s, 1.0, 0.33333);
        SmithWaterman.show(H);
    }

    public static double[][] score(String seq1, String seq2) {
        int m = seq1.length();
        int n = seq2.length();
        double[][] result = new double[m + 1][n + 1];
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                char c2;
                char c1 = seq1.charAt(i);
                result[i + 1][j + 1] = c1 == (c2 = seq2.charAt(j)) ? 1.0 : -0.3333;
                ++j;
            }
            ++i;
        }
        return result;
    }

    SmithWaterman() {
        this.mat = new double[1][];
        this.mat[0] = new double[1];
        this.mat[0][0] = 0.0;
    }

    SmithWaterman(int n) {
        this.mat = new double[n][];
        int i = 0;
        while (i < n) {
            this.mat[i] = new double[n];
            int j = 0;
            while (j < n) {
                this.mat[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < n) {
            this.mat[i][i] = 1.0;
            ++i;
        }
    }

    SmithWaterman(int m, int n) {
        this.mat = new double[m][];
        int i = 0;
        while (i < m) {
            this.mat[i] = new double[n];
            int j = 0;
            while (j < n) {
                this.mat[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
    }

    SmithWaterman(double[][] mat0) {
        int m = mat0.length;
        this.mat = new double[m][];
        int i = 0;
        while (i < m) {
            int n = mat0[i].length;
            this.mat[i] = new double[n];
            int j = 0;
            while (j < n) {
                this.mat[i][j] = mat0[i][j];
                ++j;
            }
            ++i;
        }
    }

    static double[][] Hij(double[][] s, double openCost, double extendCost) {
        int m = s.length;
        int n = s[0].length;
        double[][] H = new double[m][n];
        int i = 0;
        while (i < m) {
            H[i][0] = 0.0;
            ++i;
        }
        int j = 0;
        while (j < n) {
            H[0][j] = 0.0;
            ++j;
        }
        i = 1;
        while (i < m) {
            int j2 = 1;
            while (j2 < n) {
                double result = 0.0;
                double c1 = H[i - 1][j2 - 1] + s[i][j2];
                if (result < c1) {
                    result = c1;
                }
                double c2 = 0.0;
                int k = 1;
                while (k < i) {
                    double tmp2 = H[i - k][j2] - openCost - extendCost * (double)k;
                    if (c2 < tmp2) {
                        c2 = tmp2;
                    }
                    ++k;
                }
                if (result < c2) {
                    result = c2;
                }
                double c3 = 0.0;
                int l = 1;
                while (l < j2) {
                    double tmp3 = H[i][j2 - l] - openCost - extendCost * (double)l;
                    if (c3 < tmp3) {
                        c3 = tmp3;
                    }
                    ++l;
                }
                if (result < c3) {
                    result = c3;
                }
                H[i][j2] = result;
                ++j2;
            }
            ++i;
        }
        return H;
    }

    static int[][] traceback(double[][] s, double openCost, double extendCost) {
        double[][] H = SmithWaterman.Hij(s, openCost, extendCost);
        int[] start = SmithWaterman.max2(H);
        int i = start[0];
        int j = start[1];
        Vector<Integer> listx = new Vector<Integer>();
        Vector<Integer> listy = new Vector<Integer>();
        int count = 0;
        while (H[i][j] > 0.0) {
            int newi = i - 1;
            int newj = j - 1;
            if (i < 1 || j < 1) break;
            if (H[i - 1][j - 1] + s[i][j] != H[i][j]) {
                double tmp2;
                int k = 1;
                while (k < i) {
                    tmp2 = H[i - k][j] - openCost - extendCost * (double)k;
                    if (tmp2 == H[i][j]) {
                        newi = i - k;
                        newj = j;
                    }
                    ++k;
                }
                int l = 1;
                while (l < i) {
                    tmp2 = H[i][j - l] - openCost - extendCost * (double)l;
                    if (tmp2 == H[i][j]) {
                        newi = i;
                        newj = j - l;
                    }
                    ++l;
                }
            }
            listx.add(new Integer(i));
            listy.add(new Integer(j));
            ++count;
            i = newi;
            j = newj;
        }
        int[][] result = new int[count][2];
        int n = 0;
        while (n < count) {
            result[count - n - 1][0] = (Integer)listx.elementAt(n);
            result[count - n - 1][1] = (Integer)listy.elementAt(n);
            ++n;
        }
        return result;
    }

    public static int[] max2(double[][] mat) {
        int[] result = new int[2];
        double max = 0.0;
        int i = 0;
        while (i < mat.length) {
            int j = 0;
            while (j < mat[i].length) {
                if (max < mat[i][j]) {
                    max = mat[i][j];
                    result[0] = i;
                    result[1] = j;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    SmithWaterman(SmithWaterman mat0) {
        int m = mat0.mat.length;
        this.mat = new double[m][];
        int i = 0;
        while (i < m) {
            int n = mat0.mat[i].length;
            this.mat[i] = new double[n];
            int j = 0;
            while (j < n) {
                this.mat[i][j] = mat0.mat[i][j];
                ++j;
            }
            ++i;
        }
    }

    public static void show(double[][] mat) {
        int matsize = mat.length;
        int i = 0;
        while (i < matsize) {
            int matwidth = mat[i].length;
            int j = 0;
            while (j < matwidth) {
                if (Math.abs(mat[i][j]) > 1.0E-4) {
                    System.out.print(mat[i][j]);
                } else {
                    System.out.print(0.0);
                }
                System.out.print("\t");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public int height() {
        return this.mat.length;
    }

    public int width() {
        return this.mat[0].length;
    }

    public double value(int x, int y) {
        return this.mat[x][y];
    }

    public static String[] name(String line) {
        Vector<String> v = new Vector<String>();
        StringTokenizer ST = new StringTokenizer(line, ",");
        while (ST.hasMoreTokens()) {
            v.addElement(ST.nextToken());
        }
        int size = v.size();
        String[] result = new String[size];
        int j = 0;
        while (j < size) {
            String tmp = ((String)v.elementAt(j)).replace('U', 't');
            result[j] = tmp.toLowerCase();
            ++j;
        }
        return result;
    }

    public static String[][] CSVtoStringMatrix(String[] lines) {
        String[][] data = new String[lines.length][];
        int i = 0;
        while (i < lines.length) {
            Vector<String> v = new Vector<String>();
            StringTokenizer ST = new StringTokenizer(lines[i], ",");
            while (ST.hasMoreTokens()) {
                v.addElement(ST.nextToken());
            }
            int size = v.size();
            data[i] = new String[size];
            int j = 0;
            while (j < size) {
                String a;
                data[i][j] = a = (String)v.elementAt(j + 1);
                ++j;
            }
            ++i;
        }
        return data;
    }
}

