/*
 * Decompiled with CFR 0.152.
 */
package geneWaltz;

import geneWaltz.SmithWaterman;
import geneWaltz.disrand;
import io.fastaFormat;
import io.fileload;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class CodonScore {
    Hashtable table = new Hashtable();

    public static void main4(String[] args) throws FileNotFoundException, IOException {
        String[] data = fileload.loadLine0(args[0]);
        String[] name = CodonScore.RNAcodon(CodonScore.name(data[0]));
        double[][] m = CodonScore.CSVtoDoubleMatrix(data);
        String[][] genome = fastaFormat.translate(fileload.loadLine0(args[1]));
        String[] query = fastaFormat.translate(fileload.loadLine0(args[2]))[1];
        CodonScore codon = new CodonScore(name, m);
        String seq1 = genome[1][0];
        String seq2 = query[0];
        double[][] s = codon.codonScore(seq1, seq2);
        int[][] order = SmithWaterman.traceback(s, 11.0, 1.0);
        System.out.print(order[0][0] * 3);
        System.out.print(",");
        System.out.print(order[0][1] * 3);
        System.out.println();
        StringBuffer s1 = new StringBuffer();
        StringBuffer s2 = new StringBuffer();
        int i = 0;
        while (i < order.length) {
            s1.append(seq1.substring(order[i][0] * 3, order[i][0] * 3 + 3));
            s2.append(seq2.substring(order[i][1] * 3, order[i][1] * 3 + 3));
            ++i;
        }
        String result1 = s1.toString();
        String result2 = s2.toString();
        System.out.print(result1);
        System.out.println();
        System.out.print(result2);
        System.out.println();
        s = codon.codonScore(result1, result2);
        double[][] H = SmithWaterman.Hij(s, 11.0, 1.0);
        System.out.print(seq1.length());
        System.out.print(",");
        System.out.print(seq2.length());
        System.out.print(",");
        System.out.print(CodonScore.max(H));
        System.out.println();
    }

    public String[][] alignment(String seq1, String seq2) {
        String[][] result = new String[2][];
        double[][] s = this.codonScore(seq1, seq2);
        double[][] H = SmithWaterman.Hij(s, 11.0, 1.0);
        return result;
    }

    public static void main3(String[] args) throws FileNotFoundException, IOException {
        String[] data = fileload.loadLine0(args[0]);
        String[] name = CodonScore.RNAcodon(CodonScore.name(data[0]));
        double[][] m = CodonScore.CSVtoDoubleMatrix(data);
        String[] data2 = fileload.loadLine0(args[1]);
        double[][] org = CodonScore.CSVtoDoubleMatrix(data2);
        double[][] pij = CodonScore.pij(org);
        double[] p = CodonScore.p(org);
        CodonScore codon = new CodonScore(name, m);
        int seqLen = 30;
        int n = 0;
        while (n < 10000) {
            String[] tmp = CodonScore.evolCodon(seqLen, p, pij, name);
            String evol1 = tmp[0];
            String evol2 = tmp[1];
            double[][] s = codon.codonScore(evol1, evol2);
            double[][] H = SmithWaterman.Hij(s, 11.0, 1.0);
            double evolMax = CodonScore.max(H);
            String codon1 = CodonScore.randomCodon(seqLen, p, name);
            String codon2 = CodonScore.randomCodon(seqLen, p, name);
            s = codon.codonScore(codon1, codon2);
            H = SmithWaterman.Hij(s, 11.0, 1.0);
            double codonMax = CodonScore.max(H);
            String rand1 = CodonScore.randomDNA(seqLen, 0.25, 0.25, 0.25, 0.25);
            String rand2 = CodonScore.randomDNA(seqLen, 0.25, 0.25, 0.25, 0.25);
            s = codon.codonScore(rand1, rand2);
            H = SmithWaterman.Hij(s, 11.0, 1.0);
            double randMax = CodonScore.max(H);
            System.out.print(randMax);
            System.out.print(" ");
            System.out.print(codonMax);
            System.out.print(" ");
            System.out.print(evolMax);
            System.out.println();
            ++n;
        }
    }

    static String randomCodon(int len, double[] p, String[] codon) {
        StringBuffer result = new StringBuffer();
        int numberOfCodon = len / 3;
        int i = 0;
        while (i < numberOfCodon) {
            result.append(codon[disrand.value(p)]);
            ++i;
        }
        return result.toString();
    }

    static String[] RNAcodon(String[] DNAcodon) {
        String[] result = new String[DNAcodon.length];
        int i = 0;
        while (i < DNAcodon.length) {
            String tmp = DNAcodon[i].replace('U', 't');
            result[i] = tmp.toLowerCase();
            ++i;
        }
        return result;
    }

    static String[] evolCodon(int len, double[] p, double[][] pij, String[] codon) {
        StringBuffer result1 = new StringBuffer();
        StringBuffer result2 = new StringBuffer();
        int numberOfCodon = len / 3;
        int i = 0;
        while (i < numberOfCodon) {
            double[] p1 = pij[disrand.value(p)];
            result1.append(codon[disrand.value(p1)]);
            result2.append(codon[disrand.value(p1)]);
            ++i;
        }
        String[] result = new String[]{result1.toString(), result2.toString()};
        return result;
    }

    public static void main2(String[] args) throws FileNotFoundException, IOException {
        String[] data = fileload.loadLine0(args[0]);
        String[] name = CodonScore.name(data[0]);
        double[][] m = CodonScore.CSVtoDoubleMatrix(data);
        CodonScore codon = new CodonScore(name, m);
        System.out.println();
        String[] data2 = fileload.loadLine0(args[1]);
        double[][] org = CodonScore.CSVtoDoubleMatrix(data2);
        double[][] pij = CodonScore.pij(org);
        double[] p = CodonScore.p(org);
        double[][] s = CodonScore.score(pij, p);
        double[][] expMat = CodonScore.expectMat(p);
        double[][] test = new double[m.length][m.length];
        double lambda = new Double(args[2]);
        double Ent = 0.0;
        double sum = 0.0;
        int i = 0;
        while (i < m.length) {
            int j = 0;
            while (j < m.length) {
                double tmp = m[i][j] * p[i] * p[j];
                if (!Double.isNaN(tmp)) {
                    sum += tmp;
                    test[i][j] = tmp;
                }
                ++j;
            }
            ++i;
        }
        System.out.println(sum);
    }

    static double[][] expectMat(double[] p) {
        int size = p.length;
        double[][] result = new double[size][size];
        int i = 0;
        while (i < size) {
            int j = 0;
            while (j < size) {
                result[i][j] = p[i] * p[j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    static double lambda(double[][] score, double[][] pij, double[] p) {
        return 1.0;
    }

    static double[][] score(double[][] pij, double[] p) {
        int j;
        int size = pij.length;
        double[][] result = new double[size][size];
        double min = 0.0;
        int i = 0;
        while (i < size) {
            j = 0;
            while (j <= i) {
                double d = -Math.log(pij[i][j] / p[i] / p[j]);
                result[j][i] = d;
                result[i][j] = d;
                if (min > result[i][j]) {
                    min = result[i][j];
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            j = 0;
            while (j <= i) {
                if (Double.isNaN(result[i][j]) || Double.isInfinite(result[i][j])) {
                    double d = min;
                    result[j][i] = d;
                    result[i][j] = d;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    static double[] p(double[][] count) {
        int size = count.length;
        double[] tmp = new double[size];
        int i = 0;
        while (i < size) {
            tmp[i] = 0.0;
            int j = 0;
            while (j < size) {
                int n = i;
                tmp[n] = tmp[n] + count[i][j];
                ++j;
            }
            ++i;
        }
        double total = 0.0;
        int i2 = 0;
        while (i2 < size) {
            total += tmp[i2];
            ++i2;
        }
        double[] result = new double[size];
        int i3 = 0;
        while (i3 < size) {
            result[i3] = tmp[i3] / total;
            ++i3;
        }
        return result;
    }

    static double[][] pij(double[][] count) {
        double total = 0.0;
        int size = count.length;
        int i = 0;
        while (i < size) {
            int j = 0;
            while (j < size) {
                total += count[i][j];
                ++j;
            }
            ++i;
        }
        double[][] result = new double[size][];
        int i2 = 0;
        while (i2 < size) {
            result[i2] = new double[size];
            int j = 0;
            while (j < i2) {
                double d = (count[i2][j] + count[j][i2]) / total;
                result[j][i2] = d;
                result[i2][j] = d;
                ++j;
            }
            result[i2][i2] = count[i2][i2] / total;
            ++i2;
        }
        return result;
    }

    public static void mainOld(String[] args) throws FileNotFoundException, IOException {
        String[] data = fileload.loadLine0(args[0]);
        String[] name = CodonScore.name(data[0]);
        double[][] m = CodonScore.CSVtoDoubleMatrix(data);
        CodonScore codon = new CodonScore(name, m);
        int n = 0;
        while (n < 10000) {
            String seq1 = CodonScore.randomDNA(100, 0.25, 0.25, 0.25, 0.25);
            String seq2 = CodonScore.randomDNA(1000, 0.25, 0.25, 0.25, 0.25);
            double[][] s = codon.codonScore(seq1, seq2);
            double[][] H = SmithWaterman.Hij(s, 11.0, 1.0);
            System.out.println(CodonScore.max(H));
            ++n;
        }
    }

    public double[][] codonScore(String seq1, String seq2) {
        int m = seq1.length() / 3;
        int n = seq2.length() / 3;
        double[][] result = new double[m][n];
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                String c1 = seq1.substring(i * 3, i * 3 + 3);
                String c2 = seq2.substring(j * 3, j * 3 + 3);
                result[i][j] = this.score(c1, c2);
                ++j;
            }
            ++i;
        }
        return result;
    }

    static String randomDNA(int len, double Ucont, double Ccont, double Acont, double Gcont) {
        StringBuffer result = new StringBuffer();
        double total = Ucont + Ccont + Acont + Gcont;
        int i = 0;
        while (i < len) {
            double x = Math.random() * total;
            if (x < Ucont) {
                result.append("t");
            }
            if (Ucont < x && x < Ucont + Ccont) {
                result.append("c");
            }
            if (Ucont + Ccont < x && x < Ucont + Ccont + Acont) {
                result.append("a");
            }
            if (Ucont + Ccont + Acont < x) {
                result.append("g");
            }
            ++i;
        }
        return result.toString();
    }

    public static double max(double[][] mat) {
        double max = 0.0;
        int i = 0;
        while (i < mat.length) {
            int j = 0;
            while (j < mat[i].length) {
                if (max < mat[i][j]) {
                    max = mat[i][j];
                }
                ++j;
            }
            ++i;
        }
        return max;
    }

    public static int[] max2(double[][] mat) {
        int[] result = new int[2];
        double max = 0.0;
        int i = 0;
        while (i < mat.length) {
            int j = 0;
            while (j < mat[i].length) {
                if (max < mat[i][j]) {
                    max = mat[i][j];
                    result[0] = i;
                    result[1] = j;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static void show(double[][] mat) {
        int matsize = mat.length;
        int i = 0;
        while (i < matsize) {
            int matwidth = mat[i].length;
            int j = 0;
            while (j < matwidth) {
                if (Math.abs(mat[i][j]) > 1.0E-4) {
                    System.out.print(mat[i][j]);
                } else {
                    System.out.print(0.0);
                }
                System.out.print("\t");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public static void test(String[] args) throws FileNotFoundException, IOException {
        String[] data = fileload.loadLine0(args[0]);
        String[] name = CodonScore.name(data[0]);
        double[][] m = CodonScore.CSVtoDoubleMatrix(data);
        CodonScore codon = new CodonScore(name, m);
        String[] order0 = new String[]{"t", "c", "a", "g"};
        int c = 0;
        String[] order = new String[64];
        int p = 0;
        while (p < order0.length) {
            int q = 0;
            while (q < order0.length) {
                int r = 0;
                while (r < order0.length) {
                    order[c] = String.valueOf(order0[p]) + order0[q] + order0[r];
                    ++c;
                    ++r;
                }
                ++q;
            }
            ++p;
        }
        int i = 0;
        while (i < 64) {
            System.out.print(order[i]);
            System.out.print("\t");
            int j = 0;
            while (j < 64) {
                System.out.print(codon.score(order[i], order[j]));
                System.out.print("\t");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public CodonScore(String[] codonList, double[][] mat) {
        int i = 0;
        while (i < codonList.length) {
            int j = 0;
            while (j < codonList.length) {
                String tmp = (String.valueOf(codonList[i]) + "," + codonList[j]).replace('U', 't');
                String tag = tmp.toUpperCase();
                this.table.put(tag, new Double(mat[i][j]));
                ++j;
            }
            ++i;
        }
    }

    public double score(String codon1, String codon2) {
        String tag = String.valueOf(codon1) + "," + codon2;
        try {
            return (Double)this.table.get(tag);
        }
        catch (NullPointerException e) {
            return -8.0;
        }
    }

    public static double[][] CSVtoDoubleMatrix(String[] lines) {
        String[][] org = CodonScore.CSVtoStringMatrix(lines);
        double[][] data = new double[lines.length - 1][];
        int i = 0;
        while (i < lines.length - 1) {
            int size = org[i + 1].length;
            data[i] = new double[size - 1];
            int j = 0;
            while (j < size - 1) {
                String a = org[i + 1][j + 1];
                double d = Double.NaN;
                try {
                    d = new Double(a);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                data[i][j] = d;
                ++j;
            }
            ++i;
        }
        return data;
    }

    public static String[][] CSVtoStringMatrix(String[] lines) {
        String[][] data = new String[lines.length][];
        int i = 0;
        while (i < lines.length) {
            Vector<String> v = new Vector<String>();
            StringTokenizer ST = new StringTokenizer(lines[i], ",");
            while (ST.hasMoreTokens()) {
                v.addElement(ST.nextToken());
            }
            int size = v.size();
            data[i] = new String[size];
            int j = 0;
            while (j < size) {
                String a;
                data[i][j] = a = (String)v.elementAt(j);
                ++j;
            }
            ++i;
        }
        return data;
    }

    public static String[] name(String line) {
        Vector<String> v = new Vector<String>();
        StringTokenizer ST = new StringTokenizer(line, ",");
        while (ST.hasMoreTokens()) {
            v.addElement(ST.nextToken());
        }
        int size = v.size();
        String[] result = new String[size];
        int j = 0;
        while (j < size) {
            result[j] = (String)v.elementAt(j);
            ++j;
        }
        return result;
    }
}

