<?php
/* Reminder: always indent with 4 spaces (no tabs). */
// +---------------------------------------------------------------------------+
// | Geeklog Forums Plugin 2.0 for Geeklog - The Ultimate Weblog               |
// | Official release date: Feb 7,2003                                         |
// +---------------------------------------------------------------------------+
// | english_utf-8.php                                                         |
// | Language defines for all text                                             |
// +---------------------------------------------------------------------------+
// | Copyright (C) 2000,2001 by the following authors:                         |
// | Geeklog Author: Tony Bibbs       - tony@tonybibbs.com                     |
// +---------------------------------------------------------------------------+
// | FORUM Plugin Authors                                                      |
// | Prototype & Concept    :  Mr.GxBlock of www.gxblock.com                   |
// | Co-Developed by Matthew and Blaine                                        |
// | Matthew DeWyer, contact: matt@mycws.com          www.cweb.ws              |
// | Blaine Lang,    contact: geeklog@langfamily.ca   www.langfamily.ca        |
// +---------------------------------------------------------------------------+
// |                                                                           |
// | This program is free software; you can redistribute it and/or             |
// | modify it under the terms of the GNU General Public License               |
// | as published by the Free Software Foundation; either version 2            |
// | of the License, or (at your option) any later version.                    |
// |                                                                           |
// | This program is distributed in the hope that it will be useful,           |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of            |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
// | GNU General Public License for more details.                              |
// |                                                                           |
// | You should have received a copy of the GNU General Public License         |
// | along with this program; if not, write to the Free Software Foundation,   |
// | Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.           |
// |                                                                           |
// +---------------------------------------------------------------------------+
//

if (!defined('XHTML')) {
    define('XHTML', '');
}

$LANG_GF00 = array (
    'admin_only'        => 'Sorry Admins Only. If you are an Admin please login first.',
    'plugin'            => 'Plugin',
    'pluginlabel'       => 'Forum',         // What shows up in the siteHeader
    'searchlabel'       => 'Forum',
    'statslabel'        => 'Total Forum Posts',
    'statsheading1'     => 'Forum Top 10 Viewed Topics',
    'statsheading2'     => 'Forum Top 10 Replied Topics',
    'statsheading3'     => 'No topics to report on',
    'searchresults'     => 'Forum Search Results %s',
    'useradminmenu'     => 'Forum Features',
    'useradmintitle'    => 'Forum User Preferences',
    'access_denied'     => 'Access Denied',
    'access_denied_msg' => 'Only Root Users have Access to this Page.  Your user name and IP have been recorded.',
    'admin'             => 'Plugin Admin',
    'install_header'    => 'Install/Uninstall Plugin',
    'installed'         => 'The Plugin and Block are now installed,<p><i>Enjoy,<br' . XHTML . '><a href="MAILTO:langmail@sympatico.ca">Blaine</a></i>',
    'uninstalled'       => 'The Plugin is Not Installed',
    'install_success'   => 'Installation Successful<p><b>Next Steps</b>: 
        <ol><li>Use the Forum Admin to configure your new forum
        <li>Review Forum Settings and personalize
        <li>Create at least one Forum and one Category</ol>
        <p>Review the <a href="%s">Install Notes</a> for more information.',
        
    'install_failed'    => 'Installation Failed -- See your error log to find out why.',
    'uninstall_msg'     => 'Plugin Successfully Uninstalled',
    'install'           => 'Install',
    'uninstall'         => 'UnInstall',
    'enabled'           => '<br' . XHTML . '>Plugin is installed and enabled.<br' . XHTML . '>Disable first if you want to De-Install it.<p>',
    'warning'           => 'Forum De-Install Warning',
    'uploaderr'         => 'File Upload Error'
);


$PLG_forum_MESSAGE1 = 'Forum Plugin Upgrade: Update completed successfully.';
$PLG_forum_MESSAGE2 = 'Forum Plugin upgrade: We are unable to update this version automatically. Refer to the plugin documentation.';

$LANG_GF01['LOGIN']          = 'Login';
$LANG_GF01['FORUM']          = 'Forum';
$LANG_GF01['ALL']            = 'All'; 
$LANG_GF01['YES']            = 'Yes';
$LANG_GF01['NO']             = 'No';
$LANG_GF01['NEW']            = 'New';
$LANG_GF01['PREV']           = 'Prev';
$LANG_GF01['NEXT']           = 'Next';
$LANG_GF01['ERROR']          = 'Error!';
$LANG_GF01['CONFIRM']        = 'Confirm';
$LANG_GF01['UPDATE']         = 'Update';
$LANG_GF01['SAVE']           = 'Save';
$LANG_GF01['CANCEL']         = 'Cancel';
$LANG_GF01['CLOSE']          = 'Close';
$LANG_GF01['ON']             = 'On: ';
$LANG_GF01['ON2']            = '&nbsp;&nbsp;<b>On: </b>';
$LANG_GF01['IN']             = 'In: ';
$LANG_GF01['BY']             = 'By: ';
$LANG_GF01['RE']             = 'Re: ';
$LANG_GF01['NA']             = 'N/A';
$LANG_GF01['DATE']           = 'Date';
$LANG_GF01['VIEWS']          = 'Views';
$LANG_GF01['REPLIES']        = 'Replies';
$LANG_GF01['NAME']           = 'Name:';
$LANG_GF01['DESCRIPTION']    = 'Description: ';
$LANG_GF01['TOPIC']          = 'Topic';
$LANG_GF01['TOPICS']         = 'Topics:';
$LANG_GF01['TOPICSUBJECT']   = 'Topic Subject';
$LANG_GF01['FROM']           = 'From';
$LANG_GF01['REPLY']          = 'Reply';
$LANG_GF01['PM']             = 'PM';
$LANG_GF01['HOME']           = 'View Forums';
$LANG_GF01['HOMEPAGE']       = 'Home';
$LANG_GF01['SUBJECT']        = 'Subject';
$LANG_GF01['HELLO']          = 'Hello ';
$LANG_GF01['MEMBERS']        = 'Members';
$LANG_GF01['MOVED']          = 'Moved';
$LANG_GF01['REMOVE']         = 'Remove';
$LANG_GF01['CURRENT']        = 'Current';
$LANG_GF01['STARTEDBY']      = 'Started by';
$LANG_GF01['POSTS']          = 'Posts';
$LANG_GF01['LASTPOST']       = 'Last Post';
$LANG_GF01['POSTEDON']       = 'Posted on';
$LANG_GF01['POSTEDBY']       = 'Posted By';
$LANG_GF01['PAGE']           = 'Page';
$LANG_GF01['PAGES']          = 'Pages';
$LANG_GF01['ANONYMOUS']      = 'Anonymous:';
$LANG_GF01['TODAY']          = 'Today at ';
$LANG_GF01['WELCOME']        = 'Welcome ';
$LANG_GF01['REGISTER']       = 'Register';
$LANG_GF01['REGISTERED']     = 'Registered';
$LANG_GF01['MOSTPOPULAR']    = 'Most Popular';
$LANG_GF01['ORDERBY']        = 'Order:&nbsp;';
$LANG_GF01['ORDER']          = 'Order:';
$LANG_GF01['USER']           = 'User';
$LANG_GF01['GROUP']          = 'Group';
$LANG_GF01['ANON']           = 'Anonymous: ';
$LANG_GF01['ADMIN']          = 'Admin';
$LANG_GF01['AUTHOR']         = 'Author';
$LANG_GF01['LOCATION']       = 'Location';
$LANG_GF01['WEBSITE']        = 'Website';
$LANG_GF01['EMAIL']          = 'Email';
$LANG_GF01['MOOD']           = 'Mood';
$LANG_GF01['NOMOOD']         = 'No Mood';
$LANG_GF01['REQUIRED']       = '[Required]';
$LANG_GF01['OPTIONAL']       = '[Optional]';
$LANG_GF01['SUBMIT']         = 'Submit';
$LANG_GF01['PREVIEW']        = 'Preview';
$LANG_GF01['NOTIFY']         = 'Notify:';
$LANG_GF01['REMOVE']         = 'Remove';
$LANG_GF01['KEYWORDS']       = 'Keywords';
$LANG_GF01['EDIT']           = 'Edit';
$LANG_GF01['DELETE']         = 'Delete';
$LANG_GF01['MESSAGE']        = 'Message:';
$LANG_GF01['OPTIONS']        = 'Options:';
$LANG_GF01['MISSINGSUBJECT'] = 'Subject empty';
$LANG_GF01['MAY']            = 'may';
$LANG_GF01['IS']             = 'is';
$LANG_GF01['FOR']            = 'for';
$LANG_GF01['ARE']            = 'are';
$LANG_GF01['NOT']            = 'not';
$LANG_GF01['YOU']            = 'You';
$LANG_GF01['HTML']           = 'HTML';
$LANG_GF01['FULLHTML']       = 'Full HTML';
$LANG_GF01['WORDS']          = 'Words';
$LANG_GF01['SMILIES']        = 'Smilies';
$LANG_GF01['MIGRATE_NOW']    = 'Migrate Now'; 
$LANG_GF01['FILTERLIST']     = 'Filter List';
$LANG_GF01['SELECTFORUM']    = 'Select Forum';
$LANG_GF01['DELETEAFTER']    = 'Delete after';
$LANG_GF01['TITLE']          = 'Title';
$LANG_GF01['COMMENTS']       = 'Comments'; 
$LANG_GF01['SUBMISSIONS']    = 'Submissions';

$LANG_GF01['HTML_FILTER_MSG']  = 'Filtered HTML Allowed';
$LANG_GF01['HTML_FULL_MSG']  = 'Full HTML Allowed';
$LANG_GF01['HTML_MSG']       = 'HTML Allowed';
$LANG_GF01['CENSOR_PERM_MSG']  = 'Censored Content';
$LANG_GF01['ANON_PERM_MSG']    = 'View Anonymous Posts';
$LANG_GF01['POST_PERM_MSG1']    = 'Able to post';
$LANG_GF01['POST_PERM_MSG2']    = 'Anonymous users can post';
$LANG_GF01['CENSORED']       = 'censored';
$LANG_GF01['ALLOWED']        = 'allowed';
$LANG_GF01['GO']             = 'GO';
$LANG_GF01['STATUS']         = 'Status:';
$LANG_GF01['ONLINE']         = 'online';
$LANG_GF01['OFFLINE']        = 'offline';
$LANG_GF01['back2parent']    = 'Parent Topic';
$LANG_GF01['forumname']      = '';   // Enter name here if you want it to show in the footer of the admin screens
$LANG_GF01['category']       = 'Category: ';
$LANG_GF01['loginreqview']   = '<b>Sorry you must %s register</a> or %s login </a> to use these forums</b>';
$LANG_GF01['loginreqpost']   = '<b>Sorry you must register or login to post on these forums</b>';
$LANG_GF01['searchresults']  = '<b></b> Your search for <b>%s</b> %s author returned <b>%s</b> results:</b><br' . XHTML . '><br' . XHTML . '>';
$LANG_GF01['feature_not_on'] = 'Feature not enabled';
$LANG_GF01['nolastpostmsg']  = 'N/A';
$LANG_GF01['no_one']         = 'No one.';
$LANG_GF01['popular']        = 'Popular';
$LANG_GF01['notify']         = 'Notifications';
$LANG_GF01['PM']             = 'PM\'s';
$LANG_GF01['NEW_PM']         = 'New PM';
$LANG_GF01['DELALL_PM']      = 'Delete All';
$LANG_GF01['DELOLDER_PM']    = 'Delete older';
$LANG_GF01['members']        = 'Members';
$LANG_GF01['save_sucess']    = 'Save Sucessful';
$LANG_GF01['trademark']      = '<br' . XHTML . '><center><b>Geeklog Forum Project version 2.0</b> &copy; 2002</b></center>';
$LANG_GF01['back2top']       = 'Back to top';
$LANG_GF01['POSTMODE']       = 'Post Mode:';
$LANG_GF01['TEXTMODE']       = 'Text Mode:';
$LANG_GF01['HTMLMODE']       = 'HTML Mode:';
$LANG_GF01['TopicPreview']   = 'Topic post preview';
$LANG_GF01['moderator']      = 'Moderator';
$LANG_GF01['admin']          = 'Admin';
$LANG_GF01['DATEADDED']      = 'Date Added';
$LANG_GF01['PREVTOPIC']      = 'Prev Topic';
$LANG_GF01['NEXTTOPIC']      = 'Next Topic';
$LANG_GF01['CONTENT']        = 'Content';
$LANG_GF01['QUOTE_begin']    = '[Quote&nbsp;';
$LANG_GF01['QUOTE_by'   ]    = 'by:&nbsp;';
$LANG_GF01['RESYNC']         = "ReSync";
$LANG_GF01['RESYNCCAT']      = "ReSync Category Forums";  
$LANG_GF01['PROFILE']        = "Profile";
$LANG_GF01['DELETECONFIRM']  = "Are you sure you want to DELETE this record?";
$LANG_GF01['website']        = 'Website';
$LANG_GF01['EDITICON']       = 'Edit';
$LANG_GF01['QUOTEICON']      = 'Quote';
$LANG_GF01['ProfileLink']    = 'Profile';
$LANG_GF01['WebsiteLink']    = 'Website';
$LANG_GF01['PMLink']         = 'PM';
$LANG_GF01['EmailLink']      = 'Email';
$LANG_GF01['FORUMSUBSCRIBE'] = 'Subscribe to this forum';
$LANG_GF01['FORUMUNSUBSCRIBE'] = 'Un-Subscribe to this forum';
$LANG_GF01['NEWTOPIC']       = 'New Topic';
$LANG_GF01['POSTREPLY']      = 'Post Reply';
$LANG_GF01['SubscribeLink']  = 'Subscribe';
$LANG_GF01['unSubscribeLink'] = 'Un-Subscribe';
$LANG_GF01['FORUMSUBSCRIBE'] = 'Track this forum';
$LANG_GF01['NEWTOPIC']       = 'New Topic';
$LANG_GF01['POSTREPLY']      = 'Post Reply';
$LANG_GF01['SUBSCRIPTIONS']  = 'Subscriptions';
$LANG_GF01['TOP']            = 'Top of Post';
$LANG_GF01['PRINTABLE']      = 'Printable Version';
$LANG_GF01['ForumProfile']   = 'Forum Options';
$LANG_GF01['USERPREFS']      = 'User Preferences';
$LANG_GF01['SPEEDLIMIT']     = '"Your last comment was %s seconds ago.<br' . XHTML . '>This site requires at least %s seconds between forum posts."';
$LANG_GF01['ACCESSERROR']    = 'ACCESS ERROR';
$LANG_GF01['LEGEND']         = 'Legend';
$LANG_GF01['ACTIONS']        = 'Actions';
$LANG_GF01['DELETEALL']      = 'Delete all selected records';
$LANG_GF01['DELCONFIRM']     = 'Are you sure you want to Delete selected records?';
$LANG_GF01['DELALLCONFIRM']  = 'Are you sure you want to Delete ALL selected records?';
$LANG_GF01['STARTEDBY']      = 'Started by:';
$LANG_GF01['WARNING']        = 'Warning';
$LANG_GF01['MODERATED']      = 'Moderators: %s';
$LANG_GF01['NOTIFYNOT']      = 'NOT!';
$LANG_GF01['LASTREPLYBY']    = 'Last reply by:&nbsp;%s';
$LANG_GF01['UID']            = 'UID';
$LANG_GF01['ANON_POST_BEGIN'] = 'Anonymous messages';
$LANG_GF01['ANON_POST_END']   = 'viewable';
$LANG_GF01['INDEXPAGE']      = 'Forum Index';
$LANG_GF01['FEATURE']        = 'Feature';
$LANG_GF01['SETTING']        = 'Setting';
$LANG_GF01['MARKALLREAD']    = 'Mark All Read';

// Language for bbcode toolbar
$LANG_GF01['CODE']           = 'Code';
$LANG_GF01['FONTCOLOR']      = 'Font Color';
$LANG_GF01['FONTSIZE']       = 'Font Size';
$LANG_GF01['CLOSETAGS']      = 'Close Tags';
$LANG_GF01['CODETIP']        = 'Tip: Styles can be applied quickly to selected text';
$LANG_GF01['TINY']           = 'Tiny';
$LANG_GF01['SMALL']          = 'Small';
$LANG_GF01['NORMAL']         = 'Normal';
$LANG_GF01['LARGE']          = 'Large';
$LANG_GF01['HUGE']           = 'Huge';
$LANG_GF01['DEFAULT']        = 'Default';
$LANG_GF01['DKRED']          = 'Dark Red';
$LANG_GF01['RED']            = 'Red';
$LANG_GF01['ORANGE']         = 'Orange';
$LANG_GF01['BROWN']          = 'Brown';
$LANG_GF01['YELLOW']         = 'Yellow';
$LANG_GF01['GREEN']          = 'Green';
$LANG_GF01['OLIVE']          = 'Olive';
$LANG_GF01['CYAN']           = 'Cyan';
$LANG_GF01['BLUE']           = 'Blue';
$LANG_GF01['DKBLUE']         = 'Dark Blue';
$LANG_GF01['INDIGO']         = 'Indigo';
$LANG_GF01['VIOLET']         = 'Violet';
$LANG_GF01['WHITE']          = 'White';
$LANG_GF01['BLACK']          = 'Black';

$LANG_GF01['b_help']         = "Bold text: [b]text[/b]";
$LANG_GF01['i_help']         = "Italic text: [i]text[/i]";
$LANG_GF01['u_help']         = "Underline text: [u]text[/u]";
$LANG_GF01['q_help']         = "Quote text: [quote]text[/quote]";
$LANG_GF01['c_help']         = "Code display: [code]code[/code]";
$LANG_GF01['l_help']         = "List: [list]text[/list]";
$LANG_GF01['o_help']         = "Ordered list: [olist]text[/olist]";
$LANG_GF01['p_help']         = "[img]http://image_url[/img]  or [img w=100 h=200][/img]";
$LANG_GF01['w_help']         = "Insert URL: [url]http://url[/url] or [url=http://url]URL text[/url]";
$LANG_GF01['a_help']         = "Close all open bbCode tags";
$LANG_GF01['s_help']         = "Font color: [color=red]text[/color]  Tip: you can also use color=#FF0000";
$LANG_GF01['f_help']         = "Font size: [size=x-small]small text[/size]";
$LANG_GF01['h_help']         = "Click to view more detailed help";


$LANG_GF02['msg01']    = 'Sorry you must register to use these forums';
$LANG_GF02['msg02']    = 'You should not be here!<br' . XHTML . '>Restricted access to this forum only';
$LANG_GF02['msg03']    = '';
$LANG_GF02['msg04']    = '';
$LANG_GF02['msg05']    = '<center><em>Sorry, no topics have been created yet.</em></center>';
$LANG_GF02['msg06']    = ' new posts since your last visit';
$LANG_GF02['msg07']    = 'Online Users:';
$LANG_GF02['msg08']    = '<br' . XHTML . '><b>Total Registered Users to Date:</b> %s';
$LANG_GF02['msg09']    = '<br' . XHTML . '><b>Total Posts to Date:</b> %s <br' . XHTML . '>';
$LANG_GF02['msg10']    = '<b>Total Topics to Date:</b> %s <br' . XHTML . '>';
$LANG_GF02['msg11']    = 'Back to Forum Index';
$LANG_GF02['msg12']    = 'Back to Main Homepage';
$LANG_GF02['msg13']    = 'Registration Required, you currently must register or login to use this feature.';
$LANG_GF02['msg14']    = 'Sorry, You have been banned from making entries.<br' . XHTML . '>';
$LANG_GF02['msg15']    = 'If you feel this is an error, contact <a href="mailto:%s?subject=Forum IP Ban">Site Admin</a>.';
$LANG_GF02['msg16']    = 'These are the most popular posts, you may order them by views or replies.';
$LANG_GF02['msg17']    = 'Message Edited, Your message has been edited sucessfully. Returning to your message.';
$LANG_GF02['msg18']    = 'Error! Not all required fields were completed or were too short in length.';
$LANG_GF02['msg19']    = 'Your message has been posted.';
$LANG_GF02['msg20']    = 'Reply Added, Your reply has been posted. Returning to Forum';
$LANG_GF02['msg21']    = 'Sorry, you are unauthorized to do this. Please <a href="javascript:history.back()">Go Back</a> or <a href="%s/users.php?mode=login">Login</a><br' . XHTML . '><br' . XHTML . '>'; 
$LANG_GF02['msg22']    = '- Forum Post Notification';
$LANG_GF02['msg23a']   = "A reply has been made to the thread '%s' by %s.\n\nThis topic was started by %s in the %s forum. ";
$LANG_GF02['msg23b']   = "A new topic '%s' has been posted by %s in the %s forum on the %s website. You may view it at:\n%s/forum/viewtopic.php?showtopic=%s\n";
$LANG_GF02['msg23c']   = "You may view it at:\n%s/forum/viewtopic.php?showtopic=%s&amp;lastpost=true\n";
$LANG_GF02['msg24']    = 'You may see the thread and reply at: %s/forum/viewtopic.php?forum=%s&showtopic=%s';
$LANG_GF02['msg25']    = "\nHave a great day! \n";
$LANG_GF02['msg26']    = "\nYou are receiving this email because you have chosen to be notified when a reply has been made to this topic. ";
$LANG_GF02['msg27']    = "To stop receiving notifications on this topic go to <%s> to remove it.\n";
$LANG_GF02['msg28']    = 'Error, No subject for this post';
$LANG_GF02['msg29']    = 'Your signature will be placed here.';
$LANG_GF02['msg30']    = 'Back to top';
$LANG_GF02['msg31']    = '<b>You can still edit it here:</b>';
$LANG_GF02['msg32']    = '<b>Edit Message</b>';
$LANG_GF02['msg33']    = 'Author: ';
$LANG_GF02['msg34']    = 'Email:';
$LANG_GF02['msg35']    = 'Website:';
$LANG_GF02['msg36']    = 'Mood:';
$LANG_GF02['msg37']    = 'Message:';
$LANG_GF02['msg38']    = 'Notify me of replies ';
$LANG_GF02['msg39']    = '<br' . XHTML . '>There are no topic reviews for this new topic.';
$LANG_GF02['msg40']    = '<br' . XHTML . '>Sorry, but you have already asked to be notified of replies to this topic.<br' . XHTML . '><br' . XHTML . '>';
$LANG_GF02['msg41']    = '<br' . XHTML . '>Thank you! You will now be notified of replies to topic %s .<br' . XHTML . '><br' . XHTML . '>';
$LANG_GF02['msg42']    = 'Thank you! You have now deleted notifications on this topic.';
$LANG_GF02['msg43']    = 'Are you sure you want to delete this notification?.';
$LANG_GF02['msg44']    = '<p style="margin:0px; padding:5px;">You have no notifications currently.</p>';
$LANG_GF02['msg45']    = 'Search the Forum';
$LANG_GF02['msg46']    = 'You can search the forum by entering keywords:';
$LANG_GF02['msg47']    = 'You can also specify an author to search under:';
$LANG_GF02['msg48']    = '<br' . XHTML . '>The Chatterblock Plugin needs to be installed first.';
$LANG_GF02['msg49']    = '(Read %s times) ';
$LANG_GF02['msg50']    = 'Signature n/a';
$LANG_GF02['msg51']    = "%s\n\n<br" . XHTML . ">[Edited at %s by %s]";
$LANG_GF02['msg52']    = 'Confirmed:';
$LANG_GF02['msg53']    = 'Returning to topic..';
$LANG_GF02['msg54']    = 'Post Edited.';
$LANG_GF02['msg55']    = 'Post Deleted.';
$LANG_GF02['msg56']    = 'IP Banned.';
$LANG_GF02['msg57']    = 'Topic Made Sticky.';
$LANG_GF02['msg58']    = 'Topic Un-Stuck.';
$LANG_GF02['msg59']    = 'Normal Topic';
$LANG_GF02['msg60']    = 'New Post';
$LANG_GF02['msg61']    = 'Sticky Topic';
$LANG_GF02['msg62']    = 'Notify me of replies';
$LANG_GF02['msg63']    = 'Profile';
$LANG_GF02['msg64']    = 'Are you sure you want to delete topic %s titled: %s ?';
$LANG_GF02['msg65']    = '<br' . XHTML . '>This is a parent topic, so all replies posted to it will also be deleted.';
$LANG_GF02['msg66']    = 'Confirm Delete Post';
$LANG_GF02['msg67']    = 'Edit Forum Post';
$LANG_GF02['msg68']    = 'Note: BE CAREFUL WHEN YOU BAN, only admins have the rights to unban someone.';
$LANG_GF02['msg69']    = 'Do you really want to ban the ip address: %s?';
$LANG_GF02['msg70']    = 'Confirm Ban';
$LANG_GF02['msg71']    = 'No function selected, choose a post and then a moderator function.<br' . XHTML . '>Note: You must be a moderator to perform these functions.';
$LANG_GF02['msg72']    = 'Warning, you do not have rights to perform this moderation function.';
$LANG_GF02['msg74']    = 'Latest %s Forum Posts';
$LANG_GF02['msg75']    = 'Top %s Topics By Views';
$LANG_GF02['msg76']    = 'Top %s Topics By Posts';
$LANG_GF02['msg77']    = '<br' . XHTML . '><p style="padding-left:10px;">You should not be here!<br' . XHTML . '>Restricted access to this forum only.</p>';
$LANG_GF02['msg78']    = '<br' . XHTML . '>You should not be here!<br' . XHTML . '>Invalid Forum.';
$LANG_GF02['msg81']    = '- Topic Edit Notification';
$LANG_GF02['msg82']    = '<p>Your message "%s" has been edited by the moderator %s.</p>';
$LANG_GF02['msg83']    = '<br' . XHTML . '><br' . XHTML . '><p>You need to be signed in to use this forum feature.</p>';
$LANG_GF02['msg84']    = 'Mark all topics read';
$LANG_GF02['msg85']    = 'Page:';
$LANG_GF02['msg86']    = '&nbsp;Last %s posts&nbsp;';
$LANG_GF02['msg87']    = '<br' . XHTML . '>Warning: This topic has been locked by the moderator.<br' . XHTML . '>No additional posts are permitted';
$LANG_GF02['msg88']    = 'Site Members';
$LANG_GF02['msg88b']   = 'Forum Activity Only';
$LANG_GF02['msg89']    = 'My Enabled Notifications';
$LANG_GF02['msg100']   = 'Information:';
$LANG_GF02['msg101']   = 'Forum Rules:';
$LANG_GF02['msg102']   = 'Topic Legend:';
$LANG_GF02['msg103']   = 'Forum Jump:';
$LANG_GF02['msg104']   = 'post messages';
$LANG_GF02['msg105']   = 'edit your posts';
$LANG_GF02['msg106']   = 'Select a Forum';
$LANG_GF02['msg107']   = 'Forum Legend:';
$LANG_GF02['msg108']   = 'Active Forum';
$LANG_GF02['msg109']   = 'Locked Topic';
$LANG_GF02['msg110']   = 'Transferring to message edit page..';
$LANG_GF02['msg111']   = 'New posts since your last visit';
$LANG_GF02['msg112']   = 'View all new posts';
$LANG_GF02['msg113']   = 'View new posts';
$LANG_GF02['msg114']   = 'Locked Topic';
$LANG_GF02['msg115']   = 'Sticky Topic W/ New Post';
$LANG_GF02['msg116']   = 'Locked Topic W/ New Post';
$LANG_GF02['msg117']   = 'Search All';
$LANG_GF02['msg118']   = 'Search This Forum';
$LANG_GF02['msg119']   = 'Forum Search results for the query:';
$LANG_GF02['msg120']   = 'Most popular posts by';
$LANG_GF02['msg121']   = 'All times are %s. The time is now %s.';
$LANG_GF02['msg122']   = 'Popular Limit';
$LANG_GF02['msg123']   = 'Number of posts before calling a topic popular';
$LANG_GF02['msg124']   = 'Messages Per Page:';
$LANG_GF02['msg125']   = 'Moderator Only: Messages Listing screen';
$LANG_GF02['msg126']   = 'Search Lines';
$LANG_GF02['msg127']   = 'Number of lines to display in search results';
$LANG_GF02['msg128']   = 'Members Per Page';
$LANG_GF02['msg129']   = 'For the Members listing screen';
$LANG_GF02['msg130']   = 'View Anonymous Posts';
$LANG_GF02['msg131']   = 'Setting of No will filter out anonymous posts';
$LANG_GF02['msg132']   = 'Always Notify';
$LANG_GF02['msg133']   = 'Setting of Yes will enable auto notifcation for any topics you create or reply';
$LANG_GF02['msg134']   = 'Subscription Added';
$LANG_GF02['msg135']   = 'You will now be notified of all posts to this forum.';
$LANG_GF02['msg136']   = 'You must choose a forum to subscribe to.';
$LANG_GF02['msg137']   = 'Notification for topic enabled';
$LANG_GF02['msg138']   = '<b>Subscribed to complete forum</b>';
$LANG_GF02['msg139']   = '%s Click <a href="%s">here</a> to continue.';
$LANG_GF02['msg140']   = 'to continue';
$LANG_GF02['msg141']   = 'This page should return automatically. If you do not wish to wait, click <a href="%s">here</a>';
$LANG_GF02['msg142']   = 'Notification saved.';
$LANG_GF02['msg143']   = 'Subscribe to this topic';
$LANG_GF02['msg144']   = 'Return to topic';
$LANG_GF02['msg145']   = 'Topic Review';
$LANG_GF02['msg146']   = 'Notification Deleted';
$LANG_GF02['msg147']   = 'Forum [printable version of topic';
$LANG_GF02['msg148']   = 'Click <a href="javascript:history.back()">HERE</a> to return';
$LANG_GF02['msg149']   = 'Send %s an instant message';
$LANG_GF02['msg150']   = 'Your post in %s';
$LANG_GF02['msg151']   = 'Recent forum topics';
$LANG_GF02['msg152']   = 'Most popular viewed topics';
$LANG_GF02['msg153']   = 'Most popular replied to topics';
$LANG_GF02['msg154']   = 'Recent forum topics';
$LANG_GF02['msg155']   = 'No user posts.';
$LANG_GF02['msg156']   = 'Total number of forum posts';
$LANG_GF02['msg157']   = 'Last 10 Forum posts';
$LANG_GF02['msg158']   = 'Last 10 Forum posts by ';
$LANG_GF02['msg159']   = 'Are you sure you want to DELETE these selected Moderator records?';
$LANG_GF02['msg160']   = 'View last page of topic';
$LANG_GF02['msg161']   = 'Return to members list';
$LANG_GF02['msg162']   = 'To return to the forum index now click <a href="%s">here</a><br' . XHTML . '>Default is to return automatically to view your post.<br' . XHTML . '>If you do not wish to wait, click <a href="%s">here</a> now.';
$LANG_GF02['msg163']   = 'Post moved';
$LANG_GF02['msg164']   = 'Mark all Categories and Topics Read';
$LANG_GF02['msg165']   = '<p>ERROR: Matching <b>QUOTE</b> tag missing. Unable to format message.</p>';
$LANG_GF02['msg166']   = 'ERROR: Invalid topic or Topic not found';
$LANG_GF02['msg167']   = 'Notification Option';
$LANG_GF02['msg168']   = 'Setting of No will disable email notifictions';
$LANG_GF02['msg169']   = 'Return to Members listing';
$LANG_GF02['msg170']   = 'Latest Forum Posts';
$LANG_GF02['msg171']   = 'Forum Access Error';
$LANG_GF02['msg172']   = 'Topic does not exist. It possibly has been deleted';
$LANG_GF02['msg173']   = 'Transferring to Post Message page..';
$LANG_GF02['msg174']   = 'Unable to BAN Member - Invalid or Empty IP Address';
$LANG_GF02['msg175']   = 'Return to Forum Listing';
$LANG_GF02['msg176']   = 'Select a member';
$LANG_GF02['msg177']   = 'All Members';
$LANG_GF02['msg178']   = 'Parent Posts Only';
$LANG_GF02['msg179']   = 'Content generated in: %s seconds';
$LANG_GF02['msg180']   = 'Forum Posting Alert';
$LANG_GF02['msg181']   = 'You don\'t have access to any other forum as a moderator';
$LANG_GF02['msg182']   = 'Moderator Confirmation';
$LANG_GF02['msg183']   = 'New topic was created from this post in forum: %s';
$LANG_GF02['msg184']   = 'Notify Once Only';
$LANG_GF02['msg185']   = 'Notifications will only be sent once for forums and topics which have multiple new posts since your last visit.';
$LANG_GF02['msg186']   = 'New Topic Title';
$LANG_GF02['msg187']   = 'Return to topic - click <a href="%s">here</a>';
$LANG_GF02['msg188']   = 'Click to go directly to last post';
$LANG_GF02['msg189']   = 'Error: You can not edit this post anymore';
$LANG_GF02['msg190']   = 'Silent Edit';
$LANG_GF02['msg191']   = 'Edit not permitted. Allowable edit timeframe expired or you need moderator rights';
$LANG_GF02['msg192']   = 'Completed ... Migrated %s topics and %s comments.';
$LANG_GF02['msg193']   = 'STORY&nbsp;&nbsp;TO&nbsp;&nbsp;FORUM&nbsp;&nbsp;MIGRATION&nbsp;&nbsp;UTILITY';
$LANG_GF02['msg194']   = 'Quiet Forum';
$LANG_GF02['msg195']   = 'Click to Jump to Forum';
$LANG_GF02['msg196']   = 'View the main forum index';
$LANG_GF02['msg197']   = 'Mark all topics read';
$LANG_GF02['msg198']   = 'Update your forum settings';
$LANG_GF02['msg199']   = 'View or remove forum notifications';
$LANG_GF02['msg200']   = 'Site members report';
$LANG_GF02['msg201']   = 'Popular topics';
$LANG_GF02['msg202']   = 'No new posts';

$LANG_GF02['msg300']   = 'Your preferences have block anonymous posts enabled';

$LANG_GF02['StatusHeading']   = 'Information Only';
$LANG_GF02['PostReply']   = 'Post New Reply';
$LANG_GF02['PostTopic']   = 'Post New Topic';
$LANG_GF02['EditTopic']   = 'Edit Topic';
$LANG_GF02['quietforum']  = 'Forum has no new topics';

$LANG_GF03 = array (
    'welcomemsg'        => 'Welcome Moderator',
    'title'             => 'Moderator Functions:&nbsp;',
    'delete'            => 'Delete Post',
    'edit'              => 'Edit Post',
    'move'              => 'Move Topic',
    'split'             => 'Split Topic',
    'ban'               => 'Ban IP',
    'stick'             => 'Make Sticky',
    'unstick'           => 'Un-Stick',
    'movetopic'         => 'Move Topic',
    'movetopicmsg'      => '<br' . XHTML . '>Topic to be moved: "<b>%s</b>"',
    'splittopicmsg'     => '<br' . XHTML . '>Create a new Topic with this post: "<b>%s</b>"<br' . XHTML . '><em>By:</em>&nbsp;%s&nbsp <em>On:</em>&nbsp;%s',
    'selectforum'       => 'Select new forum:',
    'lockedpost'        => 'Add Reply Post',
    'splitheading'      => 'Split thread option:',
    'splitopt1'         => 'Move all posts from this point',
    'splitopt2'         => 'Move only this one post'
);

$LANG_GF04 = array (
    'label_forum'             => 'Forum Profile',
    'label_location'          => 'Location',
    'label_aim'               => 'AIM Handle',
    'label_yim'               => 'YIM Handle',
    'label_icq'               => 'ICQ Identity',
    'label_msnm'              => 'MS Messenger Name',
    'label_interests'         => 'Interests',
    'label_occupation'        => 'Occupation',
);

/* Settings for Additional User profile - Instant Messenging links */
$LANG_GF05 = array (
    'aim_link'               => '&nbsp;<a href="aim:goim?screenname=',
    'aim_linkend'            => '>',
    'aim_hello'              => '&message=Hi.+Are+you+there?',
    'aim_alttext'            => 'AIM:&nbsp;',
    'icq_link'               => '&nbsp;',
    'icq_alttext'            => 'ICQ #:&nbsp;',
    'msn_link'               => '&nbsp;<a href="javascript:MsgrApp.LaunchIMUI(',
    'msn_linkend'            => ')">',
    'msn_alttext'            => 'Messenger:&nbsp;',
    'yim_link'               => '&nbsp;<a href="ymsgr:sendIM?',
    'yim_linkend'            => '">',
    'yim_alttext'            => 'YIM:&nbsp;',
);


/* Admin Navbar */
$LANG_GF06 = array (
    1   => 'Statistics',
    2   => 'Settings',
    3   => 'Forums',
    4   => 'Moderator',
    5   => 'Convert',
    6   => 'Messages',
    7   => 'IP Mgmt'
);


/* User Functions Navbar */
$LANG_GF07 = array (
    1   => 'View Forums',
    2   => 'Preferences',
    3   => 'Popular Topics',
    4   => 'Subscriptions',
    5   => 'Members'
);


/* Forum User Features */
$LANG_GF08 = array (
    1   => 'Topic Notifications',
    2   => 'Track Forum Notifications',
    3   => 'Topic Exception Notifications'
);


$LANG_GF90 = array (
    'viewforums'        => 'Index',
    'stats'             => 'Statistics',
    'settings'          => 'Settings',
    'boardadmin'        => 'Forums',
    'migrate'           => 'Convert',
    'mods'              => 'Moderator',
    'messages'          => 'Messages',
    'ipman'             => 'IP Mgmt'
);

$LANG_GF91 = array (
    'gfstats'            => 'Discussion Forum Stats',
    'statsmsg'           => 'Here are the current statistics for your forum:',
    'totalcats'          => 'Total Categories:',
    'totalforums'        => 'Total Forums:',
    'totaltopics'        => 'Total Topics:',
    'totalposts'         => 'Total Posts:',
    'totalviews'         => 'Total Views:',
    'avgpmsg'            => 'Average posts per:',
    'category'           => 'Category:',
    'forum'              => 'Forum:',
    'topic'              => 'Topic:',
    'avgvmsg'            => 'Average views per:'
);

// Settings.php 
$LANG_GF92 = array (
    'gfsettings'         => 'Discussion Forum Settings',
    'gensettings'        => 'General Settings',
    'gensettings'        => 'General Settings',
    'topicsettings'      => 'Topic Posting Settings',
    'blocksettings'      => 'Latest Posts Block Settings',
    'ranksettings'       => 'Ranking Description Settings',
    'htmlsettings'       => 'Html Settings',
    'avsettings'         => 'Avatar Settings',
    'ranksettings'       => 'Rank Settings',
    'savesettings'       => '    Update Settings    ',
    'allowhtml'          => 'Allow HTML',
    'allowhtmldscp'      => 'Enable HTML to be used in posts. If set to NO then users will only be able to post in TEXT Mode but still use bbcode',
    'glfilter'           => 'Geeklog Filter',
    'glfilterdscp'       => 'Enable Geeklog filtering of HTML',
    'censor'             => 'Censor',
    'censordscp'         => 'Enable Geeklog filtering of bad words',
    'showmoods'          => 'Allow Moods',
    'showmoodsdscp'      => 'Enable moods to be selected per post',
    'allowsmilies'       => 'Allow Smilies',
    'allowsmiliesdscp'   => 'Enable smilies to be used',
    'allownotify'        => 'Allow Notification',
    'allownotifydscp'    => 'Enable Topic update email notification',
    'showiframe'         => 'Show Topic Review',
    'showiframedscp'     => 'Show Topic Review (Iframe) at bottom when replying to a topic',
    'autorefresh'        => 'Auto Refresh',
    'autorefreshdscp'    => 'Automatically refresh page after a submission',
    'refreshdelay'       => 'Pause Delay',
    'refreshdelaydscp'   => 'Pause delay in seconds if autorefresh mode used',
    'xtrausersettings'   => 'Extra User Settings',
    'xtrausersettingsdscp'    => 'Enable optional extra user settings',
    'titleleng'          => 'Title Length',
    'titlelengdscp'      => 'Maximum length (characters) for the topic subject',
    'topicspp'           => 'Topics Per Page',
    'topicsppdscp'       => 'Number of topics to display when viewing the forum index',
    'postspp'            => 'Posts Per Page',
    'postsppdscp'        => 'Number of posts to show per page',
    'regview'            => 'Register - View',
    'regviewdscp'        => 'Do you need to be registered to view posts',
    'regpost'            => 'Register - Post',
    'regpostdscp'        => 'Do you need to be registered to create posts',
    'imgset'             => 'Image Set',
    'lev1'               => 'Level 1',
    'lev1dscp'           => 'Rank 1 - Desciption and post threshold',
    'lev2'               => 'Level 2',
    'lev2dscp'           => 'Rank 2 - Desciption and post threshold',
    'lev3'               => 'Level 3',
    'lev3dscp'           => 'Rank 3 - Desciption and post threshold ',    
    'lev4'               => 'Level 4',
    'lev4dscp'           => 'Rank 4 - Desciption and post threshold',    
    'lev5'               => 'Level 5',
    'lev5dscp'           => 'Rank 5 - Desciption and post threshold',
    'setsave'            => 'Settings Saved',
    'setsavemsg'         => 'Settings saved.',
    'allownotify'        => 'Allow Notification',
    'allownotifydscp'    => 'Do you want to allow people to be notified?',
    'defaultmode'        => 'Default Post Mode',
    'defaultmodedscp'    => 'Enable HTML Mode as default - set to Yes.<br' . XHTML . '>Enable Text mode as default (safest) - set to No',
    'cbsettings'         => 'Centerblock Settings',
    'cbenable'           => 'Enable Centerblock',
    'cbenabledscp'       => '',
    'cbhomepage'         => 'Homepage Only',
    'cbhomepagedscp'     => 'Enabled will only show when on page 1',
    'cbposition'         => 'Location',
    'cbpositiondscp'     => 'Placement on the page',
    'position'           => 'Position ',
    'all_topics'         => 'All',
    'no_topic'           => 'Homepage Only',
    'position_top'       => 'Top Of Page',
    'position_feat'      => 'After Featured Story',
    'position_bottom'    => 'Bottom Of Page',
    'messagespp'         => 'Messages per Page',
    'messagesppdscp'     => 'Messages Admin screen - number of messages lines per page',
    'searchespp'         => 'Search Results',
    'searchesppdscp'     => 'Number of records to show per page when viewing search results',
    'minnamelength'      => 'Min Name Length',
    'minnamedscp'        => 'Minimum length in characters requied for members name or anonymous name',
    'mincommentlength'   => 'Min Post Length',
    'mincommentdscp'     => 'Minimum length in characters contents of post must be',
    'minsubjectlength'   => 'Min Subject Length',
    'minsubjectdscp'     => 'Minimum length in characters required for Topic Subject to post',
    'popular'            => 'Popular Posts',
    'populardscp'        => 'Number of views required for topic to have popular rating',
    'convertbreak'       => 'Convert Newlines',
    'convertbreakdscp'   => 'Convert new lines to HTML &lt;BR&gt; tags when viewing posts',
    'speedlimit'         => 'Posting Speedlimit',
    'speedlimitdscp'     => 'Time in seconds required between posts - to prevent spamming',
    'cb_subjectsize'     => 'Title Length',
    'cb_subjectsizedscp' => 'Number of characters allowed in displayed subject',
    'cb_numposts'        => 'Number of posts',
    'cb_numpostsdscp'    => 'Number of posts to show in Centerblock',
    'sb_subjectsize'     => 'Title Length',
    'sb_subjectsizedscp' => 'Number of characters allowed in displayed subject',
    'sb_numposts'        => 'Number of posts',
    'sb_numpostsdscp'    => 'Number of posts to show in latestposts block',
    'sb_latestposts'     => 'Latest Posts',
    'sb_latestpostsdscp' => 'Only show the latest post per topic',
    'userdatefmt'        => 'Date Format',
    'userdatefmtdscp'    => 'Use the user defined preference for Date/Time format where required',
    'spamxplugin'        => 'SpamX Plugin',
    'spamxplugindscp'    => 'Enable the Spam-X Plugin to filter out possible spam on all posts before saving',
    'pmplugin'           => 'PM Plugin',
    'pmplugindscp'       => 'Private Message Plugin is installed and should be enabled',
    'smiliesplugin'       => 'Smilies Plugin',
    'smiliesplugindscp'  => 'Smilies Plugin or external functions should be used for handling smilies',
    'geshiformat'        => 'Code Formatting',
    'geshiformatdscp'    => 'Use the Geshi Code Formatting Feature',
    'edit_timewindow'    => 'Edit Timeframe',
    'edit_timewindowdscp' => 'Allowed time (min) to allow members to edit their posts'

);

// Board Admin
$LANG_GF93 = array (
    'gfboard'            => 'Discussion Forum Board Admin',
    'vieworder'          => 'View Order',
    'addcat'             => 'Add Forum Category',
    'addforum'           => 'Add A Forum',
    'order'              => 'Order:',
    'catorder'           => 'Category Order',
    'forumorder'         => 'Forum Order',
    'catadded'           => 'Category Added.',
    'catdeleted'         => 'Category Deleted',
    'catedited'          => 'Category Edited.',
    'forumadded'         => 'Forum Added.',
    'forumaddError'      => 'Error Adding Forum.',
    'forumdeleted'       => 'Forum Deleted',
    'forumedited'        => 'Forum Edited',
    'forumordered'       => 'Forum Order Edited',
    'transfer'           => 'Transfering to board index..',
    'vieworder'          => 'View Order',
    'back'               => 'Back',
    'addnote'            => 'Note: You can edit these values.',
    'editnote'           => 'Edit Forum Details for: ',
    'editforumnote'      => 'Edit Forum Details for: <b>"%s"</b>',
    'deleteforumnote1'   => 'Do you want to delete the forum <b>"%s"</b>&nbsp;?',
    'editcatnote'        => 'Edit Category Details for: <b>"%s"</b>',
    'deletecatnote1'     => 'Do you want to delete the category <b>"%s"</b>&nbsp;?',
    'deletecatnote2'     => 'All forums and topics posted under those forums will also be deleted.',
    'undercat'           => 'Under Category',
    'deleteforumnote2'   => 'All topics posted under it will also be deleted.',
    'groupaccess'        => 'Group Access: ',
    'rebuild'            => 'Rebuild LastPost Table',
    'action'             => 'Actions',
    'forumdescription'   => 'Forum Description',
    'posts'              => 'Posts',
    'ordertitle'         => 'Order',
    'ModDel'             => 'Del',
    'ModEdit'            => 'Edit',
    'ModMove'            => 'Move',
    'ModStick'           => 'Stick',
    'ModBan'             => 'Ban',
    'addmoderator'       => "Add Record",
    'delmoderator'       => " Delete\nSelected",
    'moderatorwarning'   => '<b>Warning: No Forums Defined</b><br' . XHTML . '><br' . XHTML . '>Setup Forum Categories and Add at least 1 forum<br' . XHTML . '>before attempting to add Modertators',
    'private'            => 'Private Forum',
    'filtertitle'        => 'Select Moderator records to view',
    'addmessage'         => 'Add new Moderator',
    'allowedfunctions'   => 'Allowed Functions',
    'userrecords'        => 'User Records',
    'grouprecords'       => 'Group Records',
    'filterview'         => 'Filter View',
    'readonly'           => 'Readonly Forum',
    'readonlydscp'       => 'Only the Moderator can post to this forum',
    'hidden'             => 'Hidden Forum',
    'hiddendscp'         => 'Forum does not show in the forum index',
    'hideposts'          => 'Hide New posts',
    'hidepostsdscp'      => 'Updates will not show in the New Posts Blocks or RSS Feeds'

);

$LANG_GF94 = array (
    'mod_title'          => 'Forum Moderators',
    'createmod'          => 'Create Moderator',
    'deletemod'          => 'Delete Moderator',
    'currentmods'        => 'Current Moderators:',
    'moderates'          => 'Moderates',
    'deletemsg'          => '(Note: Mod will be deleted immediately you click this button.)',
    'username'           => 'Username:',
    'forforum'           => 'For Forum:',
    'modper'             => 'Permissions:',
    'candelete'          => 'Can Delete:',
    'canban'             => 'Can Ban:',
    'canedit'            => 'Can Edit:',
    'canmove'            => 'Can Move:',
    'canstick'           => 'Can Make Sticky:',
    'addsuc'             => 'Moderator record(s) added successfully.',
    'editsuc'            => 'Moderator edited sucessfully.',
    'removesuc'          => 'Moderator removed successfully from forum: ',
    'removesuc2'         => 'Moderator record(s) removed successfully from all forums.',
    'modexists'          => 'Moderator Exists',
    'modexistsmsg'       => 'Error: Sorry this moderator already exists.',
    'transfer'           => 'Transfering to mod index..',
    'removemodnote1'     => 'Are you want to remove moderator %s from the forum %s?',
    'removemodnote2'     => 'Once deleted, they will no longer be able to moderate that forum.',
    'removemodnote3'     => 'Are you want to remove moderator %s from all forums?',
    'removemodnote4'     => 'Once deleted, they will no longer be able to moderate any forums.',
    'allforums'          => 'All Forums'
);


$LANG_GF95 = array (
    'header1'           => 'Discussion Board Messages',
    'header2'           => 'Discussion Board Messages for forum&nbsp;&raquo;&nbsp;%s',
    'notyet'            => 'Feature has not been implemented yet',
    'delall'            => 'Delete All',
    'delallmsg'         => 'Are you sure you want to delete all messages from: %s?',
    'underforum'        => '<b>Under Forum: %s (ID #%s)',
    'moderate'          => 'Moderate',
    'nomess'            => 'There have been no messages posted yet! '
);

$LANG_GF96 = array (
    'gfipman'            => 'IP Management',
    'ban'                => 'Ban',
    'noips'              => '<p style="margin:0px; padding:5px;">No IPs have been banned yet!</p>',
    'unban'              => 'Un-Ban',
    'ipbanned'           => 'IP Address Banned',
    'banip'              => 'Ban IP Confirmation',
    'banipmsg'           => 'Are you sure you want to ban the ip %s?',
    'specip'             => 'Please specify an IP Address to ban!',
    'ipunbanned'         => 'IP Address Un-Banned.'
);

// IM.php
$LANG_GF97 = array (
    'msgsent'            => 'Message Sent!',
    'msgsave'            => 'Your message to %s has been sent.',
    'msgreturn'          => 'to return to your inbox.',
    'msgerror'           => 'Your message has not been sent. Please go <a href="javascript:history.back()">back</a> and make sure you have all fields filled.',
    'msgdelok'           => 'Delete Successful',
    'msgdelsuccess'      => 'You have sucessfully deleted this message.',
    'msgdelerr'          => 'The message has not been deleted. Please go <a href=\"javascript:history.back()\">back</a> and choose one.',
    'msgpriv'            => 'Private Messages',
    'msgprivnote1'       => 'You have %s private message.',
    'msgprivnote2'       => 'You have %s private messages.',
    'msgto'              => 'To Username:',
    'msgmembers'         => 'Member List.'
);


$PLG_forum_MESSAGE1 = 'Forum Plugin Upgrade completed - no errors';
$PLG_forum_MESSAGE5 = 'Forum Plugin Upgrade failed - check error.log';

?>