# -*- coding: utf-8 -*-
#
#  showingsurface.py - Showing SVG file
#  Copyright (C) 2004 by Atzm WATANABE <atzm@atzm.org>
#  Copyright (C) 2004 by Takuya KAWAHARA <num@sann.ne.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: showingsurface.py,v 1.14 2010/08/28 15:12:17 atzm Exp $
#

import gtk, pango

from common import *
from viewer.viewercommon import *

class ShowingSurface:
	def button_press(self, darea=None, event=None):
		if event.type == 5:
			return
		x = int(event.x) / SIZE_SURFACE_H
		y = int(event.y) / SIZE_SURFACE_V
		w = self.width   / SIZE_SURFACE_H
		h = self.height  / SIZE_SURFACE_V
		splite = (y * w) + x
		try:
			self.app.insert(self, r'\s[%d]' % self.ghost.get_surface_id(splite))
		except:
			pass

	def expose(self, darea=None, event=None):
		style = self.drawingarea.get_style()
		fg_gc = style.fg_gc[gtk.STATE_NORMAL]
		bg_gc = style.bg_gc[gtk.STATE_NORMAL]
		self.drawingarea.window.draw_drawable(bg_gc, self.pixmap,
											  0, 0, 0, 0, -1, -1)
		self.draw_number(fg_gc, bg_gc)
		return True

	def draw_number(self, fg_gc, bg_gc):
		num_x = self.width  / SIZE_SURFACE_H
		num_y = self.height / SIZE_SURFACE_V

		i = 0
		for y in xrange(num_y):
			for x in xrange(num_x):
				layout = pango.Layout(self.drawingarea.get_pango_context())
				try:
					layout.set_text('%d' % self.ghost.get_surface_id(i))
					[w, h] = layout.get_pixel_size()
					self.drawingarea.window.draw_rectangle(bg_gc, True,
														   x * SIZE_SURFACE_H,
														   y * SIZE_SURFACE_V,
														   w, h)
					self.drawingarea.window.draw_layout(fg_gc,
														x * SIZE_SURFACE_H,
														y * SIZE_SURFACE_V,
														layout)
				except KeyError:
					pass
				i += 1

	def __init__(self, app, pixbuf, ghost):
		self.app    = app
		self.ghost  = ghost
		self.width  = pixbuf.get_width()
		self.height = pixbuf.get_height()
		self.pixmap = pixbuf.render_pixmap_and_mask()[0]

		self.drawingarea = gtk.DrawingArea()
		self.drawingarea.set_events(gtk.gdk.EXPOSURE_MASK|gtk.gdk.BUTTON_PRESS_MASK)
		self.drawingarea.connect('expose-event', self.expose)
		self.drawingarea.connect('button-press-event', self.button_press)
		self.drawingarea.show()
		self.drawingarea.set_size_request(self.width, self.height)

		accel_group = gtk.AccelGroup()
		self.window = gtk.Window(gtk.WINDOW_TOPLEVEL)
		self.window.add_accel_group(accel_group)
		self.window.set_title('%s: %s: %s' % (unicode(APP, "utf-8"),
										  unicode(_("All surfaces"), "utf-8"),
										  self.ghost.get_ghostname()))
		self.window.connect('destroy', lambda x: x.destroy())

		scrolledwindow = gtk.ScrolledWindow()
		scrolledwindow.show()
		scrolledwindow.set_policy(gtk.POLICY_ALWAYS, gtk.POLICY_ALWAYS)
		scrolledwindow.set_shadow_type(gtk.SHADOW_IN)
		scrolledwindow.add_with_viewport(self.drawingarea)

		closebutton = get_icon_button(gtk.STOCK_CLOSE, size=gtk.ICON_SIZE_BUTTON,
									  relief=gtk.RELIEF_NORMAL, label=unicode(_('Close'), 'utf-8'))
		closebutton.show()
		closebutton.connect('clicked', lambda x: self.window.destroy())
		closebutton.add_accelerator("clicked",  accel_group, ord('Q'),
									gtk.gdk.CONTROL_MASK, gtk.ACCEL_VISIBLE)

		hbox = gtk.HBox()
		hbox.show()
		hbox.pack_end(closebutton, False, False)

		vbox = gtk.VBox()
		vbox.show()
		vbox.pack_start(scrolledwindow)
		vbox.pack_end(hbox, False, False)

		self.window.add(vbox)

		window_width  = SIZE_SURFACE_V * 10 + 27
		if self.width < window_width:
			window_width = self.width + 27

		window_height = SIZE_SURFACE_H * 7 + 27
		if self.height < window_height:
			window_height = self.height + 27

		scrolledwindow.set_size_request(window_width, window_height)
		self.window.show()
