# -*- coding: utf-8 -*-
#
#  common.py - Common functions and variables for GBottler
#  Copyright (C) 2001, 2002 by Tamito KAJIYAMA
#  Copyright (C) 2004-2010 by Atzm WATANABE <atzm@atzm.org>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: common.py,v 1.38 2011/09/29 13:06:17 atzm Exp $
#

import os, sys
import gtk

try:
	set, frozenset
except NameError:
	from sets import Set as set, ImmutableSet as frozenset

# common defines
APP = 'GBottler'
VER = '0.2.1.1'

LIBDIR = "~/.bottlecase"

AGENT_NAME = '/'.join([APP, VER])

STYLE_TALK = 0
STYLE_SCRIPT = 1
STYLE_SCRIPT_WITH_LINEFEED = 2

STATE_BOTTLE_PLAYING  = gtk.STOCK_MEDIA_PLAY
STATE_BOTTLE_RESERVED = gtk.STOCK_MEDIA_RECORD
STATE_BOTTLE_NONE     = ''

DL_SUFFIX_PATTERNS = {
	'png': '[Pp][Nn][Gg]',
	'mpg': '[Mm][Nn][Gg]',
	'jpg': '[Jj][Pp][Ee]?[Gg]',
	'gif': '[Gg][Ii][Ff]',
	'bmp': '[Bb][Mm][Pp]',
	'mpg': '[Mm][Pp][Ee]?[Gg]',
	'mp3': '[Mm][Pp]3',
	'ogg': '[Oo][Gg][Gg]',
	'wmv': '[Ww][Mm][Vv]',
	'wma': '[Ww][Mm][Aa]',
	'avi': '[Aa][Vv][Ii]',
	'mov': '[Mm][Oo][Vv]',
	'ram': '[Rr][Aa]?[Mm]',
	'swf': '[Ss][Ww][Ff]',
	'nar': '[Nn][Aa][Rr]',
	'zip': '[Zz][Ii][Pp]',
	'lzh': '[Ll][Zz][Hh]',
	'tgz': '[Tt][Gg][Zz]|[Tt][Aa][Rr]\.[Gg][Zz]',
	'tbz2': '[Tt][Bb][Zz]2|[Tt][Aa][Rr]\.[Bb][Zz]2',
	'txt': '[Tt][Xx][Tt]',
	'html': '[Hh][Tt][Mm][Ll]?',
	}

WAIT_NEXT_REQUEST = 2000
WAIT_NEXT_LOCALGHOST_POLL = 30000

# common functions
def uniq(sequence):
	return list(set(sequence))

def open_bottlecase(path=None):
	libdir = os.path.expanduser(path or LIBDIR)
	if not os.path.exists(libdir):
		os.makedirs(libdir)
	return libdir

def get_icon_button(stock, size=gtk.ICON_SIZE_MENU,
					relief=gtk.RELIEF_NONE, label=None):
	i = gtk.Image()
	i.set_from_stock(stock, size)
	i.show()

	b = gtk.Button()
	b.set_relief(relief)
	b.set_border_width(0)
	b.show()

	if label:
		h = gtk.HBox(False, 0)
		h.set_border_width(0)
		h.show()
		h.pack_start(i, True, True, 0)

		l = gtk.Label(label)
		l.show()
		h.pack_start(l, True, True, 0)
		b.add(h)
	else:
		b.add(i)

	return b

def get_icon_box(stock, label, size=gtk.ICON_SIZE_MENU):
	i = gtk.Image()
	i.set_from_stock(stock, size)
	i.show()

	l = gtk.Label(label)
	l.show()

	h = gtk.HBox(False, 0)
	h.set_border_width(0)
	h.show()
	h.pack_start(i, False, True, 0)
	h.pack_start(l, False, True, 0)

	return h

def get_hbox_with_label_button(stock, label, size=gtk.ICON_SIZE_MENU,
							   relief=gtk.RELIEF_NONE):
	i = gtk.Image()
	i.set_from_stock(stock, size)
	i.show()

	b = gtk.Button()
	b.set_relief(relief)
	b.set_size_request(15, 15)
	b.set_border_width(0)
	b.add(i)
	b.show()

	l = gtk.Label(label)
	l.show()

	e = gtk.EventBox()
	e.show()
	e.set_events(gtk.gdk.BUTTON_PRESS_MASK)
	e.add(l)

	h = gtk.HBox(False, 0)
	h.set_border_width(0)
	h.pack_start(e, False, True, 0)
	h.pack_end(b, False, True, 0)
	h.show()

	return h, e, b

def get_simple_dialog(title, stock, label, parent=None):
	d = gtk.Dialog(title, parent,
				   gtk.DIALOG_DESTROY_WITH_PARENT|gtk.DIALOG_MODAL|gtk.DIALOG_NO_SEPARATOR,
				   (gtk.STOCK_OK, gtk.RESPONSE_OK))
	d.connect("destroy", lambda w: w.destroy)
	h = get_icon_box(stock, label, gtk.ICON_SIZE_DIALOG)
	d.vbox.pack_start(h)
	return d

def get_simple_yes_or_no_dialog(title, label, parent=None, stock=gtk.STOCK_DIALOG_QUESTION):
	d = gtk.Dialog(title, parent,
				   gtk.DIALOG_DESTROY_WITH_PARENT|gtk.DIALOG_MODAL|gtk.DIALOG_NO_SEPARATOR,
				   (gtk.STOCK_NO, gtk.RESPONSE_NO,
					gtk.STOCK_YES, gtk.RESPONSE_YES))
	d.connect("destroy", lambda w: w.destroy)
	h = get_icon_box(stock,
					 label,
					 gtk.ICON_SIZE_DIALOG)
	d.vbox.pack_start(h)
	return d

def open_error_dialog(label, parent=None, stock=gtk.STOCK_DIALOG_ERROR):
	d = get_simple_dialog(unicode(_("Error"), 'utf-8'), stock, label, parent)
	d.show()
	d.run()
	d.hide()
	d.destroy()
	d = None
	return

def open_simple_entry_dialog(title, label, default="", parent=None, stock=gtk.STOCK_DIALOG_QUESTION):
	d = gtk.Dialog(title, parent,
				   gtk.DIALOG_DESTROY_WITH_PARENT|gtk.DIALOG_MODAL|gtk.DIALOG_NO_SEPARATOR,
				   (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL, gtk.STOCK_OK, gtk.RESPONSE_OK))
	d.connect("destroy", lambda w: w.destroy)
	h = get_icon_box(stock, label, gtk.ICON_SIZE_DIALOG)
	d.vbox.pack_start(h)
	e = gtk.Entry()
	e.set_text(default)
	e.connect("activate", lambda x: d.emit("response", gtk.RESPONSE_OK))
	e.show()
	d.vbox.pack_start(e)
	d.show()

	response = d.run()
	if response == gtk.RESPONSE_OK:
		result = e.get_text()
	else:
		result = ''
	d.hide()
	d.destroy()
	d = None
	return result

def open_overwrite_check_dialog(parent=None, filename=''):
	d = get_simple_yes_or_no_dialog(unicode(_("Really?"), 'utf-8'),
									unicode(_("File already exists."), 'utf-8') + " " + \
									unicode(_("overwrite?"), 'utf-8') + "\n\n" + \
									filename + '\n',
									parent)
	d.show()
	res = d.run()
	d.destroy()

	if not res or res == gtk.RESPONSE_NO:
		return False
	return True
