# -*- coding: utf-8 -*-
#
#  scriptchecker.py - Script checker for GBottler
#  Copyright (C) 2001, 2002 by Tamito KAJIYAMA
#  Copyright (C) 2004 by Atzm WATANABE <atzm@atzm.org>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: scriptchecker.py,v 1.4 2010/08/28 15:12:17 atzm Exp $
#

import gtk
import string
from bottleparser import *
from common import get_simple_dialog

class ScriptChecker:
	RESERVED_SURFACES = (0, 1, 2, 3, 4, 5, 6, 7, 8, 10, 11, 19, 20, 25)

	def __init__(self):
		self.parser = BottleParser('strict')

	def check(self, script, parent):
		lines = string.split(script, "\n")

		error = 0
		buffer = []
		i = 1.0 / len(lines)
		for n in range(len(lines)):
			if not lines[n]:
				break
			lines[n] = self.check_line(lines[n], n, parent)
			if lines[n] is None:
				error = 1
				break
			buffer.extend(lines[n])
		if error or self.check_tag_abuse(buffer):
			return 1
		else:
			return 0

	def check_line(self, script, lineno, parent):
		try:
			return self.parser.parse(script)
		except ParserError, e:
			t = gtk.TextView()
			t.set_cursor_visible(False)
			t.set_editable(False)
			t.set_wrap_mode(gtk.WRAP_CHAR)

			b = t.get_buffer()
			b.set_text('')
			b.create_tag('font').set_property('font', 'Monospace')
			b.insert_with_tags_by_name(b.get_end_iter(), unicode(_("Line"), "utf8") + \
									   " %d: %s\n%s\n" % (lineno, e.message, script) +
									   " " * (e.column) + "^" * (e.length or 1), 'font')

			s = gtk.ScrolledWindow()
			s.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
			s.set_shadow_type(gtk.SHADOW_IN)
			s.add(t)

			d = get_simple_dialog('Script Parser Error', gtk.STOCK_DIALOG_ERROR,
								  'Script Parser Error', parent)
			d.vbox.pack_start(s)
			d.set_default_size(340, 200)
			d.show_all()
			res = d.run()
			d.destroy()

			return None

	def check_tag_abuse(self, script):
		scope = error = None
		for node in script:
			if node[0] == SCRIPT_TAG:
				name, args = node[1], node[2:]
				if name == r"\h":
					scope = 0
				elif name == r"\u":
					scope = 1
				elif name == r"\s":
					if scope is None:
						error = r"no scope"
						break
					try:
						id = int(args[0])
					except ValueError, error:
						pass
					if id < -1 or id > 8191 or error:
						s = u2e(self.editor.text())
						s = string.replace(s, "\n", "")
						c = string.find(s, r"\s[%s]" % args[0])
						l = len(args[0])
						if c > -1:
							self.set_mark(self.editor, c+3, l)
						error = r"bad surface number"
						break
				elif name == r"\n" and args:
					if args[0]:
						word = args[0][0][1]
					else:
						word = ""
					if not word == "half":
						s = u2e(self.editor.text())
						s = string.replace(s, "\n", "")
						c = string.find(s, r"\n[%s]" % word)
						l = len(word)
						if c > -1:
							self.set_mark(self.editor, c+3, l)
						error = r"new line"
						break
		if error is not None:
			self.info.setText("Error: %s" % error)
			return 1
		return 0

# 	def check_tag_abuse(self, script):
# 		scope = error = None
# 		surface_usage = [0, 10]

# 		msg_or  = unicode(_("or"), "utf8")
# 		msg_tag = unicode(_("tag"), "utf8")
# 		for node in script:
# 			if node[0] == SCRIPT_TAG:
# 				name, args = node[1], node[2:]
# 				if name == r"\h":
# 					scope = 0
# 				elif name == r"\u":
# 					scope = 1
# 				elif name == r"\s":
# 					try:
# 						id = int(args[0])
# 					except ValueError:
# 						error = unicode(_('bad use of surfaces'), 'utf-8')
# 						break
# 					if id in self.RESERVED_SURFACES:
# 						target = id / 10 % 2
# 					else:
# 						target = None
# 					if scope is None:
# 						if target is None:
# 							tag = r"\h %s \u %s" % (msg_or, msg_tag)
# 						elif target == 0:
# 							tag = r"\h %s" % msg_tag
# 						else:
# 							tag = r"\u %s" % msg_tag
# 						error = r"\s[%d] " % id + \
# 								unicode(_("is used without a preceding"), "utf8") + \
# 								" %s" % tag
# 						break
# 					if id in self.RESERVED_SURFACES:
# 						surface_usage[scope] = id
# 			elif node[0] == SCRIPT_TEXT:
# 				if scope is None:
# 					error = r"\h %s \u " % msg_or + \
# 							unicode(_("is needed before characters"), "utf8")
# 					break
# 		else:
# 			if surface_usage[0] / 10 % 2 == 1 or surface_usage[0] == 20 or \
# 			   surface_usage[1] / 10 % 2 == 0:
# 				error = unicode(_("bad use of surfaces"), "utf8")
# 		if error is not None:
# 			return 1
# 		return 0
