# -*- coding: utf-8 -*-
#
#  messagesender.py - Any message send part of GBottler
#  Copyright (C) 2004-2010 by Atzm WATANABE <atzm@atzm.org>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: messagesender.py,v 1.7 2010/08/22 11:04:07 atzm Exp $
#

import gtk
import os, sys, time
from threading import Thread
from common import *
from bottlelib2 import BottleClientError
import config

if os.name == 'posix':
	import fcntl
else:
	import msvcrt

class VoteMessageSender(Thread):
	def __init__(self, client, logwindow, mid, type):
		self.client    = client
		self.logwindow = logwindow
		self.mid       = mid
		self.type      = type
		Thread.__init__(self)

	def run(self):
		gtk.gdk.threads_enter()
		self.logwindow.set_message(unicode(_('Sending %s Message...') % self.type, 'utf-8'))
		gtk.gdk.flush()
		gtk.gdk.threads_leave()

		try:
			self.client.vote_message(self.mid, self.type)
		except BottleClientError, e:
			gtk.gdk.threads_enter()
			self.logwindow.add_message(unicode(_('failed!!'), 'utf-8'))
			open_error_dialog(str(e), self.logwindow.window)
			gtk.gdk.flush()
			gtk.gdk.threads_leave()
		else:
			gtk.gdk.threads_enter()
			self.logwindow.add_message(unicode(_('Done.'), 'utf-8'))
			gtk.gdk.flush()
			gtk.gdk.threads_leave()


class MessageSender(Thread):
	def __init__(self, app, client, channel, script, ghost):
		self.app        = app
		self.client     = client
		self.channel    = channel
		self.script     = script
		self.ghost      = ghost
		self.logpath    = os.path.join(open_bottlecase(), 'sent.log')
		Thread.__init__(self)

	def run(self):
		self.send()

	def send(self):
		gtk.gdk.threads_enter()
		self.app.monitor_clear()
		self.app.monitor_insert(unicode(_("Broadcasting..."), "utf-8"))
		gtk.gdk.flush()
		gtk.gdk.threads_leave()

		try:
			self.client.send_broadcast(self.channel, self.script, self.ghost)
		except BottleClientError, e:
			gtk.gdk.threads_enter()
			open_error_dialog(unicode(_("failed!!")) + "\n" + \
							  unicode(_("Error"), "utf8") + ": \n" + \
							  unicode(str(e)), self.app.window)
			self.app.pbar.set_fraction(0.0)
			gtk.gdk.flush()
			gtk.gdk.threads_leave()
			return

		if not self.sent_log():
			gtk.gdk.threads_enter()
			open_error_dialog(unicode(_('Failed to write sent log'), 'utf-8'),
							  self.app.window)
			gtk.gdk.flush()
			gtk.gdk.threads_leave()

		if config.get('general', 'auto_reset_editor', 'boolean'):
			gtk.gdk.threads_enter()
			self.app.edit_reset()
			gtk.gdk.flush()
			gtk.gdk.threads_leave()

		gtk.gdk.threads_enter()
		self.app.pbar.set_fraction(0.0)
		gtk.gdk.flush()
		gtk.gdk.threads_leave()

	def sent_log(self):
		if not config.get('general', 'logging_sent_script', 'boolean'):
			return True

		now  = time.strftime("%Y/%m/%d-%H:%M:%S", time.localtime(time.time()))
		line = "%s\t%s\t%s\t%s\n" % (now, self.ghost, self.channel, self.script)

		# lock start
		if os.name == 'posix':
			lockfunc   = lambda file, filename: fcntl.flock(file.fileno(), fcntl.LOCK_EX|fcntl.LOCK_NB)
			unlockfunc = lambda file, filename: fcntl.flock(file.fileno(), fcntl.LOCK_UN)
		else:
			lockfunc   = lambda file, filename: msvcrt.locking(file.fileno(), msvcrt.LK_NBLCK,
															   os.path.getsize(filename))
			unlockfunc = lambda file, filename: msvcrt.locking(file.fileno(), msvcrt.LK_UNLCK,
															   os.path.getsize(filename))
		count = 5
		lockfilename = os.path.join(open_bottlecase(), '.sentloglock')
		lockfile = open(lockfilename, 'w')
		while True:
			try:
				lockfunc(lockfile, lockfilename)
			except IOError:
				if count <= 0:
					return False
				count -= 1
				sys.stderr.write('%s is locked, sleep a second\n' % self.logpath)
				time.sleep(1)
			else:
				break
		# lock end

		try:
			file = open(self.logpath, 'a')
		except IOError, (errno, message):
			unlockfunc(lockfile, lockfilename)
			return False
		else:
			file.write(line)
			file.close()

		unlockfunc(lockfile, lockfilename)
		return True
