# -*- coding: utf-8 -*-
#
#  logfetcher.py - Log Downloader
#  Copyright (C) 2004-2010 by Atzm WATANABE <atzm@atzm.org>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: logfetcher.py,v 1.4 2010/08/22 11:04:07 atzm Exp $
#

import urllib
import mimetools
import traceback

try:
	import cStringIO as _StringIO
except ImportError:
	import StringIO as _StringIO

import config
from common import AGENT_NAME

class LogFetchURLopener(urllib.URLopener):
	version = AGENT_NAME

class LogFetcher:
	def __init__(self):
		self.url = 'http://bottle.mikage.to/fetchlog.cgi'

	def fetch(self, request):
		proxy = config.get('http_server', 'http_proxy').strip()

		if proxy:
			proxy = {'http': proxy}
		else:
			proxy = None

		try:
			req = self.url + '?' + request
			fil = LogFetchURLopener(proxies=proxy).open(req)
			sio = _StringIO.StringIO(fil.read())
			code = fil.getcode()
			fil.close()
		except:
			s = _StringIO.StringIO()
			traceback.print_exc(file=s)
			return s.getvalue()

		headers = mimetools.Message(sio, 0)

		if code != 200:
			#print code, message, headers
			return str(headers) or str(code)
		if not headers.has_key("Result") or headers["Result"] != "OK":
			#print code, message, headers
			return str(headers) or str(code)
		if not headers.has_key("Limit"):
			#print code, message, headers
			return str(headers) or str(code)

		lines = []
		while True:
			line = sio.readline()
			if not line:
				break
			if line[-2:] == '\r\n':
				line = line[:-2]
			if not line:
				continue
			line = unicode(line, 'sjis', 'replace')
			[date, mid, channel, ghost, users, votes, agrees, script] = line.split('\t', 7)
			lines.append([date, mid, votes, agrees, channel, ghost, script])

		return lines
