# -*- coding: utf-8 -*-
#
#  gviewer.py - GViewer Window for GBotter
#  Copyright (C) 2004-2010 by Atzm WATANABE <atzm@atzm.org>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: gvwindow.py,v 1.26 2010/08/12 13:37:20 atzm Exp $
#

import os
import sys
import gtk, pango
from hypertextview import HyperTextView
from viewer.gviewer import GViewerQueue
from viewer.viewercommon import SIZE_SURFACE_H, SIZE_SURFACE_V

from common import *
import config

class GVWindow(gtk.Window):
	def __init__(self, ghostmanager):
		self.ghostmanager = ghostmanager

		# sakura side
		sakura_frame = gtk.Frame()
		sakura_frame.set_shadow_type(gtk.SHADOW_NONE)
		sakura_frame.set_size_request(SIZE_SURFACE_H+5, SIZE_SURFACE_V+5)

		self.t1 = HyperTextView()
		self.t1.link['foreground'] = config.get('fgcolor', 'url')
		self.t1.active['foreground'] = config.get('fgcolor', 'url')
		self.t1.hover['foreground'] = config.get('fgcolor', 'url')
		self.t1.connect('anchor-clicked', self._open_browser)
		self.t1.set_wrap_mode(gtk.WRAP_CHAR)
		self.t1.set_editable(False)
		self.t1.set_cursor_visible(False)
		sw1 = gtk.ScrolledWindow()
		sw1.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_ALWAYS)
		sw1.set_shadow_type(gtk.SHADOW_IN)
		sw1.add(self.t1)

		sakurabox = gtk.HBox()
		sakurabox.pack_start(sakura_frame, False, False, 0)
		sakurabox.pack_start(sw1)
		#sakurabox.set_size_request(100 + 5, SIZE_SURFACE_V * 2 + 20 + 5)

		# kero side
		kero_frame = gtk.Frame()
		kero_frame.set_shadow_type(gtk.SHADOW_NONE)
		kero_frame.set_size_request(SIZE_SURFACE_H+5, SIZE_SURFACE_V+5)

		self.t2 = HyperTextView()
		self.t2.link['foreground'] = config.get('fgcolor', 'url')
		self.t2.active['foreground'] = config.get('fgcolor', 'url')
		self.t2.hover['foreground'] = config.get('fgcolor', 'url')
		self.t2.connect('anchor-clicked', self._open_browser)
		self.t2.set_wrap_mode(gtk.WRAP_CHAR)
		self.t2.set_editable(False)
		self.t2.set_cursor_visible(False)
		sw2 = gtk.ScrolledWindow()
		sw2.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_ALWAYS)
		sw2.set_shadow_type(gtk.SHADOW_IN)
		sw2.add(self.t2)

		kerobox = gtk.HBox()
		kerobox.pack_start(kero_frame, False, False, 0)
		kerobox.pack_start(sw2)
		#kerobox.set_size_request(100 + 5 , SIZE_SURFACE_V + 20 + 5)

		# sender, channel, rest
		sc_label = gtk.Label()
		sc_frame = gtk.Frame()
		sc_frame.set_shadow_type(gtk.SHADOW_IN)
		sc_frame.add(sc_label)

		g_label = gtk.Label()
		g_frame = gtk.Frame()
		g_frame.set_shadow_type(gtk.SHADOW_IN)
		g_frame.add(g_label)

		r_label = gtk.Label()
		i_label = gtk.Label(unicode(_('Items'), 'utf-8'))

		restbox = gtk.HBox()
		restbox.pack_start(r_label, True, True, 0)
		restbox.pack_start(i_label, False, False, 0)
		r_frame = gtk.Frame()
		r_frame.set_shadow_type(gtk.SHADOW_IN)
		r_frame.add(restbox)

		scbox = gtk.HBox()
		scbox.pack_start(sc_frame, True, True, 0)
		scbox.pack_start(g_frame, True, True, 0)
		scbox.pack_start(r_frame, True, True, 0)

		# cancel button
		ibutton = gtk.Button(unicode(_('Cancel'), 'utf-8'))

		# cancel button
		cbutton = gtk.Button(unicode(_('Cancel all'), 'utf-8'))

		# cancel button
		closebutton = gtk.Button(unicode(_('Close'), 'utf-8'))

		# buttons
		bbox = gtk.HBox(True)
		bbox.pack_start(ibutton)
		bbox.pack_start(cbutton)
		bbox.pack_start(closebutton)

		# all
		box = gtk.VBox()
		box.pack_start(sakurabox, True, True, 0)
		box.pack_start(kerobox,   True, True, 0)
		box.pack_start(bbox,      False,False,0)
		box.pack_start(scbox,     False,False,0)

		# window
		accel_group = gtk.AccelGroup()
		gtk.Window.__init__(self)
		self.add_accel_group(accel_group)
		self.set_title(unicode(APP, "utf-8") + ": " + \
					   unicode(_("GViewer"), "utf-8"))
		self.set_default_size(config.get('gviewer', 'width', 'int'),
							  config.get('gviewer', 'height', 'int'))
		self.connect('delete-event', self.close)
		self.add(box)

		self.gvqueue = GViewerQueue([sakura_frame, self.t1, sw1], [kero_frame, self.t2, sw2], self, sc_label, g_label, r_label)

		ibutton.connect('clicked', lambda x: self.gvqueue.cancel())
		ibutton.add_accelerator("clicked",  accel_group, ord('C'),
								gtk.gdk.CONTROL_MASK, gtk.ACCEL_VISIBLE)

		cbutton.connect('clicked', lambda x: self.gvqueue.cancel_all())
		cbutton.add_accelerator("clicked",  accel_group, ord('G'),
								gtk.gdk.CONTROL_MASK, gtk.ACCEL_VISIBLE)

		closebutton.connect('clicked', lambda x: self.close())
		closebutton.add_accelerator("clicked",  accel_group, ord('Q'),
									gtk.gdk.CONTROL_MASK, gtk.ACCEL_VISIBLE)

	def _open_browser(self, widget, text, anchor, button):
		if anchor:
			os.system(config.get('browser', 'browser_command') % anchor + ' &')

	def enqueue(self, channel, ifghost, script, sender):
		ghost = self.ghostmanager.nominate_ghost(ifghost)
		self.gvqueue.enqueue(script, ghost, sender, channel, ifghost)

	def receive_preferences_changed(self):
		self.notify_use_gviewer()
		self.notify_font_changed()
		if config.get('gviewer', 'sticky', 'boolean'):
			self.stick()
		else:
			self.unstick()

		for t in [self.t1, self.t2]:
			t.link['foreground'] = config.get('fgcolor', 'url')
			t.active['foreground'] = config.get('fgcolor', 'url')
			t.hover['foreground'] = config.get('fgcolor', 'url')
			t.update()

	def notify_cancel_all(self):
		self.gvqueue.cancel_all()

	def notify_font_changed(self):
		font = config.get('font', 'general')
		self.t1.modify_font(pango.FontDescription(font))
		self.t2.modify_font(pango.FontDescription(font))

	def notify_use_gviewer(self):
		if config.get('gviewer', 'use_gviewer', 'boolean'):
			self.gvqueue.polling_start()
		else:
			self.gvqueue.polling_stop()

	def open(self, widget=None, data=None):
		self.show_all()
		self.window.raise_()

	def close(self, widget=None, e=None, data=None):
		self.hide()
		return True
