# -*- coding: utf-8 -*-
#
#  client.py - bottle client part of GBottler
#  Copyright (C) 2001, 2002 by Tamito KAJIYAMA
#  Copyright (C) 2004-2010 by Atzm WATANABE <atzm@atzm.org>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: client.py,v 1.11 2011/09/25 03:36:38 atzm Exp $
#

import gobject

import config
from bottlelib2    import BottleClient, URL_BOTTLE2, BROADCAST_TYPE_VOTE, BROADCAST_TYPE_AGREE
from downloader    import Downloader
from messagesender import MessageSender, VoteMessageSender
from common        import APP, AGENT_NAME

class Bottler(BottleClient):
	def __init__(self, app, luid):
		host = config.get('slpp_server', 'slpp_conn')
		port = config.get('slpp_server', 'slpp_port', 'int')
		url = URL_BOTTLE2

		BottleClient.__init__(self, host, port, url, luid, AGENT_NAME)
		self.app = app

		self.receive_preferences_changed()

	# handlers for BottleClient
	def handle_sstp_message(self, receive_time, mid, script, channel, ifghost, unicast, forced):
		charset = 'Shift_JIS'
		sender = APP

		if unicast:
			channel = 'unicast'
		elif forced:
			channel = 'broadcast'

		# log message
		gobject.timeout_add(0, self.app.notify_log_update, mid[:], channel, ifghost, script, receive_time)

		# send local message
		gobject.timeout_add(0, self.app.send_local_message, channel, ifghost, script, sender, charset, mid[:])

		# download
		if config.get('download', 'auto_download', 'boolean'):
			downloader = Downloader(verbose=True, script=script)
			downloader.start()

		return True

	def handle_dialog_message(self, message):
		self.app.monitor_clear()
		self.app.monitor_insert(message)
		return True

	def handle_broadcast_information(self, type, detail, forced):
		if type in [BROADCAST_TYPE_VOTE, BROADCAST_TYPE_AGREE]:
			self.app.log_votes(detail['mid'][0], type, int(detail['num'][0]))
		return True

	def handle_all_users(self, num):
		self.app.show_users()
		return True

	def handle_channel_users(self, channel, num):
		self.app.show_users_of(channel)
		return True

	def handle_close_channel(self, channel):
		self.app.close_channel(channel)
		return True

	def notify_connection_closed(self):
		self.app.part()

	# handlers for Application
	def receive_preferences_changed(self):
		self.set_proxy(config.get('http_server', 'http_proxy').strip())

	# utilities
	def _channel_cmp_index(self, a, b):
		return cmp(self.channels[a]['index'], self.channels[b]['index'])

	# APIs
	def send_message(self, channel, script, ghost):
		ms = MessageSender(self.app, self, channel, script, ghost)
		ms.start()

	def send_vote_message(self, logwindow, mid, type):
		vms = VoteMessageSender(self, logwindow, mid, type)
		vms.start()

	def set_proxy(self, proxy):
		if proxy:
			proxy = {'http': proxy}
		else:
			proxy = None
		self.proxy = proxy

	def channel_names(self):
		names = self.channels.keys()
		names.sort(self._channel_cmp_index)
		return names
