# -*- coding: ascii -*-
#
#  logparsers.py - Bottle Log Parsers
#  Copyright (C) 2004 by Atzm WATANABE <sitosito@p.chan.ne.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: logparsers.py,v 1.1 2004/09/26 19:18:38 atzm Exp $
#

import string, StringIO

from xml.sax         import saxexts, saxutils
from xml.sax.handler import ContentHandler
from xml.parsers     import expat

class BottleLogParserExpat:
	def __init__(self):
		self.parser = expat.ParserCreate()
		self.parser.StartElementHandler  = self.startElement
		self.parser.EndElementHandler    = self.endElement
		self.parser.CharacterDataHandler = self.characters

		self.parsed = []
		self.current_data = ''

	def parse(self, content):
		self.parser.Parse(content)
		return self.parsed

	def startElement(self, name, attrs):
		if name == 'message':
			self.parsed.append({'mid': attrs.get('mid')})

	def endElement(self, name):
		if name not in ['message', 'bottlelog']:
			self.parsed[-1][name] = string.strip(self.current_data)
			self.current_data = ''

	def characters(self, data):
		self.current_data += data

	def initialize(self):
		self.parsed = []
		self.current_data = ''

class BottleLogParserSAX:
	def __init__(self):
		self.parser = saxexts.make_parser()
		self.handler = BottleLogHandlerSAX()
		self.parser.setDocumentHandler(self.handler)
		self.parser.setErrorHandler(saxutils.ErrorRaiser())

	def parse(self, content):
		self.parser.parseFile(StringIO.StringIO(content))
		return self.handler.parsed

	def initialize(self):
		self.handler.initialize()

class BottleLogHandlerSAX(ContentHandler):
	def __init__(self):
		self.parsed = []
		self.current_ch = ''

	def startElement(self, name, attrs):
		if name == 'message':
			self.parsed.append({'mid': attrs.get('mid')})

	def endElement(self, name):
		if name not in ['message', 'bottlelog']:
			self.parsed[-1][name] = string.strip(self.current_ch)
			self.current_ch = ''

	def characters(self, ch, start, length):
		self.current_ch += ch

	def initialize(self):
		self.parsed = []
		self.current_ch = ''
