# -*- coding: utf-8 -*-
#
#  config.py - config for GBottler
#  Copyright (C) 2005 Atzm WATANABE <sitosito@p.chan.ne.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: config.py,v 1.7 2005/09/11 12:15:55 atzm Exp $

__author__ = '$Author: atzm $'
__version__ = '$Revision: 1.7 $'

import common
import os, ConfigParser

_userconfig = os.path.join(common.open_bottlecase(), 'bottlerc')
_parser = ConfigParser.RawConfigParser()

SSTP_FORWARD_ALL = 0
SSTP_FORWARD_INSTALLED = 1

LOGWINDOW_PAGE_PLACEMENT_NEXT = 0
LOGWINDOW_PAGE_PLACEMENT_PREV = 1
LOGWINDOW_PAGE_PLACEMENT_RIGHTMOST = 2
LOGWINDOW_PAGE_PLACEMENT_LEFTMOST = 3

LOGWINDOW_TAB_PLACEMENT_TOP = 0
LOGWINDOW_TAB_PLACEMENT_BOTTOM = 1
LOGWINDOW_TAB_PLACEMENT_LEFT = 2
LOGWINDOW_TAB_PLACEMENT_RIGHT = 3

def set(sect, key, val):
	try:
		_parser.set(sect, key, val)
	except ConfigParser.NoSectionError:
		_parser.add_section(sect)
		set(sect, key, val)

def get(sect, key, valuetype=''): # valuetype in ['', 'int', 'float', 'boolean']
	try:
		method = getattr(_parser, 'get%s' % valuetype)
		return method(sect, key)
	except (ConfigParser.NoSectionError, ConfigParser.NoOptionError):
		if valuetype == 'int':
			return 0
		elif valuetype == 'float':
			return 0.0
		elif valuetype == 'boolean':
			return False
		else:
			return ''

def write(filename=''):
	if not filename:
		filename = _userconfig
	_parser.write(file(filename, 'w'))

def read(filename=''):
	if not filename or not os.path.isfile(filename):
		filename = _userconfig
	_parser.read(filename)

def init():
	for sect, key, val in [
		['general', 'width', '500'],
		['general', 'height', '200'],
		['general', 'hide_phrasebar', 'False'],
		['general', 'startup_open_logwindow', 'True'],
		['general', 'startup_connect', 'False'],
		['general', 'connect_all', 'False'],
		['general', 'auto_reset_editor', 'True'],
		['general', 'logging_sent_script', 'True'],
		['sstp_server', 'forward_local', 'True'],
		['sstp_server', 'forward_to', str(SSTP_FORWARD_ALL)],
		['script', 'initial_script', r'\t\u\s[10]\h\s[0]|\e'],
		['logging', 'save_current_when_disconnected', 'False'],
		['logging', 'save_current_when_close_tab', 'False'],
		['logging', 'gzip', 'False'],
		['logging', 'filename', os.path.join(common.open_bottlecase(), 'autolog', '%Y%m%d', '%H-%M-%S.xml')],
		['logwindow', 'width', '450'],
		['logwindow', 'height', '300'],
		['logwindow', 'paned_position', '150'],
		['logwindow', 'hide_system_message', 'False'],
		['logwindow', 'focus_new_page', 'True'],
		['logwindow', 'new_page_placement', str(LOGWINDOW_PAGE_PLACEMENT_NEXT)],
		['logwindow', 'tab_placement', str(LOGWINDOW_TAB_PLACEMENT_TOP)],
		['browser', 'browser_command', "mozilla -remote 'openFile(%s,new-tab)'"],
		['download', 'auto_download', 'False'],
		['download', 'logging_download_history', 'True'],
		['download', 'download_type', ' '.join(common.DL_SUFFIX_PATTERNS.keys())],
		['font', 'general', 'Sans 10'],
		['font', 'script', 'Monospace 10'],
		['fgcolor', 'script', 'dark green'],
		['fgcolor', 'sakura', 'black'],
		['fgcolor', 'unyuu', 'brown'],
		['fgcolor', 'synchronized', 'blue'],
		['fgcolor', 'error', 'red'],
		['fgcolor', 'url', 'purple'],
		['phraseeditor', 'width', '450'],
		['phraseeditor', 'height', '400'],
		['gviewer', 'width', '380'],
		['gviewer', 'height', '240'],
		['gviewer', 'use_gviewer', 'False'],
		['gviewer', 'draw_number', 'False'],
		['gviewer', 'sticky', 'False'],
		['gviewer', 'auto_open', 'False'],
		['gviewer', 'auto_close', 'False'],
		['gviewer', 'raise_before_play', 'False'],
		['gviewer', 'sink_after_play', 'False'],
		['gviewer', 'sink_timer', '3000'],
		['gviewer', 'wait_char', '47'],
		['gviewer', 'wait_w1', '50'],
		['svgmanager', 'width', '450'],
		['svgmanager', 'height', '450'],
		]:
		set(sect, key, val)
	try:
		read()
	except ConfigParser.MissingSectionHeaderError:
		pass

if __name__ == '__main__':
	import sys
	init()
	_parser.write(sys.stdout)
