# -*- coding: utf-8 -*-
#
#  viewercommon.py: Common functions and defines for GViewer
#  Copyright (C) 2004 by Atzm WATANABE <sitosito@p.chan.ne.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: viewercommon.py,v 1.3 2004/10/03 04:14:39 atzm Exp $
#

import re

# debug
DEBUG = False

# pixels
SIZE_SURFACE_H = 48
SIZE_SURFACE_V = 64

# vanish image
XPM_VANISH = [
	"16 16 3 1",
	"       c None",
	".      c #000000000000",
	"X      c #FFFFFFFFFFFF"
	]
XPM_VANISH += [' ' * SIZE_SURFACE_H for a in range(SIZE_SURFACE_V)]

# sides
SIDE_SAKURA = 0
SIDE_KERO   = 1
SIDE_SYNC   = 2

# sessions
SESSION_QUICK = 3

# events
EVENT_CLEAR = 4

# names
NAME_SAKURA          = unicode('さくら', 'utf-8')
NAME_SAKURA_KUROI    = unicode('黒衣さくら', 'utf-8')
NAME_SAKURA_KAWAKAMI = unicode('川上さくら', 'utf-8')
NAME_SAKURA_DOT      = unicode('．さくら', 'utf-8')
NAME_SAKURA_DOT_     = unicode('旧・．さくら', 'utf-8')

EXPAND_QUOTE_REGEX = re.compile('"(.*?)"')
def expand_quote(text):
	try:
		text = EXPAND_QUOTE_REGEX.match(text).group(1)
	except AttributeError:
		pass
	return text	

