# -*- coding: ascii -*-
#
#  gviewer.py - GViewer Window for GBotter
#  Copyright (C) 2004 by Atzm WATANABE <sitosito@p.chan.ne.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: gvwindow.py,v 1.18 2004/10/03 04:14:39 atzm Exp $
#

import gtk, pango
from viewer.gviewer import GViewerQueue
from viewer.viewercommon import SIZE_SURFACE_H, SIZE_SURFACE_V

from prefs  import PreferenceManager
from common import *

class GVWindow(gtk.Window):
	def __init__(self, ghostmanager):
		self.ghostmanager = ghostmanager

		# sakura side
		sakura_frame = gtk.Frame()
		sakura_frame.set_shadow_type(gtk.SHADOW_NONE)
		sakura_frame.set_size_request(SIZE_SURFACE_H+5, SIZE_SURFACE_V+5)

		self.t1 = gtk.TextView()
		self.t1.set_wrap_mode(gtk.WRAP_CHAR)
		self.t1.set_editable(gtk.FALSE)
		self.t1.set_cursor_visible(gtk.FALSE)
		b1 = self.t1.get_buffer()
		sw1 = gtk.ScrolledWindow()
		sw1.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_ALWAYS)
		sw1.set_shadow_type(gtk.SHADOW_IN)
		sw1.add(self.t1)

		sakurabox = gtk.HBox()
		sakurabox.pack_start(sakura_frame, gtk.FALSE, gtk.FALSE, 0)
		sakurabox.pack_start(sw1)
		#sakurabox.set_size_request(100 + 5, SIZE_SURFACE_V * 2 + 20 + 5)

		# kero side
		kero_frame = gtk.Frame()
		kero_frame.set_shadow_type(gtk.SHADOW_NONE)
		kero_frame.set_size_request(SIZE_SURFACE_H+5, SIZE_SURFACE_V+5)

		self.t2 = gtk.TextView()
		self.t2.set_wrap_mode(gtk.WRAP_CHAR)
		self.t2.set_editable(gtk.FALSE)
		self.t2.set_cursor_visible(gtk.FALSE)
		b2 = self.t2.get_buffer()
		sw2 = gtk.ScrolledWindow()
		sw2.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_ALWAYS)
		sw2.set_shadow_type(gtk.SHADOW_IN)
		sw2.add(self.t2)

		kerobox = gtk.HBox()
		kerobox.pack_start(kero_frame, gtk.FALSE, gtk.FALSE, 0)
		kerobox.pack_start(sw2)
		#kerobox.set_size_request(100 + 5 , SIZE_SURFACE_V + 20 + 5)

		# sender, channel, rest
		sc_label = gtk.Label()
		sc_frame = gtk.Frame()
		sc_frame.set_shadow_type(gtk.SHADOW_IN)
		sc_frame.add(sc_label)

		g_label = gtk.Label()
		g_frame = gtk.Frame()
		g_frame.set_shadow_type(gtk.SHADOW_IN)
		g_frame.add(g_label)

		r_label = gtk.Label()
		i_label = gtk.Label(unicode(_('Items'), 'utf-8'))

		restbox = gtk.HBox()
		restbox.pack_start(r_label, gtk.TRUE, gtk.TRUE, 0)
		restbox.pack_start(i_label, gtk.FALSE, gtk.FALSE, 0)
		r_frame = gtk.Frame()
		r_frame.set_shadow_type(gtk.SHADOW_IN)
		r_frame.add(restbox)

		scbox = gtk.HBox()
		scbox.pack_start(sc_frame, gtk.TRUE, gtk.TRUE, 0)
		scbox.pack_start(g_frame, gtk.TRUE, gtk.TRUE, 0)
		scbox.pack_start(r_frame, gtk.TRUE, gtk.TRUE, 0)

		# cancel button
		ibutton = gtk.Button(unicode(_('Cancel'), 'utf-8'))

		# cancel button
		cbutton = gtk.Button(unicode(_('Cancel all'), 'utf-8'))

		# cancel button
		closebutton = gtk.Button(unicode(_('Close'), 'utf-8'))

		# buttons
		bbox = gtk.HBox(gtk.TRUE)
		bbox.pack_start(ibutton)
		bbox.pack_start(cbutton)
		bbox.pack_start(closebutton)

		# all
		box = gtk.VBox()
		box.pack_start(sakurabox, gtk.TRUE, gtk.TRUE, 0)
		box.pack_start(kerobox,   gtk.TRUE, gtk.TRUE, 0)
		box.pack_start(bbox,      gtk.FALSE,gtk.FALSE,0)
		box.pack_start(scbox,     gtk.FALSE,gtk.FALSE,0)

		# window
		accel_group = gtk.AccelGroup()
		gtk.Window.__init__(self)
		self.add_accel_group(accel_group)
		self.set_title(unicode(_(APP), "utf-8") + ": " + \
					   unicode(_("GViewer"), "utf-8"))
		self.set_default_size(380, 240)
		self.connect('delete-event', self.close)
		self.add(box)

		self.gvqueue = GViewerQueue([sakura_frame, b1, sw1],
									[kero_frame, b2, sw2], sc_label, g_label, r_label)

		ibutton.connect('clicked', lambda x: self.gvqueue.cancel())
		ibutton.add_accelerator("clicked",  accel_group, ord('C'),
								gtk.gdk.CONTROL_MASK, gtk.ACCEL_VISIBLE)

		cbutton.connect('clicked', lambda x: self.gvqueue.cancel_all())
		cbutton.add_accelerator("clicked",  accel_group, ord('G'),
								gtk.gdk.CONTROL_MASK, gtk.ACCEL_VISIBLE)

		closebutton.connect('clicked', lambda x: self.close())
		closebutton.add_accelerator("clicked",  accel_group, ord('Q'),
									gtk.gdk.CONTROL_MASK, gtk.ACCEL_VISIBLE)

	def enqueue(self, channel, ifghost, script, sender):
		ghost = self.ghostmanager.nominate_ghost(ifghost)
		self.gvqueue.enqueue(script, ghost, sender, channel, ifghost)

	def receive_preferences_changed(self, prefs):
		self.notify_use_gviewer(prefs[PreferenceManager.PREF_GVIEWER_USE])
		self.notify_wait_1_char(prefs[PreferenceManager.PREF_GVIEWER_WAIT_1_CHAR])
		self.notify_wait_w1_tag(prefs[PreferenceManager.PREF_GVIEWER_WAIT_W1_TAG])
		self.notify_font_changed(prefs[PreferenceManager.PREF_FONT_GENERAL])
		if prefs[PreferenceManager.PREF_GVIEWER_STICKY]:
			self.stick()
		else:
			self.unstick()

	def notify_cancel_all(self):
		self.gvqueue.cancel_all()

	def notify_font_changed(self, genfont):
		self.t1.modify_font(pango.FontDescription(genfont))
		self.t2.modify_font(pango.FontDescription(genfont))

	def notify_use_gviewer(self, use):
		if use:
			self.gvqueue.polling_start()
		else:
			self.gvqueue.polling_stop()

	def notify_wait_1_char(self, num):
		try:
			self.gvqueue.set_wait_1_char(int(num))
		except:
			pass

	def notify_wait_w1_tag(self, num):
		try:
			self.gvqueue.set_wait_w1_tag(int(num))
		except:
			pass

	def open(self, widget=None, data=None):
		self.show_all()

	def close(self, widget=None, e=None, data=None):
		self.hide()
		return gtk.TRUE
