
/*--------------------------------- vbgtH[̑I
#define	_WIN32_GDI
#define	_WIN32_SDL
#define	_WINCE_GDI
#define	_LINUX_SDL
#define	_SDL
*/

/*--------------------------------- ^`*/
typedef unsigned char u8;
typedef unsigned short u16;
typedef unsigned int u32;
typedef signed char s8;
typedef signed short s16;
typedef signed int s32;
typedef unsigned char byte;
typedef unsigned short hword;
typedef unsigned int word;

/*--------------------------------- CPUWX^`*/
typedef struct {
	u8	low;
	u8	high;
}REG8;

typedef union {
	REG8	reg8;
	u16		reg16;
}REGPAIR;

typedef struct{
	REGPAIR af;
	REGPAIR bc;
	REGPAIR de;
	REGPAIR	hl;
	u16	sp;
	REGPAIR	pc;
	u8	ime;
	u8	halt;
	u8	stop;
	u8	running;
}CPU_REGS;

CPU_REGS	cpu;

#define		A		cpu.af.reg8.high
#define		F		cpu.af.reg8.low
#define		B		cpu.bc.reg8.high
#define		C		cpu.bc.reg8.low
#define		D		cpu.de.reg8.high
#define		E		cpu.de.reg8.low
#define		H		cpu.hl.reg8.high
#define		L		cpu.hl.reg8.low
#define		PC_HIGH	cpu.pc.reg8.high
#define		PC_LOW	cpu.pc.reg8.low

#define		AF		cpu.af.reg16
#define		BC		cpu.bc.reg16
#define		DE		cpu.de.reg16
#define		HL		cpu.hl.reg16
#define		SP		cpu.sp
#define		PC		cpu.pc.reg16

#define		IME		cpu.ime
#define		HALT	cpu.halt
#define		STOP	cpu.stop
#define		CPUIsRunning	cpu.running

/*--------------------------------- tO̓ǂݏ}N*/
#define	_Z	0x80
#define _N	0x40
#define _H	0x20
#define _C	0x10
#define SF(_flag)	F|=_flag
#define RF(_flag)	F&=~_flag
#define FZ	(u8)((F>>7)&0x01)
#define FN	(u8)((F>>6)&0x01)
#define FH	(u8)((F>>5)&0x01)
#define FC	(u8)((F>>4)&0x01)

/*--------------------------------- R[h̓ǂݎ*/
#define OPCODE	RMem(PC)
#define DEST	RMem(PC+1)
#define SOURCE	(u16)(RMem(PC+1)+(RMem(PC+2)<<8))

/*--------------------------------- GBŗL̐l*/
#define	ROM_SIZE		0x40000
#define	S32_SIZE		0x8000
#define	S16_SIZE		0x4000
#define START_ADDRESS	0x0100
#define MEM_SIZE		0x10000
#define GB_LCD_X		160
#define GB_LCD_Y		144

/*--------------------------------- IOWX^*/
#define R_P1	0xFF00
#define R_SB	0xFF01
#define R_SC	0xFF02
#define R_DIV	0xFF04
#define R_TIMA	0xFF05
#define R_TMA	0xFF06
#define R_TAC	0xFF07

/*--------------------------------- 荞݃WX^*/
#define R_IF	0xFF0F

/*--------------------------------- TEhI/O*/
#define R_NR10	0xFF10
#define R_NR11	0xFF11
#define R_NR12	0xFF12
#define R_NR13	0xFF13
#define R_NR14	0xFF14
#define R_NR21	0xFF16
#define R_NR22	0xFF17
#define R_NR23	0xFF18
#define R_NR24	0xFF19
#define R_NR30	0xFF1A
#define R_NR31	0xFF1B
#define R_NR32	0xFF1C
#define R_NR33	0xFF1D
#define R_NR34	0xFF1E
#define R_NR41	0xFF20
#define R_NR42	0xFF21
#define R_NR43	0xFF22
#define R_NR44	0xFF23
#define R_NR50	0xFF24
#define R_NR51	0xFF25
#define R_NR52	0xFF26
#define R_AUD3W	0xFF30

/*--------------------------------- IOWX^*/
#define R_LCDC	0xFF40
#define R_STAT	0xFF41
#define R_SCY	0xFF42
#define R_SCX	0xFF43
#define R_LY	0xFF44
#define R_LYC	0xFF45
#define R_DMA	0xFF46
#define R_BGP	0xFF47
#define R_OBP0	0xFF48
#define R_OBP1	0xFF49
#define R_WY	0xFF4A
#define R_WX	0xFF4B

/*-------------------------------- GBCpWX^*/
#define R_KEY1	0xFF4D
#define R_VBK	0xFF4F
#define R_HDMA1	0xFF51
#define R_HDMA2	0xFF52
#define R_HDMA3	0xFF53
#define R_HDMA4	0xFF54
#define R_HDMA5	0xFF55
#define R_RP	0xFF56
#define R_BCPS	0xFF68
#define R_BCPD	0xFF69
#define R_OCPS	0xFF6A
#define R_OCPD	0xFF6B
#define R_SVBK	0xFF70

/*--------------------------------- 荞݃WX^*/
#define R_IE	0xFFFF

/*--------------------------------- 荞*/
#define	IRQ_VBLANK	0
#define	IRQ_LCDC	1
#define	IRQ_TIMER	2
#define	IRQ_SERIAL	3
#define	IRQ_KEY		4

/*--------------------------------- XvCg*/
#define	OBJ_Y	MEM[tma-2]	/*XvCgXW*/
#define	OBJ_X	MEM[tma-1]	/*XvCgYW*/
#define	OBJ_F	MEM[tma+1]	/*XvCg̃tO*/

/*--------------------------------- O[oϐ*/
FILE*	fp;
u8		MEM[MEM_SIZE];
u8		ROM[16][S16_SIZE];
u8		mbc;
u8		FrameBuffer[160*144];
u16		tmp16;
u8		tmp8;
u8		EnableBG=1, EnableWND=1, EnableOBJ=1;
u8		fVsync=1, fFps=1;
static	u32		CL=0;
static	u32		rDIV=0;
static	u32		rTAC=4096;
int		FrameCount=0, FrameSkip=0;
static	u8 irq_type;	/*s̊荞*/
static	u8 keyflag;	/*L[tO*/
static	u8 keyint;	/*L[荞݃tO(e݂ꍇɐ^)*/

static	u32 tac_table[]={
	4096,
	262144,
	65536,
	16384
};

static	u16 irq_adr[]={
	0x0040,/*VBlank*/
	0x0048,/*LCDC*/
	0x0050,/*^C}[*/
	0x0058,/*ʐM*/
	0x0060,/*L[*/
};

static	u8 irq_bit[]={
	0x01,
	0x02,
	0x04,
	0x08,
	0x10,
};

u8	Colours[4]={
	0xEF,
	0x9A,
	0x4C,
	0x22,
};


u8 ColorPalette[][4][3]={
	181,195,173,/*classic colors*/
	165,170,123,
	132,138, 90,
	 57, 56, 33,
	 49,251,198,/*lightboy colors*/
	 33,195,140,
	  0,121,132,
	  0, 40, 50,
};

/*--------------------------------- Win32GDIp̒`*/
#ifdef	_WIN32_GDI
bool fMapDlg, fTileDlg, fMemDlg, fAsmDlg, fObjDlg;	// _CAO\tO
bool fUpdate=false, fRun=false, fNext=false, fBreak=false;
bool Os9x=false;
u16	BP1=0xffff, BP2=0xffff, BP3=0xffff;
RECT DlgSize;					// _CAÕTCYL
DWORD dwSize = sizeof(BITMAPINFOHEADER)+sizeof(RGBQUAD)*256;
typedef struct{
	BITMAPINFOHEADER	bmiHeader;
	RGBQUAD				bmiColors[256];
}BMPINFO;
BMPINFO bmp_info;
HDC	hMemDC;		// obNobt@(rbg}bv)쐬
HDC hDC;		// LCDp̃foCXReLXg
HBITMAP	hBitmap=NULL;
u8	*pBitmap;
u8	PaletteNo=0;
static DWORD FpsTime;
static char frame[20], title[20];
#endif	/*_WIN32_GDI*/

/*--------------------------------- WinCEp̒`*/
#ifdef	_WINCE
HANDLE	hFile;
#define	timeGetTime()	GetTickCount()
#endif	/*_WINCE*/

/*--------------------------------- SDLʂ̒`*/
#ifdef	_SDL
SDL_Event event;
SDL_Surface *Surface;
SDL_PixelFormat *bmp_info;
SDL_Color colors[4];
#define	Sleep(_time)	SDL_Delay(_time)
#endif	/*_SDL*/

