// GBEmuDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "GBEmu.h"
#include "TilesDlg.h"
#include "Maps.h"
#include "Disasm.h"
#include "GBEmuDlg.h"
#include "AboutDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CGBEmuDlg GBEmu;
static void CPU();					// CPUG~[V
void InitializeMemory();			// IOWX^̏
void InitializeRegister();			// CPUWX^̏
void InitializeVideo(HDC hDC);		// obNobt@̏
static void DrawLine();				// LYWX^̃C쐬
static void Interrupt();
static void EndInterrupt();

#define	_WIN32_GDI

#include <conio.h>
#include <mmsystem.h>
#pragma comment(lib, "winmm.lib")
#include "defines.h"				// IOWX^̒`
#include "memory.c"					// R,W
#include "cpu.c"					// CPURAPC,Cyclee[u
#include "mainloop.c"
#include "video.c"


/////////////////////////////////////////////////////////////////////////////
// CGBEmuDlg _CAO

CGBEmuDlg::CGBEmuDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGBEmuDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGBEmuDlg)
		// : ̈ʒu ClassWizard ɂăȍǉ܂B
	//}}AFX_DATA_INIT
	// : LoadIcon  Win32  DestroyIcon ̃TuV[PXv܂B
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	
	m_pTMain = NULL;
	m_pTGUI = NULL;
	m_pTLCD = NULL;
	m_pTileDlg = NULL;
	m_pMapDlg = NULL;
	m_pMemDlg = NULL;
	m_pDasm = NULL;
	m_pObjDlg = NULL;
}

void CGBEmuDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGBEmuDlg)
		// : ̏ꏊɂ ClassWizard ɂ DDX  DDV ̌Ăяoǉ܂B
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CGBEmuDlg, CDialog)
	//{{AFX_MSG_MAP(CGBEmuDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_COMMAND(ID_MENU_EXIT, OnMenuExit)
	ON_COMMAND(ID_MENU_ABOUT, OnMenuAbout)
	ON_COMMAND(ID_MENU_OPEN, OnMenuOpen)
	ON_COMMAND(ID_MENU_RESET, OnMenuReset)
	ON_COMMAND(ID_SHOW_FPS, OnShowFps)
	ON_WM_CLOSE()
	ON_COMMAND(ID_PRIORITY_NORMAL, OnPriorityNormal)
	ON_COMMAND(ID_PRIORITY_HIGHEST, OnPriorityHighest)
	ON_COMMAND(ID_PRIORITY_LOWEST, OnPriorityLowest)
	ON_COMMAND(ID_PRIORITY_ABOVE, OnPriorityAbove)
	ON_COMMAND(ID_PRIORITY_BELOW, OnPriorityBelow)
	ON_COMMAND(ID_SHOW_TILES, OnShowTiles)
	ON_COMMAND(ID_SHOW_MAP, OnShowMap)
	ON_COMMAND(ID_VSYNC, OnVsync)
	ON_WM_DROPFILES()
	ON_COMMAND(ID_SHOW_MEMORY, OnShowMemory)
	ON_WM_SIZE()
	ON_COMMAND(ID_ZOOM1, OnZoom1)
	ON_COMMAND(ID_ZOOM2, OnZoom2)
	ON_COMMAND(ID_ZOOM3, OnZoom3)
	ON_COMMAND(ID_ZOOM4, OnZoom4)
	ON_COMMAND(ID_SHOW_DEBUG, OnShowDebug)
	ON_WM_ACTIVATE()
	ON_COMMAND(ID_SKIP0, OnSkip0)
	ON_COMMAND(ID_SKIP5, OnSkip5)
	ON_COMMAND(ID_SKIP1, OnSkip1)
	ON_COMMAND(ID_SKIP2, OnSkip2)
	ON_COMMAND(ID_SKIP3, OnSkip3)
	ON_COMMAND(ID_SKIP4, OnSkip4)
	ON_COMMAND(ID_LAYER_BG, OnLayerBg)
	ON_COMMAND(ID_LAYER_OBJ, OnLayerObj)
	ON_COMMAND(ID_LAYER_WND, OnLayerWnd)
	ON_COMMAND(ID_PALETTE1, OnPalette1)
	ON_COMMAND(ID_PALETTE2, OnPalette2)
	ON_COMMAND(ID_PALETTE3, OnPalette3)
	ON_COMMAND(ID_MENU_DISABLE_ALL, OnMenuDisableAll)
	ON_COMMAND(ID_SHOW_OAM, OnShowOam)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGBEmuDlg bZ[W nh

BOOL CGBEmuDlg::OnInitDialog()
{ // _CAȌ
	CDialog::OnInitDialog();

	// ̃_CAOp̃ACRݒ肵܂Bt[[N̓AvP[ṼC
	// EBhE_CAOłȂ͎Iɐݒ肵܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACRݒ
	SetIcon(m_hIcon, FALSE);		// ACRݒ

	// LCDpɉʂ̃foCXReLXg擾
	hDC = ::GetDC(m_hWnd);
	InitializeVideo(hDC);					// LCDprbg}bv
	::ReleaseDC(m_hWnd, hDC);
	CDialog::GetClientRect(&DlgSize);
	timeBeginPeriod(1);					// ^C}̐xŏ

	fTileDlg=fMapDlg=fMemDlg=fAsmDlg=fObjDlg=false;

/*	HMODULE	hZipDll = LoadLibrary("unzip32.dll");
	if(hZipDll){
		GBEmu.MessageBox(NULL, NULL, MB_OK);
	}
	typedef HANDLE (__stdcall *GETFUNCTION)(const HWND, LPCSTR,const DWORD);
	GETFUNCTION UnZipOpenArchive = (GETFUNCTION)GetProcAddress(hZipDll, "UnZipOpenArchive");*/

	OSVERSIONINFO	osInfo;
	osInfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	GetVersionEx(&osInfo);
	if(osInfo.dwPlatformId==VER_PLATFORM_WIN32_WINDOWS)Os9x=true;

	//  NCAg̈LCD̉𑜓xƍ킹
	SetRect(&DlgSize, 0, 0, GB_LCD_X-2, GB_LCD_Y-2);
	AdjustWindowRect(&DlgSize, WS_OVERLAPPEDWINDOW, TRUE);
	CDialog::SetWindowPos(&wndTop, 0, 0, DlgSize.right - DlgSize.left, 
							DlgSize.bottom - DlgSize.top, SWP_NOMOVE);
	memset(FrameBuffer, 3, GB_LCD_X*GB_LCD_Y);
	MEM[R_LCDC]|=0x80;

	if(__argv[1]){
		fp = fopen(__argv[1] ,"rb");
		fread(ROM, 1, ROM_SIZE, fp);
		OnMenuReset();
	}

	return TRUE;  // TRUE ԂƃRg[ɐݒ肵tH[JX͎܂B
}

// _CAO{bNXɍŏ{^ǉȂ΁AACR`悷
// R[hȉɋLqKv܂BMFC AvP[V document/view
// fgĂ̂ŁȀ̓t[[Nɂ莩Iɏ܂B

void CGBEmuDlg::OnPaint() 
{ // EBhEANeBu̍ĕ`
	if (IsIconic())
	{
		CPaintDC dc(this); // `p̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// NCAg̋`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR`悵܂B
		dc.DrawIcon(x, y, m_hIcon);
	} else {
		CDialog::OnPaint();

		LCDDraw();

	}
}

void CGBEmuDlg::ShowFps()
{
	if(FpsTime < timeGetTime()){
		FpsTime = timeGetTime() + 1000;
		strcpy(title, "GameboyVM - ");
		_itoa((int)((FrameCount)/59.0*100), frame, 10);
		FrameCount = 0;
		strcat(frame, "%");
		strcat(title, frame);
		CDialog::SetWindowText(title);
	}
}

void CGBEmuDlg::UpdateGUI()
{
	u16 Wait_A = 1000;
	u16 Wait_B = 30;
	DWORD Time_A = timeGetTime() + Wait_A;

	while(CPUIsRunning && !fUpdate){
		if(Time_A < timeGetTime()){
			Time_A = timeGetTime() + Wait_A;
			if(fTileDlg)m_pTileDlg->ShowTiles();	// ^Cr[A̍XV
			if(fMapDlg)m_pMapDlg->ShowMaps();		// }bvr[A̍XV
			if(fObjDlg)m_pObjDlg->ShowObj();		// OAMr[A̍XV
			if(fAsmDlg)m_pDasm->UpdateStack(true);	// X^bNr[A̍XV
		}
		if(fAsmDlg){
			m_pDasm->UpdateRegs();	// WX^r[AXV
			m_pDasm->UpdateStack(false);	// X^bNr[ȂI
			m_pDasm->SetDisasm();	// tAZȗI
		}
		Sleep(Wait_B);
	}
	
	CDialog::SetWindowText("GameboyVM");

}

void CGBEmuDlg::OnMenuOpen()
{ // ROMt@C̑I
	OPENFILENAME ofn;
	char filename[512];

	memset(filename, 0, 512);
	memset(&ofn, 0, sizeof(ofn));
	ofn.Flags = OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
	ofn.lpstrFile = filename;
	ofn.lpstrFilter = "Gameboy ROM Files (*.gb;*.bin)\0*.gb;*.bin\0All Files (*.*)\0*.*";
	ofn.nMaxFileTitle = 512;
	ofn.nMaxFile = 512;
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = m_hWnd;

	if(GetOpenFileName(&ofn)){
		if(fp!=NULL)fclose(fp);
		if(CPUIsRunning){
			ResumeThread(m_pTMain->m_hThread);
			CPUIsRunning = 0;
			Sleep(100);
			m_pTMain = NULL;
		}
		fp = fopen(filename ,"rb");
		fread(ROM, 1, ROM_SIZE, fp);
		OnMenuReset();
	}
}

void CGBEmuDlg::OnMenuReset() 
{ // WX^ƃ̏,s
	if(fp!=NULL){
		CPUIsRunning = 0;
		Sleep(100);
		if(!(ROM[0][0x0148]==0x00||ROM[0][0x0148]==0x01||
			ROM[0][0x0148]==0x02||ROM[0][0x0148]==0x03)){
				MessageBox("Unsupported ROM size", NULL, MB_ICONSTOP);
				return;
		}
		InitializeRegister();
		InitializeMemory();
		m_pTGUI = AfxBeginThread(ThreadGUI, this);
		m_pTMain = AfxBeginThread(ThreadMain, this);
		OnPriorityAbove();
	}
}

UINT CGBEmuDlg::ThreadMain(LPVOID pParam)
{ // Xbh烁C[vĂяo
	((CGBEmuDlg*)pParam)->MainLoop();

	return 0;
}

UINT CGBEmuDlg::ThreadGUI(LPVOID pParam)
{ // Xbh烁C[vĂяo
	((CGBEmuDlg*)pParam)->UpdateGUI();

	return 0;
}

UINT CGBEmuDlg::ThreadLCD(LPVOID pParam)
{ // XbhrfI_OĂяo
	((CGBEmuDlg*)pParam)->LCDDraw();

	return 0;
}

void CGBEmuDlg::OnClose() 
{	// I
	CPUIsRunning=0;
	timeEndPeriod(1);
	if(fp!=NULL)fclose(fp);
	DestroyWindow();
}

void CGBEmuDlg::OnDropFiles(HDROP hDropInfo) 
{	// _CAOփhbvꂽt@Cs
	char filename[MAX_PATH];

	DragQueryFile(hDropInfo, 0, filename, sizeof(filename));
	if(filename){
		CPUIsRunning=0;
		Sleep(100);
		fp = fopen(filename ,"rb");
		fread(ROM, 1, ROM_SIZE, fp);
		OnMenuReset();
	}

	CDialog::OnDropFiles(hDropInfo);
}

void InitializeVideo(HDC hDC)
{	/*rbg}bv*/

	memset(&bmp_info, 0, sizeof(BITMAPINFOHEADER));
	bmp_info.bmiHeader.biSize		= sizeof(BITMAPINFOHEADER);
	bmp_info.bmiHeader.biWidth		= GB_LCD_X;
	bmp_info.bmiHeader.biHeight		= -GB_LCD_Y;
	bmp_info.bmiHeader.biPlanes		= 1;
	bmp_info.bmiHeader.biBitCount	= 8;

	if(PaletteNo){
		tmp8=PaletteNo-1;
		bmp_info.bmiColors[0].rgbRed = ColorPalette[tmp8][0][0];
		bmp_info.bmiColors[0].rgbGreen = ColorPalette[tmp8][0][1];
		bmp_info.bmiColors[0].rgbBlue = ColorPalette[tmp8][0][2];
		bmp_info.bmiColors[0].rgbReserved = 0;
		bmp_info.bmiColors[1].rgbRed = ColorPalette[tmp8][1][0];
		bmp_info.bmiColors[1].rgbGreen = ColorPalette[tmp8][1][1];
		bmp_info.bmiColors[1].rgbBlue = ColorPalette[tmp8][1][2];
		bmp_info.bmiColors[1].rgbReserved = 0;
		bmp_info.bmiColors[2].rgbRed = ColorPalette[tmp8][2][0];
		bmp_info.bmiColors[2].rgbGreen = ColorPalette[tmp8][2][1];
		bmp_info.bmiColors[2].rgbBlue = ColorPalette[tmp8][2][2];
		bmp_info.bmiColors[2].rgbReserved = 0;
		bmp_info.bmiColors[3].rgbRed = ColorPalette[tmp8][3][0];
		bmp_info.bmiColors[3].rgbGreen = ColorPalette[tmp8][3][1];
		bmp_info.bmiColors[3].rgbBlue = ColorPalette[tmp8][3][2];
		bmp_info.bmiColors[3].rgbReserved = 0;
	}else{
		bmp_info.bmiColors[0].rgbRed = 
		bmp_info.bmiColors[0].rgbGreen = 
		bmp_info.bmiColors[0].rgbBlue = Colours[0];
		bmp_info.bmiColors[0].rgbReserved = 0;
		bmp_info.bmiColors[1].rgbRed = 
		bmp_info.bmiColors[1].rgbGreen = 
		bmp_info.bmiColors[1].rgbBlue = Colours[1];
		bmp_info.bmiColors[1].rgbReserved = 0;
		bmp_info.bmiColors[2].rgbRed = 
		bmp_info.bmiColors[2].rgbGreen = 
		bmp_info.bmiColors[2].rgbBlue = Colours[2];
		bmp_info.bmiColors[2].rgbReserved = 0;
		bmp_info.bmiColors[3].rgbRed = 
		bmp_info.bmiColors[3].rgbGreen = 
		bmp_info.bmiColors[3].rgbBlue = Colours[3];
		bmp_info.bmiColors[3].rgbReserved = 0;
	}

	hBitmap = ::CreateDIBSection(hDC, (BITMAPINFO *)&bmp_info, 
					DIB_RGB_COLORS, (void**)&pBitmap, NULL, 0);
	hMemDC	= ::CreateCompatibleDC(hDC);
	::SelectObject(hMemDC, hBitmap);
}

void CGBEmuDlg::LCDDraw()
{ // LCDʂ̃G~[Vƕ\
/*	
	if(Os9x){
		while(1){	//A҂
			if(_inp(0x03da)&0x08)break;
			else Sleep(1);
		}
	}
*/	
//	if(MEM[R_LCDC]&0x80){
		memcpy(pBitmap, FrameBuffer, GB_LCD_X * GB_LCD_Y);
		hDC = ::GetDC(m_hWnd);
		::StretchBlt(hDC, 0, 0, DlgSize.right, DlgSize.bottom, hMemDC,
						0, 0, GB_LCD_X, GB_LCD_Y, SRCCOPY);
		::ReleaseDC(m_hWnd, hDC);
//	}
}

BOOL CGBEmuDlg::PreTranslateMessage(MSG* pMsg) 
{
	if(pMsg->message == WM_KEYDOWN){
		switch(pMsg->wParam){
			case 'A':	/*P14,15Ɋ֌WȂLowɂ*/
				keyflag&=~0x0B;
				keyint=1;
				break;
			case 'Z':
				if(MEM[R_P1]&0x20)keyflag&=~0x01;
				keyint=1;
				break;
			case 'X':
				if(MEM[R_P1]&0x20)keyflag&=~0x02;
				keyint=1;
				break;
			case ' ':
				if(MEM[R_P1]&0x20)keyflag&=~0x04;
				keyint=1;
				break;
			case VK_RETURN:
				if(MEM[R_P1]&0x20)keyflag&=~0x08;
				keyint=1;
				break;
			case VK_RIGHT:
				if(MEM[R_P1]&0x10)keyflag&=~0x01;
				keyint=1;
				break;
			case VK_LEFT:
				if(MEM[R_P1]&0x10)keyflag&=~0x02;
				keyint=1;
				break;
			case VK_UP:
				if(MEM[R_P1]&0x10)keyflag&=~0x04;
				keyint=1;
				break;
			case VK_DOWN:
				if(MEM[R_P1]&0x10)keyflag&=~0x08;
				keyint=1;
				break;
			default:
				break;
		}
	}
	if(pMsg->message == WM_KEYUP){
		switch(pMsg->wParam){
			case 'A':
				keyflag|=0x0B;
				keyint=1;
				break;
			case 'Z': case VK_RIGHT:
				keyflag|=0x01;
				keyint=1;
				break;
			case 'X': case VK_LEFT:
				keyflag|=0x02;
				keyint=1;
				break;
			case ' ': case VK_UP:
				keyflag|=0x04;
				keyint=1;
				break;
			case VK_RETURN: case VK_DOWN:
				keyflag|=0x08;
				keyint=1;
				break;
			default:
				break;
		}
	}
	return CDialog::PreTranslateMessage(pMsg);
}

void CGBEmuDlg::OnPalette1() 
{
	hDC = ::GetDC(m_hWnd);
	PaletteNo=0;
	InitializeVideo(hDC);
	::ReleaseDC(m_hWnd, hDC);
	LCDDraw();
}

void CGBEmuDlg::OnPalette2() 
{
	hDC = ::GetDC(m_hWnd);
	PaletteNo=1;
	InitializeVideo(hDC);
	::ReleaseDC(m_hWnd, hDC);
	LCDDraw();
}

void CGBEmuDlg::OnPalette3() 
{
	hDC = ::GetDC(m_hWnd);
	PaletteNo=2;
	InitializeVideo(hDC);
	::ReleaseDC(m_hWnd, hDC);
	LCDDraw();
}

// VXéA[U[ŏEBhEhbOĂԁA
// J[\\邽߂ɂĂяo܂B
HCURSOR CGBEmuDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CGBEmuDlg::OnMenuExit() 
{ // I{^
	CGBEmuDlg::OnClose();
}

void CGBEmuDlg::OnMenuAbout() 
{ // 쌠_CAO̕\
	CAboutDlg about_dlg;
	about_dlg.DoModal();
}

void CGBEmuDlg::OnShowMemory() 
{	// _v\
	if(!fMemDlg){	// Tiles_CAO\
		if(m_pMemDlg==NULL){
			m_pMemDlg = new CMemDlg;
			m_pMemDlg->Create(IDD_MEMORY_DIALOG);
		}
		m_pMemDlg->ShowWindow(SW_SHOW);
		fMemDlg=true;
	}
	else m_pMemDlg->SetFocus();

	m_pMemDlg->ShowMemory();
}

void CGBEmuDlg::OnShowDebug() 
{	// fobK\
	if(!fAsmDlg){
		if(m_pDasm==NULL){
			m_pDasm = new CDisasm;
			m_pDasm->Create(IDD_DISASM_DIALOG);
		}
		m_pDasm->ShowWindow(SW_SHOW);
		fAsmDlg=true;
	}
	else m_pDasm->SetFocus();	

	m_pDasm->ShowDebug();
}

void CGBEmuDlg::OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized) 
{	/*ANeBuɃXbhꎞ~*/
	CDialog::OnActivate(nState, pWndOther, bMinimized);
	if(CPUIsRunning){
		if(nState==WA_INACTIVE && !fRun){
				SuspendThread(m_pTMain->m_hThread);
				SuspendThread(m_pTGUI->m_hThread);
		}
		else{
			ResumeThread(m_pTMain->m_hThread);
			ResumeThread(m_pTGUI->m_hThread);
		}
	}
}

void CGBEmuDlg::OnLayerBg() 
{
	if(MF_CHECKED==GetMenu()->CheckMenuItem(ID_LAYER_BG, MF_CHECKED)){
		GetMenu()->CheckMenuItem(ID_LAYER_BG, MF_UNCHECKED);
		EnableBG=0;
	}else EnableBG=1;
}

void CGBEmuDlg::OnLayerWnd() 
{
	if(MF_CHECKED==GetMenu()->CheckMenuItem(ID_LAYER_WND, MF_CHECKED)){
		GetMenu()->CheckMenuItem(ID_LAYER_WND, MF_UNCHECKED);
		EnableWND=0;
	}else EnableWND=1;
}

void CGBEmuDlg::OnLayerObj() 
{
	if(MF_CHECKED==GetMenu()->CheckMenuItem(ID_LAYER_OBJ, MF_CHECKED)){
		GetMenu()->CheckMenuItem(ID_LAYER_OBJ, MF_UNCHECKED);
		EnableOBJ=0;
	}else EnableOBJ=1;
}

void CGBEmuDlg::OnSkip0() 
{
	FrameSkip = 0;
	GetMenu()->CheckMenuRadioItem(ID_SKIP0, ID_SKIP5, ID_SKIP0, MF_BYCOMMAND);
}

void CGBEmuDlg::OnSkip1() 
{
	FrameSkip = 1;
	GetMenu()->CheckMenuRadioItem(ID_SKIP0, ID_SKIP5, ID_SKIP1, MF_BYCOMMAND);
}

void CGBEmuDlg::OnSkip2() 
{
	FrameSkip = 2;
	GetMenu()->CheckMenuRadioItem(ID_SKIP0, ID_SKIP5, ID_SKIP2, MF_BYCOMMAND);
}

void CGBEmuDlg::OnSkip3() 
{
	FrameSkip = 3;
	GetMenu()->CheckMenuRadioItem(ID_SKIP0, ID_SKIP5, ID_SKIP3, MF_BYCOMMAND);
}

void CGBEmuDlg::OnSkip4() 
{
	FrameSkip = 4;
	GetMenu()->CheckMenuRadioItem(ID_SKIP0, ID_SKIP5, ID_SKIP4, MF_BYCOMMAND);
}

void CGBEmuDlg::OnSkip5() 
{
	FrameSkip = 5;
	GetMenu()->CheckMenuRadioItem(ID_SKIP0, ID_SKIP5, ID_SKIP5, MF_BYCOMMAND);
}

void CDialog::OnOK()
{

}
 
void CGBEmuDlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);
	
	CDialog::GetClientRect(&DlgSize);
}

//---------------𑜓x̕ύX---------------------
void CGBEmuDlg::OnZoom1() 
{
	SetRect(&DlgSize, 0, 0, GB_LCD_X, GB_LCD_Y);
    AdjustWindowRect(&DlgSize, WS_OVERLAPPEDWINDOW, TRUE);
	CDialog::SetWindowPos(&wndTop, 0, 0, DlgSize.right - DlgSize.left, 
							DlgSize.bottom - DlgSize.top, SWP_NOMOVE);
	GetMenu()->CheckMenuRadioItem(ID_ZOOM1, ID_ZOOM4, ID_ZOOM1, MF_BYCOMMAND);
}

void CGBEmuDlg::OnZoom2() 
{
	SetRect(&DlgSize, 0, 0, GB_LCD_X*2, GB_LCD_Y*2);
    AdjustWindowRect(&DlgSize, WS_OVERLAPPEDWINDOW, TRUE);
	CDialog::SetWindowPos(&wndTop, 0, 0, DlgSize.right - DlgSize.left, 
							DlgSize.bottom - DlgSize.top, SWP_NOMOVE);
	GetMenu()->CheckMenuRadioItem(ID_ZOOM1, ID_ZOOM4, ID_ZOOM2, MF_BYCOMMAND);
}

void CGBEmuDlg::OnZoom3() 
{
	SetRect(&DlgSize, 0, 0, GB_LCD_X*3, GB_LCD_Y*3);
	AdjustWindowRect(&DlgSize, WS_OVERLAPPEDWINDOW, TRUE);
	CDialog::SetWindowPos(&wndTop, 0, 0, DlgSize.right - DlgSize.left, 
							DlgSize.bottom - DlgSize.top, SWP_NOMOVE);
	GetMenu()->CheckMenuRadioItem(ID_ZOOM1, ID_ZOOM4, ID_ZOOM3, MF_BYCOMMAND);
}

void CGBEmuDlg::OnZoom4() 
{
	SetRect(&DlgSize, 0, 0, GB_LCD_X*4, GB_LCD_Y*4);
    AdjustWindowRect(&DlgSize, WS_OVERLAPPEDWINDOW, TRUE);
	CDialog::SetWindowPos(&wndTop, 0, 0, DlgSize.right - DlgSize.left, 
							DlgSize.bottom - DlgSize.top, SWP_NOMOVE);
	GetMenu()->CheckMenuRadioItem(ID_ZOOM1, ID_ZOOM4, ID_ZOOM4, MF_BYCOMMAND);
}

//---------------C[vXbh̗Dx------------
void CGBEmuDlg::OnPriorityNormal()
{
	if(CPUIsRunning){	// Xbh쎞̂ݕύX
		if(SetThreadPriority(m_pTMain->m_hThread, THREAD_PRIORITY_NORMAL)){
			GetMenu()->CheckMenuRadioItem(ID_PRIORITY_NORMAL, ID_PRIORITY_LOWEST, ID_PRIORITY_NORMAL, MF_BYCOMMAND);
		}
	}
}

void CGBEmuDlg::OnPriorityHighest()
{
	if(CPUIsRunning){
		if(SetThreadPriority(m_pTMain->m_hThread, THREAD_PRIORITY_HIGHEST)){
			GetMenu()->CheckMenuRadioItem(ID_PRIORITY_NORMAL, ID_PRIORITY_LOWEST, ID_PRIORITY_HIGHEST, MF_BYCOMMAND);
		}
	}
}

void CGBEmuDlg::OnPriorityLowest()
{
	if(CPUIsRunning){
		if(SetThreadPriority(m_pTMain->m_hThread, THREAD_PRIORITY_LOWEST)){
			GetMenu()->CheckMenuRadioItem(ID_PRIORITY_NORMAL, ID_PRIORITY_LOWEST, ID_PRIORITY_LOWEST, MF_BYCOMMAND);
		}
	}
}

void CGBEmuDlg::OnPriorityAbove()
{
	if(CPUIsRunning){
		if(SetThreadPriority(m_pTMain->m_hThread, THREAD_PRIORITY_ABOVE_NORMAL)){
			GetMenu()->CheckMenuRadioItem(ID_PRIORITY_NORMAL, ID_PRIORITY_LOWEST, ID_PRIORITY_ABOVE, MF_BYCOMMAND);
		}
	}
}

void CGBEmuDlg::OnPriorityBelow() 
{
	if(CPUIsRunning){
		if(SetThreadPriority(m_pTMain->m_hThread, THREAD_PRIORITY_BELOW_NORMAL)){
			GetMenu()->CheckMenuRadioItem(ID_PRIORITY_NORMAL, ID_PRIORITY_LOWEST, ID_PRIORITY_BELOW, MF_BYCOMMAND);
		}
	}
}

void CGBEmuDlg::OnShowFps() 
{	// t[b^Cgo[ɂ邽߂̃`FbN
	if(MF_CHECKED==GetMenu()->CheckMenuItem(ID_SHOW_FPS, MF_CHECKED)){
		GetMenu()->CheckMenuItem(ID_SHOW_FPS, MF_UNCHECKED);
		fFps=0;
	}else fFps=1;
}

void CGBEmuDlg::OnVsync() 
{	// ̂߂̃`FbN
	if(MF_CHECKED==GetMenu()->CheckMenuItem(ID_VSYNC, MF_CHECKED)){
		GetMenu()->CheckMenuItem(ID_VSYNC, MF_UNCHECKED);
		fVsync=0;
	}else fVsync=1;
}

void CGBEmuDlg::OnShowTiles() 
{	// ^Cf[^ׂĕ\
	
	if(!fTileDlg){	// Tiles_CAO\
		if(m_pTileDlg==NULL){
			m_pTileDlg = new CTilesDlg;
			m_pTileDlg->Create(IDD_TILES_DIALOG);
		}
		m_pTileDlg->ShowWindow(SW_SHOW);
		fTileDlg = true;
	}
	else m_pTileDlg->SetFocus();

	m_pTileDlg->ShowTiles();
}

void CGBEmuDlg::OnShowMap() 
{	// ^Cf[^ׂĕ\

	if(!fMapDlg){	// Maps_CAO\
		if(m_pMapDlg==NULL){
			m_pMapDlg = new CMaps;
			m_pMapDlg->Create(IDD_MAPS_DIALOG);
		}
		m_pMapDlg->ShowWindow(SW_SHOW);
		fMapDlg=true;
	}
	else m_pMapDlg->SetFocus();

	m_pMapDlg->ShowMaps();
}

void CGBEmuDlg::OnMenuDisableAll() 
{
	if(MF_CHECKED==GetMenu()->CheckMenuItem(ID_MENU_DISABLE_ALL, MF_CHECKED)){
		GetMenu()->CheckMenuItem(ID_MENU_DISABLE_ALL, MF_UNCHECKED);
		fUpdate=true;
	}else {
		fUpdate=false;
		if(CPUIsRunning)m_pTGUI = AfxBeginThread(ThreadGUI, this);
	}
}

u32 HexToInt(char *hexstr)
{
	int tmp=17, ret=0, loop, size=1;

	if(hexstr[0]=='\0'||hexstr[0]==' ')return 0xFFFFFFFE;
	for(loop=strlen(hexstr)-1; loop>=0; loop--){
		switch(hexstr[loop]){
			case '0': tmp=0;break;
			case '1': tmp=1;break;
			case '2': tmp=2;break;
			case '3': tmp=3;break;
			case '4': tmp=4;break;
			case '5': tmp=5;break;
			case '6': tmp=6;break;
			case '7': tmp=7;break;
			case '8': tmp=8;break;
			case '9': tmp=9;break;
			case 'A':
			case 'a': tmp=10;break;
			case 'B':
			case 'b': tmp=11;break;
			case 'C':
			case 'c': tmp=12;break;
			case 'D':
			case 'd': tmp=13;break;
			case 'E':
			case 'e': tmp=14;break;
			case 'F':
			case 'f': tmp=15;break;
			default: return 0xFFFFFFFF;
		}
		ret=tmp*size;
		size*=16;
	}

	if(tmp==17)return 0xFFFFFFFF;
	return ret;
}


void CGBEmuDlg::OnShowOam() 
{
	if(!fObjDlg){
		if(m_pObjDlg==NULL){
			m_pObjDlg = new CObjDlg;
			m_pObjDlg->Create(IDD_OBJ_DIALOG);
		}
		m_pObjDlg->ShowWindow(SW_SHOW);
		fObjDlg=true;
	}
	else m_pObjDlg->SetFocus();

	m_pObjDlg->ShowObj();	
}
