
#define	FOREG		(u8)((OPCODE>>16)&0xF)	/*1st operand register*/
#define	SOREG		(u8)(OPCODE&0xF)		/*2nd operand register*/
#define	DREG	(u8)((OPCODE>>12)&0xF)	/*Destination register*/


static void arm_adc()
{	/*Rd := Rn + Op2 + Carry*/
	u8	op1, op2, dest;

	dest=DREG;
	op1=FOREG;
	if((OPCODE>>24)&0x2){
		arm.reg[dest]=arm.reg[op1]+((OPCODE&0xFF)<<(OPCODE&0xF0))+FC;
	}else{
		op2=SOREG;
		arm.reg[dest]=arm.reg[op1]+arm.reg[op2]+FC;
	}
	if(arm.reg[dest])RF(Z_); else SF(Z_);
}

static void arm_add()
{	/*Rd := Rn + Op2*/
	u8	op1, op2, dest;
	u32	opcode=OPCODE;
	u8	shift_type;
	u32	shift;

	dest=DREG;
	op1=FOREG;
	if((opcode>>25)&1){	/*Immediate Operand*/
		arm.reg[dest]=arm.reg[op1]+((opcode&0xFF)<<(((opcode>>8)&0xF)*2));
	}else{
		op2=SOREG;
		shift_type=(u8)((opcode>>5)&3);
		if((opcode>>4)&1){	/*Rs(8-11)*/
			shift=(opcode>>8)&0xF;
			switch(shift_type){
			case 0:	/*00 = logical left*/
				arm.reg[dest]=arm.reg[op1]+((arm.reg[op2])>>shift);
				break;
			case 1:	/*01 = logical right*/
				arm.reg[dest]=arm.reg[op1]+((arm.reg[op2])<<shift);
				break;
			case 2:	/*10 = arithmetic right*/
				u32	shift_r;	/*31bit*/
				shift_r=shift-1;
				arm.reg[dest]=arm.reg[op1]+((arm.reg[op2])<<shift);
				break;
			case 3:	/*11 = rotate right*/
				arm.reg[dest]=arm.reg[op1]+((arm.reg[op2])<<shift);
				break;
			}
		}else{	/*Rs(7-11)*/
			shift=(opcode>>7)&0x1F;
			switch(shift_type){
			case 0:	/*logical left*/
				arm.reg[dest]=arm.reg[op1]+((arm.reg[op2])>>shift);
				break;
			case 1:	/*logical right*/
				arm.reg[dest]=arm.reg[op1]+((arm.reg[op2])<<shift);
				break;
			case 2:	/*10 = arithmetic right*/
				break;
			case 3:	/*11 = rotate right*/
				break;
			}
		}
	}

	if(arm.reg[dest])RF(Z_); else SF(Z_);
}

static void arm_and()
{	/*Rd := Rn AND Op2*/
	u8	op1, op2, dest;

	dest=DREG;
	op1=FOREG;
	if((OPCODE>>24)&0x2){
		arm.reg[dest]=arm.reg[op1]&((OPCODE&0xFF)<<(OPCODE&0xF0));
	}else{
		op2=SOREG;
		arm.reg[dest]=arm.reg[op1]&arm.reg[op2];
	}
	if(arm.reg[dest])RF(Z_); else SF(Z_);
}

static void arm_b()
{	/*R15 := address*/
	PC+=(u32)((OPCODE&0x00FFFFFF)<<2);
}

static void arm_bic()
{	/*Rd := Rn AND NOT Op2*/
	u8	op1, op2, dest;

	dest=DREG;
	op1=FOREG;
	if((OPCODE>>24)&0x2){
		arm.reg[dest]=arm.reg[op1]&(!((OPCODE&0xFF)<<(OPCODE&0xF0)));
	}else{
		op2=SOREG;
		arm.reg[dest]=arm.reg[op1]&(!arm.reg[op2]);
	}
	if(arm.reg[dest])RF(Z_); else SF(Z_);
}

static void arm_bl()
{	/*R14 := R15, R15 := address*/
	R14=PC+4;
	PC+=(u32)((OPCODE&0x00FFFFFF)<<2);
}

static void arm_bx()
{	/*R15 := Rn*/
	u8 op1;
	
	op1=FOREG;
	R15=arm.reg[op1];
}

static void arm_cdp()
{	/*(Coprocessor-specific)*/

}

static void arm_cmn()
{	/*CPSR flags := Rn + Op2*/

}

static void arm_cmp()
{	/*CPSR flags := Rn - Op2*/

}

static void arm_eor()
{	/*Rd := (Rn AND NOT Op2) OR (op2 AND NOT Rn)*/
	u8	op1, op2, dest;

	dest=DREG;
	op1=FOREG;
	if((OPCODE>>24)&0x2){
		arm.reg[dest]=arm.reg[op1]^((OPCODE&0xFF)<<(OPCODE&0xF0));
	}else{
		op2=SOREG;
		arm.reg[dest]=arm.reg[op1]^arm.reg[op2];
	}
	if(arm.reg[dest])RF(Z_); else SF(Z_);
}

static void arm_ldc()
{	/*Coprocessor load*/

}

static void arm_ldm()
{	/*Stack manipulation (Pop)*/

}

static void arm_ldr()
{	/*Rd := (address)*/
	u8	op2, base, dest;
	u32	opcode=OPCODE;
	u32	offset, base_address;

	offset=opcode&0xFFF;
	dest=DREG;
	base=(u8)((opcode>>16)&0xF);	/*base register*/
	if((opcode>>25)&1){	/*1 = offset is a register*/
		op2=SOREG;
		base_address=arm.reg[base]+((arm.reg[op2])<<((opcode>>4)&0xFF));
	}else{	/*0 = offset is an immediate value*/
		base_address=arm.reg[base]+offset;
	}
	arm.reg[dest]=RMem32(base_address);

	/*ΏۂPC̏ꍇ*/
/*	if(base==15){
		WMem32(dest, arm.reg[base]+4);	
	}*/
}

static void arm_mcr()
{	/*cRn := rRn {<op>cRm}*/

}

static void arm_mla()
{	/*Rd := (Rm * Rs) + Rn*/

}

static void arm_mov()
{	/*Rd : = Op2*/
	u8	dest, op2;
	u32	opcode=OPCODE;

	dest=DREG;
	if((opcode>>25)&1){	/*0-7rbg8-11Vtg Immediate Operand*/
		arm.reg[dest]=ByteFlip32(((opcode&0xFF)<<(((opcode>>8)&0xF)*2)));
	}else{	/*IyhQ[0-3]4-11VtgăWX^*/
		op2=SOREG;
		arm.reg[dest]=((arm.reg[op2])<<((opcode>>4)&0xFF));
	}

	if(arm.reg[dest])RF(Z_); else SF(Z_);
}

static void arm_mrc()
{	/*Rn := cRn {<op>cRm}*/

}

static void arm_mrs()
{	/*Rn := PSR*/

}

static void arm_msr()
{	/*PSR := Rm*/

}

static void arm_mul()
{	/*Rd := Rm * Rs*/

}

static void arm_mvn()
{	/*Rd := 0xFFFFFFFF EOR Op2*/
	u8	op1, op2, dest;

	dest=DREG;
	op1=FOREG;
	op2=SOREG;
	arm.reg[dest]=!arm.reg[op2];
	if(arm.reg[dest])RF(Z_); else SF(Z_);
}

static void arm_orr()
{	/*Rd := Rn OR Op2*/
	u8	op1, op2, dest;

	dest=DREG;
	op1=FOREG;
	if((OPCODE>>24)&0x2){	/*0-7rbg8-11Vtg Immediate Operand*/
		arm.reg[dest]=arm.reg[op1]|((OPCODE&0xFF)<<(OPCODE&0xF0));
	}else{	/*IyhQ烌WX^*/
		op2=SOREG;
		arm.reg[dest]=arm.reg[op1]|arm.reg[op2];
	}
	if(arm.reg[dest])RF(Z_); else SF(Z_);
}

static void arm_rsb()
{	/*Rd := Op2 - Rn*/
	u8	op1, op2, dest;

	dest=DREG;
	op1=FOREG;
	if((OPCODE>>24)&0x2){
		arm.reg[dest]=((OPCODE&0xFF)<<(OPCODE&0xF0))-arm.reg[op1];
	}else{
		op2=SOREG;
		arm.reg[dest]=arm.reg[op2]-arm.reg[op1];
	}
	if(arm.reg[dest])RF(Z_); else SF(Z_);
}

static void arm_rsc()
{	/*Rd := Op2 - Rn - 1 + Carry*/
	u8	op1, op2, dest;

	dest=DREG;
	op1=FOREG;
	if((OPCODE>>24)&0x2){
		arm.reg[dest]=((OPCODE&0xFF)<<(OPCODE&0xF0))-arm.reg[op1]+FC-1;
	}else{
		op2=SOREG;
		arm.reg[dest]=arm.reg[op2]+arm.reg[op1]+FC-1;
	}
	if(arm.reg[dest])RF(Z_); else SF(Z_);
}

static void arm_sbc()
{	/*Rd := Rn - Op2 - 1 + Carry*/
	u8	op1, op2, dest;

	dest=DREG;
	op1=FOREG;
	if((OPCODE>>24)&0x2){
		arm.reg[dest]=arm.reg[op1]-((OPCODE&0xFF)<<(OPCODE&0xF0))+FC-1;
	}else{
		op2=SOREG;
		arm.reg[dest]=arm.reg[op1]-arm.reg[op2]+FC-1;
	}
	if(arm.reg[dest])RF(Z_); else SF(Z_);
}

static void arm_stc()
{	/*address := CRn*/

}

static void arm_stm()
{	/*Stack manipulation (Push)*/

}

static void arm_str()
{	/*<address> := Rd*/
	u32	opcode=OPCODE;
	u8	op2, base, dest;
	u32	offset, base_address;

	offset=opcode&0xFFF;
	dest=DREG;
	base=(u8)((opcode>>16)&0xF);	/*base register*/
	if((opcode>>25)&1){	/*1 = offset is a register*/
		op2=SOREG;
		base_address=arm.reg[base]+((arm.reg[op2])<<((opcode>>4)&0xFF));
	}else{	/*0 = offset is an immediate value*/
		base_address=arm.reg[base]+offset;
	}
	WMem32(base_address, arm.reg[dest]);
	
	if(base==15){	/*ΏۂPC̏ꍇ*/
		WMem32(base_address, RMem32(arm.reg[dest])+4);	
	}
}

static void arm_sub()
{	/*Rd := Rn - Op2*/
	u8	op1, op2, dest;

	dest=DREG;
	op1=FOREG;
	if((OPCODE>>24)&0x2){
		arm.reg[dest]=arm.reg[op1]-((OPCODE&0xFF)<<(OPCODE&0xF0));
	}else{
		op2=SOREG;
		arm.reg[dest]=arm.reg[op1]-arm.reg[op2];
	}
	if(arm.reg[dest])RF(Z_); else SF(Z_);
}

static void arm_swi()
{	/*OS call*/

}

static void arm_swp()
{	/*Rd := [Rn], [Rn] := Rm*/

}

static void arm_teq()
{	/*CPSR flags := Rn EOR Op2*/

}

static void arm_tst()
{	/*CPSR flags := Rn AND Op2*/

}

static int exec_arm_state()
{
	static char message[50];
	u8	pass=0, cond=0;

	u32	opcode=OPCODE;
	u8	opcode_21=(u8)((OPCODE>>21)&0xF);
	u8	opcode_24=(u8)((OPCODE>>24)&0xF);
	u8	opcode_26=(u8)((OPCODE>>26)&0xF);
	u8	opcode_4b=(u8)((OPCODE>>4)&0x1);
	u8	opcode_28=(u8)((OPCODE>>28)&0x0F);

	switch(opcode_28){
	case 0x0:	if(FZ)cond=1;break;
	case 0x1:	if(!FZ)cond=1;break;
	case 0x2:	if(FC)cond=1;break;
	case 0x3:	if(!FC)cond=1;break;
	case 0x4:	if(FN)cond=1;break;
	case 0x5:	if(!FN)cond=1;break;
	case 0x6:	if(FV)cond=1;break;
	case 0x7:	if(!FV)cond=1;break;
	case 0x8:	if(FC && !FZ)cond=1;break;
	case 0x9:	if(!FC || FZ)cond=1;break;
	case 0xA:	if(FN==FV)cond=1;break;
	case 0xB:	if(FN!=FV)cond=1;break;
	case 0xC:	if(!FZ && (FN==FV))cond=1;break;
	case 0xD:	if(FZ || (FN!=FV))cond=1;break;
	default:	break;
	}

	if(!cond){
		switch(opcode_24){
		case 0xA:	arm_b();pass=1;break;
		case 0xB:	arm_bl();pass=1;break;
		case 0xC:
		case 0xD:	arm_ldc();arm_stc();pass=1;break;
		case 0xE:	if(opcode_4b&0x01){arm_mrc();arm_mcr();}else{arm_cdp();}pass=1;break;
		case 0xF:	arm_swi();pass=1;break;
		default:	break;
		}

		if((opcode&0x0FFFFFF0)==0x012FFF10)arm_bx();
		else if(opcode_26==0x1){
			arm_ldr();
			arm_str();
		}
		else if(!(opcode&0x0C000000)){
			switch(opcode_21){
			case 0x0:	arm_and();break;
			case 0x1:	arm_eor();break;
			case 0x2:	arm_sub();break;
			case 0x3:	arm_rsb();break;
			case 0x4:	arm_add();break;
			case 0x5:	arm_adc();break;
			case 0x6:	arm_sbc();break;
			case 0x7:	arm_rsc();break;
			case 0x8:	arm_tst();break;
			case 0x9:	arm_teq();break;
			case 0xA:	arm_cmp();break;
			case 0xB:	arm_cmn();break;
			case 0xC:	arm_orr();break;
			case 0xD:	arm_mov();break;
			case 0xE:	arm_bic();break;
			case 0xF:	arm_mvn();break;
			}
		}else if(!opcode){
		}else if(!(opcode+1)){
		}else if(!pass){
			sprintf(message, "Unknow ARM opcode \"0x%08X\" at 0x%08X", OPCODE, PC);
			GBAEmu.MessageBox(message, NULL, MB_ICONSTOP);
		}
	}
	PC+=4;
	
	return 0;
}

void InitializeRegister()
{
	PC=0x08000000;
	SR=0x03007F00;
	CPSR=0x0000001F;
}

