// RegDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "GBAEmu.h"
#include "RegDlg.h"
#include "defines.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRegDlg _CAO

extern u32 RMem32(u32);
extern bool fRegDlg;
extern u8	fBreak;

CRegDlg::CRegDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CRegDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CRegDlg)
	m_fC = FALSE;
	m_fN = FALSE;
	m_fV = FALSE;
	m_fZ = FALSE;
	m_fIRQ = FALSE;
	m_fFIQ = FALSE;
	m_txtMode = _T("");
	m_txtOpcode = _T("");
	m_txtR0 = _T("");
	m_txtR1 = _T("");
	m_txtR10 = _T("");
	m_txtR11 = _T("");
	m_txtR13 = _T("");
	m_txtR14 = _T("");
	m_txtR12 = _T("");
	m_txtR15 = _T("");
	m_txtR16 = _T("");
	m_txtR2 = _T("");
	m_txtR3 = _T("");
	m_txtR4 = _T("");
	m_txtR5 = _T("");
	m_txtR6 = _T("");
	m_txtR7 = _T("");
	m_txtR8 = _T("");
	m_txtR9 = _T("");
	m_txtMnimonic = _T("");
	//}}AFX_DATA_INIT
}


void CRegDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRegDlg)
	DDX_Check(pDX, IDC_FLAG_C, m_fC);
	DDX_Check(pDX, IDC_FLAG_N, m_fN);
	DDX_Check(pDX, IDC_FLAG_V, m_fV);
	DDX_Check(pDX, IDC_FLAG_Z, m_fZ);
	DDX_Check(pDX, IDC_FLAG_IRQ, m_fIRQ);
	DDX_Check(pDX, IDC_FLAG_FIQ, m_fFIQ);
	DDX_Text(pDX, IDC_EDIT_MODE, m_txtMode);
	DDV_MaxChars(pDX, m_txtMode, 8);
	DDX_Text(pDX, IDC_EDIT_OPCODE, m_txtOpcode);
	DDV_MaxChars(pDX, m_txtOpcode, 8);
	DDX_Text(pDX, IDC_EDIT_R0, m_txtR0);
	DDV_MaxChars(pDX, m_txtR0, 8);
	DDX_Text(pDX, IDC_EDIT_R1, m_txtR1);
	DDV_MaxChars(pDX, m_txtR1, 8);
	DDX_Text(pDX, IDC_EDIT_R10, m_txtR10);
	DDV_MaxChars(pDX, m_txtR10, 8);
	DDX_Text(pDX, IDC_EDIT_R11, m_txtR11);
	DDV_MaxChars(pDX, m_txtR11, 8);
	DDX_Text(pDX, IDC_EDIT_R13, m_txtR13);
	DDV_MaxChars(pDX, m_txtR13, 8);
	DDX_Text(pDX, IDC_EDIT_R14, m_txtR14);
	DDV_MaxChars(pDX, m_txtR14, 8);
	DDX_Text(pDX, IDC_EDIT_R12, m_txtR12);
	DDV_MaxChars(pDX, m_txtR12, 8);
	DDX_Text(pDX, IDC_EDIT_R15, m_txtR15);
	DDV_MaxChars(pDX, m_txtR15, 8);
	DDX_Text(pDX, IDC_EDIT_R16, m_txtR16);
	DDV_MaxChars(pDX, m_txtR16, 8);
	DDX_Text(pDX, IDC_EDIT_R2, m_txtR2);
	DDV_MaxChars(pDX, m_txtR2, 8);
	DDX_Text(pDX, IDC_EDIT_R3, m_txtR3);
	DDX_Text(pDX, IDC_EDIT_R4, m_txtR4);
	DDV_MaxChars(pDX, m_txtR4, 8);
	DDX_Text(pDX, IDC_EDIT_R5, m_txtR5);
	DDV_MaxChars(pDX, m_txtR5, 8);
	DDX_Text(pDX, IDC_EDIT_R6, m_txtR6);
	DDV_MaxChars(pDX, m_txtR6, 8);
	DDX_Text(pDX, IDC_EDIT_R7, m_txtR7);
	DDV_MaxChars(pDX, m_txtR7, 8);
	DDX_Text(pDX, IDC_EDIT_R8, m_txtR8);
	DDV_MaxChars(pDX, m_txtR8, 8);
	DDX_Text(pDX, IDC_EDIT_R9, m_txtR9);
	DDV_MaxChars(pDX, m_txtR9, 8);
	DDX_Text(pDX, IDC_EDIT_MNIMONIC, m_txtMnimonic);
	DDV_MaxChars(pDX, m_txtMnimonic, 8);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CRegDlg, CDialog)
	//{{AFX_MSG_MAP(CRegDlg)
	ON_BN_CLICKED(IDC_BUTTON_CLOSE, OnButtonClose)
	ON_BN_CLICKED(IDC_BUTTON_NEXT, OnButtonNext)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRegDlg bZ[W nh

void CRegDlg::OnButtonClose() 
{
	OnClose();
}

void CRegDlg::OnButtonNext() 
{
	fBreak=1;
	AfxGetMainWnd()->SendMessage(WM_ACTIVATE, 0, 0);
	ShowRegisters();
}

void CRegDlg::ShowRegisters()
{
	UpdateData(true);
	m_txtR0.Format("%08X", R0);
	m_txtR1.Format("%08X", R1);
	m_txtR2.Format("%08X", R2);
	m_txtR3.Format("%08X", R3);
	m_txtR4.Format("%08X", R4);
	m_txtR5.Format("%08X", R5);
	m_txtR6.Format("%08X", R6);
	m_txtR7.Format("%08X", R7);
	m_txtR8.Format("%08X", R8);
	m_txtR9.Format("%08X", R9);
	m_txtR10.Format("%08X", R10);
	m_txtR11.Format("%08X", R11);
	m_txtR12.Format("%08X", R12);
	m_txtR13.Format("%08X", R13);
	m_txtR14.Format("%08X", R14);
	m_txtR15.Format("%08X", R15);
	m_txtR16.Format("%08X", R16);
	m_txtOpcode.Format("%08X", RMem32(PC));
	switch(R16&0x1F){
		case 0x10: m_txtMode="User";break;
		case 0x11: m_txtMode="FIQ";break;
		case 0x12: m_txtMode="IRQ";break;
		case 0x13: m_txtMode="Supervisor";break;
		case 0x17: m_txtMode="Abort";break;
		case 0x1B: m_txtMode="Undefined";break;
		case 0x1F: m_txtMode="System";break;
		default: m_txtMode="???";break;
	}
	m_fN=(CPSR&N_)?true:false;
	m_fZ=(CPSR&Z_)?true:false;
	m_fC=(CPSR&C_)?true:false;
	m_fV=(CPSR&V_)?true:false;
	m_fIRQ=(CPSR&I_)?true:false;
	m_fFIQ=(CPSR&F_)?true:false;
	if(CPSR&F_)CheckRadioButton(IDC_RADIO_STATE1, IDC_RADIO_STATE2, IDC_RADIO_STATE2);
	else CheckRadioButton(IDC_RADIO_STATE1, IDC_RADIO_STATE2, IDC_RADIO_STATE1);
	UpdateData(false);
}


void CRegDlg::OnClose()
{
	fRegDlg=false;
	CDialog::OnClose();
}

BOOL CRegDlg::PreTranslateMessage(MSG* pMsg) 
{
/*	if(pMsg->message==WM_KEYDOWN){
		switch(pMsg->wParam){
		case VK_RETURN:
			if(GetFocus()->GetDlgCtrlID()!=IDC_BUTTON_NEXT)
			return TRUE;
		case VK_ESCAPE:
			return TRUE;
		default:
			break;
		}
	}*/
	
	return CDialog::PreTranslateMessage(pMsg);
}
