
/*	
	GameboyVM - Nintendo Gameboy Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbemu/
*/


void InitializeMemory();
static int WMem(u16, u8);
_inline u8 RMem(u16);

void InitializeMemory()
{ /*oN֖̐ؑΉ*/
/*	u32 copy_loop;

	for(copy_loop=0; copy_loop<S32_SIZE; copy_loop++)
		MEM[copy_loop]=ROM[0][copy_loop];*/
	memset(MEM, 0x00, MEM_SIZE);

	MEM[R_P1]=0xCF;

	MEM[R_TIMA]=0x00;
	MEM[R_TMA]=0x00;
	MEM[R_TAC]=0x00;

	MEM[R_NR10]=0x80;
	MEM[R_NR11]=0xBF;
	MEM[R_NR12]=0xF3;
	MEM[R_NR14]=0xBF;
	MEM[R_NR21]=0x3F;
	MEM[R_NR22]=0x00;
	MEM[R_NR24]=0xBF;
	MEM[R_NR30]=0x7F;
	MEM[R_NR31]=0xFF;
	MEM[R_NR32]=0x9F;
	MEM[R_NR34]=0xBF;
	MEM[R_NR41]=0xFF;
	MEM[R_NR42]=0x00;
	MEM[R_NR43]=0x00;
	MEM[R_NR44]=0xBF;
	MEM[R_NR50]=0x77;
	MEM[R_NR51]=0xF3;
	MEM[R_NR52]=0xF1;

	MEM[R_LCDC]=0x91;
	MEM[R_SCY]=0x00;
	MEM[R_SCX]=0x00;
	MEM[R_LYC]=0x00;
	MEM[R_BGP]=0xFC;
	MEM[R_OBP0]=0xFF;
	MEM[R_OBP1]=0xFF;
	MEM[R_WY]=0x00;
	MEM[R_WX]=0x00;
	MEM[R_IE]=0x00;
}

static int WMem(u16 adr, u8 mem)
{	/*Write memory, (1=ݕs,0=݉)*/
	u16 copy_loop;
	u8	mbc_type=ROM[0][0x147];

	if(0x01<=mbc_type && mbc_type<=0x03){	/*MBC1*/
		if(0x2000<=adr && adr<0x4000){
			mem&=0x1F;	/*XXXBBBBB*/
			if(ROM[0][0x148]==0x01)mem&=0x03;	/*I[ot[΍*/
			if(ROM[0][0x148]==0x02)mem&=0x07;
			if(ROM[0][0x148]==0x03)mem&=0x0F;
			if(mem==0)mem++;	/*ROM Bank#10͎włȂ*/
			mbc=mem;
			return 0;
		}
	}

	if(mbc_type==0x02||mbc_type==0x03){	/*MBC1:RAM*/
		if(0x0000<=adr && adr<0x2000){	/*RAMoÑ݂tO*/
			if((mem&0x0F)==0x0A)e_rambc=1;
			else e_rambc=0;
		}else if(0x4000<=adr && adr<0x6000){
			rambc=mem&=0x03;	/*XXXXXXBB*/
			return 0;
		}else if(0xA000<=adr && adr<0xC000 && e_rambc){
			RAM[rambc][adr-0xA000]=mem;
			return 0;
		}
	}else if(0xA000<=adr && adr<0xC000){
		RAM[0][adr-0xA000]=mem;
		return 0;
	}

	if(mbc_type==0x05||mbc_type==0x06){	/*MBC2*/
		if(0x2000<=adr && adr<0x4000){
			mem&=0x0F;	/*XXXXBBBB*/
			if(ROM[0][0x148]==0x01)mem&=0x03;	/*I[ot[΍*/
			if(ROM[0][0x148]==0x02)mem&=0x07;
			if(mem==0)mem++;	/*ROM Bank#10͎włȂ*/
			mbc=mem;
			return 0;
		}
	}

	if(0x0000<=adr && adr<0x8000)return 1;	/*ROMJ[gbẄ*/
	if(0xFEA0<=adr && adr<0xFF00)return 1;	/*\ς݃*/

	if(MEM[R_STAT] & 0x02){
/*		if(0xFE00<=adr && adr<0xFEA0) return 1;*/	/*mode2*/
		if(MEM[R_STAT] & 0x01){
/*			if(0x8000<=adr && adr<0xA000) return 1;*/	/*mode3*/
		}
	}

	if(0xC000<=adr && adr<0xDE00){
		MEM[adr]=MEM[adr+0x2000]=mem;
		return 0;				/* RAMi~[̈*/
	}
	if(0xE000<=adr && adr<0xFE00){
		MEM[adr]=MEM[adr-0x2000]=mem;	/* ~[*/
		return 0;
	}

	if(R_STAT==adr){
		MEM[adr]=mem&0xF8;	/*3bitmodetO*/
		return 0;
	}

	if(R_P1==adr){	/*4-5bit݂oȂ*/
		if(mem&0x10)MEM[adr]|=0x10;
		else MEM[adr]&=0xEF;
		if(mem&0x20)MEM[adr]|=0x20;
		else MEM[adr]&=0xDF;
		return 0;
	}

	if(R_DIV==adr){
		MEM[adr]=0x00;
		return 0;
	}

	if(R_LY==adr)return 1;	/*LY͓ǎp*/

	if(R_DMA==adr){	/*DMA]*/
		MEM[adr]=mem;
		tmp16=(u16)(mem<<8);	/*0x100PʂŎwł*/
		if(0xF100<=tmp16)return 2;	/*͈͊O̓]*/
		copy_loop=0xFE00;
		while(copy_loop<0xFEA0){
			MEM[copy_loop++]=RMem(tmp16++);
		}
	}


	MEM[adr]=mem;

	return 0;
}

_inline u8 RMem(u16 adr)
{
	if(0x0000<=adr && adr<0x4000)return ROM[0][adr];/*oNO*/
	if(0x4000<=adr && adr<0x8000)return ROM[mbc][adr-0x4000];/*oNP`*/

	if(0xA000<=adr && adr<0xC000){
		return RAM[rambc][adr-0xA000];
	}

	if(R_P1==adr){
		MEM[R_P1]=(MEM[R_P1]&0xF0)|(((MEM[R_P1]&0x10)?0xF:(keyflag&0xF))&
		((MEM[R_P1]&0x20)?0xF:((keyflag>>4)&0xF)));
		return MEM[R_P1];
	}

	return MEM[adr];
}

