
/*	
	GameboyVM - Nintendo Gameboy Emulator
	Copyright 2002 Y_N y_n@users.sourceforge.jp
	Homepage https://sourceforge.jp/projects/gbemu/
*/



void InitializeMemory();
static void WMem(u16, u8);
_inline u8 RMem(u16);

u8 rom_size[]={	/*wb_[148h̃oN Bank=X*2+1 */
	0x01, 0x03, 0x07, 0x0F, 0x1F,
};


void InitializeMemory()
{ /*oN֖̐ؑΉ*/
/*	u32 copy_loop;

	for(copy_loop=0; copy_loop<S32_SIZE; copy_loop++)
		MEM[copy_loop]=ROM[0][copy_loop];*/
	memset(MEM, 0x00, MEM_SIZE);

	MEM[R_P1]=0xCF;

	MEM[R_TIMA]=0x00;
	MEM[R_TMA]=0x00;
	MEM[R_TAC]=0x00;

	MEM[R_NR10]=0x80;
	MEM[R_NR11]=0xBF;
	MEM[R_NR12]=0xF3;
	MEM[R_NR14]=0xBF;
	MEM[R_NR21]=0x3F;
	MEM[R_NR22]=0x00;
	MEM[R_NR24]=0xBF;
	MEM[R_NR30]=0x7F;
	MEM[R_NR31]=0xFF;
	MEM[R_NR32]=0x9F;
	MEM[R_NR34]=0xBF;
	MEM[R_NR41]=0xFF;
	MEM[R_NR42]=0x00;
	MEM[R_NR43]=0x00;
	MEM[R_NR44]=0xBF;
	MEM[R_NR50]=0x77;
	MEM[R_NR51]=0xF3;
	MEM[R_NR52]=0xF1;

	MEM[R_LCDC]=0x91;
	MEM[R_SCY]=0x00;
	MEM[R_SCX]=0x00;
	MEM[R_LYC]=0x00;
	MEM[R_BGP]=0xFC;
	MEM[R_OBP0]=0xFF;
	MEM[R_OBP1]=0xFF;
	MEM[R_WY]=0x00;
	MEM[R_WX]=0x00;
	MEM[R_IE]=0x00;
}

static void WMem(u16 adr, u8 val)
{	/*Write valory, (1=ݕs,0=݉)*/
	static u16 copy_loop, tmp16;
	static u8 mbc_type=ROM[0][0x147];

	if(0x01<=mbc_type && mbc_type<=0x03){	/*MBC1:ROM*/
		if(0x2000<=adr && adr<0x4000){
			val&=0x1F;	/*XXXBBBBB*/
			val&=rom_size[(ROM[0][0x148])];	/*I[ot[΍*/
			if(!val)val++;	/*ROM Bank#10͎włȂ*/
			mbc=val;
			return;
		}
		if(0x02<=mbc_type){					/*MBC1:RAM*/
			if(0x0000<=adr && adr<0x2000){	/*RAMoNtO*/
				e_rambc=((val&0x0F)==0x0A)?1:0;
				return;
			}else if(0x4000<=adr && adr<0x6000){	/*oN̑I*/
				rambc=val&0x03;	/*XXXXXXBB*/
				return;
			}else if(0xA000<=adr && adr<0xC000){
				if(e_rambc)RAM[rambc][adr-0xA000]=val;	/*tOLȂ*/
				return;
			}
		}
	}

	if(mbc_type==0x05 || mbc_type==0x06){	/*MBC2:ROM*/
		if(0x2000<=adr && adr<0x4000){
			val&=0x0F;	/*XXXXBBBB*/
			val&=rom_size[(ROM[0][0x148])];	/*I[ot[΍*/
			if(val==0)val++;	/*ROM Bank#10͎włȂ*/
			mbc=val;
			return;
		}
	}
	
	if(0xA000<=adr && adr<0xC000){	/*J[gbWRAM*/
		adr-=0xA000;
		RAM[0][adr]=val;
		return;
	}

	/*if(0xFEA0<=adr && adr<0xFF00)return;*/	/*\ς݃*/

	if(MEM[R_STAT] & 0x02){
/*		if(0xFE00<=adr && adr<0xFEA0) return;*/	/*mode2*/
		if(MEM[R_STAT] & 0x01){
/*			if(0x8000<=adr && adr<0xA000) return;*/	/*mode3*/
		}
	}

	if(0xC000<=adr && adr<0xDE00){	/*RAM(DE00h-E000h̓~[Ȃ)*/
		MEM[adr]=val;
		adr+=0x2000;
		MEM[adr]=val;
		return;
	}

	if(0xE000<=adr && adr<0xFE00){	/*RAM̃~[*/
		MEM[adr]=val;
		adr-=0x2000;
		MEM[adr]=val;
		return;
	}

	if(R_STAT==adr){
		MEM[adr]=val&0xF8;	/*3bitmodetO*/
		return;
	}

	if(R_P1==adr){	/*4-5bit݂oȂ*/
		if(val&0x10)MEM[adr]|=0x10;
		else MEM[adr]&=0xEF;
		if(val&0x20)MEM[adr]|=0x20;
		else MEM[adr]&=0xDF;
		return;
	}

	if(R_DIV==adr){
		MEM[adr]=0x00;
		return;
	}

	if(R_DMA==adr){	/*DMA]*/
		MEM[adr]=val;
		tmp16=(u16)(val<<8);	/*0x100PʂŎwł*/
		if(0xF100<=tmp16)return;	/*͈͊O̓]*/
		copy_loop=0xFE00;
		while(copy_loop<0xFEA0){
			MEM[copy_loop++]=RMem(tmp16++);
		}
	}

	if(0x0000<=adr && adr<0x8000)return;	/*ROMJ[gbẄ*/
	if(R_LY==adr)return;	/*LY͓ǎp*/

	MEM[adr]=val;
}

_inline u8 RMem(u16 adr)
{
	u8 tmp8;

	if(0x0000<=adr && adr<0x4000){
		return ROM[0][adr];/*oNO*/
	}
	
	if(0x4000<=adr && adr<0x8000){
		adr-=0x4000;
		return ROM[mbc][adr];/*oNP`*/
	}

	if(0xA000<=adr && adr<0xC000){
		adr-=0xA000;
		return RAM[rambc][adr];
	}

	if(R_P1==adr){
		tmp8=MEM[adr];
		MEM[adr]=(tmp8&0xF0)|(((tmp8&0x10)?0xF:(keyflag&0xF))&
				((tmp8&0x20)?0xF:((keyflag>>4)&0xF)));
		return MEM[adr];
	}

	return MEM[adr];
}

