// DmaDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "gbemu.h"
#include "DmaDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define	_ASM_

extern DWORD dwSize;
LPBITMAPINFO dma_info = (LPBITMAPINFO)new char[dwSize];
LPBITMAPINFO char_info = (LPBITMAPINFO)new char[dwSize];

CDC* pSDC;
CDC* pDDC;
extern bool fDmaDlg;
extern BYTE RmemB(UINT,WORD);
extern void WmemB(UINT,WORD,BYTE);
extern BYTE MEM[0x10000];
extern BYTE Colours[4];
extern UINT HexToInt(char *hexstr);
extern BYTE rsize;
extern BYTE *ROM[32];
extern int CheckExtensionName(char* filename, char* extension);
BYTE	ObjBuffer[8*8];
BYTE	PenColor;
bool	fEdit;
bool	fShift;

/////////////////////////////////////////////////////////////////////////////
// CDmaDlg _CAO


CDmaDlg::CDmaDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDmaDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDmaDlg)
	m_txtDma = _T("0000");
	m_txtOffset = 16;
	m_txtBank = 1;
	//}}AFX_DATA_INIT
}


void CDmaDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDmaDlg)
	DDX_Control(pDX, IDC_SCROLLBAR_BANK, m_scrBank);
	DDX_Control(pDX, IDC_SCROLLBAR_DMA, m_scrDma);
	DDX_Text(pDX, IDC_DMA_ADDRESS, m_txtDma);
	DDX_Text(pDX, IDC_EDIT_OFFSET, m_txtOffset);
	DDV_MinMaxUInt(pDX, m_txtOffset, 0, 384);
	DDX_Text(pDX, IDC_EDIT_BANK, m_txtBank);
	DDV_MinMaxUInt(pDX, m_txtBank, 0, 512);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDmaDlg, CDialog)
	//{{AFX_MSG_MAP(CDmaDlg)
	ON_WM_CLOSE()
	ON_WM_PAINT()
	ON_WM_VSCROLL()
	ON_BN_CLICKED(IDC_BUTTON_GO, OnButtonGo)
	ON_WM_SETCURSOR()
	ON_EN_CHANGE(IDC_EDIT_OFFSET, OnChangeEditOffset)
	ON_WM_LBUTTONDOWN()
	ON_BN_CLICKED(IDC_CHECK_EDIT, OnCheckEdit)
	ON_BN_CLICKED(IDC_BUTTON_RESET, OnButtonReset)
	ON_BN_CLICKED(IDC_BUTTON_WRITE, OnButtonWrite)
	ON_EN_KILLFOCUS(IDC_EDIT_BANK, OnKillfocusEditBank)
	ON_BN_CLICKED(IDC_BUTTON_SAVE, OnButtonSave)
	ON_BN_CLICKED(IDC_BUTTON_SAVEBIN, OnButtonSavebin)
	ON_BN_CLICKED(IDC_BUTTON_LOADBIN, OnButtonLoadbin)
	ON_WM_HSCROLL()
	ON_BN_CLICKED(IDC_PALETTE0, OnPalette0)
	ON_BN_CLICKED(IDC_PALETTE1, OnPalette1)
	ON_BN_CLICKED(IDC_PALETTE2, OnPalette2)
	ON_BN_CLICKED(IDC_PALETTE3, OnPalette3)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDmaDlg bZ[W nh

BOOL CDmaDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	t_num = 0;
	fEdit = false;
	fShift= false;
	memset(ObjBuffer,0,8*8);

	RECT	DlgSize;
	SetRect(&DlgSize, 0, 0, 350, 345);
	AdjustWindowRect(&DlgSize, WS_OVERLAPPEDWINDOW, TRUE);
	CDialog::SetWindowPos(&wndTop, 0, 0, DlgSize.right - DlgSize.left,
							DlgSize.bottom - DlgSize.top, SWP_NOMOVE);

	pDDC=GetDlgItem(IDC_IMAGE_TILES)->GetDC();
	pSDC=GetDlgItem(IDC_IMAGE_CHAR)->GetDC();

	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_IMAGE_CHAR), 0, 5, 5, 170, 170, SWP_NOACTIVATE|SWP_NOZORDER);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_BUTTON_RESET), 0, 260, 5, 80, 20, SWP_NOACTIVATE|SWP_NOZORDER);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_BUTTON_WRITE), 0, 260, 30, 80, 20, SWP_NOACTIVATE|SWP_NOZORDER);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_BUTTON_LOADBIN), 0, 260, 60, 80, 20, SWP_NOACTIVATE|SWP_NOZORDER);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_BUTTON_SAVEBIN), 0, 260, 85, 80, 20, SWP_NOACTIVATE|SWP_NOZORDER);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_BUTTON_SAVE), 0, 260, 115, 80, 60, SWP_NOACTIVATE|SWP_NOZORDER);

	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_PALETTE0), 0, 190, 20, 26, 26, SWP_NOACTIVATE|SWP_NOZORDER);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_PALETTE1), 0, 190, 50, 26, 26, SWP_NOACTIVATE|SWP_NOZORDER);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_PALETTE2), 0, 190, 80, 26, 26, SWP_NOACTIVATE|SWP_NOZORDER);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_PALETTE3), 0, 190, 110, 26, 26, SWP_NOACTIVATE|SWP_NOZORDER);

	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_IMAGE_TILES), 0, 5, 195, 221, 149, SWP_NOACTIVATE|SWP_NOZORDER);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_SCROLLBAR_DMA), 0, 226, 195, 18, 145, SWP_NOACTIVATE|SWP_NOZORDER);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_SCROLLBAR_BANK), 0, 5, 343	, 219, 18, SWP_NOACTIVATE|SWP_NOZORDER);

	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_CHECK_EDIT), 0, 250, 195, 70, 20, SWP_NOACTIVATE|SWP_NOZORDER);

	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_EDIT_OFFSET), 0, 295, 250, 40, 18, SWP_NOACTIVATE|SWP_NOZORDER);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_EDIT_BANK), 0, 295, 280, 40, 18, SWP_NOACTIVATE|SWP_NOZORDER);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_DMA_ADDRESS), 0, 295, 310, 40, 18, SWP_NOACTIVATE|SWP_NOZORDER);

	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_STATIC_OFFSET), 0, 250, 250, 40, 18, SWP_NOACTIVATE|SWP_NOZORDER);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_STATIC_BANK), 0, 250, 280, 40, 18, SWP_NOACTIVATE|SWP_NOZORDER);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_BUTTON_GO), 0, 250, 310, 40, 18, SWP_NOACTIVATE|SWP_NOZORDER);

	DmaAdr = 0x0000;
	m_scrDma.SetScrollRange(0, 0x800, TRUE);
	m_scrBank.SetScrollRange(1, rsize-1, TRUE);

	m_scrDma.SetScrollPos(DmaAdr>>4, TRUE);
	m_scrBank.SetScrollPos(1, TRUE);

	OnPalette3();

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CDmaDlg::OnOK()
{

}

BOOL CDmaDlg::PreTranslateMessage(MSG* pMsg) 
{
/*	if(pMsg->message==WM_KEYDOWN){
		switch(pMsg->wParam){
		case VK_ESCAPE:
			return false;
		case VK_DOWN:
			if((DmaAdr+0x10)>=0x7FB0)DmaAdr=0x7FB0;
			else DmaAdr+=0x10;
			m_scrDma.SetScrollPos(DmaAdr>>4, TRUE);
			ShowDma();
			break;
		case VK_UP:
			if((DmaAdr-0x10)<=0x0000)DmaAdr=0x0000;
			else DmaAdr-=0x10;
			m_scrDma.SetScrollPos(DmaAdr>>4, TRUE);
			ShowDma();
			break;
		default: break;
		}
	}*/
	if(pMsg->message==WM_KEYDOWN){
		switch(pMsg->wParam){
		case VK_ESCAPE:
			return TRUE;
		case VK_SHIFT:
			fShift=true;
			break;
		case VK_RIGHT:
			if(!fEdit){
				if(t_num>=383){
					t_num=0;
					ShowDma();
				}else{
					t_num++;
					ShowDma();
				}
			}
			break;
		case VK_LEFT:
			if(!fEdit){
				if(t_num==0){
					t_num=383;
					ShowDma();
				}else{
					t_num--;
					ShowDma();
				}
			}
			break;
		case VK_DOWN:
			if(!fEdit){
				if(t_num>=360){
					t_num-=360;
					ShowDma();
				}else{
					t_num+=24;
					ShowDma();
				}
			}
			break;
		case VK_UP:
			if(!fEdit){
				if(t_num<24){
					t_num+=360;
					ShowDma();
				}else{
					t_num-=24;
					ShowDma();
				}
			}
			break;
		}
	}
	if(pMsg->message==WM_KEYUP){
		switch(pMsg->wParam){
		case VK_SHIFT:
			fShift=false;
			break;
		}
	}



	return CDialog::PreTranslateMessage(pMsg);
}

void CDmaDlg::ShowDma()
{
	unsigned int tdpy, tmpx, tmpy;
	unsigned char tdd, tds;
	unsigned short tda;
	unsigned char DmaBuffer[216*144];
	unsigned int fba;
	UINT bank;
	COLORREF SysBGPalette;

	tda = DmaAdr;
	
	ShowDmaChar();

	UpdateData(true);
	m_txtDma.Format("%04X", DmaAdr+(0x10*t_num));
	bank = m_txtBank;
	UpdateData(false);

	for(tmpy=0; tmpy<144; tmpy++){
		for(tmpx=0; tmpx<216; tmpx++){
			DmaBuffer[tmpx+tmpy*216]=4;
		}
	}

	for(tmpy=0; tmpy<144; tmpy+=9){		// }bvf[^
		for(tmpx=0; tmpx<216; tmpx+=9){
			for(tdpy=0; tdpy<8; tdpy++){	// ^Cf[^
				tdd = RmemB(bank, tda++);		// 1oCgڂ̃^Cf[^
				tds = RmemB(bank, tda++);	// 2oCgڂ̃^Cf[^
				fba=tdpy*216+tmpx+tmpy*216;
#ifdef	_ASM_
				__asm{
					mov		dl, 80h
					mov		eax, fba
					lea		edi, [DmaBuffer+eax]
bg_start_loop:
					mov		al, tdd		; tdd&tds&tilebit
					mov		cl, tds
					and		al, cl
					and		al, dl
					cmp		al, dl
					jnz		bg_palette0
					mov		cl, 3
					mov		[edi], cl
					jmp		bg_palette3
bg_palette0:
					mov		al, tdd		; ~tdd&tds&tilebit
					mov		cl, tds
					not		al
					and		al, cl
					and		al, dl
					cmp		al, dl
					jnz		bg_palette1
					mov		cl, 2
					mov		[edi], cl
					jmp		bg_palette3
bg_palette1:
					mov		al, tdd		; tdd&~tds&tilebit, 
					mov		cl, tds
					not		cl
					and		al, cl
					and		al, dl
					cmp		al, dl
					jnz		bg_palette2
					mov		cl, 1
					mov		[edi], cl
					jmp		bg_palette3
bg_palette2:
					mov		al, tdd		; ~tdd&~tds&tilebit
					mov		cl, tds
					and		al, cl
					and		al, dl
					cmp		al, dl
					jz		bg_palette3
					xor		ecx, ecx
					mov		[edi], cl
bg_palette3:
					inc		edi
					shr		dl, 1
					jnz		bg_start_loop
				}
#else
				unsigned char *dbuf=&DmaBuffer[fba];
				for(unsigned char tilebit=0x80; tilebit; tilebit>>=1, dbuf++){
					if(~tdd&~tds&tilebit)*dbuf=0;
					if(tdd&~tds&tilebit)*dbuf=1;
					if(~tdd&tds&tilebit)*dbuf=2;
					if(tdd&tds&tilebit)*dbuf=3;
				}
#endif	/*_ASM_*/
			}
		}
	}

	memset(dma_info, 0, sizeof(BITMAPINFOHEADER));
	dma_info->bmiHeader.biSize		= sizeof(BITMAPINFOHEADER);
	dma_info->bmiHeader.biWidth		= 216;
	dma_info->bmiHeader.biHeight	= -144;
	dma_info->bmiHeader.biPlanes	= 1;
	dma_info->bmiHeader.biBitCount	= 8;

	/*BGPWX^pbgϊ*/
	dma_info->bmiColors[0].rgbBlue		=
	dma_info->bmiColors[0].rgbGreen	=
	dma_info->bmiColors[0].rgbRed		= Colours[0];
	dma_info->bmiColors[0].rgbReserved = 0;
	dma_info->bmiColors[1].rgbBlue		=
	dma_info->bmiColors[1].rgbGreen	=
	dma_info->bmiColors[1].rgbRed		= Colours[1];
	dma_info->bmiColors[1].rgbReserved	= 0;
	dma_info->bmiColors[2].rgbBlue		=
	dma_info->bmiColors[2].rgbGreen	=
	dma_info->bmiColors[2].rgbRed		= Colours[2];
	dma_info->bmiColors[2].rgbReserved	= 0;
	dma_info->bmiColors[3].rgbBlue		=
	dma_info->bmiColors[3].rgbGreen	=
	dma_info->bmiColors[3].rgbRed		= Colours[3];
	dma_info->bmiColors[3].rgbReserved = 0;
	SysBGPalette=GetSysColor(COLOR_3DLIGHT);
	dma_info->bmiColors[4].rgbBlue = (unsigned char)(SysBGPalette>>16);
	dma_info->bmiColors[4].rgbGreen = (unsigned char)(SysBGPalette>>8);
	dma_info->bmiColors[4].rgbRed = (unsigned char)(SysBGPalette);
	dma_info->bmiColors[4].rgbReserved = 0;

	HDC	hMemDC	= ::CreateCompatibleDC(pDDC->m_hDC);
	HBITMAP	hBitmap	= ::CreateDIBitmap(pDDC->m_hDC, &dma_info->bmiHeader, CBM_INIT, DmaBuffer, dma_info, DIB_RGB_COLORS);
	HBITMAP	hOldmap	= (HBITMAP)::SelectObject(hMemDC, hBitmap);

	::BitBlt(pDDC->m_hDC, 2, 2, 215, 143, hMemDC, 0, 0, SRCCOPY);
	::DeleteObject(hBitmap);

	CBrush cbrush;
	RECT setrect;

	int tx1, ty1;
	int tx, ty;

	tx1=t_num;
	ty1=0;
	while(tx1>=24){
		tx1-=24;
		ty1++;
	}
	if(t_num>=384)ty1=200;	/*384ȏ̏ꍇ͈͂܂Ȃ*/

	tx=9*tx1;
	ty=9*ty1;

	if(!tx)tx++;
	if(!ty)ty++;
	if(tx==9*23)tx--;
	if(ty==9*15)ty--;

	tx++;
	ty++;
	cbrush.CreateSolidBrush(RGB(255, 0, 0));	/*^C̑I*/
	SetRect(&setrect, tx, ty, 10+tx, 10+ty);
	pDDC->FrameRect(&setrect, &cbrush);
	cbrush.DeleteObject();
}

void CDmaDlg::OnClose()
{
	fDmaDlg = false;

	CDialog::OnClose();
}

void CDmaDlg::OnPaint() 
{
	CPaintDC dc(this); // `p̃foCX ReLXg

	COLORREF rectcolor;

	rectcolor = RGB(Colours[0], Colours[0], Colours[0]);
	GetDlgItem(IDC_PALETTE0)->GetDC()->FillSolidRect(1, 1, 18, 18, rectcolor);
	rectcolor=RGB(Colours[1], Colours[1], Colours[1]);
	GetDlgItem(IDC_PALETTE1)->GetDC()->FillSolidRect(1, 1, 18, 18, rectcolor);
	rectcolor=RGB(Colours[2], Colours[2], Colours[2]);
	GetDlgItem(IDC_PALETTE2)->GetDC()->FillSolidRect(1, 1, 18, 18, rectcolor);
	rectcolor=RGB(Colours[3], Colours[3], Colours[3]);
	GetDlgItem(IDC_PALETTE3)->GetDC()->FillSolidRect(1, 1, 18, 18, rectcolor);

	ShowDma();
}

void CDmaDlg::OnButtonGo() 
{
	UpdateData(true);
	DmaAdr = HexToInt(m_txtDma.GetBuffer(10));
	UpdateData(false);

	m_txtDma.ReleaseBuffer();
	ShowDma();
}

void CDmaDlg::ShowDmaChar()
{
	unsigned int tdpy;
	unsigned char tdd, tds, charbit;
	unsigned short tda=0x8000;
	unsigned char CharBuffer[8*8];
	unsigned int fba;
	UINT bank;

	UpdateData(true);
	bank = m_txtBank;
	UpdateData(false);

	tda=DmaAdr+(0x10*t_num);

	for(tdpy=0; tdpy<8; tdpy++){	// ^Cf[^
		tdd = RmemB(bank, tda++);		// 1oCgڂ̃^Cf[^
		tds = RmemB(bank, tda++);	// 2oCgڂ̃^Cf[^
		fba=tdpy*8;
		for(charbit=0x80; charbit; charbit=charbit>>1, fba++){
			if(~tdd&~tds&charbit)CharBuffer[fba]=0;
			if(tdd&~tds&charbit)CharBuffer[fba]=1;
			if(~tdd&tds&charbit)CharBuffer[fba]=2;
			if(tdd&tds&charbit)CharBuffer[fba]=3;
		}
	}

	memset(char_info, 0, sizeof(BITMAPINFOHEADER));
	char_info->bmiHeader.biSize	= sizeof(BITMAPINFOHEADER);
	char_info->bmiHeader.biWidth	= 8;
	char_info->bmiHeader.biHeight	= -8;
	char_info->bmiHeader.biPlanes	= 1;
	char_info->bmiHeader.biBitCount	= 8;

	// BGPWX^pbgϊ
	char_info->bmiColors[0].rgbBlue =
	char_info->bmiColors[0].rgbGreen =
	char_info->bmiColors[0].rgbRed = Colours[0];
	char_info->bmiColors[0].rgbReserved = 0;
	char_info->bmiColors[1].rgbBlue =
	char_info->bmiColors[1].rgbGreen =
	char_info->bmiColors[1].rgbRed = Colours[1];
	char_info->bmiColors[1].rgbReserved = 0;
	char_info->bmiColors[2].rgbBlue =
	char_info->bmiColors[2].rgbGreen =
	char_info->bmiColors[2].rgbRed = Colours[2];
	char_info->bmiColors[2].rgbReserved = 0;
	char_info->bmiColors[3].rgbBlue =
	char_info->bmiColors[3].rgbGreen =
	char_info->bmiColors[3].rgbRed = Colours[3];
	char_info->bmiColors[3].rgbReserved = 0;

	HBITMAP	hBitmap;
	HDC	hMemDC	= ::CreateCompatibleDC(pSDC->m_hDC);
	if(fEdit){
		hBitmap	= ::CreateDIBitmap(pSDC->m_hDC, &char_info->bmiHeader, CBM_INIT, ObjBuffer, char_info, DIB_RGB_COLORS);
	}else{
		hBitmap	= ::CreateDIBitmap(pSDC->m_hDC, &char_info->bmiHeader, CBM_INIT, CharBuffer, char_info, DIB_RGB_COLORS);
	}

	HBITMAP	hOldmap	= (HBITMAP)::SelectObject(hMemDC, hBitmap);
	::StretchBlt(pSDC->m_hDC, 2, 2, 160, 160, hMemDC, 0, 0, 8, 8, SRCCOPY);
	::DeleteObject(hBitmap);
}

BOOL CDmaDlg::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
	if(pWnd==GetDlgItem(IDC_IMAGE_CHAR))
	{
		HCURSOR hCursor = AfxGetApp()->LoadCursor(IDC_PAINT_CURSOR);
		::SetCursor(hCursor);
		return TRUE;
	}
	
	return CDialog::OnSetCursor(pWnd, nHitTest, message);
}

void CDmaDlg::OnChangeEditOffset() 
{
	// TODO: ꂪ RICHEDIT Rg[̏ꍇARg[́A lParam }XN
	// ł̘_a ENM_CHANGE tOt CRichEditCrtl().SetEventMask()
	// bZ[WRg[֑邽߂ CDialog::OnInitDialog() ֐I[o[
	// ChȂ肱̒ʒm𑗂܂B
	
	UpdateData(true);
	t_num=m_txtOffset;
	UpdateData(false);
	ShowDma();
	
}

void CDmaDlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
	POINT	pos;
	UINT x,y;

	GetCursorPos(&pos);
	ScreenToClient(&pos);

	x = (pos.x-12)/20;
	y = (pos.y-12)/20;

	if(x<8 && y<8){
		if(fEdit){
			ObjBuffer[x+y*8] = PenColor;
		}else{
			MessageBox("Please check \"Edit enable\".", 0, MB_ICONINFORMATION);
		}
	}

	ShowDma();

	CDialog::OnLButtonDown(nFlags, point);
}

void CDmaDlg::OnCheckEdit() 
{
	CButton* pBPchk = (CButton*)GetDlgItem(IDC_CHECK_EDIT);
	
	if(fEdit){
		fEdit=false;
		pBPchk->SetCheck(0);

		GetDlgItem(IDC_BUTTON_RESET)->EnableWindow(false);
		GetDlgItem(IDC_BUTTON_WRITE)->EnableWindow(false);
		GetDlgItem(IDC_BUTTON_LOADBIN)->EnableWindow(false);
		GetDlgItem(IDC_SCROLLBAR_DMA)->EnableWindow(true);
		GetDlgItem(IDC_SCROLLBAR_BANK)->EnableWindow(true);
		GetDlgItem(IDC_BUTTON_GO)->EnableWindow(true);
		GetDlgItem(IDC_EDIT_OFFSET)->EnableWindow(true);
		GetDlgItem(IDC_EDIT_BANK)->EnableWindow(true);
		GetDlgItem(IDC_DMA_ADDRESS)->EnableWindow(true);
	}else{
		fEdit=true;
		pBPchk->SetCheck(1);

		OnButtonReset();

		GetDlgItem(IDC_BUTTON_RESET)->EnableWindow(true);
		GetDlgItem(IDC_BUTTON_WRITE)->EnableWindow(true);
		GetDlgItem(IDC_BUTTON_LOADBIN)->EnableWindow(true);
		GetDlgItem(IDC_SCROLLBAR_DMA)->EnableWindow(false);
		GetDlgItem(IDC_SCROLLBAR_BANK)->EnableWindow(false);
		GetDlgItem(IDC_BUTTON_GO)->EnableWindow(false);
		GetDlgItem(IDC_EDIT_OFFSET)->EnableWindow(false);
		GetDlgItem(IDC_EDIT_BANK)->EnableWindow(false);
		GetDlgItem(IDC_DMA_ADDRESS)->EnableWindow(false);
	}
}

void CDmaDlg::OnButtonReset()
{
	unsigned int tdpy;
	unsigned char tdd, tds;
	unsigned short tda;
	unsigned int fba;
	UINT bank;

	UpdateData(true);
	bank = m_txtBank;
	UpdateData(false);

	tda=DmaAdr+(0x10*t_num);
	
	for(tdpy=0; tdpy<8; tdpy++){	// ^Cf[^
		tdd = RmemB(bank, tda++);		// 1oCgڂ̃^Cf[^
		tds = RmemB(bank, tda++);	// 2oCgڂ̃^Cf[^
		fba=tdpy*8;
		
#ifdef	_ASM_
		__asm{
			mov		dl, 80h
			mov		eax, fba
			lea		edi, [ObjBuffer+eax]
bg_start_loop:
			mov		al, tdd		; tdd&tds&tilebit
			mov		cl, tds
			and		al, cl
			and		al, dl
			cmp		al, dl
			jnz		bg_palette0
			mov		cl, 3
			mov		[edi], cl
			jmp		bg_palette3
bg_palette0:
			mov		al, tdd		; ~tdd&tds&tilebit
			mov		cl, tds
			not		al
			and		al, cl
			and		al, dl
			cmp		al, dl
			jnz		bg_palette1
			mov		cl, 2
			mov		[edi], cl
			jmp		bg_palette3
bg_palette1:
			mov		al, tdd		; tdd&~tds&tilebit, 
			mov		cl, tds
			not		cl
			and		al, cl
			and		al, dl
			cmp		al, dl
			jnz		bg_palette2
			mov		cl, 1
			mov		[edi], cl
			jmp		bg_palette3
bg_palette2:
			mov		al, tdd		; ~tdd&~tds&tilebit
			mov		cl, tds
			and		al, cl
			and		al, dl
			cmp		al, dl
			jz		bg_palette3
			xor		ecx, ecx
			mov		[edi], cl
bg_palette3:
			inc		edi
			shr		dl, 1
			jnz		bg_start_loop
		}
#else
		unsigned char *obuf=&ObjBuffer[fba];
		for(unsigned char charbit=0x80; charbit; charbit=charbit>>1, obuf++){
			if(~tdd&~tds&charbit)*obuf=0;
			if(tdd&~tds&charbit)*obuf=1;
			if(~tdd&tds&charbit)*obuf=2;
			if(tdd&tds&charbit)*obuf=3;
		}
#endif	/*_ASM_*/
	}

	ShowDmaChar();
}

void CDmaDlg::OnButtonWrite() 
{
	unsigned int tdpy;
	unsigned char tdd, tds, charbit;
	unsigned short tda;
	unsigned int fba;
	UINT bank;

	UpdateData(true);
	bank = m_txtBank;
	UpdateData(false);

	tda=DmaAdr+(0x10*t_num);
	
	for(tdpy=0; tdpy<8; tdpy++){
		tdd=tds=0;
		fba=tdpy*8;
		for(charbit=0x80; charbit; charbit=charbit>>1, fba++){
			if(ObjBuffer[fba]==1){
				tdd|=charbit;//tdd&~tds&charbit
			}
			if(ObjBuffer[fba]==2){
				tds|=charbit;
			}
			if(ObjBuffer[fba]==3){
				tdd|=charbit;
				tds|=charbit;
			}
		}
		WmemB(bank, tda++, tdd);
		WmemB(bank, tda++, tds);
	}

	ShowDma();
}

void CDmaDlg::OnKillfocusEditBank() 
{
	UINT bank;

	UpdateData(true);
	bank = m_txtBank;
	UpdateData(false);

	if(bank>rsize){
		if(fDmaDlg){
			MessageBox("Please input a fewer value.", 0, MB_ICONINFORMATION);
			GetDlgItem(IDC_EDIT_BANK)->SetFocus();
		}
	}
}

void CDmaDlg::OnButtonSave() 
{
	OPENFILENAME ofn;
	char filename[512];
	FILE *ofp;
	UINT i;

	memset(filename, 0, 512);
	memset(&ofn, 0, sizeof(ofn));

	ofn.Flags		= OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
	ofn.lpstrFile	= filename;
	ofn.lpstrFilter	= "Gameboy ROM Files (*.gb)\0*.gb;\0All Files (*.*)\0*.*";
	ofn.nMaxFileTitle	= 512;
	ofn.nMaxFile	= 512;
	ofn.lStructSize	= sizeof(OPENFILENAME);
	ofn.hwndOwner	= m_hWnd;

	if(ROM[0]){
		if(GetSaveFileName(&ofn)){
			if(!CheckExtensionName(filename, ".gb")){
				strcat(filename, ".gb");
			}
			ofp = fopen(filename, "wb");
			for(i=0; i<rsize; i++){
				fwrite(ROM[i], 1, 0x4000, ofp);
			}
			fclose(ofp);
		}
	}else{
		MessageBox("Please open ROM file.", 0, MB_ICONINFORMATION);
	}
}

void CDmaDlg::OnButtonSavebin() 
{
	OPENFILENAME ofn;
	char filename[512];
	FILE *ofp;
	BYTE bin[8*2];
	unsigned int tdpy;
	unsigned char tdd, tds, charbit;
	unsigned short tda;
	unsigned int fba;
	
	tda=0;

	memset(filename, 0, 512);
	memset(&ofn, 0, sizeof(ofn));

	ofn.Flags		= OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
	ofn.lpstrFile	= filename;
	ofn.lpstrFilter	= "Binary File(*.bin)\0*.bin;\0All Files (*.*)\0*.*";
	ofn.nMaxFileTitle	= 512;
	ofn.nMaxFile	= 512;
	ofn.lStructSize	= sizeof(OPENFILENAME);
	ofn.hwndOwner	= m_hWnd;

	if(GetSaveFileName(&ofn)){
		if(!CheckExtensionName(filename, ".bin")){
			strcat(filename, ".bin");
		}
		for(tdpy=0; tdpy<8; tdpy++){
			tdd = tds = 0;
			fba = tdpy * 8;
			for(charbit=0x80; charbit; charbit=charbit>>1, fba++){
				if(ObjBuffer[fba]==1){
					tdd|=charbit;
				}
				if(ObjBuffer[fba]==2){
					tds|=charbit;
				}
				if(ObjBuffer[fba]==3){
					tdd|=charbit;
					tds|=charbit;
				}
			}
			bin[tda++] = tdd;
			bin[tda++] = tds;
		}
		ofp = fopen(filename, "wb");
		fwrite(bin, 1, 16, ofp);
		fclose(ofp);
	}
}

void CDmaDlg::OnButtonLoadbin() 
{
	OPENFILENAME ofn;
	char filename[512];
	FILE *ofp;
	BYTE bin[8*2];
	unsigned int tdpy;
	unsigned char tdd, tds, charbit;
	unsigned short tda;
	unsigned int fba;

	tda=0;

	memset(filename, 0, 512);
	memset(&ofn, 0, sizeof(ofn));

	ofn.Flags		= OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
	ofn.lpstrFile	= filename;
	ofn.lpstrFilter	= "Binary Files(*.bin)\0*.bin;\0All Files (*.*)\0*.*";
	ofn.nMaxFileTitle	= 512;
	ofn.nMaxFile	= 512;
	ofn.lStructSize	= sizeof(OPENFILENAME);
	ofn.hwndOwner	= m_hWnd;

	if(GetOpenFileName(&ofn)){
		ofp = fopen(filename, "rb");
		fread(ObjBuffer, 1, 16, ofp);
		fclose(ofp);
		for(tdpy=0; tdpy<8; tdpy++){
			tdd = bin[tda++];
			tds = bin[tda++];
			fba = tdpy * 8;
			for(charbit=0x80; charbit; charbit=charbit>>1, fba++){
				if(~tdd&~tds&charbit)ObjBuffer[fba]=0;
				if(tdd&~tds&charbit)ObjBuffer[fba]=1;
				if(~tdd&tds&charbit)ObjBuffer[fba]=2;
				if(tdd&tds&charbit)ObjBuffer[fba]=3;
			}
		}
	}

	ShowDmaChar();
}

void CDmaDlg::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	UINT ScrPos=m_scrDma.GetScrollPos();
	if(!fEdit && !fShift){
		switch(nSBCode) {
			case SB_LINEUP:	/*XN[o[̃{^*/
				if((DmaAdr-48*8)<=0x0000)DmaAdr=0x0000;
				else DmaAdr-=48*8;
				m_scrDma.SetScrollPos(DmaAdr>>4, TRUE);
				ShowDma();
				break;
			case SB_LINEDOWN:
				if((DmaAdr+48*8)>=0x7FB0)DmaAdr=0x7FB0;
				else DmaAdr+=48*8;
				m_scrDma.SetScrollPos(DmaAdr>>4, TRUE);
				ShowDma();
				break;
			case SB_PAGEUP:	/*XN[o[̗]*/
				if((DmaAdr-48*8)<=0x0000)DmaAdr=0x0000;
				else DmaAdr-=48*8;
				m_scrDma.SetScrollPos(DmaAdr>>4, TRUE);
				ShowDma();
				break;
			case SB_PAGEDOWN:
				if((DmaAdr+48*8)>=0x7FB0)DmaAdr=0x7FB0;
				else DmaAdr+=48*8;
				m_scrDma.SetScrollPos(DmaAdr>>4, TRUE);
				ShowDma();
				break;
			case SB_THUMBPOSITION:	/*XN[o[̂܂*/
			case SB_THUMBTRACK:
				DmaAdr=nPos<<4;
				DmaAdr&=~0x180;
				if(nPos==0x800)DmaAdr=0x7FB0;
				m_scrDma.SetScrollPos(nPos, TRUE);
				ShowDma();
				break;
		}
	}

	CDialog::OnVScroll(nSBCode, nPos, pScrollBar);
}

void CDmaDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	UINT ScrPos=m_scrBank.GetScrollPos();
	INT bank;

	UpdateData(true);
	bank = m_txtBank;
	UpdateData(false);

	if(!fEdit && !fShift){
		switch(nSBCode) {
			case SB_PAGEUP:
			case SB_LINELEFT:
				if((bank-1)<=1)bank=1;
				else bank-=1;
				m_scrBank.SetScrollPos(bank, TRUE);
				ShowDma();
				break;
			case SB_PAGEDOWN:
			case SB_LINERIGHT:
				if((bank+1)>=(rsize-1))bank=(rsize-1);
				else bank+=1;
				m_scrBank.SetScrollPos(bank, TRUE);
				ShowDma();
				break;
			case SB_THUMBPOSITION:
			case SB_THUMBTRACK:
				bank = nPos;
				if(bank==0)bank=1;
				if(bank>(rsize-1))bank=(rsize-1);
				m_scrBank.SetScrollPos(bank, TRUE);
				ShowDma();
				break;
		}
	}

	UpdateData(true);
	m_txtBank = bank;
	UpdateData(false);

	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CDmaDlg::OnPalette0() 
{
	PenColor=0;
	OnPaint();
}

void CDmaDlg::OnPalette1() 
{
	PenColor=1;
	OnPaint();
}

void CDmaDlg::OnPalette2() 
{
	PenColor=2;
	OnPaint();
}

void CDmaDlg::OnPalette3() 
{
	PenColor=3;
	OnPaint();
}
